/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.AntDebugger;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private String expression;

    public String getShortDescription() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        AntDebugger antDebugger = (AntDebugger)((Object)debuggerEngine.lookupFirst(null, AntDebugger.class));
        if (antDebugger == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        try {
            StyledDocument styledDocument = editorCookie.openDocument();
            JEditorPane jEditorPane = ToolTipAnnotation.getCurrentEditor();
            if (jEditorPane == null) {
                return null;
            }
            this.expression = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, NbDocument.findLineOffset((StyledDocument)styledDocument, (int)part.getLine().getLineNumber()) + part.getColumn());
            if (this.expression == null) {
                return null;
            }
            RequestProcessor.getDefault().post((Runnable)this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void run() {
        if (this.expression == null) {
            return;
        }
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return;
        }
        AntDebugger antDebugger = (AntDebugger)((Object)debuggerEngine.lookupFirst(null, AntDebugger.class));
        if (antDebugger == null) {
            return;
        }
        String string = antDebugger.evaluate(this.expression);
        if (string == null || string.equals(this.expression)) {
            return;
        }
        String string2 = this.expression + " = " + string;
        this.firePropertyChange("shortDescription", null, string2);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            n7 = string.length();
            for (n5 = n3; n5 > 0 && string.charAt(n5 - 1) != '\"'; --n5) {
            }
            for (n4 = Math.max(n3, 1); n4 < n7 && string.charAt(n4 - 1) != '\"'; ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4 - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = ToolTipAnnotation.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private static EditorCookie getCurrentEditorCookie() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        return (EditorCookie)node.getCookie(EditorCookie.class);
    }
}

