/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.spi.AntEvent;
import org.netbeans.modules.ant.debugger.DebuggerAnnotation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Utils {
    private static Object currentLine;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void markCurrent(Object object) {
        Utils.unmarkCurrent();
        Annotatable[] annotatableArray = (Annotatable[])object;
        int n = 0;
        int n2 = annotatableArray.length;
        DebuggerAnnotation[] debuggerAnnotationArray = new DebuggerAnnotation[n2];
        debuggerAnnotationArray[n] = annotatableArray[n] instanceof Line.Part ? new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_PART_ANNOTATION_TYPE, annotatableArray[n]) : new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_ANNOTATION_TYPE, annotatableArray[n]);
        for (n = 1; n < n2; ++n) {
            debuggerAnnotationArray[n] = annotatableArray[n] instanceof Line.Part ? new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_PART_ANNOTATION_TYPE2, annotatableArray[n]) : new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_ANNOTATION_TYPE2, annotatableArray[n]);
        }
        currentLine = debuggerAnnotationArray;
        Utils.showLine(object);
    }

    static void unmarkCurrent() {
        if (currentLine != null) {
            int n = ((DebuggerAnnotation[])currentLine).length;
            for (int i = 0; i < n; ++i) {
                ((DebuggerAnnotation[])currentLine)[i].detach();
            }
            currentLine = null;
        }
    }

    static void showLine(Object object) {
        final Annotatable[] annotatableArray = (Annotatable[])object;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (annotatableArray[0] instanceof Line) {
                    ((Line)annotatableArray[0]).show(2);
                } else if (annotatableArray[0] instanceof Line.Part) {
                    ((Line.Part)annotatableArray[0]).getLine().show(2);
                } else {
                    throw new InternalError();
                }
            }
        });
    }

    static int getLineNumber(Object object) {
        Annotatable[] annotatableArray = (Annotatable[])object;
        if (annotatableArray[0] instanceof Line) {
            return ((Line)annotatableArray[0]).getLineNumber();
        }
        if (annotatableArray[0] instanceof Line.Part) {
            return ((Line.Part)annotatableArray[0]).getLine().getLineNumber();
        }
        throw new InternalError();
    }

    public static boolean contains(Object object, Line line) {
        if (object == null) {
            return false;
        }
        Annotatable[] annotatableArray = (Annotatable[])object;
        int n = annotatableArray.length;
        for (int i = 0; i < n; ++i) {
            if (annotatableArray[i].equals(line)) {
                return true;
            }
            if (!(annotatableArray[i] instanceof Line.Part) || !((Line.Part)annotatableArray[i]).getLine().equals(line)) continue;
            return true;
        }
        return false;
    }

    static Object getLine(AntEvent antEvent) {
        File file = antEvent.getScriptLocation();
        int n = antEvent.getLine();
        if (file == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (!$assertionsDisabled && editorCookie == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && lineCookie == null) {
                throw new AssertionError();
            }
            StyledDocument styledDocument = editorCookie.openDocument();
            InputSource inputSource = Utils.createInputSource(fileObject, editorCookie, styledDocument);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            int[] nArray = new int[4];
            class Handler
            extends DefaultHandler {
                private Locator locator;
                private final /* synthetic */ int[] val$line;
                private final /* synthetic */ AntEvent val$event;
                private final /* synthetic */ int val$lineNumber;

                Handler(int[] nArray, AntEvent antEvent, int n) {
                    this.val$line = nArray;
                    this.val$event = antEvent;
                    this.val$lineNumber = n;
                }

                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if (this.val$line[0] == 0 && string3.equals(this.val$event.getTaskName()) && this.locator.getLineNumber() == this.val$lineNumber) {
                        this.val$line[0] = this.locator.getLineNumber();
                        this.val$line[1] = this.locator.getColumnNumber() - 1;
                    }
                }

                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (this.val$line[0] != 0 && this.val$line[2] == 0 && string3.equals(this.val$event.getTaskName())) {
                        this.val$line[2] = this.locator.getLineNumber();
                        this.val$line[3] = this.locator.getColumnNumber() - 1;
                    }
                }
            }
            sAXParser.parse(inputSource, (DefaultHandler)new Handler(nArray, antEvent, n));
            if (nArray[0] == 0) {
                return null;
            }
            Annotatable[] annotatableArray = new Annotatable[nArray[2] - nArray[0] + 1];
            int n2 = 0;
            for (int i = nArray[0]; i <= nArray[2]; ++i) {
                Line line = lineCookie.getLineSet().getCurrent(i - 1);
                annotatableArray[n2++] = line;
            }
            return annotatableArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static Object getLine(TargetLister.Target target, String string) {
        LineCookie lineCookie;
        EditorCookie editorCookie;
        Object object;
        FileObject fileObject = target.getScript().getFileObject();
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError((Object)("No build script for " + target.getName()));
        }
        try {
            object = DataObject.find((FileObject)fileObject);
            editorCookie = (EditorCookie)object.getCookie(EditorCookie.class);
            lineCookie = (LineCookie)object.getCookie(LineCookie.class);
            if (!$assertionsDisabled && editorCookie == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && lineCookie == null) {
                throw new AssertionError();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new AssertionError((Object)dataObjectNotFoundException);
        }
        try {
            Line line;
            int n;
            object = editorCookie.openDocument();
            InputSource inputSource = Utils.createInputSource(fileObject, editorCookie, (StyledDocument)object);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            int[] nArray = new int[4];
            class Handler
            extends DefaultHandler {
                private Locator locator;
                private final /* synthetic */ int[] val$line;
                private final /* synthetic */ TargetLister.Target val$target;

                Handler(int[] nArray, TargetLister.Target target) {
                    this.val$line = nArray;
                    this.val$target = target;
                }

                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if (this.val$line[0] == 0 && string3.equals("target") && this.val$target.getName().equals(attributes.getValue("name"))) {
                        this.val$line[0] = this.locator.getLineNumber();
                        this.val$line[1] = this.locator.getColumnNumber();
                    }
                }

                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (this.val$line[0] != 0 && this.val$line[2] == 0 && string3.equals("target")) {
                        this.val$line[2] = this.locator.getLineNumber();
                        this.val$line[3] = this.locator.getColumnNumber();
                    }
                }
            }
            sAXParser.parse(inputSource, (DefaultHandler)new Handler(nArray, target));
            if (nArray[0] == 0) {
                return null;
            }
            int n2 = nArray[0] - 1;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (string != null && (n = Utils.findIndexOf((line = lineCookie.getLineSet().getCurrent(n2)).getText(), string)) >= 0) {
                arrayList.add(line.createPart(n, string.length()));
                ++n2;
            }
            if (arrayList.size() < 1) {
                while (n2 < nArray[2]) {
                    line = lineCookie.getLineSet().getCurrent(n2);
                    arrayList.add(line);
                    ++n2;
                }
            }
            return arrayList.toArray(new Annotatable[arrayList.size()]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static int findIndexOf(String string, String string2) {
        int n = 0;
        while ((n = string.indexOf(string2, n)) > 0) {
            char c = string.charAt(n - 1);
            if (!Character.isWhitespace(c) && c != ',' && c != '\"') {
                ++n;
                continue;
            }
            if (string.length() <= n + string2.length() || Character.isWhitespace(c = string.charAt(n + string2.length())) || c == ',' || c == '\"') break;
            ++n;
        }
        return n;
    }

    private static InputSource createInputSource(FileObject fileObject, EditorCookie editorCookie, final StyledDocument styledDocument) throws IOException, BadLocationException {
        InputSource inputSource;
        block5: {
            final StringWriter stringWriter = new StringWriter(styledDocument.getLength());
            final EditorKit editorKit = Utils.findKit(editorCookie.getOpenedPanes());
            final IOException[] iOExceptionArray = new IOException[1];
            final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
            styledDocument.render(new Runnable(){

                public void run() {
                    try {
                        editorKit.write(stringWriter, (Document)styledDocument, 0, styledDocument.getLength());
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationExceptionArray[0] = badLocationException;
                    }
                }
            });
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
            if (badLocationExceptionArray[0] != null) {
                throw badLocationExceptionArray[0];
            }
            inputSource = new InputSource(new StringReader(stringWriter.toString()));
            if (fileObject != null) {
                try {
                    inputSource.setSystemId(fileObject.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)fileStateInvalidException);
                }
            }
        }
        return inputSource;
    }

    private static EditorKit findKit(JEditorPane[] jEditorPaneArray) {
        EditorKit editorKit;
        if (jEditorPaneArray != null) {
            editorKit = jEditorPaneArray[0].getEditorKit();
        } else {
            editorKit = JEditorPane.createEditorKitForContentType("text/xml");
            if (editorKit == null) {
                editorKit = new DefaultEditorKit();
            }
        }
        if (!$assertionsDisabled && editorKit == null) {
            throw new AssertionError();
        }
        return editorKit;
    }

    static {
        $assertionsDisabled = !Utils.class.desiredAssertionStatus();
    }
}

