/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class AntBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set actions = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);

    public AntBreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    public void doAction(Object object) {
        int n;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        if (!AntBreakpointActionProvider.isAntFile((FileObject)line.getLookup().lookup(FileObject.class))) {
            return;
        }
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n2 = breakpointArray.length;
        for (n = 0; n < n2; ++n) {
            if (!(breakpointArray[n] instanceof AntBreakpoint) || !((AntBreakpoint)breakpointArray[n]).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpointArray[n]);
            break;
        }
        if (n == n2) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new AntBreakpoint(line));
        }
    }

    public Set getActions() {
        return actions;
    }

    static Line getCurrentLine() {
        Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        LineCookie lineCookie = (LineCookie)node.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        Caret caret = jEditorPaneArray[0].getCaret();
        if (caret == null) {
            return null;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        try {
            return lineCookie.getLineSet().getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static boolean isAntFile(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        return fileObject.getMIMEType().equals("text/x-ant+xml");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = true;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        bl = line == null ? false : AntBreakpointActionProvider.isAntFile((FileObject)line.getLookup().lookup(FileObject.class));
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

