/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.ant.debugger.DebuggerAnnotation;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.openide.text.Annotatable;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private Map breakpointToAnnotation = new HashMap();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof AntBreakpoint)) {
            return;
        }
        this.addAnnotation(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof AntBreakpoint)) {
            return;
        }
        this.removeAnnotation(breakpoint);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != "enabled") {
            return;
        }
        this.removeAnnotation((Breakpoint)propertyChangeEvent.getSource());
        this.addAnnotation((Breakpoint)propertyChangeEvent.getSource());
    }

    private void addAnnotation(Breakpoint breakpoint) {
        this.breakpointToAnnotation.put(breakpoint, new DebuggerAnnotation(breakpoint.isEnabled() ? DebuggerAnnotation.BREAKPOINT_ANNOTATION_TYPE : DebuggerAnnotation.DISABLED_BREAKPOINT_ANNOTATION_TYPE, (Annotatable)((AntBreakpoint)breakpoint).getLine()));
        breakpoint.addPropertyChangeListener("enabled", (PropertyChangeListener)this);
    }

    private void removeAnnotation(Breakpoint breakpoint) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)this.breakpointToAnnotation.remove(breakpoint));
        if (debuggerAnnotation == null) {
            return;
        }
        debuggerAnnotation.detach();
        breakpoint.removePropertyChangeListener("enabled", (PropertyChangeListener)this);
    }
}

