/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{AntBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        if (!string.equals(AntBreakpoint.class.getName())) {
            return null;
        }
        Line line = this.getLine(properties.getString("url", null), properties.getInt("lineNumber", 1));
        if (line == null) {
            return null;
        }
        return new AntBreakpoint(line);
    }

    public void write(Object object, Properties properties) {
        AntBreakpoint antBreakpoint = (AntBreakpoint)((Object)object);
        FileObject fileObject = (FileObject)antBreakpoint.getLine().getLookup().lookup(FileObject.class);
        try {
            properties.setString("url", fileObject.getURL().toString());
            properties.setInt("lineNumber", antBreakpoint.getLine().getLineNumber());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            fileStateInvalidException.printStackTrace();
        }
    }

    private Line getLine(String string, int n) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

