/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.palette.BrowseFolders;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.IMG;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class IMGCustomizer
extends JPanel {
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private boolean dialogOK = false;
    IMG img;
    JTextComponent target;
    private JButton jButton1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;

    public IMGCustomizer(IMG iMG, JTextComponent jTextComponent) {
        this.img = iMG;
        this.target = jTextComponent;
        this.initComponents();
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || FileUtil.toFileObject((File)file).getMIMEType().startsWith("image/");
            }

            public String getDescription() {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$html$palette$items$IMGCustomizer == null ? (class$org$netbeans$modules$html$palette$items$IMGCustomizer = IMGCustomizer.class$("org.netbeans.modules.html.palette.items.IMGCustomizer")) : class$org$netbeans$modules$html$palette$items$IMGCustomizer), (String)"LBL_IMG_FileChooserDesc");
                return string;
            }
        });
    }

    public boolean showDialog() {
        this.dialogOK = false;
        String string = "";
        try {
            string = NbBundle.getBundle((String)"org.netbeans.modules.html.palette.items.resources.Bundle").getString("NAME_html-IMG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage((Class)IMGCustomizer.class, (String)"LBL_Customizer_InsertPrefix") + " " + string, true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx("IMGCustomizer"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (IMGCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    IMGCustomizer.this.evaluateInput();
                    IMGCustomizer.this.dialogOK = true;
                }
                IMGCustomizer.this.dialog.dispose();
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private void evaluateInput() {
        String string = this.jTextField1.getText();
        this.img.setLocation(string);
        String string2 = this.jTextField2.getText();
        this.img.setWidth(string2);
        String string3 = this.jTextField3.getText();
        this.img.setHeight(string3);
        String string4 = this.jTextField4.getText();
        this.img.setAlttext(string4);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jFileChooser1.setCurrentDirectory(null);
        this.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jTextField4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)IMGCustomizer.class, (String)"LBL_IMG_Alt"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSN_IMG_Alt"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSD_IMG_Alt"));
        this.jTextField1.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jTextField1, gridBagConstraints);
        this.jButton1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage((Class)IMGCustomizer.class, (String)"LBL_IMG_Browse"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IMGCustomizer.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSN_IMG_Browse"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSD_IMG_Browse"));
        this.jTextField2.setColumns(10);
        this.jTextField2.setMinimumSize(new Dimension(100, 19));
        this.jTextField2.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jTextField2, gridBagConstraints);
        this.jTextField3.setColumns(10);
        this.jTextField3.setMinimumSize(new Dimension(100, 19));
        this.jTextField3.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.jTextField3, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)IMGCustomizer.class, (String)"LBL_IMG_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSN_IMG_Location"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSD_IMG_Location"));
        this.jLabel2.setLabelFor(this.jTextField2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)IMGCustomizer.class, (String)"LBL_IMG_Width"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSN_IMG_Width"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSD_IMG_Width"));
        this.jLabel3.setLabelFor(this.jTextField3);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)IMGCustomizer.class, (String)"LBL_IMG_Height"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSN_IMG_Height"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IMGCustomizer.class, (String)"ACSD_IMG_Height"));
        this.jTextField4.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.jTextField4, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        Object object;
        Document document = this.target.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        SourceGroup[] sourceGroupArray = HTMLPaletteUtilities.getSourceGroups(fileObject);
        File file = null;
        if (sourceGroupArray.length > 0) {
            object = BrowseFolders.showDialog(sourceGroupArray, BrowseFolders.imageFileFilter);
            if (object != null) {
                file = FileUtil.toFile((FileObject)object);
            }
        } else {
            this.jFileChooser1.setCurrentDirectory(FileUtil.toFile((FileObject)fileObject.getParent()));
            int n = this.jFileChooser1.showOpenDialog(this);
            if (n == 0) {
                file = this.jFileChooser1.getSelectedFile();
            }
        }
        if (file != null) {
            Object object2;
            object = file.getAbsolutePath();
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            try {
                object2 = HTMLPaletteUtilities.getRelativePath(fileObject, fileObject2);
                if (((String)object2).length() > 0) {
                    object = object2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jTextField1.setText((String)object);
            try {
                object2 = new ImageIcon(file.getAbsolutePath()).getImage();
                int n = ((Image)object2).getWidth(null);
                this.jTextField2.setText(n != -1 ? new Integer(n).toString() : "");
                int n2 = ((Image)object2).getHeight(null);
                this.jTextField3.setText(n2 != -1 ? new Integer(n2).toString() : "");
                this.jTextField4.setText(fileObject2.getName());
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }
}

