/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import org.netbeans.beaninfo.editors.ExPropertyEditorSupport;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class BoolEditor
extends ExPropertyEditorSupport {
    String[] stringValues = null;

    protected void attachEnvImpl(PropertyEnv propertyEnv) {
        this.stringValues = (String[])propertyEnv.getFeatureDescriptor().getValue("stringValues");
    }

    protected void validateEnv(PropertyEnv propertyEnv) {
        if (this.stringValues != null && this.stringValues.length != 2) {
            throw new ExPropertyEditorSupport.EnvException("String value hint for boolean editor must contain exactly 2 items.  The supplied value contains " + this.stringValues.length + " items: " + BoolEditor.arrToStr(this.stringValues));
        }
    }

    private String getStringRep(boolean bl) {
        if (this.stringValues != null) {
            return this.stringValues[bl ? 0 : 1];
        }
        String string = bl ? NbBundle.getMessage((Class)BoolEditor.class, (String)"TRUE") : NbBundle.getMessage((Class)BoolEditor.class, (String)"FALSE");
        return string;
    }

    private Boolean stringVal(String string) {
        String string2 = string.trim().toUpperCase();
        String string3 = this.getStringRep(true).toUpperCase();
        if (string3.equals(string2)) {
            return Boolean.TRUE;
        }
        string3 = this.getStringRep(false).toUpperCase();
        if (string3.equals(string2)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String getJavaInitializationString() {
        Boolean bl = (Boolean)this.getValue();
        if (bl == null) {
            return "null";
        }
        return Boolean.TRUE.equals(this.getValue()) ? "true" : "false";
    }

    public String[] getTags() {
        return new String[]{this.getStringRep(true), this.getStringRep(false)};
    }

    public String getAsText() {
        Boolean bl = (Boolean)this.getValue();
        if (bl == null) {
            return NbBundle.getMessage((Class)BoolEditor.class, (String)"NULL");
        }
        return this.getStringRep(Boolean.TRUE.equals(this.getValue()));
    }

    public void setAsText(String string) {
        Boolean bl = this.stringVal(string);
        boolean bl2 = bl == null ? false : bl;
        this.setValue(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }
}

