/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.netbeans.beaninfo.ExplorerPanel;
import org.netbeans.beaninfo.editors.DataObjectPanel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class DataObjectTreeView
extends DataObjectPanel {
    static final int DEFAULT_INSET = 10;
    private ExplorerPanel expPanel;
    private TreeView reposTree;
    private boolean initialized = false;

    public DataObjectTreeView(PropertyEditorSupport propertyEditorSupport, PropertyEnv propertyEnv) {
        super(propertyEditorSupport, propertyEnv);
        this.initComponent();
        this.reposTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DataObjectTreeView.class, (String)"ACSN_DataObjectPanel"));
        this.setDescription(NbBundle.getMessage((Class)DataObjectTreeView.class, (String)"ACSD_DataObjectPanel"));
    }

    public void addNotify() {
        this.completeInitialization();
        super.addNotify();
    }

    private void initComponent() {
        this.expPanel = new ExplorerPanel();
        this.expPanel.setLayout(new BorderLayout());
        this.reposTree = new BeanTreeView();
        this.reposTree.setSelectionMode(1);
        this.reposTree.setPopupAllowed(false);
        this.reposTree.setDefaultActionAllowed(false);
        this.expPanel.add((Component)this.reposTree, "Center");
    }

    private void completeInitialization() {
        Node node;
        Object object;
        if (this.initialized) {
            return;
        }
        if (this.insets != null) {
            this.setBorder(new EmptyBorder(this.insets));
        } else {
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        this.setLayout(new BorderLayout(0, 2));
        if (this.subTitle != null) {
            object = new JLabel(this.subTitle);
            ((JLabel)object).setLabelFor((Component)this.reposTree);
            this.add((Component)object, "North");
        }
        if (this.rootNode == null) {
            if (this.dataFilter != null) {
                if (this.folderFilter != null) {
                    object = new DataFilter(){

                        public boolean acceptDataObject(DataObject dataObject) {
                            if (DataObjectTreeView.this.folderFilter.acceptDataObject(dataObject)) {
                                return true;
                            }
                            return DataObjectTreeView.this.dataFilter.acceptDataObject(dataObject);
                        }
                    };
                    this.rootNode = RepositoryNodeFactory.getDefault().repository((DataFilter)object);
                } else {
                    this.rootNode = RepositoryNodeFactory.getDefault().repository(this.dataFilter);
                }
            } else {
                this.rootNode = this.folderFilter != null ? RepositoryNodeFactory.getDefault().repository(this.folderFilter) : RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
            }
        }
        if (this.nodeFilter != null) {
            object = new DataObjectPanel.FilteredChildren(this.rootNode, this.nodeFilter, this.dataFilter);
            this.rootNode = node = new FilterNode(this.rootNode, (Children)object);
        }
        object = this.rootNode;
        if (this.rootObject != null && (node = this.findNodeForObj(this.rootNode, this.rootObject)) != null) {
            NodeAcceptor nodeAcceptor = this.nodeFilter;
            if (nodeAcceptor == null) {
                nodeAcceptor = new NodeAcceptor(){

                    public boolean acceptNodes(Node[] nodeArray) {
                        return false;
                    }
                };
            }
            DataObjectPanel.FilteredChildren filteredChildren = new DataObjectPanel.FilteredChildren(node, nodeAcceptor, this.dataFilter);
            FilterNode filterNode = new FilterNode(node, (Children)filteredChildren);
            object = filterNode;
        }
        this.expPanel.getExplorerManager().setRootContext((Node)object);
        node = null;
        if (this.dObj != null) {
            node = this.findNodeForObj((Node)object, this.dObj);
        }
        if (node != null) {
            try {
                this.expPanel.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
            }
        }
        this.expPanel.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                    DataObject dataObject = DataObjectTreeView.this.getDataObject();
                    boolean bl = false;
                    if (nodeArray != null && nodeArray.length > 0 && DataObjectTreeView.this.dataFilter != null && dataObject != null) {
                        bl = DataObjectTreeView.this.dataFilter.acceptDataObject(dataObject);
                    } else {
                        boolean bl2 = bl = dataObject != null;
                    }
                    if (bl) {
                        DataObjectTreeView.this.myEditor.setValue(dataObject);
                    }
                    DataObjectTreeView.this.setOkButtonEnabled(bl);
                }
            }
        });
        this.add((Component)((Object)this.expPanel), "Center");
        if (this.dataFilter != null && this.getDataObject() != null) {
            this.setOkButtonEnabled(this.dataFilter.acceptDataObject(this.getDataObject()));
        } else {
            this.setOkButtonEnabled(this.getDataObject() != null);
        }
        this.initialized = true;
    }

    public void setDescription(String string) {
        this.getAccessibleContext().setAccessibleDescription(string);
        this.reposTree.getAccessibleContext().setAccessibleDescription(string);
    }

    public DataObject getDataObject() {
        DataObject dataObject = null;
        Node[] nodeArray = this.expPanel.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        }
        return dataObject;
    }

    public Node getNode() {
        Node node = null;
        Node[] nodeArray = this.expPanel.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            node = nodeArray[0];
        }
        return node;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getDataObject();
    }
}

