/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import org.netbeans.beaninfo.editors.ArrayOfIntSupport;
import org.netbeans.beaninfo.editors.PointCustomEditor;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class DimensionEditor
extends ArrayOfIntSupport {
    public DimensionEditor() {
        super("java.awt.Dimension", 2);
    }

    int[] getValues() {
        Dimension dimension = (Dimension)this.getValue();
        return new int[]{dimension.width, dimension.height};
    }

    static String toArr(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nArray != null && nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i == nArray.length - 1) continue;
                stringBuffer.append(',');
            }
        } else {
            return NbBundle.getMessage((Class)DimensionEditor.class, (String)"MSG_NULL_OR_EMPTY");
        }
        return stringBuffer.toString();
    }

    void setValues(int[] nArray) {
        if (nArray[0] < 0 || nArray[1] < 0) {
            String string = NbBundle.getMessage((Class)DimensionEditor.class, (String)"CTL_NegativeSize");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Negative value");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), string, null, new Date());
            throw illegalArgumentException;
        }
        this.setValue(new Dimension(nArray[0], nArray[1]));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new PointCustomEditor(this);
    }

    String getHintFormat() {
        return NbBundle.getMessage((Class)DimensionEditor.class, (String)"CTL_HintFormat");
    }

    protected String getXMLValueTag() {
        return "Dimension";
    }
}

