/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ToolTipManager;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IDESettings
extends SystemOption {
    static final long serialVersionUID = 801136840705717911L;
    public static final String PROP_SHOW_TOOLTIPS_IN_IDE = "showToolTipsInIDE";
    public static final String PROP_CONFIRM_DELETE = "confirmDelete";
    public static final String PROP_HOME_PAGE = "homePage";
    public static final String PROP_USE_PROXY = "useProxy";
    public static final String PROP_PROXY_TYPE = "proxyType";
    public static final String PROP_PROXY_HOST = "userProxyHost";
    public static final String PROP_PROXY_PORT = "userProxyPort";
    public static final String PROP_SHOW_FILE_EXTENSIONS = "showFileExtensions";
    public static final String PROP_MODULES_SORT_MODE = "modulesSortMode";
    public static final String PROP_WWWBROWSER = "WWWBrowser";
    public static final String PROP_UIMODE = "UIMode";
    public static final String PROP_IGNORED_FILES = "IgnoredFiles";
    public static final String KEY_PROXY_HOST = "http.proxyHost";
    public static final String KEY_PROXY_PORT = "http.proxyPort";
    public static final String KEY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String KEY_HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String KEY_HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String KEY_HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final int MODULES_SORT_UNSORTED = 0;
    public static final int MODULES_SORT_DISPLAYNAME = 1;
    public static final int MODULES_SORT_CODENAME = 2;
    public static final int MODULES_SORT_ENABLED = 3;
    public static final int MODULES_SORT_URL = 4;
    public static final int MODULES_SORT_CATEGORY = 5;
    public static final int DIRECT_CONNECTION = 0;
    public static final int AUTO_DETECT_PROXY = 1;
    public static final int MANUAL_SET_PROXY = 2;
    private static boolean showToolTips;
    private static boolean showTips;
    private static int lastTip;
    private static boolean confirmDelete;
    private static int modulesSortMode;
    private static boolean useProxy;
    private static int proxyType;
    private static String userProxyHost;
    private static String userProxyPort;
    private static int uiMode;
    private static String ignoredFiles;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    protected void initialize() {
        super.initialize();
        this.setProxy();
        this.putProperty(PROP_WWWBROWSER, "", false);
    }

    private void setProxy() {
        String string = this.getProxyHost();
        String string2 = this.getProxyPort();
        String string3 = this.getDefaultNonProxyHosts();
        System.setProperty(KEY_PROXY_HOST, string);
        System.setProperty(KEY_PROXY_PORT, string2);
        System.setProperty(KEY_NON_PROXY_HOSTS, string3);
        System.setProperty(KEY_HTTPS_PROXY_HOST, string);
        System.setProperty(KEY_HTTPS_PROXY_PORT, string2);
        System.setProperty(KEY_HTTPS_NON_PROXY_HOSTS, string3);
    }

    public static URL getRealHomeURL() {
        try {
            return new URL(NbBundle.getMessage((Class)IDESettings.class, (String)"URL_default_home_page"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public int getModulesSortMode() {
        return modulesSortMode;
    }

    public void setModulesSortMode(int n) {
        int n2 = modulesSortMode;
        modulesSortMode = n;
        this.firePropertyChange(PROP_MODULES_SORT_MODE, new Integer(n2), new Integer(n));
    }

    public boolean getShowToolTipsInIDE() {
        return showToolTips;
    }

    public void setShowToolTipsInIDE(boolean bl) {
        if (showToolTips == bl) {
            return;
        }
        showToolTips = bl;
        ToolTipManager.sharedInstance().setEnabled(bl);
        this.firePropertyChange(PROP_SHOW_TOOLTIPS_IN_IDE, !showToolTips ? Boolean.TRUE : Boolean.FALSE, showToolTips ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getConfirmDelete() {
        return confirmDelete;
    }

    public void setConfirmDelete(boolean bl) {
        if (bl == confirmDelete) {
            return;
        }
        Boolean bl2 = confirmDelete ? Boolean.TRUE : Boolean.FALSE;
        confirmDelete = bl;
        this.firePropertyChange(PROP_CONFIRM_DELETE, bl2, confirmDelete ? Boolean.TRUE : Boolean.FALSE);
    }

    public String displayName() {
        return NbBundle.getBundle((Class)IDESettings.class).getString("CTL_IDESettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IDESettings.class);
    }

    public String getHomePage() {
        return HtmlBrowser.getHomePage();
    }

    public void setHomePage(String string) {
        HtmlBrowser.setHomePage((String)string);
    }

    public boolean getUseProxy() {
        return useProxy;
    }

    public void setUseProxy(boolean bl) {
        if (useProxy != bl) {
            if (bl) {
                this.setProxyType(2);
            } else {
                this.setProxyType(1);
            }
        }
    }

    public int getProxyType() {
        int n;
        int n2 = n = proxyType == -1 ? 1 : proxyType;
        if (n == 1 && !this.isSystemProxyDetect()) {
            n = 0;
        }
        return n;
    }

    public void setProxyType(int n) {
        if (proxyType != n) {
            int n2 = proxyType;
            boolean bl = this.getUseProxy();
            String string = this.getProxyHost();
            String string2 = this.getProxyPort();
            proxyType = n;
            if (bl != this.getUseProxy()) {
                this.firePropertyChange(PROP_USE_PROXY, bl ? Boolean.TRUE : Boolean.FALSE, this.getUseProxy() ? Boolean.TRUE : Boolean.FALSE);
            }
            if (!string.equals(this.getProxyHost())) {
                this.firePropertyChange(PROP_PROXY_HOST, string, this.getProxyHost());
            }
            if (!string2.equals(this.getProxyPort())) {
                this.firePropertyChange(PROP_PROXY_PORT, string2, this.getProxyPort());
            }
            this.setProxy();
        }
    }

    public String getUserProxyHost() {
        return userProxyHost;
    }

    public String getUserProxyPort() {
        return userProxyPort;
    }

    public void setUserProxyHost(String string) {
        String string2;
        if (!(string = string == null ? "" : string).equals(string2 = this.getUserProxyHost())) {
            userProxyHost = string;
            if (2 == this.getProxyType()) {
                System.setProperty(KEY_PROXY_HOST, string);
                System.setProperty(KEY_HTTPS_PROXY_HOST, string);
                this.firePropertyChange(PROP_PROXY_HOST, string2, string);
            }
        }
    }

    public void setUserProxyPort(String string) {
        String string2;
        if (!(string = string == null ? "" : string).equals(string2 = this.getUserProxyPort())) {
            userProxyPort = string;
            if (2 == this.getProxyType()) {
                System.setProperty(KEY_PROXY_PORT, string);
                System.setProperty(KEY_HTTPS_PROXY_PORT, string);
                this.firePropertyChange(PROP_PROXY_PORT, string2, string);
            }
        }
    }

    public String getProxyHost() {
        switch (this.getProxyType()) {
            case 1: {
                return this.getSystemProxyHost();
            }
            case 2: {
                return this.getUserProxyHost();
            }
            case 0: {
                return "";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
        }
        return null;
    }

    public void readOldProxyHost(String string) {
        this.setUserProxyHost(string);
    }

    public void readOldProxyPort(String string) {
        this.setUserProxyPort(string);
    }

    public void setProxyHost(String string) {
        String string2 = string = string == null ? "" : string;
        if (2 == this.getProxyType() && !this.getUserProxyHost().equals(string)) {
            String string3 = this.getUserProxyHost();
            this.setUserProxyHost(string);
            System.setProperty(KEY_PROXY_HOST, string);
            System.setProperty(KEY_HTTPS_PROXY_HOST, string);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Don't set proxy host if proxy type " + this.getProxyType()));
        }
    }

    public String getProxyPort() {
        switch (this.getProxyType()) {
            case 1: {
                return this.getSystemProxyPort();
            }
            case 2: {
                return this.getUserProxyPort();
            }
            case 0: {
                return "";
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unknown proxy type " + this.getProxyType()));
        }
        return null;
    }

    public void setProxyPort(String string) {
        String string2 = string = string == null ? "" : string;
        if (2 == this.getProxyType() && !this.getUserProxyPort().equals(string)) {
            String string3 = this.getUserProxyPort();
            this.setUserProxyPort(string);
            System.setProperty(KEY_PROXY_PORT, this.getProxyPort());
            System.setProperty(KEY_HTTPS_PROXY_PORT, this.getProxyPort());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Don't set proxy port if proxy type " + this.getProxyType()));
        }
    }

    public boolean getShowFileExtensions() {
        return DataNode.getShowFileExtensions();
    }

    public void setShowFileExtensions(boolean bl) {
        boolean bl2 = this.getShowFileExtensions();
        DataNode.setShowFileExtensions((boolean)bl);
        this.firePropertyChange(PROP_SHOW_FILE_EXTENSIONS, bl2, bl);
    }

    public HtmlBrowser.Factory getWWWBrowser() {
        block8: {
            try {
                Object object = this.getProperty(PROP_WWWBROWSER);
                if (object instanceof String && !"".equals(object)) {
                    Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, (String)object, null));
                    return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
                }
                if (object != null && !"".equals(object)) break block8;
                Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(HtmlBrowser.Factory.class));
                Iterator iterator = result.allInstances().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
                    DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                    DataObject[] dataObjectArray = dataFolder.getChildren();
                    for (int i = 0; i < dataObjectArray.length; ++i) {
                        Object object2 = null;
                        try {
                            if (Boolean.TRUE.equals(dataObjectArray[i].getPrimaryFile().getAttribute("hidden"))) continue;
                            InstanceCookie instanceCookie = (InstanceCookie)dataObjectArray[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? IDESettings.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (instanceCookie == null || (object2 = instanceCookie.instanceCreate()) == null || !object2.equals(e)) continue;
                            return (HtmlBrowser.Factory)e;
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                        }
                    }
                }
                return null;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    public void setWWWBrowser(HtmlBrowser.Factory factory) {
        try {
            if (factory == null) {
                this.putProperty(PROP_WWWBROWSER, "", true);
                return;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)factory));
            if (item != null) {
                this.putProperty(PROP_WWWBROWSER, item.getId(), true);
            } else {
                ErrorManager.getDefault().log("IDESettings: Cannot find browser in lookup");
                this.putProperty(PROP_WWWBROWSER, "", true);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public void setUIMode(int n) {
        if (uiMode == n) {
            return;
        }
        int n2 = uiMode;
        uiMode = n;
        this.firePropertyChange(PROP_UIMODE, new Integer(n2), new Integer(n));
    }

    public int getUIMode() {
        return uiMode;
    }

    private String getDefaultNonProxyHosts() {
        String string = "localhost|127.0.0.1";
        String string2 = "";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            if (!string2.equals("localhost")) {
                string = string + "|" + string2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            String string3 = InetAddress.getLocalHost().getCanonicalHostName();
            if (!string3.equals("localhost") && !string3.equals(string2)) {
                string = string + "|" + string3;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    public String getIgnoredFiles() {
        return ignoredFiles;
    }

    public void setIgnoredFiles(String string) throws IllegalArgumentException {
        if (!ignoredFiles.equals(string)) {
            try {
                String string2 = ignoredFiles;
                Pattern.compile(string);
                ignoredFiles = string;
                this.firePropertyChange(PROP_IGNORED_FILES, string2, string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(patternSyntaxException);
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, patternSyntaxException.getMessage(), patternSyntaxException.getLocalizedMessage(), null, null);
                throw illegalArgumentException;
            }
        }
    }

    private boolean isSystemProxyDetect() {
        return System.getProperty("netbeans.system_http_proxy") != null;
    }

    private String getSystemProxyHost() {
        String string = System.getProperty("netbeans.system_http_proxy");
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n <= 0 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(0, n);
    }

    private String getSystemProxyPort() {
        String string = System.getProperty("netbeans.system_http_proxy");
        if (string == null) {
            return "";
        }
        int n = string.indexOf(":");
        if (n <= 0 || n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    static {
        $assertionsDisabled = !IDESettings.class.desiredAssertionStatus();
        showToolTips = true;
        showTips = true;
        lastTip = -1;
        confirmDelete = true;
        modulesSortMode = 5;
        useProxy = false;
        proxyType = -1;
        userProxyHost = System.getProperty(KEY_PROXY_HOST, "");
        userProxyPort = System.getProperty(KEY_PROXY_PORT, "");
        uiMode = 2;
        ignoredFiles = "^(CVS|SCCS|vssver\\.scc|#.*#|%.*%|\\.(cvsignore|svn|DS_Store))$|^\\.[#_]|~$";
    }
}

