/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;

public final class NbKeymap
extends Observable
implements Keymap,
Comparator {
    String name;
    Keymap parent;
    Map bindings;
    Action defaultAction;
    Map actions;
    private static List context = new ArrayList();
    private final Action NO_ACTION = new KeymapAction(null, null);

    public static void resetContext() {
        context.clear();
        StatusDisplayer.getDefault().setStatusText("");
    }

    public static KeyStroke[] getContext() {
        return context.toArray(new KeyStroke[context.size()]);
    }

    public static void shiftContext(KeyStroke keyStroke) {
        context.add(keyStroke);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = context.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(NbKeymap.getKeyText((KeyStroke)iterator.next())).append(' ');
        }
        StatusDisplayer.getDefault().setStatusText(stringBuffer.toString());
    }

    private static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public Action createMapAction(Keymap keymap, KeyStroke keyStroke) {
        return new KeymapAction(keymap, keyStroke);
    }

    public NbKeymap() {
        this("Default", null);
    }

    NbKeymap(String string, Keymap keymap) {
        this.name = string;
        this.parent = keymap;
        this.bindings = new HashMap();
    }

    public Action getDefaultAction() {
        if (this.defaultAction != null) {
            return this.defaultAction;
        }
        return this.parent != null ? this.parent.getDefaultAction() : null;
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
        this.setChanged();
        this.notifyObservers();
    }

    public String getName() {
        return this.name;
    }

    public Action getAction(KeyStroke keyStroke) {
        Action action;
        KeyStroke[] keyStrokeArray = NbKeymap.getContext();
        Keymap keymap = this;
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (keymap == this) {
                action = (Action)this.bindings.get(keyStrokeArray[i]);
                if (action == null && this.parent != null) {
                    action = this.parent.getAction(keyStrokeArray[i]);
                }
            } else {
                action = keymap.getAction(keyStrokeArray[i]);
            }
            if (!(action instanceof KeymapAction)) {
                int n = keyStroke.getKeyCode();
                if (n != 17 && n != 18 && n != 65406 && n != 16 && n != 157) {
                    NbKeymap.resetContext();
                }
                return null;
            }
            keymap = ((KeymapAction)action).keymap;
        }
        if (keymap == this) {
            action = (Action)this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }
        action = keymap.getAction(keyStroke);
        if (action != null) {
            if (!(action instanceof KeymapAction)) {
                NbKeymap.resetContext();
            }
            return action;
        }
        if (keyStroke.isOnKeyRelease() || keyStroke.getKeyChar() != '\u0000' && keyStroke.getKeyChar() != '\uffff') {
            return null;
        }
        switch (keyStroke.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return null;
            }
        }
        NbKeymap.resetContext();
        return this.NO_ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStroke[] getBoundKeyStrokes() {
        int n = 0;
        KeyStroke[] keyStrokeArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            keyStrokeArray = new KeyStroke[this.bindings.size()];
            Iterator iterator = this.bindings.keySet().iterator();
            while (iterator.hasNext()) {
                keyStrokeArray[n++] = (KeyStroke)iterator.next();
            }
        }
        return keyStrokeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getBoundActions() {
        int n = 0;
        Action[] actionArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionArray = new Action[this.bindings.size()];
            Iterator iterator = this.bindings.values().iterator();
            while (iterator.hasNext()) {
                actionArray[n++] = (Action)iterator.next();
            }
        }
        return actionArray;
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        List list;
        Map map = this.actions;
        if (map == null) {
            map = this.buildReverseMapping();
        }
        if ((list = (List)map.get(action)) != null) {
            return list.toArray(new KeyStroke[list.size()]);
        }
        return new KeyStroke[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildReverseMapping() {
        HashMap<Action, List<KeyStroke>> hashMap = this.actions = new HashMap<Action, List<KeyStroke>>();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            Iterator iterator = this.bindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Action action = (Action)entry.getValue();
                KeyStroke keyStroke = (KeyStroke)entry.getKey();
                List<KeyStroke> list = (List<KeyStroke>)hashMap.get(action);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList(1));
                    hashMap.put(action, list);
                }
                list.add(keyStroke);
            }
        }
        return hashMap;
    }

    public synchronized boolean isLocallyDefined(KeyStroke keyStroke) {
        return this.bindings.containsKey(keyStroke);
    }

    private void updateActionAccelerator(final Action action) {
        if (action == null) {
            return;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                KeyStroke[] keyStrokeArray = NbKeymap.this.getKeyStrokesForAction(action);
                Arrays.sort(keyStrokeArray, NbKeymap.this);
                action.putValue("AcceleratorKey", keyStrokeArray.length > 0 ? keyStrokeArray[0] : null);
            }
        });
    }

    public int compare(Object object, Object object2) {
        KeyStroke keyStroke = (KeyStroke)object;
        KeyStroke keyStroke2 = (KeyStroke)object2;
        return KeyEvent.getKeyText(keyStroke.getKeyCode()).length() - KeyEvent.getKeyText(keyStroke2.getKeyCode()).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        Action action2;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            action2 = this.bindings.put(keyStroke, action);
            this.actions = null;
        }
        this.updateActionAccelerator(action);
        this.updateActionAccelerator(action2);
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionForKeyStrokeMap(Map map) {
        HashSet hashSet = new HashSet();
        Object object = this;
        synchronized (object) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = map.get(k);
                hashSet.add(v);
                hashSet.add(this.bindings.put(k, v));
            }
            this.actions = null;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.updateActionAccelerator((Action)object.next());
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        Action action;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            action = (Action)this.bindings.remove(keyStroke);
            this.actions = null;
        }
        this.updateActionAccelerator(action);
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings() {
        HashSet hashSet;
        Object object = this;
        synchronized (object) {
            hashSet = new HashSet(this.bindings.values());
            this.bindings.clear();
            this.actions = null;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            this.updateActionAccelerator((Action)object.next());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Keymap getResolveParent() {
        return this.parent;
    }

    public void setResolveParent(Keymap keymap) {
        this.parent = keymap;
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        return "Keymap[" + this.name + "]" + this.bindings;
    }

    public class KeymapAction
    extends AbstractAction {
        private Keymap keymap;
        private KeyStroke stroke;

        public KeymapAction(Keymap keymap, KeyStroke keyStroke) {
            this.keymap = keymap;
            this.stroke = keyStroke;
        }

        public Keymap getSubMap() {
            return this.keymap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.stroke == null) {
                NbKeymap.resetContext();
            } else {
                NbKeymap.shiftContext(this.stroke);
            }
        }
    }

    public static class SubKeymap
    implements Keymap {
        Object hold;
        Keymap parent;
        Map bindings;
        Action defaultAction;

        public SubKeymap(Object object) {
            this.hold = object;
            this.bindings = new HashMap();
        }

        public void setMapping(Map map) {
            this.bindings = new HashMap(map);
        }

        public String getName() {
            return "name";
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            return new KeyStroke[0];
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public Action getAction(KeyStroke keyStroke) {
            return (Action)this.bindings.get(keyStroke);
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Action[] getBoundActions() {
            SubKeymap subKeymap = this;
            synchronized (subKeymap) {
                return this.bindings.values().toArray(new Action[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyStroke[] getBoundKeyStrokes() {
            SubKeymap subKeymap = this;
            synchronized (subKeymap) {
                return this.bindings.keySet().toArray(new KeyStroke[0]);
            }
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public void removeBindings() {
            this.bindings.clear();
        }
    }
}

