/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.openide.explorer.PsSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public class PsSettingsImpl
extends PsSettings {
    private static final String FILE_NAME = "pssettings.36";
    private static final String KEY_VERSION = "version";
    private static final String VERSION = "1.0";
    private static Boolean log = null;
    private Reference settingsFile = null;

    public PsSettingsImpl() {
        PsSettingsImpl.log("Creating default instance of PsSettingsImpl");
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public void putInt(String string, int n) {
        PsSettingsImpl.log("Putting value " + n + " for " + string);
        try {
            String string2 = Integer.toString(n);
            this.put(string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
        }
    }

    public void putBoolean(String string, boolean bl) {
        PsSettingsImpl.log("Putting value " + bl + " for " + string);
        String string2 = bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        this.put(string, string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        PsSettingsImpl.log("getBoolean value " + string);
        String string2 = this.get(string, null);
        return string2 != null ? Boolean.TRUE.toString().equals(string2) : bl;
    }

    public void put(String string, String string2) {
        PsSettingsImpl.log("put " + string + " as " + string2);
        FileObject fileObject = this.getSettingsFile(true);
        if (fileObject != null) {
            try {
                fileObject.setAttribute(string, (Object)string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        } else {
            PsSettingsImpl.log("  problem finding file object");
        }
    }

    public String get(String string, String string2) {
        PsSettingsImpl.log("get " + string);
        FileObject fileObject = this.getSettingsFile(false);
        if (fileObject != null) {
            Object object = fileObject.getAttribute(string);
            PsSettingsImpl.log("  found " + object + " for " + string);
            if (object instanceof String) {
                return (String)object;
            }
            if (object != null) {
                ClassCastException classCastException = new ClassCastException(fileObject + " attribute " + string + " should be an instance of String, not " + object.getClass() + "(" + object + ")");
                ErrorManager.getDefault().notify(16, (Throwable)classCastException);
            }
        }
        return string2;
    }

    private FileObject getSettingsFile(boolean bl) {
        FileObject fileObject = null;
        if (this.settingsFile != null) {
            fileObject = (FileObject)this.settingsFile.get();
        }
        if (fileObject == null && (fileObject = this.findFileObject(bl)) != null) {
            this.settingsFile = new WeakReference<FileObject>(fileObject);
        }
        return fileObject;
    }

    private FileObject findFileObject(boolean bl) {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(FILE_NAME);
            if (bl && fileObject == null) {
                fileObject = fileSystem.getRoot().createData(FILE_NAME);
                fileObject.setAttribute(KEY_VERSION, (Object)VERSION);
            }
            return fileObject;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(16, (Throwable)iOException);
            return null;
        }
    }

    private static void log(String string) {
        if (log == null) {
            Boolean bl = log = ErrorManager.getDefault().getInstance(PsSettingsImpl.class.getName()).isLoggable(1) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (log.booleanValue()) {
            ErrorManager.getDefault().getInstance(PsSettingsImpl.class.getName()).log(string);
        }
    }
}

