/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.perftool.Util;

final class Parser {
    private static final String nline = System.getProperty("line.separator");
    private static final Pattern SESSION_START_PATTERN = Pattern.compile("^([\\-]+)" + nline + "^(>Log Session: .*)", 8);
    private static Pattern SESSION_END_PATTERN = Pattern.compile("^([\\-]+)" + nline, 8);
    private static Pattern ENTRY_PATTERN = Pattern.compile("^\\Q[IDE-Perf] \\E([^0-9]+)([0-9]+)\\.([0-9]+) s", 8);

    private Parser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionInfo[] getData(File file) throws IOException {
        StringBuffer stringBuffer;
        int n;
        Object object;
        Serializable serializable;
        FileReader fileReader = new FileReader(file);
        try {
            serializable = new StringBuffer((int)file.length());
            object = new char[4096];
            while ((n = fileReader.read((char[])object)) != -1) {
                ((StringBuffer)serializable).append((char[])object, 0, n);
            }
            stringBuffer = serializable;
        }
        finally {
            ((Reader)fileReader).close();
        }
        serializable = new ArrayList(20);
        n = 0;
        while (((Matcher)(object = (Object)SESSION_START_PATTERN.matcher(stringBuffer.subSequence(n, stringBuffer.length())))).find()) {
            int n2 = ((Matcher)object).start();
            Parser.parseEntries(stringBuffer, n, n2, (List)((Object)serializable));
            Matcher matcher = SESSION_END_PATTERN.matcher(stringBuffer.subSequence(((Matcher)object).end(), stringBuffer.length()));
            if (!matcher.find()) continue;
            int n3 = matcher.end();
            SessionInfo sessionInfo = new SessionInfo(Parser.trimString(((Object)stringBuffer.subSequence(n2, n3)).toString()));
            serializable.add(sessionInfo);
            n = n3;
        }
        return serializable.toArray(new SessionInfo[serializable.size()]);
    }

    private static void parseEntries(CharSequence charSequence, int n, int n2, List list) throws IOException, PatternSyntaxException {
        Matcher matcher;
        int n3 = list.size();
        if (n3 == 0) {
            return;
        }
        SessionInfo sessionInfo = (SessionInfo)list.get(n3 - 1);
        while (n2 > n && (matcher = ENTRY_PATTERN.matcher(charSequence.subSequence(n, charSequence.length()))).find()) {
            if (matcher.start() > n2) {
                n = matcher.start();
                continue;
            }
            String string = matcher.group();
            double d = Parser.strings2Double(matcher.group(2), matcher.group(3));
            Field field = new Field(sessionInfo, matcher.group(1), d);
            sessionInfo.addField(field);
            n = matcher.end();
        }
        if (sessionInfo.size() == 0) {
            list.remove(n3 - 1);
        }
    }

    private static double strings2Double(String string, String string2) {
        try {
            double d = Double.parseDouble(string);
            return d += Double.parseDouble(string2) / Util.tenpower(string2.length());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return -1.0;
        }
    }

    private static String trimString(String string) {
        char c;
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        while (((c = string.charAt(n++)) == '\n' || c == '\r') && n < n2) {
        }
        --n;
        if ((n = (string = string.substring(n)).length() - 1) < 0) {
            return string;
        }
        while (((c = string.charAt(n--)) == '\n' || c == '\r') && n >= 0) {
        }
        return string.substring(0, n + 2);
    }

    public static class Field {
        private String name;
        private double time;
        private SessionInfo session;

        Field(SessionInfo sessionInfo, String string, double d) {
            this.name = string;
            this.time = d;
            this.session = sessionInfo;
        }

        public String getName() {
            return this.name;
        }

        public double getTime() {
            return this.time;
        }

        public SessionInfo getSessionInfo() {
            return this.session;
        }
    }

    public static class SessionInfo {
        private String desc;
        private Map fields;
        private int build;
        private Date date;

        SessionInfo(String string) {
            this.desc = string;
            this.fields = new HashMap(80);
            this.build = SessionInfo.getBuildNumber(string);
            Locale locale = SessionInfo.getLocale(string);
            this.date = SessionInfo.getDate(string, locale);
        }

        public String getDescription() {
            return this.desc;
        }

        void addField(Field field) {
            this.fields.put(field.getName(), field);
        }

        public Field getField(String string) {
            return (Field)this.fields.get(string);
        }

        public int getBuildNumber() {
            return this.build;
        }

        public Date getDate() {
            return this.date;
        }

        int size() {
            return this.fields.size();
        }

        private static int getBuildNumber(String string) {
            try {
                int n = string.indexOf("(Build ");
                int n2 = string.indexOf(41, n);
                String string2 = string.substring(n + 7, n2);
                if (string2.equals("@BUILD_NUMBER_SUBST@")) {
                    return -1;
                }
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return -1;
            }
        }

        private static Locale getLocale(String string) {
            int n = string.indexOf("System Locale");
            n = string.indexOf("= ", n);
            String[] stringArray = new String[]{null, "", ""};
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(3);
            char c = string.charAt(n += 2);
            while (Character.isLetter(c)) {
                if (c == ':') {
                    stringArray[n2++] = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(c);
                c = string.charAt(++n);
            }
            stringArray[n2] = stringBuffer.toString();
            return new Locale(stringArray[0], stringArray[1], stringArray[2]);
        }

        private static Date getDate(String string, Locale locale) {
            int n = string.indexOf(">Log Session: ");
            int n2 = string.indexOf(62, n + 14);
            String string2 = Parser.trimString(string.substring(n + 14, n2));
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, locale);
            Date date = dateFormat.parse(string2, new ParsePosition(0));
            return date;
        }
    }
}

