/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class FileOwnerQuery {
    private static Lookup.Result implementations;
    private static List cache;
    public static final int EXTERNAL_ALGORITHM_TRANSIENT = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FileOwnerQuery() {
    }

    public static Project getOwner(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to FileOwnerQuery.getOwner(FileObject)");
        }
        FileObject fileObject2 = FileUtil.getArchiveFile((FileObject)fileObject);
        if (fileObject2 != null) {
            fileObject = fileObject2;
        }
        Iterator iterator = FileOwnerQuery.getInstances().iterator();
        while (iterator.hasNext()) {
            FileOwnerQueryImplementation fileOwnerQueryImplementation = (FileOwnerQueryImplementation)iterator.next();
            Project project = fileOwnerQueryImplementation.getOwner(fileObject);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    public static Project getOwner(URI uRI) {
        Object object;
        if (uRI.isOpaque() && "jar".equalsIgnoreCase(uRI.getScheme())) {
            object = uRI.getSchemeSpecificPart();
            int n = ((String)object).lastIndexOf(33);
            if (n > 0) {
                object = ((String)object).substring(0, n);
            }
            try {
                uRI = URI.create((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    URL uRL = new URL((String)object);
                    uRI = new File(uRL.getPath()).toURI();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    if (!$assertionsDisabled) {
                        throw new AssertionError(object);
                    }
                    return null;
                }
            }
        } else if (!uRI.isAbsolute() || uRI.isOpaque()) {
            throw new IllegalArgumentException("Bad URI: " + uRI);
        }
        object = FileOwnerQuery.getInstances().iterator();
        while (object.hasNext()) {
            FileOwnerQueryImplementation fileOwnerQueryImplementation = (FileOwnerQueryImplementation)object.next();
            Project project = fileOwnerQueryImplementation.getOwner(uRI);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    static void reset() {
        SimpleFileOwnerQueryImplementation.reset();
    }

    public static void markExternalOwner(FileObject fileObject, Project project, int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(fileObject, project);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm: " + n);
            }
        }
    }

    public static void markExternalOwner(URI uRI, Project project, int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(uRI, project);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm: " + n);
            }
        }
    }

    private static synchronized List getInstances() {
        if (implementations == null) {
            implementations = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
            implementations.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class clazz = class$org$netbeans$api$project$FileOwnerQuery == null ? (class$org$netbeans$api$project$FileOwnerQuery = FileOwnerQuery.class$("org.netbeans.api.project.FileOwnerQuery")) : class$org$netbeans$api$project$FileOwnerQuery;
                    synchronized (clazz) {
                        cache = null;
                    }
                }
            });
        }
        if (cache == null) {
            cache = new ArrayList(implementations.allInstances());
        }
        return cache;
    }

    static {
        $assertionsDisabled = !FileOwnerQuery.class.desiredAssertionStatus();
    }
}

