/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectState;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class ProjectManager {
    private static final ErrorManager ERR;
    private static final int ERR_LVL;
    private static final Lookup.Result factories;
    private static final ProjectManager DEFAULT;
    private static final Mutex MUTEX;
    private static final Object NO_SUCH_PROJECT;
    private static final Object SOME_SUCH_PROJECT;
    private static final Object LOADING_PROJECT;
    private final Map dir2Proj = new WeakHashMap();
    private final Set modifiedProjects = new HashSet();
    private final Map proj2Factory = new WeakHashMap();
    private final FileChangeListener projectDeletionListener = new ProjectDeletionListener();
    private Thread loadingThread = null;
    static boolean quiet;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectManager() {
        factories.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ProjectManager.this.clearNonProjectCache();
            }
        });
    }

    public static ProjectManager getDefault() {
        return DEFAULT;
    }

    public static Mutex mutex() {
        return MUTEX;
    }

    void reset() {
        this.dir2Proj.clear();
        this.modifiedProjects.clear();
        this.proj2Factory.clear();
    }

    public Project findProject(final FileObject fileObject) throws IOException, IllegalArgumentException {
        if (fileObject == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to findProject");
        }
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to findProject: " + fileObject);
        }
        try {
            return (Project)ProjectManager.mutex().readAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                /*
                 * Exception decompiling
                 */
                public Object run() throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 3[TRYBLOCK]], but top level block is 7[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$api$project$ProjectManager == null ? (class$org$netbeans$api$project$ProjectManager = ProjectManager.class$("org.netbeans.api.project.ProjectManager")) : class$org$netbeans$api$project$ProjectManager).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private Project createProject(FileObject fileObject) throws IOException {
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !ProjectManager.mutex().isReadAccess()) {
            throw new AssertionError();
        }
        ProjectStateImpl projectStateImpl = new ProjectStateImpl();
        Iterator iterator = factories.allInstances().iterator();
        while (iterator.hasNext()) {
            ProjectFactory projectFactory = (ProjectFactory)iterator.next();
            Project project = projectFactory.loadProject(fileObject, projectStateImpl);
            if (project == null) continue;
            this.proj2Factory.put(project, projectFactory);
            projectStateImpl.attach(project);
            return project;
        }
        return null;
    }

    public boolean isProject(final FileObject fileObject) throws IllegalArgumentException {
        if (fileObject == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to isProject");
        }
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to isProject: " + fileObject);
        }
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){
            static final /* synthetic */ boolean $assertionsDisabled;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                Boolean bl;
                boolean bl2;
                block19: {
                    Boolean bl3;
                    block17: {
                        block18: {
                            Map map = ProjectManager.this.dir2Proj;
                            synchronized (map) {
                                Object v;
                                do {
                                    if ((v = ProjectManager.this.dir2Proj.get(fileObject)) != LOADING_PROJECT) continue;
                                    try {
                                        ProjectManager.this.dir2Proj.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                } while (v == LOADING_PROJECT);
                                if (!$assertionsDisabled && v == LOADING_PROJECT) {
                                    throw new AssertionError();
                                }
                                if (v == NO_SUCH_PROJECT) {
                                    return Boolean.FALSE;
                                }
                                if (v != null) {
                                    return Boolean.TRUE;
                                }
                                ProjectManager.this.dir2Proj.put(fileObject, LOADING_PROJECT);
                            }
                            bl2 = false;
                            try {
                                boolean bl4 = ProjectManager.this.checkForProject(fileObject);
                                Map map2 = ProjectManager.this.dir2Proj;
                                synchronized (map2) {
                                    bl2 = true;
                                    ProjectManager.this.dir2Proj.notifyAll();
                                    if (bl4) {
                                        ProjectManager.this.dir2Proj.put(fileObject, SOME_SUCH_PROJECT);
                                        bl3 = Boolean.TRUE;
                                        // MONITOREXIT @DISABLED, blocks:[16, 2, 6] lbl33 : MonitorExitStatement: MONITOREXIT : var3_6
                                        Object var7_9 = null;
                                        if (bl2) return bl3;
                                        if ($assertionsDisabled) break block17;
                                        break block18;
                                    }
                                    ProjectManager.this.dir2Proj.put(fileObject, NO_SUCH_PROJECT);
                                    bl = Boolean.FALSE;
                                }
                                break block19;
                            }
                            catch (Throwable throwable) {
                                Object var7_11 = null;
                                if (bl2) throw throwable;
                                if (!$assertionsDisabled && ProjectManager.this.dir2Proj.get(fileObject) != LOADING_PROJECT) {
                                    throw new AssertionError();
                                }
                                ProjectManager.this.dir2Proj.remove(fileObject);
                                throw throwable;
                            }
                        }
                        if (ProjectManager.this.dir2Proj.get(fileObject) != LOADING_PROJECT) {
                            throw new AssertionError();
                        }
                    }
                    ProjectManager.this.dir2Proj.remove(fileObject);
                    return bl3;
                }
                Object var7_10 = null;
                if (bl2) return bl;
                if (!$assertionsDisabled && ProjectManager.this.dir2Proj.get(fileObject) != LOADING_PROJECT) {
                    throw new AssertionError();
                }
                ProjectManager.this.dir2Proj.remove(fileObject);
                return bl;
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$api$project$ProjectManager == null ? (class$org$netbeans$api$project$ProjectManager = ProjectManager.class$("org.netbeans.api.project.ProjectManager")) : class$org$netbeans$api$project$ProjectManager).desiredAssertionStatus();
            }
        });
    }

    private boolean checkForProject(FileObject fileObject) {
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !fileObject.isFolder()) {
            throw new AssertionError(fileObject);
        }
        if (!$assertionsDisabled && !ProjectManager.mutex().isReadAccess()) {
            throw new AssertionError();
        }
        Iterator iterator = factories.allInstances().iterator();
        while (iterator.hasNext()) {
            ProjectFactory projectFactory = (ProjectFactory)iterator.next();
            if (!projectFactory.isProject(fileObject)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonProjectCache() {
        Map map = this.dir2Proj;
        synchronized (map) {
            this.dir2Proj.values().removeAll(Arrays.asList(NO_SUCH_PROJECT, SOME_SUCH_PROJECT));
        }
    }

    public Set getModifiedProjects() {
        return (Set)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                return new HashSet(ProjectManager.this.modifiedProjects);
            }
        });
    }

    public boolean isModified(final Project project) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    if (!ProjectManager.this.proj2Factory.containsKey(project)) {
                        throw new IllegalArgumentException("Project " + project + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                }
                return ProjectManager.this.modifiedProjects.contains(project);
            }
        });
    }

    public void saveProject(final Project project) throws IOException, IllegalArgumentException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    if (!ProjectManager.this.proj2Factory.containsKey(project)) {
                        throw new IllegalArgumentException("Project " + project + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                    if (ProjectManager.this.modifiedProjects.contains(project)) {
                        ProjectFactory projectFactory = (ProjectFactory)ProjectManager.this.proj2Factory.get(project);
                        projectFactory.saveProject(project);
                        ProjectManager.this.modifiedProjects.remove(project);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public void saveAllProjects() throws IOException {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public Object run() throws IOException {
                    Iterator iterator = ProjectManager.this.modifiedProjects.iterator();
                    while (iterator.hasNext()) {
                        Project project = (Project)iterator.next();
                        ProjectFactory projectFactory = (ProjectFactory)ProjectManager.this.proj2Factory.get(project);
                        if (!$assertionsDisabled && projectFactory == null) {
                            throw new AssertionError(project);
                        }
                        projectFactory.saveProject(project);
                        iterator.remove();
                    }
                    return null;
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$api$project$ProjectManager == null ? (class$org$netbeans$api$project$ProjectManager = ProjectManager.class$("org.netbeans.api.project.ProjectManager")) : class$org$netbeans$api$project$ProjectManager).desiredAssertionStatus();
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public boolean isValid(final Project project) {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    return ProjectManager.this.proj2Factory.containsKey(project);
                }
            }
        });
    }

    static /* synthetic */ Thread access$200(ProjectManager projectManager) {
        return projectManager.loadingThread;
    }

    static /* synthetic */ int access$300() {
        return ERR_LVL;
    }

    static /* synthetic */ ErrorManager access$400() {
        return ERR;
    }

    static /* synthetic */ Thread access$202(ProjectManager projectManager, Thread thread) {
        projectManager.loadingThread = thread;
        return projectManager.loadingThread;
    }

    static /* synthetic */ Project access$700(ProjectManager projectManager, FileObject fileObject) throws IOException {
        return projectManager.createProject(fileObject);
    }

    static /* synthetic */ FileChangeListener access$800(ProjectManager projectManager) {
        return projectManager.projectDeletionListener;
    }

    static {
        $assertionsDisabled = !ProjectManager.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault().getInstance(ProjectManager.class.getName());
        ERR_LVL = Boolean.getBoolean(ProjectManager.class.getName() + ".LOG_WARN") ? 16 : 1;
        factories = Lookup.getDefault().lookup(new Lookup.Template(ProjectFactory.class));
        DEFAULT = new ProjectManager();
        MUTEX = new Mutex();
        NO_SUCH_PROJECT = "NO_SUCH_PROJECT";
        SOME_SUCH_PROJECT = "SOME_SUCH_PROJECT";
        LOADING_PROJECT = "LOADING_PROJECT";
        quiet = false;
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            Map map = ProjectManager.this.dir2Proj;
            synchronized (map) {
                ProjectManager.this.dir2Proj.remove(fileEvent.getFile());
            }
        }
    }

    private final class ProjectStateImpl
    implements ProjectState {
        private Project p;
        static final /* synthetic */ boolean $assertionsDisabled;

        private ProjectStateImpl() {
        }

        void attach(Project project) {
            if (!$assertionsDisabled && project == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.p != null) {
                throw new AssertionError();
            }
            this.p = project;
        }

        public void markModified() {
            if (!$assertionsDisabled && this.p == null) {
                throw new AssertionError();
            }
            ProjectManager.mutex().writeAccess(new Mutex.Action(this){
                private final /* synthetic */ ProjectStateImpl this$1;
                {
                    this.this$1 = projectStateImpl;
                }

                public Object run() {
                    if (!ProjectManager.access$1300(ProjectStateImpl.access$1200(this.this$1)).containsKey(ProjectStateImpl.access$1100(this.this$1))) {
                        throw new IllegalStateException("An attempt to call ProjectState.markModified on a deleted project: " + ProjectStateImpl.access$1100(this.this$1).getProjectDirectory());
                    }
                    ProjectManager.access$1400(ProjectStateImpl.access$1200(this.this$1)).add(ProjectStateImpl.access$1100(this.this$1));
                    return null;
                }
            });
        }

        public void notifyDeleted() throws IllegalStateException {
            if (!$assertionsDisabled && this.p == null) {
                throw new AssertionError();
            }
            ProjectManager.mutex().writeAccess(new Mutex.Action(this){
                private final /* synthetic */ ProjectStateImpl this$1;
                {
                    this.this$1 = projectStateImpl;
                }

                public Object run() {
                    if (ProjectManager.access$1300(ProjectStateImpl.access$1200(this.this$1)).get(ProjectStateImpl.access$1100(this.this$1)) == null) {
                        throw new IllegalStateException("An attempt to call notifyDeleted more than once. Project: " + ProjectStateImpl.access$1100(this.this$1).getProjectDirectory());
                    }
                    ProjectManager.access$000(ProjectStateImpl.access$1200(this.this$1)).remove(ProjectStateImpl.access$1100(this.this$1).getProjectDirectory());
                    ProjectManager.access$1300(ProjectStateImpl.access$1200(this.this$1)).remove(ProjectStateImpl.access$1100(this.this$1));
                    ProjectManager.access$1400(ProjectStateImpl.access$1200(this.this$1)).remove(ProjectStateImpl.access$1100(this.this$1));
                    return null;
                }
            });
        }

        static /* synthetic */ Project access$1100(ProjectStateImpl projectStateImpl) {
            return projectStateImpl.p;
        }

        static /* synthetic */ ProjectManager access$1200(ProjectStateImpl projectStateImpl) {
            return projectStateImpl.ProjectManager.this;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$api$project$ProjectManager == null ? (class$org$netbeans$api$project$ProjectManager = ProjectManager.class$("org.netbeans.api.project.ProjectManager")) : class$org$netbeans$api$project$ProjectManager).desiredAssertionStatus();
        }
    }
}

