/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

public class ProjectUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (projectInformation != null) {
            return projectInformation;
        }
        return new BasicInformation(project);
    }

    public static Sources getSources(Project project) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources != null) {
            return sources;
        }
        return GenericSources.genericOnly(project);
    }

    public static boolean hasSubprojectCycles(final Project project, final Project project2) {
        return (Boolean)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                return ProjectUtils.visit(new HashSet(), project, project, project2);
            }
        });
    }

    private static boolean visit(Set set, Project project, Project project2, Project project3) {
        if (!set.add(project)) {
            return true;
        }
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider != null) {
            Iterator iterator = subprojectProvider.getSubprojects().iterator();
            while (iterator.hasNext()) {
                Project project4 = (Project)iterator.next();
                if (project3 == project4) {
                    project3 = null;
                }
                if (!ProjectUtils.visit(set, project4, project2, project3)) continue;
                return true;
            }
        }
        if (project3 != null && project == project2 && ProjectUtils.visit(set, project3, project2, project3)) {
            return true;
        }
        if (!$assertionsDisabled && !set.contains(project)) {
            throw new AssertionError();
        }
        set.remove(project);
        return false;
    }

    static {
        $assertionsDisabled = !ProjectUtils.class.desiredAssertionStatus();
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project project) {
            this.p = project;
        }

        public String getName() {
            try {
                return this.p.getProjectDirectory().getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return fileStateInvalidException.toString();
            }
        }

        public String getDisplayName() {
            return this.p.getProjectDirectory().getNameExt();
        }

        public Icon getIcon() {
            return new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/projectapi/resources/empty.gif"));
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public Project getProject() {
            return this.p;
        }
    }
}

