/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.util.Lookup;

public final class ProjectOperations {
    private ProjectOperations() {
    }

    public static List getMetadataFiles(Project project) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ProjectOperations.getProjectsOperationsImplementation(project).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((DataFilesProviderImplementation)iterator.next()).getMetadataFiles());
        }
        return arrayList;
    }

    public static List getDataFiles(Project project) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ProjectOperations.getProjectsOperationsImplementation(project).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((DataFilesProviderImplementation)iterator.next()).getDataFiles());
        }
        return arrayList;
    }

    public static boolean isDeleteOperationSupported(Project project) {
        return !ProjectOperations.getDeleteOperationImplementation(project).isEmpty();
    }

    public static void notifyDeleting(Project project) throws IOException {
        Iterator iterator = ProjectOperations.getDeleteOperationImplementation(project).iterator();
        while (iterator.hasNext()) {
            ((DeleteOperationImplementation)iterator.next()).notifyDeleting();
        }
    }

    public static void notifyDeleted(Project project) throws IOException {
        Iterator iterator = ProjectOperations.getDeleteOperationImplementation(project).iterator();
        while (iterator.hasNext()) {
            ((DeleteOperationImplementation)iterator.next()).notifyDeleted();
        }
    }

    public static boolean isCopyOperationSupported(Project project) {
        return !ProjectOperations.getCopyOperationImplementation(project).isEmpty();
    }

    public static void notifyCopying(Project project) throws IOException {
        Iterator iterator = ProjectOperations.getCopyOperationImplementation(project).iterator();
        while (iterator.hasNext()) {
            ((CopyOperationImplementation)iterator.next()).notifyCopying();
        }
    }

    public static void notifyCopied(Project project, Project project2, File file, String string) throws IOException {
        Iterator iterator = ProjectOperations.getCopyOperationImplementation(project).iterator();
        while (iterator.hasNext()) {
            ((CopyOperationImplementation)iterator.next()).notifyCopied(null, file, string);
        }
        iterator = ProjectOperations.getCopyOperationImplementation(project2).iterator();
        while (iterator.hasNext()) {
            ((CopyOperationImplementation)iterator.next()).notifyCopied(project, file, string);
        }
    }

    public static void notifyMoving(Project project) throws IOException {
        Iterator iterator = ProjectOperations.getMoveOperationImplementation(project).iterator();
        while (iterator.hasNext()) {
            ((MoveOperationImplementation)iterator.next()).notifyMoving();
        }
    }

    public static void notifyMoved(Project project, Project project2, File file, String string) throws IOException {
        Iterator iterator = ProjectOperations.getMoveOperationImplementation(project).iterator();
        while (iterator.hasNext()) {
            ((MoveOperationImplementation)iterator.next()).notifyMoved(null, file, string);
        }
        iterator = ProjectOperations.getMoveOperationImplementation(project2).iterator();
        while (iterator.hasNext()) {
            ((MoveOperationImplementation)iterator.next()).notifyMoved(project, file, string);
        }
    }

    public static boolean isMoveOperationSupported(Project project) {
        return true;
    }

    private static Collection getDeleteOperationImplementation(Project project) {
        return project.getLookup().lookup(new Lookup.Template(DeleteOperationImplementation.class)).allInstances();
    }

    private static Collection getProjectsOperationsImplementation(Project project) {
        return project.getLookup().lookup(new Lookup.Template(DataFilesProviderImplementation.class)).allInstances();
    }

    private static Collection getCopyOperationImplementation(Project project) {
        return project.getLookup().lookup(new Lookup.Template(CopyOperationImplementation.class)).allInstances();
    }

    private static Collection getMoveOperationImplementation(Project project) {
        return project.getLookup().lookup(new Lookup.Template(MoveOperationImplementation.class)).allInstances();
    }
}

