/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.netbeans.lib.gjast.ASLog;
import org.netbeans.lib.gjast.ASParser;
import org.netbeans.lib.gjast.lite.Scanner;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.JScanner;
import org.netbeans.lib.java.parser.ScannerToken;
import org.netbeans.lib.java.parser.Token;

public class ASScanner
extends com.sun.tools.javac.parser.Scanner
implements JScanner {
    private ArrayList<Token> tokens;
    public static final int INVALID_INDEX = -1;
    private boolean storeTokens;
    private int currentToken;
    private int curTokenType;
    private char[] srcBuffer;
    private int srcBufferLength;
    private int[] lineTable;
    private ASTContext astContext;
    Source source;
    Log log;
    private ArrayList<Token> padding = new ArrayList();
    private static final Token[] EMPTY_PADDING;
    private static final boolean ignoreSpaces = true;
    private Token lastToken = null;
    private int lastEndPos = 0;
    private boolean eof_returned = false;
    private static final Integer MOD_ABSTRACT;
    private static final Integer MOD_PUBLIC;
    private static final Integer MOD_PROTECTED;
    private static final Integer MOD_PRIVATE;
    private static final Integer MOD_STATIC;
    private static final Integer MOD_FINAL;
    private static final Integer MOD_SYNCHRONIZED;
    private static final Integer MOD_NATIVE;
    private static final Integer MOD_STRICTFP;
    private static final Integer MOD_TRANSIENT;
    private static final Integer MOD_VOLATILE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static final /* synthetic */ int[] $SwitchMap$com$sun$tools$javac$parser$Tokens;
    static final /* synthetic */ int[] $SwitchMap$com$sun$tools$javac$parser$Scanner$CommentStyle;

    public ASTree getToken(int index) {
        if (!$assertionsDisabled && !this.storeTokens) {
            throw new AssertionError();
        }
        return index != -1 && index < this.tokens.size() ? this.tokens.get(index) : null;
    }

    Token[] getTokens() {
        if (this.storeTokens && this.tokens != null) {
            Token[] array = new Token[this.tokens.size()];
            return this.tokens.toArray(array);
        }
        return null;
    }

    public int indexOf(int offset) {
        if (!$assertionsDisabled && !this.storeTokens) {
            throw new AssertionError();
        }
        int low = 0;
        int high = this.tokens.size() - 1;
        int idx;
        Token token;
        int tokenOffset;
        while ((tokenOffset = (token = this.tokens.get(idx = (low + high) / 2)).getStartOffset()) != offset) {
            if (low > high) {
                return -1;
            }
            if (tokenOffset < offset) {
                low = idx + 1;
                continue;
            }
            high = idx - 1;
        }
        return idx;
    }

    public int getCurrentTokenIndex() {
        if (!$assertionsDisabled && !this.storeTokens) {
            throw new AssertionError();
        }
        return this.currentToken;
    }

    protected ASScanner(Factory fac, char[] input, int inputLength, boolean storeTokens, ASTContext context) {
        super((Scanner.Factory)fac, input, inputLength);
        this.srcBuffer = input;
        this.srcBufferLength = inputLength;
        this.log = fac.log;
        this.source = fac.source;
        this.storeTokens = storeTokens;
        if (storeTokens) {
            this.tokens = new ArrayList();
        }
        this.currentToken = -1;
        this.lineTable = ASScanner.createLineTable(this.srcBuffer, inputLength);
        this.astContext = context;
    }

    public String yytext() {
        return this.stringVal().intern();
    }

    public int yylex() throws IOException {
        this.nextToken();
        return this.curTokenType;
    }

    public int yyhash() {
        return this.yytext().hashCode();
    }

    public boolean isDeprecated() {
        return this.deprecatedFlag();
    }

    public void nextToken() {
        super.nextToken();
        Tokens javacToken = this.token();
        this.curTokenType = this.convertJavacTokenToAST(javacToken);
        if (this.storeTokens && this.curTokenType != 0) {
            this.flushLineEndings();
            Object value = this.getValue(javacToken);
            if (this.curTokenType == 361) {
                if (javacToken == Tokens.ENUM) {
                    value = "enum";
                } else if (javacToken == Tokens.ASSERT) {
                    value = "assert";
                }
            }
            this.tokens.add(this.makeToken(this.curTokenType, value, this.pos(), this.endPos(), this.getPadding(), ++this.currentToken));
        }
    }

    public void token(Tokens token) {
        super.token(token);
        if (this.storeTokens) {
            Token oldToken = this.tokens.remove(this.currentToken--);
            int offset = oldToken.getStartOffset();
            this.tokens.add(this.makeToken(oldToken.getType(), oldToken.getValue(), offset++, offset, oldToken.getPadding(), ++this.currentToken));
            this.tokens.add(this.makeToken(this.convertJavacTokenToAST(token), oldToken.getValue(), offset, oldToken.getEndOffset(), null, ++this.currentToken));
        }
    }

    private Object getValue(Tokens type) {
        switch ($SwitchMap$com$sun$tools$javac$parser$Tokens[type.ordinal()]) {
            case 1: {
                return this.stringVal().intern();
            }
            case 2: {
                return this.stringVal().intern();
            }
            case 3: {
                return MOD_PUBLIC;
            }
            case 4: {
                return MOD_PRIVATE;
            }
            case 5: {
                return MOD_PROTECTED;
            }
            case 6: {
                return MOD_STATIC;
            }
            case 7: {
                return MOD_FINAL;
            }
            case 8: {
                return MOD_SYNCHRONIZED;
            }
            case 9: {
                return MOD_VOLATILE;
            }
            case 10: {
                return MOD_TRANSIENT;
            }
            case 11: {
                return MOD_NATIVE;
            }
            case 12: {
                return MOD_ABSTRACT;
            }
            case 13: {
                return MOD_STRICTFP;
            }
            case 14: {
                return Boolean.TRUE;
            }
            case 15: {
                return Boolean.FALSE;
            }
            case 16: {
                return new Character(this.stringVal().charAt(0));
            }
            case 17: {
                return this.intVal();
            }
            case 18: {
                return this.longVal();
            }
            case 19: {
                Float n;
                String proper = this.radix() == 16 ? "0x" + this.stringVal() : this.stringVal();
                try {
                    n = Float.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = new Float(Float.NaN);
                }
                return n;
            }
            case 20: {
                Double n;
                String proper = this.radix() == 16 ? "0x" + this.stringVal() : this.stringVal();
                try {
                    n = Double.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = new Double(Double.NaN);
                }
                return n;
            }
        }
        return null;
    }

    private Integer intVal() {
        String s = this.stringVal();
        try {
            if (s.equals("2147483648") && this.radix() == 10 && this.lastToken.getType() == 334) {
                return new Integer(Integer.MIN_VALUE);
            }
            return new Integer(Convert.string2int(s, this.radix()));
        }
        catch (NumberFormatException e) {
            this.log.error(this.pos(), "int.number.too.large", new Object[]{s});
            return new Integer(Integer.MIN_VALUE);
        }
    }

    private Long longVal() {
        String s = this.stringVal();
        try {
            if ((s.equals("9223372036854775808") || s.equals("9223372036854775808L")) && this.radix() == 10 && this.lastToken.getType() == 334) {
                return new Long(Long.MIN_VALUE);
            }
            return new Long(Convert.string2long(s, this.radix()));
        }
        catch (NumberFormatException e) {
            this.log.error(this.pos(), "int.number.too.large", new Object[]{s});
            return new Long(Long.MIN_VALUE);
        }
    }

    private Token[] getPadding() {
        Token[] padArray = new Token[this.padding.size()];
        this.padding.toArray(padArray);
        this.padding.clear();
        return padArray;
    }

    protected void processComment(Scanner.CommentStyle style) {
        if (this.storeTokens) {
            int tokenType;
            switch ($SwitchMap$com$sun$tools$javac$parser$Scanner$CommentStyle[style.ordinal()]) {
                case 1: {
                    tokenType = 362;
                    break;
                }
                case 2: {
                    tokenType = 364;
                    break;
                }
                case 3: {
                    tokenType = 363;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"unknown CommentStyle");
                    }
                    tokenType = 368;
                }
            }
            this.padding.add(this.makeToken(tokenType, this.pos(), this.endPos(), null, this.padding.size()));
        }
    }

    protected void processWhiteSpace() {
        if (this.storeTokens) {
            this.flushLineEndings();
            int start = this.pos();
            int end = this.endPos();
            boolean report = false;
            for (int i = start; i < end; ++i) {
                if (this.srcBuffer[i] == ' ') continue;
                report = true;
                break;
            }
            if (report) {
                this.padding.add(this.makeToken(365, start, end, null, this.padding.size()));
            } else {
                this.lastEndPos = end;
            }
        }
    }

    private void flushLineEndings() {
        int end = this.pos();
        if (this.lastEndPos < end) {
            this.padding.add((Token)new ScannerToken(366, this.lastEndPos, end, null, this.padding.size()));
        }
        this.lastEndPos = end;
    }

    private Token makeToken(int t, int start, int end, Token[] pad, int index) {
        return this.makeToken(t, null, start, end, pad, index);
    }

    private Token makeToken(int t, Object o, int start, int end, Token[] pad, int index) {
        this.flushLineEndings();
        this.lastEndPos = end;
        this.lastToken = new ScannerToken(t, o, start, end, pad, index, this.deprecatedFlag(), this.astContext);
        return this.lastToken;
    }

    private int convertJavacTokenToAST(Tokens javacToken) {
        switch ($SwitchMap$com$sun$tools$javac$parser$Tokens[javacToken.ordinal()]) {
            case 21: {
                if (this.eof_returned) {
                    return 0;
                }
                this.eof_returned = true;
                return 367;
            }
            case 22: {
                return 368;
            }
            case 1: {
                return 361;
            }
            case 12: {
                return 257;
            }
            case 23: {
                if (this.source.allowAsserts()) {
                    return 258;
                }
                return 361;
            }
            case 24: {
                return 259;
            }
            case 25: {
                return 260;
            }
            case 26: {
                return 261;
            }
            case 27: {
                return 262;
            }
            case 28: {
                return 263;
            }
            case 29: {
                return 264;
            }
            case 30: {
                return 265;
            }
            case 31: {
                return 266;
            }
            case 32: {
                return 267;
            }
            case 33: {
                return 268;
            }
            case 34: {
                return 269;
            }
            case 35: {
                return 270;
            }
            case 36: {
                return 271;
            }
            case 37: {
                if (this.source.allowEnums()) {
                    return 272;
                }
                return 361;
            }
            case 38: {
                return 273;
            }
            case 7: {
                return 274;
            }
            case 39: {
                return 275;
            }
            case 40: {
                return 276;
            }
            case 41: {
                return 277;
            }
            case 42: {
                return 278;
            }
            case 43: {
                return 279;
            }
            case 44: {
                return 280;
            }
            case 45: {
                return 281;
            }
            case 46: {
                return 282;
            }
            case 47: {
                return 283;
            }
            case 48: {
                return 284;
            }
            case 49: {
                return 285;
            }
            case 11: {
                return 286;
            }
            case 50: {
                return 287;
            }
            case 51: {
                return 288;
            }
            case 4: {
                return 289;
            }
            case 5: {
                return 290;
            }
            case 3: {
                return 291;
            }
            case 52: {
                return 292;
            }
            case 53: {
                return 293;
            }
            case 6: {
                return 294;
            }
            case 13: {
                return 295;
            }
            case 54: {
                return 296;
            }
            case 55: {
                return 297;
            }
            case 8: {
                return 298;
            }
            case 56: {
                return 299;
            }
            case 57: {
                return 300;
            }
            case 58: {
                return 301;
            }
            case 10: {
                return 302;
            }
            case 59: {
                return 303;
            }
            case 60: {
                return 304;
            }
            case 9: {
                return 305;
            }
            case 61: {
                return 306;
            }
            case 17: 
            case 18: {
                return 356;
            }
            case 19: 
            case 20: {
                return 357;
            }
            case 16: {
                return 358;
            }
            case 2: {
                return 359;
            }
            case 14: 
            case 15: {
                return 355;
            }
            case 62: {
                return 360;
            }
            case 63: {
                return 307;
            }
            case 64: {
                return 308;
            }
            case 65: {
                return 309;
            }
            case 66: {
                return 310;
            }
            case 67: {
                return 311;
            }
            case 68: {
                return 312;
            }
            case 69: {
                return 313;
            }
            case 70: {
                return 314;
            }
            case 71: {
                return 315;
            }
            case 72: {
                return 317;
            }
            case 73: {
                return 318;
            }
            case 74: {
                return 319;
            }
            case 75: {
                return 320;
            }
            case 76: {
                return 321;
            }
            case 77: {
                return 322;
            }
            case 78: {
                return 323;
            }
            case 79: {
                return 324;
            }
            case 80: {
                return 325;
            }
            case 81: {
                return 326;
            }
            case 82: {
                return 327;
            }
            case 83: {
                return 328;
            }
            case 84: {
                return 329;
            }
            case 85: {
                return 330;
            }
            case 86: {
                return 331;
            }
            case 87: {
                return 332;
            }
            case 88: {
                return 333;
            }
            case 89: {
                return 334;
            }
            case 90: {
                return 335;
            }
            case 91: {
                return 336;
            }
            case 92: {
                return 337;
            }
            case 93: {
                return 338;
            }
            case 94: {
                return 339;
            }
            case 95: {
                return 340;
            }
            case 96: {
                return 341;
            }
            case 97: {
                return 342;
            }
            case 98: {
                return 343;
            }
            case 99: {
                return 344;
            }
            case 100: {
                return 345;
            }
            case 101: {
                return 346;
            }
            case 102: {
                return 347;
            }
            case 103: {
                return 348;
            }
            case 104: {
                return 349;
            }
            case 105: {
                return 350;
            }
            case 106: {
                return 351;
            }
            case 107: {
                return 352;
            }
            case 108: {
                return 353;
            }
            case 109: {
                return 354;
            }
            case 110: {
                return 316;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("unmapped token " + javacToken));
        }
        return -1;
    }

    private static int[] createLineTable(char[] src, int max) {
        int c = 0;
        int i = 0;
        int[] linebuf = new int[max];
        block0: while (i < max) {
            linebuf[c++] = i;
            do {
                if (src[i] != '\r' && src[i] != '\n') continue;
                if (src[i] == '\r' && i + 1 < max && src[i + 1] == '\n') {
                    i += 2;
                    continue block0;
                }
                ++i;
                continue block0;
            } while (++i < max);
        }
        if (c < max) {
            linebuf[c++] = max;
        }
        int[] lines = new int[c];
        System.arraycopy(linebuf, 0, lines, 0, c);
        return lines;
    }

    static {
        $SwitchMap$com$sun$tools$javac$parser$Scanner$CommentStyle = new int[Scanner.CommentStyle.values().length];
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Scanner$CommentStyle[Scanner.CommentStyle.BLOCK.ordinal()] = 1;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Scanner$CommentStyle[Scanner.CommentStyle.JAVADOC.ordinal()] = 2;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Scanner$CommentStyle[Scanner.CommentStyle.LINE.ordinal()] = 3;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        $SwitchMap$com$sun$tools$javac$parser$Tokens = new int[Tokens.values().length];
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.IDENTIFIER.ordinal()] = 1;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STRINGLITERAL.ordinal()] = 2;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PUBLIC.ordinal()] = 3;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PRIVATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PROTECTED.ordinal()] = 5;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STATIC.ordinal()] = 6;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FINAL.ordinal()] = 7;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SYNCHRONIZED.ordinal()] = 8;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.VOLATILE.ordinal()] = 9;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TRANSIENT.ordinal()] = 10;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.NATIVE.ordinal()] = 11;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ABSTRACT.ordinal()] = 12;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STRICTFP.ordinal()] = 13;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TRUE.ordinal()] = 14;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FALSE.ordinal()] = 15;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CHARLITERAL.ordinal()] = 16;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INTLITERAL.ordinal()] = 17;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LONGLITERAL.ordinal()] = 18;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FLOATLITERAL.ordinal()] = 19;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DOUBLELITERAL.ordinal()] = 20;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EOF.ordinal()] = 21;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ERROR.ordinal()] = 22;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ASSERT.ordinal()] = 23;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BOOLEAN.ordinal()] = 24;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BREAK.ordinal()] = 25;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BYTE.ordinal()] = 26;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CASE.ordinal()] = 27;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CATCH.ordinal()] = 28;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CHAR.ordinal()] = 29;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CLASS.ordinal()] = 30;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CONST.ordinal()] = 31;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CONTINUE.ordinal()] = 32;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DEFAULT.ordinal()] = 33;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DO.ordinal()] = 34;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DOUBLE.ordinal()] = 35;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ELSE.ordinal()] = 36;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ENUM.ordinal()] = 37;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EXTENDS.ordinal()] = 38;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FINALLY.ordinal()] = 39;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FLOAT.ordinal()] = 40;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.FOR.ordinal()] = 41;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GOTO.ordinal()] = 42;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.IF.ordinal()] = 43;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.IMPLEMENTS.ordinal()] = 44;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.IMPORT.ordinal()] = 45;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INSTANCEOF.ordinal()] = 46;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INT.ordinal()] = 47;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.INTERFACE.ordinal()] = 48;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LONG.ordinal()] = 49;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.NEW.ordinal()] = 50;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PACKAGE.ordinal()] = 51;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RETURN.ordinal()] = 52;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SHORT.ordinal()] = 53;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUPER.ordinal()] = 54;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SWITCH.ordinal()] = 55;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.THIS.ordinal()] = 56;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.THROW.ordinal()] = 57;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.THROWS.ordinal()] = 58;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TRY.ordinal()] = 59;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.VOID.ordinal()] = 60;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.WHILE.ordinal()] = 61;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.NULL.ordinal()] = 62;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LPAREN.ordinal()] = 63;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RPAREN.ordinal()] = 64;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LBRACE.ordinal()] = 65;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RBRACE.ordinal()] = 66;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LBRACKET.ordinal()] = 67;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.RBRACKET.ordinal()] = 68;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SEMI.ordinal()] = 69;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.COMMA.ordinal()] = 70;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.DOT.ordinal()] = 71;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.ELLIPSIS.ordinal()] = 72;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EQ.ordinal()] = 73;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GT.ordinal()] = 74;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LT.ordinal()] = 75;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BANG.ordinal()] = 76;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.TILDE.ordinal()] = 77;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.QUES.ordinal()] = 78;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.COLON.ordinal()] = 79;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.EQEQ.ordinal()] = 80;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LTEQ.ordinal()] = 81;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTEQ.ordinal()] = 82;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BANGEQ.ordinal()] = 83;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.AMPAMP.ordinal()] = 84;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BARBAR.ordinal()] = 85;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PLUSPLUS.ordinal()] = 86;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUBSUB.ordinal()] = 87;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PLUS.ordinal()] = 88;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUB.ordinal()] = 89;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STAR.ordinal()] = 90;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SLASH.ordinal()] = 91;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.AMP.ordinal()] = 92;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BAR.ordinal()] = 93;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CARET.ordinal()] = 94;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PERCENT.ordinal()] = 95;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LTLT.ordinal()] = 96;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGT.ordinal()] = 97;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGTGT.ordinal()] = 98;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PLUSEQ.ordinal()] = 99;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SUBEQ.ordinal()] = 100;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.STAREQ.ordinal()] = 101;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.SLASHEQ.ordinal()] = 102;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.AMPEQ.ordinal()] = 103;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.BAREQ.ordinal()] = 104;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.CARETEQ.ordinal()] = 105;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.PERCENTEQ.ordinal()] = 106;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.LTLTEQ.ordinal()] = 107;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGTEQ.ordinal()] = 108;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.GTGTGTEQ.ordinal()] = 109;
        }
        catch (NoSuchFieldError ex) {
            // empty catch block
        }
        try {
            ASScanner.$SwitchMap$com$sun$tools$javac$parser$Tokens[Tokens.MONKEYS_AT.ordinal()] = 110;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        $assertionsDisabled = !ASScanner.class.desiredAssertionStatus();
        EMPTY_PADDING = new Token[0];
        MOD_ABSTRACT = new Integer(1024);
        MOD_PUBLIC = new Integer(1);
        MOD_PROTECTED = new Integer(4);
        MOD_PRIVATE = new Integer(2);
        MOD_STATIC = new Integer(8);
        MOD_FINAL = new Integer(16);
        MOD_SYNCHRONIZED = new Integer(32);
        MOD_NATIVE = new Integer(256);
        MOD_STRICTFP = new Integer(2048);
        MOD_TRANSIENT = new Integer(128);
        MOD_VOLATILE = new Integer(64);
    }

    public static class Factory
    extends Scanner.Factory {
        Log log;
        Source source;

        public static Scanner.Factory instance(Context context) {
            Scanner.Factory instance = (Scanner.Factory)context.get(scannerFactoryKey);
            if (instance == null) {
                instance = new Factory(context, ASLog.instance(context));
            }
            return instance;
        }

        protected Factory(Context context, Log log) {
            super(context);
            this.log = log;
            this.source = Source.instance(context);
        }

        public JScanner newScanner(char[] input, int inputLength, boolean storeTokens, ASTContext context) {
            return new ASScanner(this, input, inputLength, storeTokens, context);
        }

        public static JScanner newScanner(Reader in, String sourceLevel) {
            return Factory.newScanner(in, sourceLevel, false);
        }

        public static JScanner newScanner(Reader in, String sourceLevel, boolean liteScanning) {
            char[] input = ASParser.readInChars(in);
            int inputLength = input.length - 1;
            if (liteScanning) {
                return new Scanner(input, sourceLevel);
            }
            Context context = new Context();
            Options opts = Options.instance(context);
            if (sourceLevel != null) {
                opts.put("-source", sourceLevel);
            }
            Factory factory = (Factory)Factory.instance(context);
            return factory.newScanner(input, inputLength, false, null);
        }
    }
}

