/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.test;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.netbeans.lib.gjast.ASParser;
import org.netbeans.lib.gjast.ASTreeNode;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.netbeans.lib.java.parser.JParser;
import org.netbeans.lib.java.parser.ScannerToken;
import org.netbeans.lib.java.parser.Token;

public final class FootprintTest {
    static final boolean doAttribution = false;

    public static void main(String[] args) {
        String sourceLevel = "1.5";
        if (args.length == 0) {
            System.err.println("java FootprintTest.java [-source <level>] <file>");
        }
        ArrayList<JParser> astList = new ArrayList<JParser>();
        String[] arr$ = args;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String path = arr$[i$];
            astList.add(FootprintTest.compile(path));
        }
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
    }

    private FootprintTest() {
    }

    public static JParser compile(String filename) {
        ASParser parser = null;
        try {
            FileReader fileIn = new FileReader(filename);
            char[] src = FootprintTest.readInChars(fileIn);
            CharArrayReader in = new CharArrayReader(src);
            MiniContext ctx = new MiniContext(src, "1.5");
            parser = new ASParser(ctx, in, filename);
            ctx.setParser(parser);
            parser.parse(false);
            FootprintTest.verifyTree(parser.getASTree());
            FootprintTest.verifyTokens(parser.getTokens());
            System.out.println("parsed " + filename);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        return parser;
    }

    static void verifyTree(ASTree ast) {
        ASTree[] subTrees;
        if (ast == null) {
            return;
        }
        if (!(ast instanceof ASTreeNode) && !(ast instanceof ScannerToken)) {
            System.err.println("verifyTree: found " + ast.getClass().getName());
        }
        if (ast.getASTContext() == null) {
            System.err.println("verifyTree: null AST for " + ast.toString());
        }
        if ((subTrees = ast.getSubTrees()) != null) {
            ASTree[] arr$ = subTrees;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ASTree t = arr$[i$];
                FootprintTest.verifyTree(t);
            }
        }
    }

    static void verifyTokens(Token[] tok) {
        Token[] arr$ = tok;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Token t = arr$[i$];
            if (t instanceof ScannerToken) continue;
            System.err.println("found " + t.getClass().getName());
        }
    }

    static char[] readInChars(Reader in) {
        try {
            int n;
            CharArrayWriter out = new CharArrayWriter();
            char[] buf = new char[8192];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            return out.toCharArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class MiniContext
    implements ASTContext {
        JParser parser;
        String sourceText;
        String sourceLevel;
        ErrConsumer errConsumer = new ErrConsumer(){

            public void pushError(Object severity, String errorFileName, int line, int column, String message, String key, String[] args) {
                System.err.print(severity == ErrConsumer.ERROR ? "error: " : "warning: ");
                System.err.println(errorFileName + ":" + line + "," + column + ": " + message);
            }
        };

        MiniContext(char[] src, String sourceLevel) {
            this.sourceText = new String(src);
            this.sourceLevel = sourceLevel;
        }

        void setParser(JParser parser) {
            this.parser = parser;
        }

        public String getText(ASTree tree) {
            return tree == null ? null : this.getText(tree, tree);
        }

        public String getText(ASTree first, ASTree last) {
            int start = this.getToken(first.getFirstToken()).getStartOffset();
            int end = this.getToken(last.getLastToken()).getEndOffset();
            return this.sourceText.substring(start, end);
        }

        public String getText(Token token) {
            int start = token.getStartOffset();
            int end = token.getEndOffset();
            return this.sourceText.substring(start, end);
        }

        public Token getToken(int index) {
            Token[] tokens = this.parser.getTokens();
            return tokens[index];
        }

        public ASTree getRootTree() {
            return this.parser.getASTree();
        }

        public ASTree getParent(ASTree tree) {
            return null;
        }

        public String getSourceLevel() {
            return this.sourceLevel;
        }

        public String getClassPath() {
            String mycp = System.getProperty("gjast.class.path");
            if (mycp == null) {
                mycp = System.getProperty("java.class.path");
            }
            return mycp;
        }

        public ErrConsumer getErrorConsumer() {
            return this.errConsumer;
        }
    }
}

