/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.java.JavaKit;

class BracketCompletion {
    BracketCompletion() {
    }

    static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
        if (!(syntaxSupport instanceof ExtSyntaxSupport) || !BracketCompletion.completionSettingEnabled()) {
            return;
        }
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)syntaxSupport;
        if (c == ')' || c == ']' || c == '(' || c == '[') {
            TokenID tokenID = extSyntaxSupport.getTokenID(n);
            if (tokenID == JavaTokenContext.RBRACKET || tokenID == JavaTokenContext.RPAREN) {
                BracketCompletion.skipClosingBracket(baseDocument, caret, c);
            } else if (tokenID == JavaTokenContext.LBRACKET || tokenID == JavaTokenContext.LPAREN) {
                BracketCompletion.completeOpeningBracket(baseDocument, n, caret, c);
            }
        } else if (c == ';') {
            BracketCompletion.moveSemicolon(baseDocument, n, caret);
        }
    }

    private static void moveSemicolon(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        int n3 = n;
        TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n2);
        for (TokenItem tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getOffset() <= n2; tokenItem2 = tokenItem2.getNext()) {
            TokenID tokenID = tokenItem2.getTokenID();
            if (tokenID == JavaTokenContext.RPAREN) {
                n3 = tokenItem2.getOffset();
                continue;
            }
            if (tokenID == JavaTokenContext.WHITESPACE) continue;
            return;
        }
        if (BracketCompletion.isForLoopSemicolon(tokenItem) || BracketCompletion.posWithinAnyQuote(baseDocument, n)) {
            return;
        }
        baseDocument.remove(n, 1);
        baseDocument.insertString(n3, ";", null);
        caret.setDot(n3 + 1);
    }

    private static boolean isForLoopSemicolon(TokenItem tokenItem) {
        if (tokenItem == null || tokenItem.getTokenID() != JavaTokenContext.SEMICOLON) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            if (tokenItem.getTokenID() == JavaTokenContext.LPAREN) {
                if (n == 0) {
                    for (tokenItem = tokenItem.getPrevious(); tokenItem != null && (tokenItem.getTokenID() == JavaTokenContext.WHITESPACE || tokenItem.getTokenID() == JavaTokenContext.BLOCK_COMMENT || tokenItem.getTokenID() == JavaTokenContext.LINE_COMMENT); tokenItem = tokenItem.getPrevious()) {
                    }
                    return tokenItem.getTokenID() == JavaTokenContext.FOR;
                }
                --n;
                continue;
            }
            if (tokenItem.getTokenID() == JavaTokenContext.RPAREN) {
                ++n;
                continue;
            }
            if (tokenItem.getTokenID() == JavaTokenContext.LBRACE) {
                if (n2 == 0) {
                    return false;
                }
                --n2;
                continue;
            }
            if (tokenItem.getTokenID() == JavaTokenContext.RBRACE) {
                ++n2;
                continue;
            }
            if (tokenItem.getTokenID() != JavaTokenContext.SEMICOLON) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return false;
    }

    static void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (BracketCompletion.completionSettingEnabled()) {
            char[] cArray;
            if (c == '(' || c == '[') {
                TokenID tokenID = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenID(n);
                if (tokenID == JavaTokenContext.RBRACKET && BracketCompletion.tokenBalance(baseDocument, (TokenID)JavaTokenContext.LBRACKET, (TokenID)JavaTokenContext.RBRACKET) != 0 || tokenID == JavaTokenContext.RPAREN && BracketCompletion.tokenBalance(baseDocument, (TokenID)JavaTokenContext.LPAREN, (TokenID)JavaTokenContext.RPAREN) != 0) {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '\"') {
                char[] cArray2 = baseDocument.getChars(n, 1);
                if (cArray2 != null && cArray2[0] == '\"') {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '\'' && (cArray = baseDocument.getChars(n, 1)) != null && cArray[0] == '\'') {
                baseDocument.remove(n, 1);
            }
        }
    }

    static boolean isAddRightBrace(BaseDocument baseDocument, int n) throws BadLocationException {
        boolean bl = false;
        if (BracketCompletion.completionSettingEnabled() && n > 0) {
            int n2 = n;
            TokenItem tokenItem = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n2 - 1, n2);
            bl = true;
            int n3 = n - tokenItem.getOffset();
            if (n3 > 0 && n3 < tokenItem.getImage().length()) {
                switch (tokenItem.getTokenID().getNumericID()) {
                    case 5: 
                    case 7: {
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            if (bl) {
                int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                while (tokenItem != null && tokenItem.getOffset() >= n4) {
                    boolean bl2 = false;
                    switch (tokenItem.getTokenID().getNumericID()) {
                        case 5: 
                        case 7: 
                        case 8: {
                            bl2 = true;
                        }
                    }
                    if (!bl2) break;
                    tokenItem = tokenItem.getPrevious();
                }
                if (tokenItem == null || tokenItem.getTokenID() != JavaTokenContext.LBRACE || tokenItem.getOffset() < n4) {
                    bl = false;
                }
            }
            if (bl) {
                bl = BracketCompletion.braceBalance(baseDocument) > 0;
            }
        }
        return bl;
    }

    static int getRowOrBlockEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1 || n >= n2) {
            return n;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        block8: for (TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, ++n2); tokenItem != null && tokenItem.getOffset() < n2; tokenItem = tokenItem.getNext()) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 53: {
                    ++n3;
                    continue block8;
                }
                case 54: {
                    if (n3-- == 0) {
                        return tokenItem.getOffset();
                    }
                }
                case 57: {
                    ++n4;
                    continue block8;
                }
                case 58: {
                    if (n4-- == 0) {
                        return tokenItem.getOffset();
                    }
                }
                case 55: {
                    ++n5;
                    continue block8;
                }
                case 56: {
                    if (n5-- != 0) continue block8;
                    return tokenItem.getOffset();
                }
            }
        }
        return n2;
    }

    private static int braceBalance(BaseDocument baseDocument) throws BadLocationException {
        return BracketCompletion.tokenBalance(baseDocument, (TokenID)JavaTokenContext.LBRACE, (TokenID)JavaTokenContext.RBRACE);
    }

    private static int tokenBalance(BaseDocument baseDocument, TokenID tokenID, TokenID tokenID2) throws BadLocationException {
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        BalanceTokenProcessor balanceTokenProcessor = new BalanceTokenProcessor(tokenID, tokenID2);
        extSyntaxSupport.tokenizeText((TokenProcessor)balanceTokenProcessor, 0, baseDocument.getLength(), true);
        return balanceTokenProcessor.getBalance();
    }

    private static void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c) throws BadLocationException {
        BaseImageTokenID baseImageTokenID = c == ')' ? JavaTokenContext.RPAREN : JavaTokenContext.RBRACKET;
        int n = caret.getDot();
        if (BracketCompletion.isSkipClosingBracket(baseDocument, n, (TokenID)baseImageTokenID)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument baseDocument, int n, TokenID tokenID) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenItem tokenItem = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n, n + 1);
        if (tokenItem != null && tokenItem.getTokenID() == tokenID) {
            int n2;
            int n3 = tokenID.getNumericID();
            int n4 = n3 == 54 ? 53 : 55;
            for (TokenItem tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() == tokenID; tokenItem2 = tokenItem2.getNext()) {
                tokenItem = tokenItem2;
            }
            int n5 = 0;
            int n6 = -1;
            TokenItem tokenItem3 = tokenItem;
            boolean bl2 = false;
            block13: for (tokenItem = tokenItem.getPrevious(); !bl2 && tokenItem != null; tokenItem = tokenItem.getPrevious()) {
                n2 = tokenItem.getTokenID().getNumericID();
                switch (n2) {
                    case 53: 
                    case 55: {
                        if (n2 != n3 || ++n6 != 0) continue block13;
                        if (n5 != 0) {
                            n6 = 1;
                        }
                        bl2 = true;
                        continue block13;
                    }
                    case 54: 
                    case 56: {
                        if (n2 != n3) continue block13;
                        --n6;
                        continue block13;
                    }
                    case 57: {
                        if (++n5 <= 0) continue block13;
                        bl2 = true;
                        continue block13;
                    }
                    case 58: {
                        --n5;
                    }
                }
            }
            if (n6 != 0) {
                bl = true;
            } else {
                n5 = 0;
                n6 = 1;
                bl2 = false;
                block14: for (tokenItem = tokenItem3.getNext(); !bl2 && tokenItem != null; tokenItem = tokenItem.getPrevious()) {
                    n2 = tokenItem.getTokenID().getNumericID();
                    switch (n2) {
                        case 53: 
                        case 55: {
                            if (n2 != n4) continue block14;
                            ++n6;
                            continue block14;
                        }
                        case 54: 
                        case 56: {
                            if (n2 != n3 || --n6 != 0) continue block14;
                            if (n5 != 0) {
                                n6 = -1;
                            }
                            bl2 = true;
                            continue block14;
                        }
                        case 57: {
                            ++n5;
                            continue block14;
                        }
                        case 58: {
                            if (--n5 >= 0) continue block14;
                            bl2 = true;
                        }
                    }
                }
                bl = n6 == 0;
            }
        }
        return bl;
    }

    private static void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (BracketCompletion.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + BracketCompletion.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    static boolean completeQuote(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        boolean bl;
        if (!BracketCompletion.completionSettingEnabled()) {
            return false;
        }
        if (BracketCompletion.isEscapeSequence(baseDocument, n)) {
            return false;
        }
        SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
        if (!(syntaxSupport instanceof ExtSyntaxSupport)) {
            return false;
        }
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)syntaxSupport;
        TokenID tokenID = null;
        if (baseDocument.getLength() > n) {
            tokenID = extSyntaxSupport.getTokenID(n);
        }
        if (tokenID == JavaTokenContext.BLOCK_COMMENT || tokenID == JavaTokenContext.LINE_COMMENT) {
            return false;
        }
        boolean bl2 = BracketCompletion.isQuoteCompletablePosition(baseDocument, n);
        int n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        boolean bl3 = n2 < n;
        boolean bl4 = bl = tokenID == JavaTokenContext.STRING_LITERAL || tokenID == JavaTokenContext.CHAR_LITERAL;
        if (!bl && tokenID == JavaTokenContext.WHITESPACE && bl3 && n - 1 > 0) {
            tokenID = extSyntaxSupport.getTokenID(n - 1);
            boolean bl5 = bl = tokenID == JavaTokenContext.STRING_LITERAL || tokenID == JavaTokenContext.CHAR_LITERAL;
        }
        if (bl) {
            if (bl3) {
                return false;
            }
            char c2 = baseDocument.getChars(n, 1)[0];
            if (c2 == c) {
                baseDocument.insertString(n, "" + c, null);
                baseDocument.remove(n, 1);
                return true;
            }
        }
        if (bl2 && !bl || bl3) {
            baseDocument.insertString(n, "" + c + c, null);
            return true;
        }
        return false;
    }

    private static boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private static boolean isQuoteCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n == n2 || n2 == -1) {
            return false;
        }
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)n2);
        if (n3 == -1) {
            return false;
        }
        char c = baseDocument.getChars(n3, 1)[0];
        return c == ')' || c == ',' || c == '+' || c == '}' || c == ';';
    }

    private static boolean completionSettingEnabled() {
        return (Boolean)Settings.getValue((Class)JavaKit.class, (String)"pair-characters-completion");
    }

    private static char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return ' ';
    }

    static boolean posWithinString(BaseDocument baseDocument, int n) {
        return BracketCompletion.posWithinQuotes(baseDocument, n, '\"', (TokenID)JavaTokenContext.STRING_LITERAL);
    }

    static boolean posWithinQuotes(BaseDocument baseDocument, int n, char c, TokenID tokenID) {
        try {
            MyTokenProcessor myTokenProcessor = new MyTokenProcessor();
            baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)myTokenProcessor, n - 1, baseDocument.getLength(), true);
            return myTokenProcessor.tokenID == tokenID && (n - myTokenProcessor.tokenStart == 1 || baseDocument.getChars(n - 1, 1)[0] != c);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    static boolean posWithinAnyQuote(BaseDocument baseDocument, int n) {
        try {
            MyTokenProcessor myTokenProcessor = new MyTokenProcessor();
            baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)myTokenProcessor, n - 1, baseDocument.getLength(), true);
            if (myTokenProcessor.tokenID == JavaTokenContext.STRING_LITERAL || myTokenProcessor.tokenID == JavaTokenContext.CHAR_LITERAL) {
                char[] cArray = baseDocument.getChars(n - 1, 1);
                return n - myTokenProcessor.tokenStart == 1 || cArray[0] != '\"' && cArray[0] != '\'';
            }
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument baseDocument, int n) {
        try {
            MyTokenProcessor myTokenProcessor = new MyTokenProcessor();
            baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)myTokenProcessor, Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n), baseDocument.getLength(), true);
            return myTokenProcessor.tokenID == JavaTokenContext.STRING_LITERAL;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static class BalanceTokenProcessor
    implements TokenProcessor {
        private TokenID leftTokenID;
        private TokenID rightTokenID;
        private int balance;

        BalanceTokenProcessor(TokenID tokenID, TokenID tokenID2) {
            this.leftTokenID = tokenID;
            this.rightTokenID = tokenID2;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            if (tokenID == this.leftTokenID) {
                ++this.balance;
            } else if (tokenID == this.rightTokenID) {
                --this.balance;
            }
            return true;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        }

        public int getBalance() {
            return this.balance;
        }
    }

    static class MyTokenProcessor
    implements TokenProcessor {
        public TokenID tokenID = null;
        public int tokenStart = -1;
        private int bufferStartPos = 0;

        MyTokenProcessor() {
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            this.tokenStart = this.tokenBuffer2DocumentOffset(n);
            this.tokenID = tokenID;
            return false;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartPos = n3 - n;
        }

        private int tokenBuffer2DocumentOffset(int n) {
            return n + this.bufferStartPos;
        }
    }
}

