/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;

public final class GeneratorUtils {
    public static final int GETTER = 1;
    public static final int SETTER = 2;

    private GeneratorUtils() {
    }

    private static String getCapitalizedName(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static String[] getGetterSetterNames(Field field, boolean bl) {
        Type type;
        String[] stringArray = bl ? ((type = field.getType()) instanceof PrimitiveType && PrimitiveTypeKindEnum.BOOLEAN.equals((Object)((PrimitiveType)type).getKind()) ? new String[]{"is" + GeneratorUtils.getCapitalizedName(field.getName()), "get" + GeneratorUtils.getCapitalizedName(field.getName())} : new String[]{"get" + GeneratorUtils.getCapitalizedName(field.getName())}) : new String[]{"set" + GeneratorUtils.getCapitalizedName(field.getName())};
        return stringArray;
    }

    public static String getGetterSetterName(Field field, boolean bl) {
        return GeneratorUtils.getGetterSetterNames(field, bl)[0];
    }

    public static Method createGetterSetter(Field field, boolean bl, int n) {
        Feature[] featureArray;
        Object object;
        ClassDefinition classDefinition = field.getDeclaringClass();
        JavaModelPackage javaModelPackage = (JavaModelPackage)classDefinition.refImmediatePackage();
        Method method = javaModelPackage.getMethod().createMethod();
        boolean bl2 = false;
        TypeReference typeReference = JavaModelUtil.resolveImportsForType((Element)classDefinition, (Type)field.getType());
        Feature[] featureArray2 = field.getName();
        method.setName(GeneratorUtils.getGetterSetterName(field, bl));
        method.setModifiers(1 | (bl2 ? 8 : 0));
        if (bl) {
            method.setBodyText("return " + (String)featureArray2 + ";");
            method.setTypeName(typeReference);
        } else {
            object = javaModelPackage.getParameter().createParameter();
            featureArray = bl2 ? "a" + GeneratorUtils.getCapitalizedName((String)featureArray2) : featureArray2;
            object.setTypeName(typeReference);
            object.setName((String)featureArray);
            method.getParameters().add(object);
            if (bl2) {
                method.setBodyText((String)featureArray2 + " = " + (String)featureArray + ";");
            } else {
                method.setBodyText("this." + (String)featureArray2 + " = " + (String)featureArray + ";");
            }
            method.setType(javaModelPackage.getPrimitiveType().resolve("void"));
        }
        object = classDefinition.getFeatures();
        if (n == -1) {
            object.add(method);
        } else {
            featureArray = object.toArray(new Feature[0]);
            int n2 = -1;
            int n3 = 0;
            while (n3 < featureArray.length && JavaMetamodel.getManager().getElementPosition((Element)featureArray[n3]).getEnd().getOffset() < n) {
                n2 = n3++;
            }
            if (n2 == -1) {
                object.add(method);
            } else {
                object.add(n2 + 1, method);
            }
        }
        return method;
    }

    public static int checkForGetterSetter(Field field) {
        int n;
        ClassDefinition classDefinition = field.getDeclaringClass();
        String[] stringArray = GeneratorUtils.getGetterSetterNames(field, true);
        String[] stringArray2 = GeneratorUtils.getGetterSetterNames(field, false);
        boolean bl = false;
        boolean bl2 = false;
        List<Type> list = Collections.singletonList(field.getType());
        for (n = 0; n < stringArray.length; ++n) {
            if (classDefinition.getMethod(stringArray[n], Collections.EMPTY_LIST, false) == null) continue;
            bl = true;
            break;
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (classDefinition.getMethod(stringArray2[n], list, false) == null) continue;
            bl2 = true;
            break;
        }
        return (bl ? 1 : 0) | (bl2 ? 2 : 0);
    }

    public static void overrideMethod(ClassDefinition classDefinition, Method method, int n) {
        ClassMember[] classMemberArray;
        Method method2;
        int n2 = method.getModifiers();
        List list = classDefinition.getContents();
        if (method.getResource().getName().endsWith(".class")) {
            method2 = (Method)JavaModelUtil.duplicateInScope((Element)classDefinition, (Element)method);
        } else {
            classMemberArray = (ClassMember[])method.duplicate();
            classMemberArray.setJavadocText(null);
            classMemberArray.setBody(null);
            method2 = (Method)JavaModelUtil.duplicateInScope((Element)classDefinition, (Element)classMemberArray);
            classMemberArray.refDelete();
        }
        method2.setModifiers(n2 & 0xFFFFFADF);
        if (n == -1) {
            list.add(method2);
        } else {
            classMemberArray = list.toArray(new ClassMember[0]);
            int n3 = -1;
            int n4 = 0;
            while (n4 < classMemberArray.length && JavaMetamodel.getManager().getElementPosition((Element)classMemberArray[n4]).getEnd().getOffset() < n) {
                n3 = n4++;
            }
            if (n3 == -1) {
                list.add(method2);
            } else {
                list.add(n3 + 1, method2);
            }
        }
    }
}

