/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class JCExtension {
    public static boolean equals(JCClass jCClass, ClassElement classElement) {
        return jCClass.getFullName().equals(classElement.getName().getFullName());
    }

    public static boolean equals(JCType jCType, Type type) {
        int n = 0;
        while (type.isArray()) {
            ++n;
            type = type.getElementType();
        }
        String string = type.isPrimitive() ? type.getFullString() : type.getClassName().getFullName();
        return jCType.getArrayDepth() == n && jCType.getClazz().getFullName().equals(string);
    }

    public static boolean equals(JCField jCField, FieldElement fieldElement) {
        return jCField.getName().equals(fieldElement.getName().getFullName()) && JCExtension.equals(jCField.getType(), fieldElement.getType());
    }

    public static boolean equals(JCConstructor jCConstructor, ConstructorElement constructorElement) {
        JCParameter[] jCParameterArray = jCConstructor.getParameters();
        MethodParameter[] methodParameterArray = constructorElement.getParameters();
        if (methodParameterArray == null || jCParameterArray.length != methodParameterArray.length) {
            return false;
        }
        for (int i = jCParameterArray.length - 1; i >= 0; --i) {
            if (JCExtension.equals(jCParameterArray[i].getType(), methodParameterArray[i].getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(JCMethod jCMethod, MethodElement methodElement) {
        return jCMethod.getName().equals(methodElement.getName().getFullName()) && JCExtension.equals((JCConstructor)jCMethod, (ConstructorElement)methodElement);
    }

    public static FieldElement findFieldElement(JCField jCField, ClassElement classElement) {
        FieldElement[] fieldElementArray = classElement.getFields();
        if (fieldElementArray != null) {
            for (int i = 0; i < fieldElementArray.length; ++i) {
                if (!JCExtension.equals(jCField, fieldElementArray[i])) continue;
                return fieldElementArray[i];
            }
        }
        return null;
    }

    public static ConstructorElement findConstructorElement(JCConstructor jCConstructor, ClassElement classElement) {
        ConstructorElement[] constructorElementArray = classElement.getConstructors();
        if (constructorElementArray != null) {
            for (int i = 0; i < constructorElementArray.length; ++i) {
                if (!JCExtension.equals(jCConstructor, constructorElementArray[i])) continue;
                return constructorElementArray[i];
            }
        }
        return null;
    }

    public static MethodElement findMethodElement(JCMethod jCMethod, ClassElement classElement) {
        MethodElement[] methodElementArray = classElement.getMethods();
        if (methodElementArray != null) {
            for (int i = 0; i < methodElementArray.length; ++i) {
                if (!JCExtension.equals(jCMethod, methodElementArray[i])) continue;
                return methodElementArray[i];
            }
        }
        return null;
    }

    public static ClassPath getFullClassPath(FileObject fileObject) {
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null) {
            arrayList.add(classPath);
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")) != null) {
            arrayList.add(classPath);
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot")) != null) {
            arrayList.add(classPath);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])arrayList.toArray(new ClassPath[arrayList.size()]));
    }

    static JCClass findResultInnerClass(JCFinder jCFinder, JCClass jCClass, String string, Document document) {
        if (jCClass == null || string == null) {
            return null;
        }
        ClassElement classElement = ClassElement.forName((String)jCClass.getFullName(), (FileObject)NbEditorUtilities.getDataObject((Document)document).getPrimaryFile());
        if (classElement == null) {
            return null;
        }
        ClassElement[] classElementArray = classElement.getClasses();
        if (string != null) {
            for (int i = 0; i < classElementArray.length; ++i) {
                JCClass jCClass2;
                if (!string.equals(classElementArray[i].getName().getName()) && !string.equals(classElementArray[i].getName().getFullName()) || (jCClass2 = jCFinder.getExactClass(classElementArray[i].getName().getFullName())) == null) continue;
                return jCClass2;
            }
        }
        return null;
    }

    static int findEndOfMethod(JTextComponent jTextComponent, int n) {
        return JCExtension.findEndOfMethod((BaseDocument)jTextComponent.getDocument(), n);
    }

    static int findEndOfMethod(BaseDocument baseDocument, int n) {
        ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
        ClosingParenProcessor closingParenProcessor = new ClosingParenProcessor();
        try {
            extSyntaxSupport.tokenizeText((TokenProcessor)closingParenProcessor, n, baseDocument.getLength(), false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return closingParenProcessor.getClosingParenOffset();
    }

    private static Object findImportedItem(NbJavaSyntaxSupport nbJavaSyntaxSupport, CompletionQuery.Result result) {
        return JCExtension.findImportedItem(nbJavaSyntaxSupport, result, null);
    }

    private static Object findImportedItem(NbJavaSyntaxSupport nbJavaSyntaxSupport, CompletionQuery.Result result, String string) {
        nbJavaSyntaxSupport.refreshJavaImport();
        String string2 = nbJavaSyntaxSupport.getPackage();
        for (int i = 0; i < result.getData().size(); ++i) {
            Object object = result.getData().get(i);
            if (object instanceof JCResultItem) {
                object = ((JCResultItem)object).getAssociatedObject();
            }
            if (!(object instanceof JCClass)) continue;
            JCClass jCClass = (JCClass)object;
            String string3 = jCClass.getPackageName();
            if (!nbJavaSyntaxSupport.isImported(jCClass) && !string2.equals(string3) || string != null && !string.equals(jCClass.getName())) continue;
            Object object2 = result.getData().get(i);
            if (object2 instanceof JCResultItem) {
                object2 = ((JCResultItem)object2).getAssociatedObject();
            }
            return object2;
        }
        return null;
    }

    private static Object findResultInnerItem(NbJavaSyntaxSupport nbJavaSyntaxSupport, CompletionQuery.Result result, Document document) {
        ClassElement classElement;
        JCClass jCClass = nbJavaSyntaxSupport.getTopClass();
        if (jCClass != null && (classElement = ClassElement.forName((String)jCClass.getFullName(), (FileObject)NbEditorUtilities.getDataObject((Document)document).getPrimaryFile())) != null) {
            ClassElement[] classElementArray = classElement.getClasses();
            for (int i = 0; i < result.getData().size(); ++i) {
                int n;
                JCMethod[] jCMethodArray;
                JCClass jCClass2;
                JCClass jCClass3;
                JCMethod jCMethod;
                Object object = result.getData().get(i);
                if (object instanceof JCResultItem) {
                    object = ((JCResultItem)object).getAssociatedObject();
                }
                if (object instanceof JCClass) {
                    return JCExtension.findResultInnerClass(nbJavaSyntaxSupport.getFinder(), jCClass, ((JCClass)object).getFullName(), document);
                }
                if (object instanceof JCMethod) {
                    jCMethod = (JCMethod)object;
                    jCClass3 = jCMethod.getClazz();
                    if (jCClass3 == null || (jCClass2 = JCExtension.findResultInnerClass(nbJavaSyntaxSupport.getFinder(), jCClass, jCClass3.getFullName(), document)) == null) continue;
                    jCMethodArray = jCClass2.getMethods();
                    for (n = 0; n < jCMethodArray.length; ++n) {
                        if (!jCMethodArray[n].equals(jCMethod)) continue;
                        return jCMethodArray[n];
                    }
                }
                if (object instanceof JCConstructor) {
                    jCMethod = (JCConstructor)object;
                    jCClass3 = jCMethod.getClazz();
                    if (jCClass3 == null || (jCClass2 = JCExtension.findResultInnerClass(nbJavaSyntaxSupport.getFinder(), jCClass, jCClass3.getFullName(), document)) == null) continue;
                    jCMethodArray = jCClass2.getConstructors();
                    for (n = 0; n < jCMethodArray.length; ++n) {
                        if (!jCMethodArray[n].equals(jCMethod)) continue;
                        return jCMethodArray[n];
                    }
                    return jCClass2;
                }
                if (!(object instanceof JCField) || (jCClass3 = (jCMethod = (JCField)object).getClazz()) == null || (jCClass2 = JCExtension.findResultInnerClass(nbJavaSyntaxSupport.getFinder(), jCClass, jCClass3.getFullName(), document)) == null) continue;
                jCMethodArray = jCClass2.getFields();
                for (n = 0; n < jCMethodArray.length; ++n) {
                    if (!jCMethodArray[n].equals(jCMethod)) continue;
                    return jCMethodArray[n];
                }
            }
        }
        return null;
    }

    public static Object findItemAtCaretPos(JTextComponent jTextComponent) {
        Object object = null;
        Completion completion = ExtUtilities.getCompletion((JTextComponent)jTextComponent);
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
        NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(NbJavaSyntaxSupport.class);
        if (completion != null) {
            if (completion.isPaneVisible()) {
                object = completion.getSelectedValue();
                if (object instanceof JCResultItem) {
                    object = ((JCResultItem)object).getAssociatedObject();
                }
                if (object != null) {
                    return object;
                }
            } else {
                try {
                    int n = jTextComponent.getCaret().getDot();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)baseDocument, (int)n);
                    if (nArray == null || n > 0 && baseDocument.getChars(n - 1, 1)[0] == '(' && n == nArray[0]) {
                        nArray = new int[]{n, n};
                    }
                    for (int i = nArray.length - 1; i >= 1; --i) {
                        Object object2;
                        Object object3;
                        int n2;
                        CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[i], syntaxSupport);
                        if (result == null || result.getData().size() <= 0) continue;
                        Object object4 = result.getData().get(0);
                        if (object4 instanceof JCResultItem) {
                            object4 = ((JCResultItem)object4).getAssociatedObject();
                        }
                        if ((object4 instanceof JCConstructor || object4 instanceof JCMethod) && result.getData().size() > 1 && (n2 = JCExtension.findEndOfMethod(jTextComponent, nArray[i])) > -1 && (object3 = completion.getQuery().query(jTextComponent, n2, syntaxSupport)) != null && object3.getData().size() > 0) {
                            object2 = object3.getData().get(0);
                            if (object2 instanceof JCResultItem) {
                                object2 = ((JCResultItem)object2).getAssociatedObject();
                            }
                            return object2;
                        }
                        Object object5 = JCExtension.findResultInnerItem(nbJavaSyntaxSupport, result, (Document)baseDocument);
                        if (object5 != null) {
                            return object5;
                        }
                        object3 = JCExtension.findImportedItem(nbJavaSyntaxSupport, result);
                        if (object3 != null) {
                            return object3;
                        }
                        object2 = result.getData().get(0);
                        if (!(object2 instanceof JCResultItem)) continue;
                        return ((JCResultItem)object2).getAssociatedObject();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static final class ClosingParenProcessor
    implements TokenProcessor {
        private int bufferStartOffset;
        private int level = 0;
        private int closingParenOffset = -1;

        private ClosingParenProcessor() {
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartOffset = n3 - n;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            int n3 = this.bufferStartOffset + n;
            switch (tokenID.getNumericID()) {
                case 53: {
                    ++this.level;
                    break;
                }
                case 54: {
                    if (this.level == 0) {
                        this.closingParenOffset = n3 + 1;
                        return false;
                    }
                    --this.level;
                    break;
                }
                case 51: {
                    return false;
                }
            }
            return true;
        }

        public int getClosingParenOffset() {
            return this.closingParenOffset;
        }
    }
}

