/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.MethodParamsTipPaintComponent;
import org.netbeans.modules.editor.java.NbJMICompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMICompletionQuery;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.NbBundle;

public class JavaCompletionProvider
implements CompletionProvider {
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaCompletionProvider;

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        JavaSyntaxSupport javaSyntaxSupport = (JavaSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(JavaSyntaxSupport.class);
        if (".".equals(string) && !javaSyntaxSupport.isCompletionDisabled(jTextComponent.getCaret().getDot())) {
            return 1;
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (n == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(jTextComponent.getCaret().getDot()), jTextComponent);
        }
        if (n == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), jTextComponent);
        }
        if (n == 4) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new ToolTipQuery(), jTextComponent);
        }
        return null;
    }

    static class ToolTipQuery
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private JToolTip queryToolTip;
        private Position queryMethodParamsStartPos = null;
        private boolean otherMethodContext;

        ToolTipQuery() {
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            Position position = this.queryMethodParamsStartPos;
            this.queryMethodParamsStartPos = null;
            NbJavaJMICompletionQuery nbJavaJMICompletionQuery = new NbJavaJMICompletionQuery(true);
            BaseDocument baseDocument = (BaseDocument)document;
            NbJavaJMICompletionQuery.JavaResult javaResult = (NbJavaJMICompletionQuery.JavaResult)nbJavaJMICompletionQuery.tipQuery(this.component, n, baseDocument.getSyntaxSupport(), false);
            if (javaResult != null) {
                this.queryCaretOffset = n;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = -1;
                boolean bl = false;
                Iterator iterator = javaResult.getData().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object e = iterator.next();
                    if (!(e instanceof NbJMIResultItem.CallableFeatureResultItem)) continue;
                    NbJMIResultItem.CallableFeatureResultItem callableFeatureResultItem = (NbJMIResultItem.CallableFeatureResultItem)e;
                    if (!bl) {
                        object = callableFeatureResultItem.substituteExp;
                        if (object.getTokenCount() > 0) {
                            try {
                                this.queryMethodParamsStartPos = baseDocument.createPosition(object.getTokenOffset(0));
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        bl = true;
                    }
                    if ((object = callableFeatureResultItem.createParamsList()).size() > 0) {
                        n2 = callableFeatureResultItem.getCurrentParamIndex();
                    } else {
                        object.add(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JavaCompletionProvider == null ? JavaCompletionProvider.class$("org.netbeans.modules.editor.java.JavaCompletionProvider") : class$org$netbeans$modules$editor$java$JavaCompletionProvider), (String)"JCP-no-parameters"));
                    }
                    arrayList.add(object);
                }
                this.queryAnchorOffset = javaResult.getSubstituteOffset() + 1;
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                this.queryToolTip = new MethodParamsTipPaintComponent(arrayList, n2);
                completionResultSet.setToolTip(this.queryToolTip);
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            String string = null;
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            try {
                string = n - this.queryCaretOffset > 0 ? document.getText(this.queryCaretOffset, n - this.queryCaretOffset) : (n - this.queryCaretOffset < 0 ? document.getText(n, this.queryCaretOffset - n) : "");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string == null) {
                return false;
            }
            boolean bl = true;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case ',': {
                        bl = false;
                        break;
                    }
                    case '(': {
                        ++n2;
                        bl = false;
                        break;
                    }
                    case ')': {
                        --n2;
                        bl = false;
                    }
                }
                if (n2 >= 0) continue;
                this.otherMethodContext = true;
            }
            if (this.otherMethodContext && n2 < 0) {
                this.otherMethodContext = false;
            }
            if (this.queryMethodParamsStartPos == null || n <= this.queryMethodParamsStartPos.getOffset()) {
                bl = false;
            }
            return this.otherMethodContext || bl;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (!this.otherMethodContext) {
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                completionResultSet.setToolTip(this.queryToolTip);
            }
            completionResultSet.finish();
        }
    }

    static class DocQuery
    extends AsyncCompletionQuery {
        private Object item;
        private JTextComponent component;

        DocQuery(Object object) {
            this.item = object;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            if (this.item == null) {
                this.item = JMIUtils.findItemAtCaretPos(this.component);
            }
            if (this.item != null) {
                completionResultSet.setDocumentation((CompletionDocumentation)new DocItem(this.getAssociatedObject(this.item), ExtUtilities.getExtEditorUI((JTextComponent)this.component)));
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        private Object getAssociatedObject(Object object) {
            Object object2 = object;
            if (object instanceof NbJMIResultItem) {
                object2 = ((NbJMIResultItem)object).getAssociatedObject();
            }
            if (object2 instanceof Feature) {
                object2 = JMIUtils.getDefintion((Feature)object2);
            }
            if (object2 instanceof ClassDefinition) {
                object2 = JMIUtils.getSourceElementIfExists((ClassDefinition)object2);
            }
            return object2;
        }

        private class DocItem
        implements CompletionDocumentation {
            private String text;
            private MyJavaDoc doc;
            private Action goToSource = null;
            private ExtEditorUI ui;
            private URL url;

            public DocItem(Object object, ExtEditorUI extEditorUI) {
                Resource resource;
                this.ui = extEditorUI;
                this.doc = new MyJavaDoc(extEditorUI);
                this.doc.setItem(object);
                this.url = this.getURL(object);
                Resource resource2 = resource = object instanceof Element && ((Element)object).isValid() ? ((Element)object).getResource() : null;
                if (resource != null && resource.getName().endsWith(".java")) {
                    this.goToSource = new AbstractAction(this, object){
                        private final /* synthetic */ Object val$item;
                        private final /* synthetic */ DocItem this$1;
                        {
                            this.this$1 = docItem;
                            this.val$item = object;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            JMIUtils.openElement((Element)this.val$item);
                            if (actionEvent != null) {
                                Completion.get().hideDocumentation();
                            }
                        }
                    };
                }
            }

            public CompletionDocumentation resolveLink(String string) {
                Object object = this.doc.parseLink(string, (ClassDefinition)((JavaClass)null));
                return object != null ? new DocItem(object, this.ui) : null;
            }

            public String getText() {
                return this.text;
            }

            public URL getURL() {
                return this.url;
            }

            private URL getURL(Object object) {
                return this.doc.getURL(object);
            }

            public Action getGotoSourceAction() {
                return this.goToSource;
            }

            private class MyJavaDoc
            extends NbJMICompletionJavaDoc {
                private MyJavaDoc(ExtEditorUI extEditorUI) {
                    super(extEditorUI);
                }

                private void setItem(Object object) {
                    new MyJavaDocParser(object).run();
                }

                private URL getURL(Object object) {
                    URL[] uRLArray = this.getJMISyntaxSupport().getJavaDocURLs(object);
                    return uRLArray == null || uRLArray.length < 1 ? null : uRLArray[0];
                }

                private class MyJavaDocParser
                extends NbJMICompletionJavaDoc.JMIParsingThread {
                    private MyJavaDocParser(Object object) {
                        super(MyJavaDoc.this, object);
                    }

                    protected void showJavaDoc(String string) {
                        DocItem.this.text = string;
                    }
                }
            }
        }
    }

    static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private NbJavaJMICompletionQuery.JavaResult queryResult;
        private int creationCaretOffset;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;

        Query(int n) {
            this.creationCaretOffset = n;
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            if (n >= this.creationCaretOffset) {
                try {
                    if (this.isJavaIdentifierPart(document.getText(this.creationCaretOffset, n - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            NbJavaJMICompletionQuery nbJavaJMICompletionQuery;
            NbJavaJMICompletionQuery.JavaResult javaResult;
            if (JavaMetamodel.getManager().isScanInProgress()) {
                completionResultSet.setWaitText(NbBundle.getMessage((Class)(class$org$netbeans$modules$editor$java$JavaCompletionProvider == null ? (class$org$netbeans$modules$editor$java$JavaCompletionProvider = JavaCompletionProvider.class$("org.netbeans.modules.editor.java.JavaCompletionProvider")) : class$org$netbeans$modules$editor$java$JavaCompletionProvider), (String)"scanning-in-progress"));
            }
            if ((javaResult = (NbJavaJMICompletionQuery.JavaResult)(nbJavaJMICompletionQuery = new NbJavaJMICompletionQuery(true)).query(this.component, n, Utilities.getSyntaxSupport((JTextComponent)this.component))) != null) {
                this.queryCaretOffset = n;
                this.queryAnchorOffset = javaResult.getSubstituteOffset();
                completionResultSet.setTitle(javaResult.getTitle());
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                completionResultSet.addAllItems((Collection)javaResult.getData());
                this.queryResult = javaResult;
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            this.filterPrefix = null;
            if (n >= this.queryCaretOffset && this.queryAnchorOffset > -1) {
                try {
                    this.filterPrefix = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                    if (!this.isJavaIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                completionResultSet.setTitle(this.getFilteredTitle(this.queryResult.getTitle(), this.filterPrefix));
                completionResultSet.setAnchorOffset(this.queryAnchorOffset);
                completionResultSet.addAllItems(this.getFilteredData(this.queryResult.getData(), this.filterPrefix));
            }
            completionResultSet.finish();
        }

        private boolean isJavaIdentifierPart(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection collection, String string) {
            ArrayList<CompletionQuery.ResultItem> arrayList = new ArrayList<CompletionQuery.ResultItem>();
            boolean bl = string.length() > 1 && string.equals(string.toUpperCase());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CompletionQuery.ResultItem resultItem = (CompletionQuery.ResultItem)iterator.next();
                if (!JMIUtils.startsWith(resultItem.getItemText(), string) && (!bl || !(resultItem instanceof NbJMIResultItem.ClassResultItem) || !JMIUtils.matchesCamelCase(resultItem.getItemText(), string))) continue;
                arrayList.add(resultItem);
            }
            return arrayList;
        }

        private String getFilteredTitle(String string, String string2) {
            String string3;
            int n = string.lastIndexOf(46);
            String string4 = string3 = n == -1 ? string2 : string.substring(0, n + 1) + string2;
            if (string.endsWith("*")) {
                string3 = string3 + "*";
            }
            return string3;
        }
    }
}

