/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSettingsDefaults;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.java.JavaKit;

public class JavaIndentEngine
extends FormatterIndentEngine {
    public static final String JAVA_FORMAT_NEWLINE_BEFORE_BRACE_PROP = "javaFormatNewlineBeforeBrace";
    public static final String JAVA_FORMAT_SPACE_BEFORE_PARENTHESIS_PROP = "javaFormatSpaceBeforeParenthesis";
    public static final String JAVA_FORMAT_LEADING_STAR_IN_COMMENT_PROP = "javaFormatLeadingStarInComment";
    public static final String JAVA_FORMAT_STATEMENT_CONTINUATION_INDENT_PROP = "javaFormatStatementContinuationIndent";
    static final long serialVersionUID = -7936605291288152329L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("javaFormatNewlineBeforeBrace", Boolean.TYPE), new ObjectStreamField("javaFormatSpaceBeforeParenthesis", Boolean.TYPE), new ObjectStreamField("javaFormatLeadingStarInComment", Boolean.TYPE), new ObjectStreamField("javaFormatStatementContinuationIndent", Integer.TYPE)};

    public JavaIndentEngine() {
        this.setAcceptedMimeTypes(new String[]{"text/x-java"});
    }

    protected ExtFormatter createFormatter() {
        return new JavaFormatter(JavaKit.class);
    }

    public boolean getJavaFormatSpaceBeforeParenthesis() {
        Boolean bl = (Boolean)this.getValue("java-format-space-before-parenthesis");
        if (bl == null) {
            bl = JavaSettingsDefaults.defaultJavaFormatSpaceBeforeParenthesis;
        }
        return bl;
    }

    public void setJavaFormatSpaceBeforeParenthesis(boolean bl) {
        this.setValue("java-format-space-before-parenthesis", bl ? Boolean.TRUE : Boolean.FALSE, JAVA_FORMAT_SPACE_BEFORE_PARENTHESIS_PROP);
    }

    public boolean getJavaFormatNewlineBeforeBrace() {
        Boolean bl = (Boolean)this.getValue("java-format-newline-before-brace");
        if (bl == null) {
            bl = JavaSettingsDefaults.defaultJavaFormatNewlineBeforeBrace;
        }
        return bl;
    }

    public void setJavaFormatNewlineBeforeBrace(boolean bl) {
        this.setValue("java-format-newline-before-brace", bl ? Boolean.TRUE : Boolean.FALSE, JAVA_FORMAT_NEWLINE_BEFORE_BRACE_PROP);
    }

    public boolean getJavaFormatLeadingStarInComment() {
        Boolean bl = (Boolean)this.getValue("java-format-leading-star-in-comment");
        if (bl == null) {
            bl = JavaSettingsDefaults.defaultJavaFormatLeadingStarInComment;
        }
        return bl;
    }

    public void setJavaFormatLeadingStarInComment(boolean bl) {
        this.setValue("java-format-leading-star-in-comment", bl ? Boolean.TRUE : Boolean.FALSE, JAVA_FORMAT_LEADING_STAR_IN_COMMENT_PROP);
    }

    public int getJavaFormatStatementContinuationIndent() {
        Integer n = (Integer)this.getValue("java-format-statement-continuation-indent");
        if (n == null) {
            n = JavaSettingsDefaults.defaultJavaFormatStatementContinuationIndent;
        }
        return n;
    }

    public void setJavaFormatStatementContinuationIndent(int n) {
        this.setValue("java-format-statement-continuation-indent", new Integer(n), JAVA_FORMAT_STATEMENT_CONTINUATION_INDENT_PROP);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.setJavaFormatNewlineBeforeBrace(getField.get(JAVA_FORMAT_NEWLINE_BEFORE_BRACE_PROP, this.getJavaFormatNewlineBeforeBrace()));
        this.setJavaFormatSpaceBeforeParenthesis(getField.get(JAVA_FORMAT_SPACE_BEFORE_PARENTHESIS_PROP, this.getJavaFormatSpaceBeforeParenthesis()));
        this.setJavaFormatLeadingStarInComment(getField.get(JAVA_FORMAT_LEADING_STAR_IN_COMMENT_PROP, this.getJavaFormatLeadingStarInComment()));
        this.setJavaFormatStatementContinuationIndent(getField.get(JAVA_FORMAT_STATEMENT_CONTINUATION_INDENT_PROP, this.getJavaFormatStatementContinuationIndent()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put(JAVA_FORMAT_NEWLINE_BEFORE_BRACE_PROP, this.getJavaFormatNewlineBeforeBrace());
        putField.put(JAVA_FORMAT_SPACE_BEFORE_PARENTHESIS_PROP, this.getJavaFormatSpaceBeforeParenthesis());
        putField.put(JAVA_FORMAT_LEADING_STAR_IN_COMMENT_PROP, this.getJavaFormatLeadingStarInComment());
        putField.put(JAVA_FORMAT_STATEMENT_CONTINUATION_INDENT_PROP, this.getJavaFormatStatementContinuationIndent());
        objectOutputStream.writeFields();
    }
}

