/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.JmiException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.Catch;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.TryStatement;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.BracketCompletion;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaFixAllImports;
import org.netbeans.modules.editor.java.NbJMICompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMIFastImport;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.java.editor.JavaEditorModule;
import org.netbeans.modules.javacore.TryWrapper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaKit
extends NbEditorKit
implements HelpCtx.Provider {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    static final long serialVersionUID = -5445829962533684922L;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport;
    static /* synthetic */ Class class$org$netbeans$editor$BaseAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Element;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper;

    public JavaKit() {
        JavaEditorModule.init();
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JavaKit.class);
    }

    public Document createDefaultDocument() {
        NbEditorDocument nbEditorDocument = new NbEditorDocument(((Object)((Object)this)).getClass());
        nbEditorDocument.putProperty((Object)"write-line-separator", (Object)"\n");
        return nbEditorDocument;
    }

    public Syntax createSyntax(Document document) {
        return new JavaSyntax(this.getSourceLevel((BaseDocument)document));
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new NbJavaJMISyntaxSupport(baseDocument);
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return new NbJMICompletionJavaDoc(extEditorUI);
    }

    public String getSourceLevel(BaseDocument baseDocument) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        return dataObject != null ? SourceLevelQuery.getSourceLevel((FileObject)dataObject.getPrimaryFile()) : null;
    }

    public Formatter createFormatter() {
        return new JavaFormatter(((Object)((Object)this)).getClass());
    }

    protected void toolTipAnnotationsLock(Document document) {
        JavaModel.getJavaRepository().beginTrans(false);
    }

    protected void toolTipAnnotationsUnlock(Document document) {
        JavaModel.getJavaRepository().endTrans();
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        baseDocument.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
        baseDocument.putProperty((Object)SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
                if (JavaTokenContext.LINE_COMMENT == tokenID) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, tokenID, tokenContextPath, n, n2));
                }
            }
        });
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new FastImportAction(), new JavaGenerateGoToPopupAction(), new JavaGotoSuperImplementation(), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new ExpandAllJavadocFolds(), new CollapseAllJavadocFolds(), new ExpandAllCodeBlockFolds(), new CollapseAllCodeBlockFolds(), new JavaGenerateFoldPopupAction(), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false)};
        Action[] actionArray2 = new Action[]{new JavaJMIGotoHelpAction(), new JavaJMIGotoSourceAction(), new JavaJMIGotoDeclarationAction(), new JavaFixAllImports(), new TryCatchAction()};
        Action[] actionArray3 = TextAction.augmentList(actionArray, actionArray2);
        return TextAction.augmentList(super.createActions(), actionArray3);
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent jTextComponent, JMenu jMenu) {
            this.addAction(jTextComponent, jMenu, JavaKit.collapseAllJavadocFolds);
            this.addAction(jTextComponent, jMenu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(jTextComponent, jMenu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(jTextComponent, jMenu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public CollapseAllCodeBlockFolds() {
            super(JavaKit.collapseAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.collapseAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-collapse-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            arrayList.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public ExpandAllCodeBlockFolds() {
            super(JavaKit.expandAllCodeBlockFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.expandAllCodeBlockFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-expand-all-code-block-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            ArrayList<FoldType> arrayList = new ArrayList<FoldType>();
            arrayList.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            arrayList.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, arrayList);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        public CollapseAllJavadocFolds() {
            super(JavaKit.collapseAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.collapseAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-collapse-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.collapse((FoldHierarchy)foldHierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        public ExpandAllJavadocFolds() {
            super(JavaKit.expandAllJavadocFolds);
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(JavaKit.expandAllJavadocFolds));
            this.putValue("PopupMenuText", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("popup-expand-all-javadoc-folds"));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
            FoldUtilities.expand((FoldHierarchy)foldHierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String string, boolean bl) {
            super(string, bl);
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
            BracketCompletion.charBackspaced(baseDocument, n, caret, c);
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            int n = caret.getDot();
            if (BracketCompletion.posWithinString(baseDocument, n)) {
                try {
                    baseDocument.insertString(n, "\" + \"", null);
                    caret.setDot(n += 3);
                    return new Integer(n);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(baseDocument, n)) {
                        int n2 = BracketCompletion.getRowOrBlockEnd(baseDocument, n);
                        baseDocument.insertString(n2, "}", null);
                        baseDocument.getFormatter().indentNewLine((Document)baseDocument, n2);
                        caret.setDot(n);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
            if (object != null && object instanceof Integer) {
                int n = caret.getDot();
                caret.setDot(n + 1);
            }
        }
    }

    public static class TryCatchAction
    extends BaseAction {
        public TryCatchAction() {
            super(JavaKit.tryCatchAction);
        }

        protected boolean asynchonous() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                TryStatement tryStatement;
                TryWrapper tryWrapper;
                FileObject fileObject;
                int n;
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n2 = -1;
                int n3 = jTextComponent.getSelectionStart();
                if (n3 == (n = jTextComponent.getSelectionEnd())) {
                    try {
                        n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
                        n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n) + 1;
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                    }
                }
                JavaModel.getJavaRepository().beginTrans(true);
                try {
                    fileObject = NbEditorUtilities.getDataObject((Document)baseDocument).getPrimaryFile();
                    JavaModel.setClassPath((FileObject)fileObject);
                    tryWrapper = new TryWrapper(fileObject, n3, n);
                    tryStatement = tryWrapper.wrap();
                }
                catch (JmiException jmiException) {
                    Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)jmiException.getLocalizedMessage());
                    return;
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    tryWrapper = tryStatement.getFinalizer();
                    if (tryWrapper != null) {
                        n2 = tryWrapper.getEndOffset() - 1;
                    } else {
                        fileObject = (Catch)tryStatement.getCatches().get(0);
                        n2 = fileObject.getEndOffset() - 1;
                    }
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
                if (n2 != -1) {
                    jTextComponent.setCaretPosition(n2);
                    jTextComponent.setSelectionStart(n2);
                    jTextComponent.setSelectionEnd(n2);
                }
            }
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = JavaKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }

        public static final class MainMenuWrapper
        extends MainMenuAction {
            private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

            public MainMenuWrapper() {
                this.setMenu();
            }

            protected String getMenuItemText() {
                return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper == null ? (class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$TryCatchAction$MainMenuWrapper")) : class$org$netbeans$modules$editor$java$JavaKit$TryCatchAction$MainMenuWrapper)).getString("try_catch_main_menu_item");
            }

            public JMenuItem getMenuPresenter() {
                return this.menuItem;
            }

            protected String getActionName() {
                return JavaKit.tryCatchAction;
            }
        }
    }

    public static class FastImportAction
    extends BaseAction {
        public FastImportAction() {
            super(JavaKit.fastImportAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Runnable runnable = new Runnable(this, jTextComponent){
                private final /* synthetic */ JTextComponent val$target;
                private final /* synthetic */ FastImportAction this$0;
                {
                    this.this$0 = fastImportAction;
                    this.val$target = jTextComponent;
                }

                public void run() {
                    if (this.val$target != null) {
                        new NbJavaJMIFastImport(this.val$target).setDialogVisible(true);
                    }
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)JavaKit.fastImportAction));
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                StringBuffer stringBuffer = new StringBuffer("System.out.println(\"");
                String string = (String)baseDocument.getProperty((Object)"title");
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                try {
                    stringBuffer.append(Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                stringBuffer.append(' ');
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                if (baseKit == null) {
                    return;
                }
                Action action = baseKit.getActionByName("insert-content");
                if (action != null) {
                    Utilities.performAction((Action)action, (ActionEvent)new ActionEvent(jTextComponent, 1001, stringBuffer.toString()), (JTextComponent)jTextComponent);
                }
            }
        }
    }

    public static class JavaJMIGotoHelpAction
    extends JavaGotoHelpAction {
        protected boolean asynchonous() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL[] getJavaDocURLs(JTextComponent jTextComponent) {
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
            NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            JMIUtils jMIUtils = JMIUtils.get(baseDocument);
            jMIUtils.beginTrans(false);
            try {
                Object object = JMIUtils.findItemAtCaretPos(jTextComponent);
                URL[] uRLArray = object == null ? null : nbJavaJMISyntaxSupport.getJavaDocURLs(object);
                return uRLArray;
            }
            finally {
                jMIUtils.endTrans(false);
            }
        }
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        public JavaGotoHelpAction() {
            super("goto-help", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoHelpAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction).getName());
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("java-desc-goto-help"));
        }

        public URL[] getJavaDocURLs(JTextComponent jTextComponent) {
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            Object object = JCExtension.findItemAtCaretPos(jTextComponent);
            return object == null ? null : nbJavaSyntaxSupport.getJavaDocURLs(object);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                URL[] uRLArray = this.getJavaDocURLs(jTextComponent);
                if (uRLArray != null && uRLArray.length > 0) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(uRLArray[0]);
                } else {
                    Utilities.setStatusText((JTextComponent)jTextComponent, (String)NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("cannot_find_javadoc"));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("show_javadoc");
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        private void addAcceleretors(Action action, JMenuItem jMenuItem, JTextComponent jTextComponent) {
            Keymap keymap = jTextComponent.getKeymap();
            if (keymap != null) {
                KeyStroke keyStroke;
                KeyStroke[] keyStrokeArray = keymap.getKeyStrokesForAction(action);
                if (keyStrokeArray != null && keyStrokeArray.length > 0) {
                    jMenuItem.setAccelerator(keyStrokeArray[0]);
                } else if (action != null && (keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                    jMenuItem.setAccelerator(keyStroke);
                }
            }
        }

        protected void addAction(JTextComponent jTextComponent, JMenu jMenu, Action action) {
            if (action != null) {
                String string = (String)action.getValue("Name");
                JMenuItem jMenuItem = null;
                if (action instanceof BaseAction) {
                    jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                }
                if (jMenuItem == null) {
                    String string2 = (String)action.getValue("trimmed-text");
                    if (string2 == null) {
                        string2 = this.getItemText(jTextComponent, string, action);
                    }
                    if (string2 != null) {
                        jMenuItem = new JMenuItem(string2);
                        Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)string2);
                        jMenuItem.addActionListener(action);
                        this.addAcceleretors(action, jMenuItem, jTextComponent);
                        jMenuItem.setEnabled(action.isEnabled());
                        Object object = action.getValue("helpID");
                        if (object != null && object instanceof String) {
                            jMenuItem.putClientProperty("HelpID", object);
                        }
                    } else if ("goto-source".equals(string)) {
                        jMenuItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(action, jMenuItem, jTextComponent);
                        jMenuItem.setEnabled(false);
                    }
                }
                if (jMenuItem != null) {
                    jMenu.add(jMenuItem);
                }
            }
        }

        protected void addAction(JTextComponent jTextComponent, JMenu jMenu, String string) {
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return;
            }
            Action action = baseKit.getActionByName(string);
            if (action != null) {
                this.addAction(jTextComponent, jMenu, action);
            } else {
                jMenu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent jTextComponent, String string, Action action) {
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
            return string2;
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("generate-goto-popup");
            JMenu jMenu = new JMenu(string);
            return jMenu;
        }
    }

    public static class JavaGotoSuperImplementation
    extends BaseAction {
        public JavaGotoSuperImplementation() {
            super("goto-super-implementation");
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto-super-implementation"));
            String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto-super-implementation-trimmed");
            this.putValue("trimmed-text", string);
            this.putValue("PopupMenuText", string);
        }

        protected boolean asynchonous() {
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Runnable runnable = new Runnable(this, jTextComponent){
                private final /* synthetic */ JTextComponent val$target;
                private final /* synthetic */ JavaGotoSuperImplementation this$0;
                {
                    this.this$0 = javaGotoSuperImplementation;
                    this.val$target = jTextComponent;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Collection collection;
                    if (SwingUtilities.isEventDispatchThread()) {
                        RequestProcessor.getDefault().post((Runnable)this);
                        return;
                    }
                    Node node = NbEditorUtilities.getTopComponent((JTextComponent)this.val$target).getActivatedNodes()[0];
                    Element element = (Element)node.getLookup().lookup(class$org$netbeans$jmi$javamodel$Element == null ? (class$org$netbeans$jmi$javamodel$Element = JavaKit.class$("org.netbeans.jmi.javamodel.Element")) : class$org$netbeans$jmi$javamodel$Element);
                    if (!(element instanceof Method)) {
                        return;
                    }
                    BaseDocument baseDocument = (BaseDocument)this.val$target.getDocument();
                    JMIUtils jMIUtils = JMIUtils.get(baseDocument);
                    FileObject fileObject = NbEditorUtilities.getDataObject((Document)baseDocument).getPrimaryFile();
                    Method method = null;
                    jMIUtils.beginTrans(false);
                    try {
                        JavaMetamodel.getManager().setClassPath(fileObject, true);
                        collection = JavaModelUtil.getOverriddenMethods((Method)((Method)element));
                        if (!collection.isEmpty()) {
                            method = (Method)collection.iterator().next();
                        }
                    }
                    finally {
                        jMIUtils.endTrans(false);
                    }
                    collection = Utilities.getSyntaxSupport((JTextComponent)this.val$target);
                    NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)collection.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                    nbJavaJMISyntaxSupport.openSource(method, false);
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)"goto-super-implementation"));
        }
    }

    public static class JavaJMIGotoSourceAction
    extends JavaGotoSourceAction {
        protected boolean asynchonous() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String openSource(JTextComponent jTextComponent) {
            String string = null;
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
            NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            JMIUtils jMIUtils = JMIUtils.get(baseDocument);
            Object object = null;
            jMIUtils.beginTrans(false);
            try {
                object = JMIUtils.findItemAtCaretPos(jTextComponent);
                if (object instanceof NbJMIResultItem.VarResultItem) {
                    object = ((NbJMIResultItem.VarResultItem)object).getType();
                }
                if (object instanceof ClassDefinition) {
                    object = JMIUtils.getSourceElementIfExists((ClassDefinition)object);
                }
                string = nbJavaJMISyntaxSupport.openSource(object, false);
            }
            finally {
                jMIUtils.endTrans(false);
            }
            if (string != null) {
                boolean bl = object instanceof JavaPackage;
                String string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(bl ? "goto_source_package_not_found" : "goto_source_source_not_found");
                return MessageFormat.format(string2, string);
            }
            return null;
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted");
        }

        protected Class getShortDescriptionBundleClass() {
            return class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = JavaKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }
    }

    public static class JavaGotoSourceAction
    extends BaseAction {
        public JavaGotoSourceAction() {
            super("goto-source", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoSourceAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction).getName());
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/gotosource.gif");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Runnable runnable = new Runnable(this, jTextComponent){
                private final /* synthetic */ JTextComponent val$target;
                private final /* synthetic */ JavaGotoSourceAction this$0;
                {
                    this.this$0 = javaGotoSourceAction;
                    this.val$target = jTextComponent;
                }

                public void run() {
                    String string;
                    if (SwingUtilities.isEventDispatchThread()) {
                        RequestProcessor.getDefault().post((Runnable)this);
                        return;
                    }
                    if (this.val$target != null && (string = this.this$0.openSource(this.val$target)) != null) {
                        Toolkit.getDefaultToolkit().beep();
                        StatusDisplayer.getDefault().setStatusText(string);
                    }
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)"goto-source"));
        }

        public String openSource(JTextComponent jTextComponent) {
            Object object;
            String string = null;
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            string = nbJavaSyntaxSupport.openSource(object = JCExtension.findItemAtCaretPos(jTextComponent), false);
            if (string != null) {
                boolean bl = object instanceof JCPackage;
                String string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(bl ? "goto_source_package_not_found" : "goto_source_source_not_found");
                return MessageFormat.format(string2, string);
            }
            return null;
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("goto_source_open_source_not_formatted");
        }
    }

    public static class JavaJMIGotoDeclarationAction
    extends JavaGotoDeclarationAction {
        public JavaJMIGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaJMIGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaJMIGotoDeclarationAction).getName());
        }

        protected boolean asynchonous() {
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Runnable runnable = new Runnable(this, jTextComponent){
                private final /* synthetic */ JTextComponent val$target;
                private final /* synthetic */ JavaJMIGotoDeclarationAction this$0;
                {
                    this.this$0 = javaJMIGotoDeclarationAction;
                    this.val$target = jTextComponent;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        RequestProcessor.getDefault().post((Runnable)this);
                        return;
                    }
                    if (this.val$target != null) {
                        int n;
                        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.val$target);
                        NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                        BaseDocument baseDocument = (BaseDocument)this.val$target.getDocument();
                        JMIUtils jMIUtils = JMIUtils.get(baseDocument);
                        Object object = null;
                        String string = null;
                        jMIUtils.beginTrans(false);
                        try {
                            object = JMIUtils.findItemAtCaretPos(this.val$target);
                            if (object instanceof NbJMIResultItem.VarResultItem) {
                                n = nbJavaJMISyntaxSupport.findLocalDeclarationPosition(((NbJMIResultItem.VarResultItem)object).getItemText(), this.val$target.getCaretPosition());
                                this.val$target.setCaretPosition(n);
                                JumpList.checkAddEntry((JTextComponent)this.val$target);
                            } else {
                                if (object instanceof ClassDefinition) {
                                    object = JMIUtils.getSourceElementIfExists((ClassDefinition)object);
                                }
                                string = nbJavaJMISyntaxSupport.openSource(object, true);
                            }
                        }
                        finally {
                            jMIUtils.endTrans(false);
                        }
                        if (string != null) {
                            Toolkit.getDefaultToolkit().beep();
                            n = object instanceof JavaPackage;
                            String string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(n != 0 ? "goto_source_package_not_found" : "goto_source_source_not_found");
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string2, string));
                        }
                    }
                }
            };
            JavaMetamodel.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)(class$org$netbeans$editor$BaseAction == null ? (class$org$netbeans$editor$BaseAction = JavaKit.class$("org.netbeans.editor.BaseAction")) : class$org$netbeans$editor$BaseAction), (String)"goto-declaration"));
        }
    }

    public static class JavaGotoDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        public JavaGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion((JTextComponent)jTextComponent);
                SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
                NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaKit.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
                if (completion != null) {
                    boolean bl;
                    String string = null;
                    Object object = null;
                    if (completion.isPaneVisible()) {
                        object = JCExtension.findItemAtCaretPos(jTextComponent);
                        string = nbJavaSyntaxSupport.openSource(object, true);
                    } else {
                        bl = false;
                        int n = jTextComponent.getCaret().getDot();
                        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                        try {
                            int n2;
                            int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)baseDocument, (int)n);
                            if (nArray != null && nArray.length == 2 && ((n2 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)nArray[0])) < 0 || baseDocument.getChars(n2, 1)[0] != '.')) {
                                bl = this.gotoDeclaration(jTextComponent);
                            }
                            if (!bl) {
                                object = JCExtension.findItemAtCaretPos(jTextComponent);
                                string = nbJavaSyntaxSupport.openSource(object, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    if (string != null) {
                        Toolkit.getDefaultToolkit().beep();
                        bl = object instanceof JCPackage;
                        String string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaKit.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(bl ? "goto_source_package_not_found" : "goto_source_source_not_found");
                        StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string2, string));
                    }
                }
            }
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            if (c == '\"' || c == '\'') {
                boolean bl2 = BracketCompletion.completeQuote(baseDocument, n, caret, c);
                if (bl2) {
                    caret.setDot(n + 1);
                } else {
                    super.insertString(baseDocument, n, caret, string, bl);
                }
            } else {
                super.insertString(baseDocument, n, caret, string, bl);
                BracketCompletion.charInserted(baseDocument, n, caret, c);
            }
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            char c = string.charAt(0);
            Document document = jTextComponent.getDocument();
            if (c == '\"' || c == '\'') {
                if (document != null) {
                    try {
                        boolean bl2 = false;
                        int n2 = Math.min(caret.getDot(), caret.getMark());
                        int n3 = Math.max(caret.getDot(), caret.getMark());
                        if (n2 != n3) {
                            document.remove(n2, n3 - n2);
                        }
                        int n4 = caret.getDot();
                        if (document instanceof BaseDocument) {
                            bl2 = BracketCompletion.completeQuote((BaseDocument)document, n4, caret, c);
                        }
                        if (bl2) {
                            caret.setDot(n4 + 1);
                        } else if (string != null && string.length() > 0) {
                            document.insertString(n2, string, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(jTextComponent, n, caret, string, bl);
                if (document instanceof BaseDocument) {
                    BracketCompletion.charInserted((BaseDocument)document, caret.getDot() - 1, caret, c);
                }
            }
        }
    }
}

