/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class NbJMIPaintComponent
extends JPanel {
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif";
    static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
    static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
    static final String ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
    static final String ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
    static final String LOCAL_VARIABLE = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
    static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
    static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
    static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
    static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
    static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
    static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
    static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
    static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
    static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
    static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
    static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
    static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
    static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
    static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
    static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
    static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
    static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
    static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
    static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
    static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
    private static final int ICON_WIDTH = 16;
    private static final int ICON_TEXT_GAP = 5;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    public static final Color KEYWORD_COLOR = Color.darkGray;
    public static final Color TYPE_COLOR = Color.black;
    static final Color ENCLOSING_CALL_COLOR = Color.gray;
    static final Color ACTIVE_PARAMETER_COLOR = Color.black;

    public NbJMIPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    protected void setDeprecated(boolean bl) {
        this.isDeprecated = bl;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        this.drawX += 21;
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics graphics, String string) {
        this.drawString(graphics, string, false);
    }

    protected void drawString(Graphics graphics, String string, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, string, null, bl);
    }

    protected void drawString(Graphics graphics, String string, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawString(Graphics graphics, String string, Color color, Font font, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, string, font, bl);
        if (graphics != null) {
            graphics.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics graphics, String string, Color color) {
        if (graphics == null) {
            this.drawString(graphics, "   ");
            this.drawString(graphics, string, color);
        } else {
            int n;
            int n2 = this.getWidth() - this.getWidth(string) - this.drawX;
            if (n2 > (n = this.getWidth(" ")) * 2) {
                this.drawX = this.getWidth() - 2 * n - this.getWidth(string);
            } else {
                this.drawX = this.getWidth() - 2 * n - this.getWidth(string) - this.getWidth("...   ");
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.drawX, 0, this.getWidth() - this.drawX, this.getHeight());
                this.drawString(graphics, "...   ", color);
            }
            this.drawString(graphics, string, color);
        }
    }

    protected void drawStringToGraphics(Graphics graphics, String string) {
        this.drawStringToGraphics(graphics, string, null, false);
    }

    protected void drawStringToGraphics(Graphics graphics, String string, Font font, boolean bl) {
        if (graphics != null) {
            if (!bl) {
                graphics.drawString(string, this.drawX, this.drawY);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
                graphics2D.drawString(attributedString.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        if (string == null) {
            string = "";
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.getWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public static class NbStringPaintComponent
    extends NbJMIPaintComponent {
        private String str;

        public void setString(String string) {
            this.str = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, null);
            this.drawString(graphics, this.str, TYPE_COLOR);
        }
    }

    public static class NbAttributePaintComponent
    extends NbJMIPaintComponent {
        private String typeName;
        private Color typeColor;
        private String attrName;
        private String defaultValueText;
        private Color ATTR_COLOR = Color.darkGray;

        public void setAttrName(String string) {
            this.attrName = string;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public void setDefaultValueText(String string) {
            this.defaultValueText = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, null);
            this.drawString(graphics, this.typeName, this.typeColor);
            this.drawString(graphics, " ");
            if (this.defaultValueText == null) {
                this.drawString(graphics, this.attrName, this.ATTR_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), false);
            } else {
                this.drawString(graphics, this.attrName, this.ATTR_COLOR);
                this.drawString(graphics, " = ");
                this.drawString(graphics, this.defaultValueText);
            }
        }
    }

    public static class NbConstructorPaintComponent
    extends NbCallableFeaturePaintComponent {
        private Color CONSTRUCTOR_COLOR = Color.orange.darker();
        private Icon[] icon = new Icon[4];

        protected Icon getIcon() {
            String string = NbJMIPaintComponent.CONSTRUCTOR_PUBLIC;
            int n = JavaCompletion.getLevel((int)this.getCFModifiers());
            Icon icon = this.icon[n];
            if (icon != null) {
                return icon;
            }
            switch (n) {
                case 0: {
                    string = NbJMIPaintComponent.CONSTRUCTOR_PRIVATE;
                    break;
                }
                case 1: {
                    string = NbJMIPaintComponent.CONSTRUCTOR_PACKAGE;
                    break;
                }
                case 2: {
                    string = NbJMIPaintComponent.CONSTRUCTOR_PROTECTED;
                    break;
                }
                case 3: {
                    string = NbJMIPaintComponent.CONSTRUCTOR_PUBLIC;
                }
            }
            ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)string));
            this.icon[n] = imageIcon;
            return imageIcon;
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            Icon icon = this.isEnclosingCall() ? null : this.getIcon();
            this.drawIcon(graphics, icon);
            Color color = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.CONSTRUCTOR_COLOR;
            this.drawString(graphics, this.getCFName(), color, null, bl);
            this.drawParameterList(graphics, this.getParamList());
        }
    }

    public static class NbMethodPaintComponent
    extends NbCallableFeaturePaintComponent {
        private Color METHOD_COLOR = Color.red.darker().darker();
        private Icon[][] icon = new Icon[2][4];

        protected Icon getIcon() {
            int n = JavaCompletion.getLevel((int)this.getCFModifiers());
            boolean bl = (this.getCFModifiers() & 8) != 0;
            Icon icon = this.icon[bl ? 1 : 0][n];
            if (icon != null) {
                return icon;
            }
            String string = NbJMIPaintComponent.METHOD_PUBLIC;
            if ((this.getCFModifiers() & 8) != 0) {
                switch (n) {
                    case 0: {
                        string = NbJMIPaintComponent.METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = NbJMIPaintComponent.METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = NbJMIPaintComponent.METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = NbJMIPaintComponent.METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = NbJMIPaintComponent.METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = NbJMIPaintComponent.METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = NbJMIPaintComponent.METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = NbJMIPaintComponent.METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)string));
            this.icon[bl ? 1 : 0][n] = imageIcon;
            return imageIcon;
        }

        protected void draw(Graphics graphics) {
            Color color;
            boolean bl = this.isDeprecated();
            Icon icon = this.isEnclosingCall() ? null : this.getIcon();
            this.drawIcon(graphics, icon);
            Color color2 = color = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.METHOD_COLOR;
            if ((this.getCFModifiers() & 0x20000000) != 0 && !this.isEnclosingCall()) {
                this.drawString(graphics, this.getCFName(), color, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), bl);
            } else {
                this.drawString(graphics, this.getCFName(), color, null, bl);
            }
            this.drawParameterList(graphics, this.getParamList());
            Color color3 = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.getTypeColor();
            this.drawTypeName(graphics, this.getTypeName(), color3);
        }
    }

    public static class NbCallableFeaturePaintComponent
    extends NbJMIPaintComponent {
        private Color PARAMETER_NAME_COLOR = Color.magenta.darker();
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private String cfName;
        private String typeName;
        private Color typeColor;
        private int activeParameterIndex = -1;
        private int drawParamIndex;

        public int getCFModifiers() {
            return this.modifiers;
        }

        public String getCFName() {
            return this.cfName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setModifiers(int n) {
            this.modifiers = n;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        public void setFeatureName(String string) {
            this.cfName = string;
        }

        public void setParams(List list) {
            this.params = list;
        }

        public void setExceptions(List list) {
            this.excs = list;
        }

        protected List getParamList() {
            return this.params;
        }

        protected List getExceptionList() {
            return this.excs;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int n) {
            this.activeParameterIndex = n;
        }

        boolean isEnclosingCall() {
            return this.activeParameterIndex != -1;
        }

        protected void drawExceptions(Graphics graphics, List list, boolean bl) {
            if (list.size() > 0) {
                Color color = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : KEYWORD_COLOR;
                this.drawString(graphics, NbJMIPaintComponent.THROWS, color, null, bl);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    NbJMIResultItem.ExcStr excStr = (NbJMIResultItem.ExcStr)iterator.next();
                    Color color2 = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : excStr.getTypeColor();
                    this.drawString(graphics, excStr.getName(), color2, null, bl);
                    if (!iterator.hasNext()) continue;
                    Color color3 = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.getForeground();
                    this.drawString(graphics, ", ", color3, this.getFont(), bl);
                }
            }
        }

        protected void drawParameter(Graphics graphics, NbJMIResultItem.ParamStr paramStr) {
            this.drawParameter(graphics, paramStr, false);
        }

        protected void drawParameter(Graphics graphics, NbJMIResultItem.ParamStr paramStr, boolean bl) {
            String string;
            Color color;
            Font font;
            Font font2 = font = this.isEnclosingCall() && this.drawParamIndex == this.activeParameterIndex ? new Font(this.getFont().getName(), 1, this.getFont().getSize()) : this.getFont();
            Color color2 = this.isEnclosingCall() ? (this.drawParamIndex == this.activeParameterIndex ? ACTIVE_PARAMETER_COLOR : ENCLOSING_CALL_COLOR) : paramStr.getTypeColor();
            this.drawString(graphics, paramStr.getSimpleTypeName(), color2, font, bl);
            Color color3 = this.isEnclosingCall() ? (this.drawParamIndex == this.activeParameterIndex ? ACTIVE_PARAMETER_COLOR : ENCLOSING_CALL_COLOR) : (color = this.getForeground());
            if (paramStr.isVarArg()) {
                this.drawString(graphics, "...", color, this.getFont(), bl);
            }
            if ((string = paramStr.getName()) != null && string.length() > 0) {
                this.drawString(graphics, " ", color, this.getFont(), bl);
                Color color4 = this.isEnclosingCall() ? (this.drawParamIndex == this.activeParameterIndex ? ACTIVE_PARAMETER_COLOR : ENCLOSING_CALL_COLOR) : this.PARAMETER_NAME_COLOR;
                this.drawString(graphics, paramStr.getName(), color4, font, bl);
            }
        }

        protected void drawParameterList(Graphics graphics, List list) {
            this.drawParameterList(graphics, list, false);
        }

        protected void drawParameterList(Graphics graphics, List list, boolean bl) {
            Color color = this.isEnclosingCall() ? ENCLOSING_CALL_COLOR : this.getForeground();
            this.drawString(graphics, "(", color, this.getFont(), bl);
            this.drawParamIndex = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.drawParameter(graphics, (NbJMIResultItem.ParamStr)iterator.next(), bl);
                if (iterator.hasNext()) {
                    this.drawString(graphics, ", ", color, this.getFont(), bl);
                }
                ++this.drawParamIndex;
            }
            this.drawString(graphics, ")", color, this.getFont(), bl);
        }
    }

    public static class NbFieldPaintComponent
    extends NbJMIPaintComponent {
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isLocalVar;
        private Icon[][] icon = new Icon[2][4];
        private Icon localIcon;
        private Color FIELD_COLOR = Color.blue.darker();
        private Color VAR_COLOR = Color.blue.darker().darker();

        public NbFieldPaintComponent(boolean bl) {
            this.isLocalVar = bl;
        }

        public void setFieldName(String string) {
            this.fldName = string;
        }

        public String getFieldName() {
            return this.fldName;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setModifiers(int n) {
            this.modifiers = n;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            this.drawIcon(graphics, this.getIcon());
            if ((this.modifiers & 0x20000000) != 0) {
                this.drawString(graphics, this.fldName, this.isLocalVar ? this.VAR_COLOR : this.FIELD_COLOR, new Font(this.getDrawFont().getName(), this.getDrawFont().getStyle() | 1, this.getDrawFont().getSize()), bl);
            } else {
                this.drawString(graphics, this.fldName, this.isLocalVar ? this.VAR_COLOR : this.FIELD_COLOR, null, bl);
            }
            this.drawTypeName(graphics, this.typeName, this.typeColor);
        }

        protected Icon getIcon() {
            String string = NbJMIPaintComponent.FIELD_PUBLIC;
            int n = JavaCompletion.getLevel((int)this.modifiers);
            if (this.isLocalVar && n == 1) {
                if (this.localIcon == null) {
                    this.localIcon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.LOCAL_VARIABLE));
                }
                return this.localIcon;
            }
            boolean bl = (this.modifiers & 8) != 0;
            Icon icon = this.icon[bl ? 1 : 0][n];
            if (icon != null) {
                return icon;
            }
            if (bl) {
                switch (n) {
                    case 0: {
                        string = NbJMIPaintComponent.FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = NbJMIPaintComponent.FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = NbJMIPaintComponent.FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = NbJMIPaintComponent.FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = NbJMIPaintComponent.FIELD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = NbJMIPaintComponent.FIELD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = NbJMIPaintComponent.FIELD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = NbJMIPaintComponent.FIELD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)string));
            this.icon[bl ? 1 : 0][n] = imageIcon;
            return imageIcon;
        }
    }

    public static class NbAnnotationPaintComponent
    extends NbClassPaintComponent {
        private Icon icon;

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.ANNOTATION));
            }
            return this.icon;
        }
    }

    public static class NbEnumPaintComponent
    extends NbClassPaintComponent {
        private Icon icon;

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.ENUM));
            }
            return this.icon;
        }
    }

    public static class NbInterfacePaintComponent
    extends NbClassPaintComponent {
        private Icon icon;
        private Color INTERFACE_COLOR = Color.darkGray;

        protected Color getColor() {
            return this.INTERFACE_COLOR;
        }

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.INTERFACE));
            }
            return this.icon;
        }
    }

    public static class NbClassPaintComponent
    extends NbJMIPaintComponent {
        private Color CLASS_COLOR = Color.red.darker().darker().darker();
        private Color PACKAGE_COLOR = Color.gray;
        String simpleClassName;
        String fqName = null;
        private Icon icon;
        JavaClass cls;

        public void setSimpleClassName(String string) {
            this.simpleClassName = string;
        }

        public void setFQName(String string) {
            this.fqName = string;
        }

        public void setCls(JavaClass javaClass) {
            this.cls = javaClass;
        }

        protected void draw(Graphics graphics) {
            boolean bl = this.isDeprecated();
            this.drawIcon(graphics, this.getIcon());
            this.drawString(graphics, this.simpleClassName, this.getColor(), null, bl);
            if (this.fqName != null && this.fqName.length() > 0) {
                this.drawString(graphics, this.fqName, this.PACKAGE_COLOR, null, bl);
            }
        }

        protected Color getColor() {
            return this.CLASS_COLOR;
        }

        protected Icon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.CLASS));
            }
            return this.icon;
        }

        public String getToolTipText() {
            if (this.cls == null) {
                return "";
            }
            FileObject fileObject = JavaMetamodel.getManager().getFileObject(this.cls.getResource());
            if (fileObject != null) {
                return FileUtil.getFileDisplayName((FileObject)fileObject);
            }
            return "";
        }
    }

    public static class NbPackagePaintComponent
    extends NbJMIPaintComponent {
        private String pkgName;
        private boolean displayFullPackagePath;
        private Color PACKAGE_COLOR = Color.green.darker().darker().darker();
        private Icon icon;

        public void setPackageName(String string) {
            this.pkgName = string;
        }

        public void setDisplayFullPackagePath(boolean bl) {
            this.displayFullPackagePath = bl;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, this.getIcon());
            String string = this.pkgName;
            if (!this.displayFullPackagePath) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            this.drawString(graphics, string, this.PACKAGE_COLOR);
        }

        protected Icon getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            Icon icon = null;
            Object object = UIManager.get("Nb.Explorer.Folder.icon");
            if (object == null) {
                icon = new ImageIcon(Utilities.loadImage((String)NbJMIPaintComponent.PACKAGE));
            } else if (object instanceof Image) {
                icon = new ImageIcon((Image)object);
            } else if (object instanceof Icon) {
                icon = (Icon)object;
            }
            this.icon = icon;
            return icon;
        }
    }
}

