/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.NbJMIPaintComponent;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMIFastImport;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.RequestProcessor;

public abstract class NbJMIResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    protected int selectionStartOffset = -1;
    protected int selectionEndOffset = -1;
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport;

    public abstract String getItemText();

    protected abstract Object getAssociatedObject();

    protected static Color getTypeColor(Type type) {
        return type instanceof PrimitiveType ? NbJMIPaintComponent.KEYWORD_COLOR : NbJMIPaintComponent.TYPE_COLOR;
    }

    public void setSubstituteOffset(int n) {
        this.substituteOffset = n;
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string = this.getItemText();
        if (string != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                string = string + toAdd;
            }
            baseDocument.atomicLock();
            try {
                String string2 = baseDocument.getText(n, n2);
                if (string.equals(string2)) {
                    boolean bl2 = false;
                    return bl2;
                }
                baseDocument.remove(n, n2);
                baseDocument.insertString(n, string, null);
                if (this.selectionStartOffset >= 0) {
                    jTextComponent.select(n + this.selectionStartOffset, n + this.selectionEndOffset);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        Component component = this.getPaintComponent(bl);
        if (component == null) {
            return null;
        }
        if (bl) {
            component.setBackground(jList.getSelectionBackground());
            component.setForeground(jList.getSelectionForeground());
        } else {
            component.setBackground(jList.getBackground());
            component.setForeground(jList.getForeground());
        }
        component.getAccessibleContext().setAccessibleName(this.getItemText());
        component.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return component;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics graphics, Font font) {
        Component component = this.getPaintComponent(false);
        return component.getPreferredSize().width;
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        Component component = this.getPaintComponent(bl);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        component.setBounds(0, 0, n, n2);
        ((NbJMIPaintComponent)component).paintComponent(graphics);
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            Completion completion = Completion.get();
            switch (keyEvent.getKeyChar()) {
                case ' ': {
                    if (keyEvent.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '(': 
                case ',': 
                case ';': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)keyEvent.getSource(), Character.toString(keyEvent.getKeyChar()))) break;
                    keyEvent.consume();
                }
            }
        }
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new JavaCompletionProvider.DocQuery(this), Registry.getMostActiveComponent());
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(jTextComponent);
        return true;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(jTextComponent, "");
    }

    private boolean defaultAction(JTextComponent jTextComponent, String string) {
        int n = this.substituteOffset;
        if (n == -1) {
            n = jTextComponent.getCaret().getDot();
        }
        toAdd = string;
        return this.substituteText(jTextComponent, n, jTextComponent.getCaret().getDot() - n, false);
    }

    static class ExcStr {
        private String name;
        private Color typeColor;

        public ExcStr(String string, Color color) {
            this.name = string;
            this.typeColor = color;
        }

        public String getName() {
            return this.name;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    static class ParamStr {
        private String type;
        private String simpleType;
        private String prm;
        private boolean isVarArg;
        private Color typeColor;

        public ParamStr(String string, String string2, String string3, boolean bl, Color color) {
            this.type = string;
            this.simpleType = string2;
            this.prm = string3;
            this.isVarArg = bl;
            this.typeColor = color;
        }

        public String getTypeName() {
            return this.type;
        }

        public String getSimpleTypeName() {
            return this.simpleType;
        }

        public String getName() {
            return this.prm;
        }

        public boolean isVarArg() {
            return this.isVarArg;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }
    }

    public static class StringResultItem
    extends NbJMIResultItem {
        private String str;
        private static NbJMIPaintComponent.NbStringPaintComponent stringComponent = null;

        public StringResultItem(String string) {
            this.str = string;
        }

        public String getItemText() {
            return this.str;
        }

        public Component getPaintComponent(boolean bl) {
            if (stringComponent == null) {
                stringComponent = new NbJMIPaintComponent.NbStringPaintComponent();
            }
            stringComponent.setSelected(bl);
            stringComponent.setString(this.str);
            return stringComponent;
        }

        public int getSortPriority() {
            return 50;
        }

        protected Object getAssociatedObject() {
            return this.str;
        }
    }

    public static class AttributeResultItem
    extends NbJMIResultItem {
        private Attribute attr;
        private String attrName;
        private String typeName;
        private Color typeColor;
        private String defaultValueText;
        private static NbJMIPaintComponent.NbAttributePaintComponent attrComponent = null;

        public AttributeResultItem(Attribute attribute) {
            this.attr = attribute;
            this.attrName = attribute.getName();
            Type type = attribute.getType();
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = AttributeResultItem.getTypeColor(type);
            this.defaultValueText = attribute.getDefaultValueText();
        }

        public String getItemText() {
            return this.attrName + "=";
        }

        public String getAttrName() {
            return this.attrName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getDefaultValueText() {
            return this.defaultValueText;
        }

        public Component getPaintComponent(boolean bl) {
            if (attrComponent == null) {
                attrComponent = new NbJMIPaintComponent.NbAttributePaintComponent();
            }
            attrComponent.setAttrName(this.attrName);
            attrComponent.setTypeName(this.typeName);
            attrComponent.setTypeColor(this.typeColor);
            attrComponent.setDefaultValueText(this.defaultValueText);
            attrComponent.setSelected(bl);
            return attrComponent;
        }

        protected Object getAssociatedObject() {
            return this.attr;
        }

        public int getSortPriority() {
            return 100;
        }
    }

    public static class AnnotationResultItem
    extends ClassResultItem {
        private int size = 0;
        private int defaultMembersCnt = 0;

        public AnnotationResultItem(AnnotationType annotationType, boolean bl, boolean bl2) {
            super((JavaClass)annotationType, bl, bl2, false);
            Iterator iterator = annotationType.getContents().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Attribute)) continue;
                Attribute attribute = (Attribute)e;
                if (attribute.getDefaultValueText() != null) {
                    ++this.defaultMembersCnt;
                }
                ++this.size;
            }
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            if (this.defaultMembersCnt != this.size) {
                if (toAdd.length() == 0) {
                    toAdd = "(";
                } else if (!"(".equals(toAdd)) {
                    toAdd = "()" + toAdd;
                }
            }
            return super.substituteText(jTextComponent, n, n2, bl);
        }
    }

    public static class ClassResultItem
    extends NbJMIResultItem {
        private JavaClass cls;
        private boolean isInterface;
        private boolean isDeprecated;
        boolean addImport;
        boolean generateClassSkeleton;
        private String fqName = null;
        private String name = null;
        private static NbJMIPaintComponent.NbInterfacePaintComponent interfaceComponent = null;
        private static NbJMIPaintComponent.NbClassPaintComponent classComponent = null;
        private static NbJMIPaintComponent.NbEnumPaintComponent enumComponent = null;
        private static NbJMIPaintComponent.NbAnnotationPaintComponent annotationComponent = null;
        private static final boolean autoImportDisabled = Boolean.getBoolean("org.netbeans.java.editor.disableAutoImport");
        private static final boolean autoGenerationDisabled = Boolean.getBoolean("org.netbeans.java.editor.disableAutoClassSkeletonGeneration");
        private boolean displayFQN;

        public ClassResultItem(JavaClass javaClass, boolean bl, boolean bl2, boolean bl3) {
            this.cls = javaClass;
            this.addImport = bl2 && !autoImportDisabled;
            this.name = javaClass.getSimpleName();
            this.displayFQN = bl;
            if (bl || this.addImport) {
                this.fqName = javaClass.getName();
                int n = this.fqName.indexOf(60);
                if (n >= 0) {
                    this.fqName = this.fqName.substring(0, n);
                }
                this.fqName = (n = this.fqName.lastIndexOf(46)) >= 0 ? " (" + this.fqName.substring(0, n) + ")" : "";
            } else {
                this.fqName = "";
            }
            this.isInterface = javaClass.isInterface();
            this.isDeprecated = javaClass.isDeprecated();
            this.addImport = bl2 && !autoImportDisabled;
            this.generateClassSkeleton = bl3 && !autoGenerationDisabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            String string = this.cls instanceof ParameterizedType ? null : this.getItemText();
            int n3 = 0;
            boolean bl2 = "(".equals(toAdd);
            boolean bl3 = true;
            if (string != null) {
                if (toAdd != null && !toAdd.equals("\n")) {
                    string = string + toAdd;
                    if (bl2) {
                        string = string + ")";
                    }
                    n3 = toAdd.length();
                }
                baseDocument.atomicLock();
                try {
                    String string2 = baseDocument.getText(n, n2);
                    if (string.equals(string2)) {
                        bl3 = false;
                    } else {
                        baseDocument.remove(n, n2);
                        baseDocument.insertString(n, string, null);
                        if (bl2) {
                            jTextComponent.setCaretPosition(jTextComponent.getCaretPosition() - 1);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            int n4 = n3;
            RequestProcessor.getDefault().post(new Runnable(this, baseDocument, jTextComponent, n4, bl2){
                private final /* synthetic */ BaseDocument val$doc;
                private final /* synthetic */ JTextComponent val$c;
                private final /* synthetic */ int val$toAddDeltaResult;
                private final /* synthetic */ boolean val$makeConstructor;
                private final /* synthetic */ ClassResultItem this$0;
                {
                    this.this$0 = classResultItem;
                    this.val$doc = baseDocument;
                    this.val$c = jTextComponent;
                    this.val$toAddDeltaResult = n;
                    this.val$makeConstructor = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    StringBuffer stringBuffer;
                    block17: {
                        stringBuffer = new StringBuffer();
                        JMIUtils jMIUtils = JMIUtils.get(this.val$doc);
                        jMIUtils.beginTrans(true);
                        try {
                            Object object;
                            Object object2;
                            if (!ClassResultItem.access$000(this.this$0).isValid()) break block17;
                            HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
                            NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)this.val$doc.getSyntaxSupport().get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = NbJMIResultItem.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                            JavaClass javaClass = nbJavaJMISyntaxSupport.getJavaClass(this.val$c.getCaretPosition());
                            if (this.this$0.addImport && javaClass != null && !ClassResultItem.access$000(this.this$0).isInner()) {
                                object2 = ClassResultItem.access$000(this.this$0) instanceof ParameterizedType ? ((ParameterizedType)ClassResultItem.access$000(this.this$0)).getDefinition() : ClassResultItem.access$000(this.this$0);
                                object = JavaModelUtil.resolveImportsForClass((Element)javaClass, (JavaClass)object2);
                                if (!object2.getSimpleName().equals(object.getName())) {
                                    this.val$doc.atomicLock();
                                    try {
                                        int n = this.val$c.getCaretPosition() - this.val$toAddDeltaResult - ClassResultItem.access$100(this.this$0).length();
                                        this.val$doc.remove(n, ClassResultItem.access$100(this.this$0).length());
                                        this.val$doc.insertString(n, object.getName(), null);
                                    }
                                    catch (BadLocationException badLocationException) {
                                    }
                                    finally {
                                        this.val$doc.atomicUnlock();
                                    }
                                    hashMap.put(object2, Boolean.TRUE);
                                } else {
                                    hashMap.put(object2, Boolean.FALSE);
                                }
                            }
                            if (!this.val$makeConstructor && ClassResultItem.access$200(this.this$0)) {
                                stringBuffer.append("() {\n");
                                object2 = jMIUtils.findMethods((Type)ClassResultItem.access$000(this.this$0), "", false, false, null, false, false, null, false, true);
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    Object object3;
                                    Method method = (Method)object.next();
                                    int n = method.getModifiers();
                                    if (!Modifier.isAbstract(n)) continue;
                                    stringBuffer.append(Modifier.toString(n & 0xFFFFFADF));
                                    stringBuffer.append(' ');
                                    Type type = method.getType();
                                    stringBuffer.append(JMIUtils.getTypeName(type, type instanceof JavaClass && ClassResultItem.access$300(this.this$0, (JavaClass)type, javaClass, hashMap), true));
                                    stringBuffer.append(' ');
                                    stringBuffer.append(method.getName());
                                    stringBuffer.append('(');
                                    Object object4 = method.getParameters().iterator();
                                    while (object4.hasNext()) {
                                        object3 = (Parameter)object4.next();
                                        stringBuffer.append(JMIUtils.getTypeName(type, (type = object3.getType()) instanceof JavaClass && ClassResultItem.access$300(this.this$0, (JavaClass)type, javaClass, hashMap), true));
                                        stringBuffer.append(' ');
                                        stringBuffer.append(object3.getName());
                                        if (object3.isVarArg()) {
                                            stringBuffer.append("...");
                                        }
                                        if (!object4.hasNext()) continue;
                                        stringBuffer.append(", ");
                                    }
                                    stringBuffer.append(')');
                                    object4 = method.getExceptions();
                                    if (!object4.isEmpty()) {
                                        stringBuffer.append(" throws ");
                                    }
                                    object3 = object4.iterator();
                                    while (object3.hasNext()) {
                                        JavaClass javaClass2 = (JavaClass)object3.next();
                                        stringBuffer.append(JMIUtils.getTypeName((Type)javaClass2, ClassResultItem.access$300(this.this$0, javaClass2, javaClass, hashMap), true));
                                        if (!object3.hasNext()) continue;
                                        stringBuffer.append(',');
                                    }
                                    stringBuffer.append(" {\n}\n");
                                }
                                stringBuffer.append('}');
                            }
                        }
                        finally {
                            jMIUtils.endTrans(false);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(this, stringBuffer){
                        private final /* synthetic */ StringBuffer val$sb;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$sb = stringBuffer;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            String string = this.val$sb.toString();
                            if (string != null && string.length() > 0) {
                                1.access$400(this.this$1).atomicLock();
                                try {
                                    int n = 1.access$500(this.this$1).getCaret().getDot();
                                    1.access$400(this.this$1).insertString(n, string, null);
                                    int n2 = 1.access$500(this.this$1).getCaret().getDot();
                                    1.access$400(this.this$1).getFormatter().reformat(1.access$400(this.this$1), n, n2);
                                }
                                catch (BadLocationException badLocationException) {
                                }
                                finally {
                                    1.access$400(this.this$1).atomicUnlock();
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ BaseDocument access$400(1 var0) {
                    return var0.val$doc;
                }

                static /* synthetic */ JTextComponent access$500(1 var0) {
                    return var0.val$c;
                }
            });
            return bl3;
        }

        private boolean useFQN(JavaClass javaClass, JavaClass javaClass2, Map map) {
            Boolean bl;
            if ((javaClass = (JavaClass)JMIUtils.getDefintion((Feature)javaClass)) instanceof TypeParameter) {
                javaClass = ((TypeParameter)javaClass).getSuperClass();
            }
            if ((bl = (Boolean)map.get(javaClass)) == null) {
                if (javaClass2 != null) {
                    MultipartId multipartId = JavaModelUtil.resolveImportsForClass((Element)javaClass2, (JavaClass)javaClass);
                    bl = !javaClass.getSimpleName().equals(multipartId.getName());
                } else {
                    bl = Boolean.FALSE;
                }
                map.put(javaClass, bl);
            }
            return bl;
        }

        public boolean substituteTextSimple(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return super.substituteText(jTextComponent, n, n2, bl);
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 2) {
                this.substituteTextSimple((JTextComponent)keyEvent.getSource());
                keyEvent.consume();
            }
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        }

        private void substituteTextSimple(JTextComponent jTextComponent) {
            int n = this.substituteOffset;
            if (n == -1) {
                n = jTextComponent.getCaretPosition();
            }
            this.substituteTextSimple(jTextComponent, n, jTextComponent.getCaretPosition() - n, false);
            Completion.get().hideCompletion();
        }

        public boolean checkAutoImport(JTextComponent jTextComponent) {
            if (this.addImport) {
                return new NbJavaJMIFastImport(jTextComponent).checkAutoImport(this);
            }
            return false;
        }

        private boolean checkClassSkeletonAutoGeneration() {
            return this.generateClassSkeleton && (Modifier.isAbstract(this.cls.getModifiers()) || Modifier.isInterface(this.cls.getModifiers()));
        }

        public String getItemText() {
            return this.name;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            boolean bl;
            boolean bl2 = bl = !this.checkAutoImport(jTextComponent) && !this.checkClassSkeletonAutoGeneration();
            if (bl) {
                super.instantSubstitution(jTextComponent);
            }
            return bl;
        }

        public CharSequence getSortText() {
            return this.name + this.fqName;
        }

        public Component getPaintComponent(boolean bl) {
            if (this.cls instanceof AnnotationType) {
                if (annotationComponent == null) {
                    annotationComponent = new NbJMIPaintComponent.NbAnnotationPaintComponent();
                }
                annotationComponent.setSelected(bl);
                annotationComponent.setDeprecated(this.isDeprecated);
                annotationComponent.setSimpleClassName(this.name);
                annotationComponent.setFQName(this.fqName);
                if (this.displayFQN) {
                    annotationComponent.setCls(this.cls);
                }
                return annotationComponent;
            }
            if (this.cls instanceof JavaEnum) {
                if (enumComponent == null) {
                    enumComponent = new NbJMIPaintComponent.NbEnumPaintComponent();
                }
                enumComponent.setSelected(bl);
                enumComponent.setDeprecated(this.isDeprecated);
                enumComponent.setSimpleClassName(this.name);
                enumComponent.setFQName(this.fqName);
                if (this.displayFQN) {
                    enumComponent.setCls(this.cls);
                }
                return enumComponent;
            }
            if (this.isInterface) {
                if (interfaceComponent == null) {
                    interfaceComponent = new NbJMIPaintComponent.NbInterfacePaintComponent();
                }
                interfaceComponent.setSelected(bl);
                interfaceComponent.setDeprecated(this.isDeprecated);
                interfaceComponent.setSimpleClassName(this.name);
                interfaceComponent.setFQName(this.fqName);
                if (this.displayFQN) {
                    interfaceComponent.setCls(this.cls);
                }
                return interfaceComponent;
            }
            if (classComponent == null) {
                classComponent = new NbJMIPaintComponent.NbClassPaintComponent();
            }
            classComponent.setSelected(bl);
            classComponent.setDeprecated(this.isDeprecated);
            classComponent.setSimpleClassName(this.name);
            classComponent.setFQName(this.fqName);
            if (this.displayFQN) {
                classComponent.setCls(this.cls);
            }
            return classComponent;
        }

        protected Object getAssociatedObject() {
            return this.cls;
        }

        public int getSortPriority() {
            return 600;
        }

        static /* synthetic */ JavaClass access$000(ClassResultItem classResultItem) {
            return classResultItem.cls;
        }

        static /* synthetic */ String access$100(ClassResultItem classResultItem) {
            return classResultItem.name;
        }

        static /* synthetic */ boolean access$200(ClassResultItem classResultItem) {
            return classResultItem.checkClassSkeletonAutoGeneration();
        }

        static /* synthetic */ boolean access$300(ClassResultItem classResultItem, JavaClass javaClass, JavaClass javaClass2, Map map) {
            return classResultItem.useFQN(javaClass, javaClass2, map);
        }
    }

    public static class PackageResultItem
    extends NbJMIResultItem {
        private boolean displayFullPackagePath;
        private JavaPackage pkg;
        private String pkgName;
        private static NbJMIPaintComponent.NbPackagePaintComponent pkgComponent = null;

        public PackageResultItem(JavaPackage javaPackage, boolean bl) {
            this.pkg = javaPackage;
            this.displayFullPackagePath = bl;
            this.pkgName = javaPackage.getName();
        }

        public String getItemText() {
            return this.displayFullPackagePath ? this.pkgName : this.pkgName.substring(this.pkgName.lastIndexOf(46) + 1);
        }

        public Component getPaintComponent(boolean bl) {
            if (pkgComponent == null) {
                pkgComponent = new NbJMIPaintComponent.NbPackagePaintComponent();
            }
            pkgComponent.setSelected(bl);
            pkgComponent.setPackageName(this.pkgName);
            pkgComponent.setDisplayFullPackagePath(this.displayFullPackagePath);
            return pkgComponent;
        }

        public int getSortPriority() {
            return 700;
        }

        protected Object getAssociatedObject() {
            return this.pkg;
        }
    }

    public static abstract class CallableFeatureResultItem
    extends NbJMIResultItem {
        JCExpression substituteExp;
        private CallableFeature cf;
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private String cfName;
        private String typeName;
        private Color typeColor;
        private boolean isDeprecated;
        private int activeParameterIndex = -1;
        private int varArgIndex = -1;

        public CallableFeatureResultItem(CallableFeature callableFeature, JCExpression jCExpression, ClassDefinition classDefinition) {
            Parameter parameter;
            this.cf = callableFeature;
            this.substituteExp = jCExpression;
            this.modifiers = callableFeature.getModifiers();
            if (callableFeature.getDeclaringClass() == (classDefinition instanceof ParameterizedType ? ((ParameterizedType)classDefinition).getDefinition() : classDefinition)) {
                this.modifiers |= 0x20000000;
            }
            this.cfName = callableFeature.getName();
            Type type = callableFeature.getType();
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = CallableFeatureResultItem.getTypeColor(type);
            this.isDeprecated = callableFeature.isDeprecated();
            Iterator iterator = callableFeature.getParameters().iterator();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                Type type2 = parameter.getType();
                this.params.add(new ParamStr(type2.getName(), JMIUtils.getTypeName(type2, false, false), parameter.getName(), parameter.isVarArg(), CallableFeatureResultItem.getTypeColor(type2)));
                if (!parameter.isVarArg()) continue;
                this.varArgIndex = this.params.size() - 1;
            }
            iterator = callableFeature.getExceptions().iterator();
            while (iterator.hasNext()) {
                parameter = (JavaClass)iterator.next();
                this.excs.add(new ExcStr(parameter.getSimpleName(), CallableFeatureResultItem.getTypeColor((Type)parameter)));
            }
        }

        public String getItemText() {
            return this.getName();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public String getName() {
            return this.cfName;
        }

        public List getParams() {
            return this.params;
        }

        public List getExceptions() {
            return this.excs;
        }

        public CharSequence getSortText() {
            return this.getName() + "#" + this.getParamsCountString() + "#" + this.printParams(false);
        }

        private String getParamsCountString() {
            int n = this.params.size();
            return (n < 10 ? "0" : "") + n;
        }

        protected Object getAssociatedObject() {
            return this.cf;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int n) {
            this.activeParameterIndex = n;
        }

        boolean isEnclosingCall() {
            return this.activeParameterIndex != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            int n3;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            String string = null;
            boolean bl2 = true;
            for (JCExpression jCExpression = this.substituteExp; jCExpression != null; jCExpression = jCExpression.getParent()) {
                if (jCExpression.getExpID() != 22) continue;
                bl2 = false;
                break;
            }
            switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                case 11: {
                    break;
                }
                case 10: {
                    boolean bl3;
                    Object object;
                    int n4 = this.params.size();
                    if (n4 == 0) {
                        if (this.getActiveParameterIndex() != -1) break;
                        try {
                            n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                            if (n3 > -1 && baseDocument.getChars(n3, 1)[0] == ')') {
                                string = baseDocument.getText(n + n2, n3 + 1 - n - n2);
                                n2 = n3 + 1 - n;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (string != null) break;
                        string = ")";
                        break;
                    }
                    n3 = this.getActiveParameterIndex();
                    if (n3 != -1) {
                        String string2;
                        boolean bl4 = false;
                        if (n3 < n4 && (string2 = ((ParamStr)this.params.get(n3)).getName()) != null) {
                            try {
                                baseDocument.insertString(jTextComponent.getCaretPosition(), string2, null);
                                bl4 = true;
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        return bl4;
                    }
                    int n5 = this.substituteExp.getParameterCount() - 1;
                    boolean bl5 = false;
                    Formatter formatter = baseDocument.getFormatter();
                    if (formatter instanceof ExtFormatter && (object = ((ExtFormatter)formatter).getSettingValue("java-format-space-after-comma")) instanceof Boolean && ((Boolean)object).booleanValue()) {
                        bl5 = true;
                    }
                    try {
                        if (bl5 && (n5 == 0 || n > 0 && Character.isWhitespace(baseDocument.getText(n - 1, 1).charAt(0)))) {
                            bl5 = false;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    boolean bl6 = bl3 = n4 > 0 ? ((ParamStr)this.params.get(n4 - 1)).isVarArg() : false;
                    if (n5 >= n4 && !bl3) break;
                    string = bl5 ? " " : "";
                    break;
                }
                default: {
                    Object object;
                    string = this.getItemText();
                    n3 = 0;
                    boolean bl7 = false;
                    Formatter formatter = baseDocument.getFormatter();
                    if (formatter instanceof ExtFormatter) {
                        object = ((ExtFormatter)formatter).getSettingValue("java-format-space-before-parenthesis");
                        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                            n3 = 1;
                        }
                        if ((object = ((ExtFormatter)formatter).getSettingValue("pair-characters-completion")) instanceof Boolean && ((Boolean)object).booleanValue()) {
                            bl7 = true;
                        }
                    }
                    if (!bl2) break;
                    object = null;
                    try {
                        int n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n6 > -1 && n6 <= Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n + n2)) && baseDocument.getChars(n6, 1)[0] == '(') {
                            object = baseDocument.getText(n + n2, n6 + 1 - n - n2);
                            if (n3 != 0 && ((String)object).length() < 2) {
                                string = string + ' ';
                            }
                            n2 = n6 + 1 - n;
                            string = string + (String)object;
                            toAdd = null;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (object == null) {
                        if (n3 != 0) {
                            string = string + ' ';
                        }
                        string = string + '(';
                        if (this.params.size() > 0) {
                            this.selectionStartOffset = this.selectionEndOffset = string.length();
                            Completion completion = Completion.get();
                            completion.hideCompletion();
                            completion.hideDocumentation();
                            completion.showToolTip();
                        }
                        if (!bl7) break;
                        string = string + ")";
                        break;
                    }
                    try {
                        int n7 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n7 <= -1 || baseDocument.getChars(n7, 1)[0] != ')') break;
                        object = baseDocument.getText(n + n2, n7 + 1 - n - n2);
                        n2 = n7 + 1 - n;
                        if (this.params.size() > 0) {
                            this.selectionStartOffset = this.selectionEndOffset = string.length();
                        }
                        string = string + (String)object;
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (string != null) {
                if (toAdd != null && !toAdd.equals("\n") && !"(".equals(toAdd)) {
                    string = string + toAdd;
                }
                baseDocument.atomicLock();
                try {
                    String string3 = baseDocument.getText(n, n2);
                    if (string.equals(string3)) {
                        jTextComponent.setCaretPosition(n + n2);
                        n3 = 0;
                        return n3 != 0;
                    }
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n, string, null);
                    if (this.selectionStartOffset >= 0) {
                        jTextComponent.select(n + this.selectionStartOffset, n + this.selectionEndOffset);
                    } else if ("(".equals(toAdd) && (n3 = string.lastIndexOf(41)) > -1) {
                        jTextComponent.setCaretPosition(n + n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
                return true;
            }
            return false;
        }

        List createParamsList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.params.iterator();
            while (iterator.hasNext()) {
                String string;
                StringBuffer stringBuffer = new StringBuffer();
                ParamStr paramStr = (ParamStr)iterator.next();
                stringBuffer.append(paramStr.getSimpleTypeName());
                if (paramStr.isVarArg()) {
                    stringBuffer.append("...");
                }
                if ((string = paramStr.getName()) != null && string.length() > 0) {
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                }
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                }
                arrayList.add(stringBuffer.toString());
            }
            return arrayList;
        }

        int getCurrentParamIndex() {
            int n = 0;
            if (this.substituteExp != null && this.substituteExp.getExpID() == 10) {
                n = this.substituteExp.getParameterCount() - 1;
            }
            if (this.varArgIndex > -1 && this.varArgIndex < n) {
                n = this.varArgIndex;
            }
            return n;
        }

        protected String printParams(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            Iterator iterator = this.params.iterator();
            while (iterator.hasNext()) {
                String string;
                ParamStr paramStr = (ParamStr)iterator.next();
                stringBuffer.append(paramStr.getSimpleTypeName());
                if (paramStr.isVarArg()) {
                    stringBuffer.append("...");
                }
                if (bl && (string = paramStr.getName()) != null && string.length() > 0) {
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        protected String printExceptions() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.excs.size() > 0) {
                stringBuffer.append(" throws ");
                Iterator iterator = this.excs.iterator();
                while (iterator.hasNext()) {
                    ExcStr excStr = (ExcStr)iterator.next();
                    stringBuffer.append(excStr.getName());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
            }
            return stringBuffer.toString();
        }
    }

    public static class ConstructorResultItem
    extends CallableFeatureResultItem {
        private static NbJMIPaintComponent.NbConstructorPaintComponent ctrComponent = null;

        public ConstructorResultItem(Constructor constructor, JCExpression jCExpression) {
            super((CallableFeature)constructor, jCExpression, null);
        }

        public String getName() {
            return this.getTypeName();
        }

        public Component getPaintComponent(boolean bl) {
            if (ctrComponent == null) {
                ctrComponent = new NbJMIPaintComponent.NbConstructorPaintComponent();
            }
            ctrComponent.setFeatureName(this.getName());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setDeprecated(this.isDeprecated());
            ctrComponent.setSelected(bl);
            ctrComponent.setActiveParameterIndex(this.getActiveParameterIndex());
            return ctrComponent;
        }

        public int getSortPriority() {
            return this.isEnclosingCall() ? 5 : 400;
        }

        public String toString() {
            String string = Modifier.toString(this.getModifiers()) + " ";
            return (string.length() > 1 ? string : "") + this.getName() + this.printParams(true) + this.printExceptions();
        }
    }

    public static class MethodResultItem
    extends CallableFeatureResultItem {
        private static NbJMIPaintComponent.NbMethodPaintComponent mtdComponent = null;

        public MethodResultItem(Method method, JCExpression jCExpression, ClassDefinition classDefinition) {
            super((CallableFeature)method, jCExpression, classDefinition);
        }

        public Component getPaintComponent(boolean bl) {
            if (mtdComponent == null) {
                mtdComponent = new NbJMIPaintComponent.NbMethodPaintComponent();
            }
            mtdComponent.setFeatureName(this.getName());
            mtdComponent.setModifiers(this.getModifiers());
            mtdComponent.setTypeName(this.getTypeName());
            mtdComponent.setTypeColor(this.getTypeColor());
            mtdComponent.setParams(this.getParams());
            mtdComponent.setExceptions(this.getExceptions());
            mtdComponent.setDeprecated(this.isDeprecated());
            mtdComponent.setSelected(bl);
            mtdComponent.setActiveParameterIndex(this.getActiveParameterIndex());
            return mtdComponent;
        }

        public int getSortPriority() {
            return this.isEnclosingCall() ? 10 : 500;
        }

        public String toString() {
            String string = Modifier.toString(this.getModifiers()) + " ";
            return (string.length() > 1 ? string : "") + this.getTypeName() + " " + this.getName() + this.printParams(true) + this.printExceptions();
        }
    }

    public static class FieldResultItem
    extends NbJMIResultItem {
        private Field fld;
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isDeprecated;
        private static NbJMIPaintComponent.NbFieldPaintComponent fieldComponent = null;

        public FieldResultItem(Field field, ClassDefinition classDefinition) {
            this.fld = field;
            this.fldName = field.getName();
            this.modifiers = field.getModifiers();
            if (field.getDeclaringClass() == (classDefinition instanceof ParameterizedType ? ((ParameterizedType)classDefinition).getDefinition() : classDefinition)) {
                this.modifiers |= 0x20000000;
            }
            Type type = field.getType();
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = FieldResultItem.getTypeColor(type);
            this.isDeprecated = field.isDeprecated();
        }

        public String getItemText() {
            return this.fldName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getFieldName() {
            return this.fldName;
        }

        public Component getPaintComponent(boolean bl) {
            if (fieldComponent == null) {
                fieldComponent = new NbJMIPaintComponent.NbFieldPaintComponent(false);
            }
            fieldComponent.setTypeName(this.typeName);
            fieldComponent.setFieldName(this.fldName);
            fieldComponent.setTypeColor(this.typeColor);
            fieldComponent.setModifiers(this.modifiers);
            fieldComponent.setSelected(bl);
            fieldComponent.setDeprecated(this.isDeprecated);
            return fieldComponent;
        }

        protected Object getAssociatedObject() {
            return this.fld;
        }

        public int getSortPriority() {
            return 300;
        }

        public String toString() {
            String string = Modifier.toString(this.modifiers) + " ";
            return (string.length() > 1 ? string : "") + this.typeName + " " + this.fldName;
        }
    }

    public static class VarResultItem
    extends NbJMIResultItem {
        private Type type;
        private String typeName;
        private Color typeColor;
        private String varName;
        private int modifiers;
        private static NbJMIPaintComponent.NbFieldPaintComponent fieldComponent = null;

        public VarResultItem(String string, Type type, int n) {
            this.type = type;
            this.varName = string;
            this.modifiers = n | 0x20000000;
            this.typeName = JMIUtils.getTypeName(type, false, false);
            this.typeColor = VarResultItem.getTypeColor(type);
        }

        public String getItemText() {
            return this.varName;
        }

        public Component getPaintComponent(boolean bl) {
            if (fieldComponent == null) {
                fieldComponent = new NbJMIPaintComponent.NbFieldPaintComponent(true);
            }
            fieldComponent.setTypeName(this.typeName);
            fieldComponent.setTypeColor(this.typeColor);
            fieldComponent.setFieldName(this.varName);
            fieldComponent.setModifiers(this.modifiers);
            fieldComponent.setSelected(bl);
            return fieldComponent;
        }

        protected Object getAssociatedObject() {
            return this;
        }

        public Type getType() {
            return this.type;
        }

        public int getSortPriority() {
            return 200;
        }

        public String toString() {
            String string = Modifier.toString(this.modifiers) + " ";
            return (string.length() > 1 ? string : "") + this.typeName + " " + this.varName;
        }
    }
}

