/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.RequestProcessor;

final class NbJavaFoldManager
extends JavaFoldManager
implements SettingsChangeListener,
ParsingListener,
Runnable {
    private static final int INIT_FOLDS_PARSING_FOLD_UPDATES_DELAY = 1000;
    private static boolean debug = Boolean.getBoolean("netbeans.debug.editor.fold.manager.java");
    private FoldOperation operation;
    private final HashMap id2foldInfo = new HashMap();
    private Fold initialCommentFold;
    private Fold importsFold;
    private boolean foldImportsPreset;
    private boolean foldInnerClassesPreset;
    private boolean foldJavadocsPreset;
    private boolean foldCodeBlocksPreset;
    private boolean foldInitialCommentsPreset;
    private boolean listeningOnParsing;
    private boolean documentModified;
    private static RequestProcessor javaFoldsRP;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaFoldManager;

    private static synchronized RequestProcessor getJavaFoldsRP() {
        if (javaFoldsRP == null) {
            javaFoldsRP = new RequestProcessor("Java-Folds", 1);
        }
        return javaFoldsRP;
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        this.settingsChange(null);
    }

    private FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        if (this.foldImportsPreset || this.foldCodeBlocksPreset || this.foldInnerClassesPreset || this.foldJavadocsPreset) {
            NbJavaFoldManager.getJavaFoldsRP().post((Runnable)this);
        } else {
            NbJavaFoldManager.getJavaFoldsRP().post((Runnable)this, 1000, 1);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.documentModified = true;
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.documentModified = true;
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeFoldNotify(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.removeFoldNotify(fold);
    }

    public void expandNotify(Fold fold) {
    }

    public void release() {
    }

    public void resourceParsed(Resource resource) {
        FileObject fileObject;
        DataObject dataObject = this.getDataObject();
        if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
            String string;
            try {
                string = resource.getName();
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null && fileObject.getPath().endsWith(string) && JavaModel.getFileObject((Resource)resource) == fileObject) {
                this.updateFolds(null);
            }
        }
    }

    public void run() {
        try {
            Resource resource = this.getResource();
            if (resource != null && resource.isValid()) {
                if (!this.listeningOnParsing) {
                    this.listeningOnParsing = true;
                    new WeakParsingListener(this).startListening();
                }
                this.updateFolds(null);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private void updateFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        if (!this.getOperation().isReleased()) {
            final UpdateFoldsRequest updateFoldsRequest = this.collectFoldUpdates(foldHierarchyTransaction != null);
            if (foldHierarchyTransaction != null) {
                this.processUpdateFoldRequest(updateFoldsRequest, foldHierarchyTransaction);
            } else {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (!NbJavaFoldManager.this.getOperation().isReleased()) {
                            Document document = NbJavaFoldManager.this.getDocument();
                            if (!(document instanceof AbstractDocument)) {
                                return;
                            }
                            AbstractDocument abstractDocument = (AbstractDocument)document;
                            abstractDocument.readLock();
                            try {
                                FoldHierarchy foldHierarchy = NbJavaFoldManager.this.getOperation().getHierarchy();
                                foldHierarchy.lock();
                                try {
                                    FoldHierarchyTransaction foldHierarchyTransaction = NbJavaFoldManager.this.getOperation().openTransaction();
                                    try {
                                        NbJavaFoldManager.this.processUpdateFoldRequest(updateFoldsRequest, foldHierarchyTransaction);
                                    }
                                    finally {
                                        foldHierarchyTransaction.commit();
                                    }
                                }
                                finally {
                                    foldHierarchy.unlock();
                                }
                            }
                            finally {
                                abstractDocument.readUnlock();
                            }
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateFoldsRequest collectFoldUpdates(boolean bl) {
        UpdateFoldsRequest updateFoldsRequest = new UpdateFoldsRequest();
        Document document = this.getDocument();
        if (this.getOperation().isReleased() || !(document instanceof AbstractDocument)) {
            return updateFoldsRequest;
        }
        AbstractDocument abstractDocument = (AbstractDocument)document;
        if (bl && !this.isAnydFoldPresetRequiringParsing()) {
            abstractDocument.readLock();
            try {
                this.collectNonParsingFoldUpdates(updateFoldsRequest, abstractDocument);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            finally {
                abstractDocument.readUnlock();
            }
            NbJavaFoldManager.getJavaFoldsRP().post((Runnable)this, 1000);
        } else {
            ((JMManager)JMManager.getManager()).waitScanFinished();
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                JavaModel.setClassPath((FileObject)this.getDataObject().getPrimaryFile());
                Resource resource = this.getResource();
                if (resource == null || !resource.isValid()) {
                    UpdateFoldsRequest updateFoldsRequest2 = updateFoldsRequest;
                    return updateFoldsRequest2;
                }
                abstractDocument.readLock();
                try {
                    PositionBounds positionBounds;
                    Object object;
                    this.collectNonParsingFoldUpdates(updateFoldsRequest, abstractDocument);
                    int n = abstractDocument.getLength();
                    int n2 = Integer.MAX_VALUE;
                    int n3 = Integer.MIN_VALUE;
                    Object object2 = resource.getImports().iterator();
                    while (object2.hasNext()) {
                        object = (Import)object2.next();
                        positionBounds = JavaMetamodel.getManager().getElementPosition((Element)object);
                        n2 = Math.min(n2, positionBounds.getBegin().getOffset());
                        n3 = Math.max(n3, positionBounds.getEnd().getOffset());
                    }
                    if (n2 != Integer.MAX_VALUE && n2 >= 0 && (n2 += 7) < n3 && n3 <= n) {
                        updateFoldsRequest.setImportsFoldInfo(new ImportsFoldInfo(abstractDocument.createPosition(n2), abstractDocument.createPosition(n3)));
                    }
                    object2 = resource.getClassifiers();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        positionBounds = (JavaClass)object.next();
                        if (debug) {
                            System.err.println("JavaFoldManager: found Class: " + positionBounds);
                        }
                        this.collectClassFoldUpdates(updateFoldsRequest, (JavaClass)positionBounds, true, abstractDocument);
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                finally {
                    abstractDocument.readUnlock();
                }
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
        return updateFoldsRequest;
    }

    private void collectNonParsingFoldUpdates(UpdateFoldsRequest updateFoldsRequest, AbstractDocument abstractDocument) throws BadLocationException {
        int n = abstractDocument.getLength();
        BaseDocument baseDocument = (BaseDocument)abstractDocument;
        NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)baseDocument.getSyntaxSupport();
        InitialCommentProcessor initialCommentProcessor = new InitialCommentProcessor();
        nbJavaSyntaxSupport.tokenizeText(initialCommentProcessor, 0, n, false);
        int n2 = initialCommentProcessor.getCommentStartOffset();
        int n3 = initialCommentProcessor.getCommentEndOffset();
        if (n2 >= 0 && n2 < n3 && n3 <= n) {
            updateFoldsRequest.setInitialCommentFoldInfo(new InitialCommentFoldInfo(baseDocument.createPosition(n2), baseDocument.createPosition(n3)));
        }
    }

    private void collectClassFoldUpdates(UpdateFoldsRequest updateFoldsRequest, JavaClass javaClass, boolean bl, AbstractDocument abstractDocument) throws BadLocationException {
        ClassMemberFoldInfo classMemberFoldInfo = new ClassMemberFoldInfo((ClassMember)javaClass, bl, abstractDocument);
        updateFoldsRequest.addMemberFoldInfo(classMemberFoldInfo);
        Iterator iterator = javaClass.getFeatures().iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (debug) {
                System.err.println("JavaFoldManager: found Feature: " + feature);
            }
            if (feature instanceof JavaClass) {
                JavaClass javaClass2 = (JavaClass)feature;
                if (debug) {
                    System.err.println("JavaFoldManager: found SubClass: " + javaClass2);
                }
                this.collectClassFoldUpdates(updateFoldsRequest, javaClass2, false, abstractDocument);
                continue;
            }
            boolean bl2 = feature instanceof Field;
            ClassMemberFoldInfo classMemberFoldInfo2 = new ClassMemberFoldInfo((ClassMember)feature, bl2, abstractDocument);
            updateFoldsRequest.addMemberFoldInfo(classMemberFoldInfo2);
        }
    }

    private void processUpdateFoldRequest(UpdateFoldsRequest updateFoldsRequest, FoldHierarchyTransaction foldHierarchyTransaction) {
        if (updateFoldsRequest.isValid()) {
            String string;
            ClassMemberFoldInfo classMemberFoldInfo;
            Object object;
            Iterator<Object> iterator;
            Fold fold = this.getInitialCommentFold();
            InitialCommentFoldInfo initialCommentFoldInfo = updateFoldsRequest.getInitialCommentFoldInfo();
            if (initialCommentFoldInfo != null) {
                if (initialCommentFoldInfo.isUpdateNecessary(fold)) {
                    boolean bl;
                    boolean bl2 = fold != null ? fold.isCollapsed() : (bl = this.documentModified ? false : this.foldInitialCommentsPreset);
                    if (fold != null) {
                        this.getOperation().removeFromHierarchy(fold, foldHierarchyTransaction);
                        this.setInitialCommentFold(null);
                    }
                    try {
                        initialCommentFoldInfo.updateHierarchy(foldHierarchyTransaction, bl);
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            } else if (fold != null) {
                this.getOperation().removeFromHierarchy(fold, foldHierarchyTransaction);
                this.setInitialCommentFold(null);
            }
            fold = this.getImportsFold();
            ImportsFoldInfo importsFoldInfo = updateFoldsRequest.getImportsFoldInfo();
            if (importsFoldInfo != null) {
                if (importsFoldInfo.isUpdateNecessary(fold)) {
                    boolean bl;
                    boolean bl3 = fold != null ? fold.isCollapsed() : (bl = this.documentModified ? false : this.foldImportsPreset);
                    if (fold != null) {
                        this.getOperation().removeFromHierarchy(fold, foldHierarchyTransaction);
                        this.setImportsFold(null);
                    }
                    try {
                        importsFoldInfo.updateHierarchy(foldHierarchyTransaction, bl);
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            } else if (fold != null) {
                this.getOperation().removeFromHierarchy(fold, foldHierarchyTransaction);
                this.setImportsFold(null);
            }
            Map map = (Map)this.id2foldInfo.clone();
            List list = updateFoldsRequest.getMemberFoldInfos();
            if (list != null) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    object = (ClassMemberFoldInfo)iterator.next();
                    if (((ClassMemberFoldInfo)object).isUpdateNecessary(classMemberFoldInfo = this.findClassMemberFoldInfo(string = ((ClassMemberFoldInfo)object).getId()))) {
                        if (classMemberFoldInfo != null) {
                            classMemberFoldInfo.removeFromHierarchy(foldHierarchyTransaction);
                        }
                        try {
                            ((ClassMemberFoldInfo)object).updateHierarchy(foldHierarchyTransaction, classMemberFoldInfo);
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify((Throwable)badLocationException);
                        }
                        this.putClassMemberFoldInfo(string, (ClassMemberFoldInfo)object);
                    }
                    if (classMemberFoldInfo == null) continue;
                    map.remove(string);
                }
            }
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                string = (String)object.getKey();
                classMemberFoldInfo = (ClassMemberFoldInfo)object.getValue();
                classMemberFoldInfo.removeFromHierarchy(foldHierarchyTransaction);
                this.removeClassMemberFoldInfo(string);
                if (!debug) continue;
                System.err.println("Removing obsolete foldInfo: " + classMemberFoldInfo);
            }
        }
    }

    private boolean isAnydFoldPresetRequiringParsing() {
        return this.foldImportsPreset || this.foldCodeBlocksPreset || this.foldInnerClassesPreset || this.foldJavadocsPreset;
    }

    Fold getInitialCommentFold() {
        return this.initialCommentFold;
    }

    void setInitialCommentFold(Fold fold) {
        this.initialCommentFold = fold;
    }

    Fold getImportsFold() {
        return this.importsFold;
    }

    void setImportsFold(Fold fold) {
        this.importsFold = fold;
    }

    private ClassMemberFoldInfo findClassMemberFoldInfo(String string) {
        return (ClassMemberFoldInfo)this.id2foldInfo.get(string);
    }

    private void removeClassMemberFoldInfo(String string) {
        this.id2foldInfo.remove(string);
    }

    private void putClassMemberFoldInfo(String string, ClassMemberFoldInfo classMemberFoldInfo) {
        this.id2foldInfo.put(string, classMemberFoldInfo);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        this.foldInitialCommentsPreset = this.getSetting("code-folding-collapse-initial-comment");
        this.foldImportsPreset = this.getSetting("code-folding-collapse-import");
        this.foldCodeBlocksPreset = this.getSetting("code-folding-collapse-method");
        this.foldInnerClassesPreset = this.getSetting("code-folding-collapse-innerclass");
        this.foldJavadocsPreset = this.getSetting("code-folding-collapse-javadoc");
    }

    private boolean getSetting(String string) {
        JTextComponent jTextComponent = this.getOperation().getHierarchy().getComponent();
        return SettingsUtil.getBoolean((Class)Utilities.getKitClass((JTextComponent)jTextComponent), (String)string, (boolean)false);
    }

    Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    DataObject getDataObject() {
        Document document = this.getDocument();
        return document != null ? NbEditorUtilities.getDataObject((Document)document) : null;
    }

    Resource getResource() {
        DataObject dataObject = this.getDataObject();
        return dataObject != null ? JavaModel.getResource((FileObject)dataObject.getPrimaryFile()) : null;
    }

    private void removeFoldNotify(Fold fold) {
        if (fold == this.getInitialCommentFold()) {
            this.setInitialCommentFold(null);
        } else if (fold == this.getImportsFold()) {
            this.setImportsFold(null);
        } else {
            ClassMemberFoldInfo classMemberFoldInfo = (ClassMemberFoldInfo)this.getOperation().getExtraInfo(fold);
            classMemberFoldInfo.removeFoldNotify(fold);
        }
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new NbJavaFoldManager();
        }
    }

    private static final class WeakParsingListener
    implements ParsingListener {
        private WeakReference ref;

        WeakParsingListener(ParsingListener parsingListener) {
            this.ref = new WeakReference<ParsingListener>(parsingListener);
        }

        public void startListening() {
            JavaMetamodel.getManager();
            JavaMetamodel.addParsingListener((ParsingListener)this);
        }

        public void resourceParsed(Resource resource) {
            ParsingListener parsingListener = (ParsingListener)this.ref.get();
            if (parsingListener != null) {
                parsingListener.resourceParsed(resource);
            } else {
                JavaMetamodel.getManager();
                JavaMetamodel.removeParsingListener((ParsingListener)this);
            }
        }
    }

    private final class UpdateFoldsRequest {
        private Document creationTimeDoc;
        private InitialCommentFoldInfo initialCommentFoldInfo;
        private ImportsFoldInfo importsFoldInfo;
        private List memberFoldInfos;

        UpdateFoldsRequest() {
            this.creationTimeDoc = NbJavaFoldManager.this.getDocument();
        }

        boolean isValid() {
            return this.creationTimeDoc == NbJavaFoldManager.this.getDocument();
        }

        InitialCommentFoldInfo getInitialCommentFoldInfo() {
            return this.initialCommentFoldInfo;
        }

        void setInitialCommentFoldInfo(InitialCommentFoldInfo initialCommentFoldInfo) {
            this.initialCommentFoldInfo = initialCommentFoldInfo;
        }

        ImportsFoldInfo getImportsFoldInfo() {
            return this.importsFoldInfo;
        }

        void setImportsFoldInfo(ImportsFoldInfo importsFoldInfo) {
            this.importsFoldInfo = importsFoldInfo;
        }

        List getMemberFoldInfos() {
            return this.memberFoldInfos;
        }

        void addMemberFoldInfo(ClassMemberFoldInfo classMemberFoldInfo) {
            if (this.memberFoldInfos == null) {
                this.memberFoldInfos = new ArrayList();
            }
            this.memberFoldInfos.add(classMemberFoldInfo);
        }
    }

    private final class ClassMemberFoldInfo {
        private String id;
        private ClassMember classMember;
        private JavaDoc javadoc;
        private Fold fold;
        private Fold javadocFold;
        private boolean javadocFoldOnly;
        private JavaFoldManager.FoldTemplate template;
        private JavaFoldManager.FoldTemplate javadocTemplate;
        private Position classMemberStartPos;
        private Position classMemberEndPos;
        private Position javadocStartPos;
        private Position javadocEndPos;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ClassMemberFoldInfo(ClassMember classMember, boolean bl, AbstractDocument abstractDocument) throws BadLocationException {
            int n;
            ClassMember classMember2;
            this.classMember = classMember;
            this.javadocFoldOnly = bl;
            this.template = JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE;
            this.javadocTemplate = JavaFoldManager.JAVADOC_FOLD_TEMPLATE;
            this.id = classMember.refMofId();
            this.javadoc = classMember.getJavadoc();
            int n2 = abstractDocument.getLength();
            JavaMetamodel javaMetamodel = JavaMetamodel.getManager();
            if (!bl) {
                PositionBounds positionBounds;
                classMember2 = classMember;
                if (classMember2 instanceof Method) {
                    // empty if block
                }
                if ((positionBounds = javaMetamodel.getElementPosition((Element)classMember2)) != null) {
                    n = positionBounds.getBegin().getOffset();
                    int n3 = positionBounds.getEnd().getOffset();
                    if (n >= 0 && n < n3 && n3 <= n2) {
                        if ((classMember2 instanceof Method || classMember2 instanceof Constructor || classMember2 instanceof JavaClass) && abstractDocument instanceof BaseDocument) {
                            BaseDocument baseDocument = (BaseDocument)abstractDocument;
                            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)baseDocument.getSyntaxSupport();
                            OpeningBraceProcessor openingBraceProcessor = new OpeningBraceProcessor(n3);
                            nbJavaSyntaxSupport.tokenizeText(openingBraceProcessor, n, n3, false);
                            int n4 = openingBraceProcessor.getOpeningBraceOffset();
                            n = n4 >= 0 && n4 < n3 ? n4 : -1;
                        }
                        if (n >= 0) {
                            this.classMemberStartPos = abstractDocument.createPosition(n);
                            this.classMemberEndPos = abstractDocument.createPosition(n3);
                        }
                    }
                }
            }
            if (this.javadoc != null && (classMember2 = javaMetamodel.getElementPosition((Element)this.javadoc)) != null) {
                int n5 = classMember2.getBegin().getOffset();
                n = classMember2.getEnd().getOffset();
                if (n5 >= 0 && n5 < n && n <= n2) {
                    this.javadocStartPos = abstractDocument.createPosition(n5);
                    this.javadocEndPos = abstractDocument.createPosition(n);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public boolean isUpdateNecessary(ClassMemberFoldInfo classMemberFoldInfo) {
            boolean bl = false;
            if (classMemberFoldInfo == null) {
                bl = true;
            } else {
                Fold fold;
                if (!this.javadocFoldOnly) {
                    fold = classMemberFoldInfo.getFold();
                    if (this.classMemberStartPos != null && (fold == null || this.classMemberStartPos.getOffset() != fold.getStartOffset() || this.classMemberEndPos.getOffset() != fold.getEndOffset())) {
                        bl = true;
                    }
                }
                if (!bl && this.javadoc != null) {
                    fold = classMemberFoldInfo.getJavadocFold();
                    if (this.javadocStartPos != null && fold != null) {
                        if (this.javadocStartPos.getOffset() != fold.getStartOffset() || this.javadocEndPos.getOffset() != fold.getEndOffset()) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
            }
            return bl;
        }

        public void updateHierarchy(FoldHierarchyTransaction foldHierarchyTransaction, ClassMemberFoldInfo classMemberFoldInfo) throws BadLocationException {
            boolean bl;
            Fold fold;
            int n;
            int n2;
            if (debug) {
                System.err.println("JavaFoldManager.updateHierarchy(): classMember=" + this.classMember);
            }
            if (!this.javadocFoldOnly && this.classMemberStartPos != null && FoldOperation.isBoundsValid((int)(n2 = this.classMemberStartPos.getOffset()), (int)(n = this.classMemberEndPos.getOffset()), (int)this.template.getStartGuardedLength(), (int)this.template.getEndGuardedLength())) {
                bl = classMemberFoldInfo != null && (fold = classMemberFoldInfo.getFold()) != null ? fold.isCollapsed() : (NbJavaFoldManager.this.documentModified ? false : (this.classMember instanceof JavaClass ? NbJavaFoldManager.this.foldInnerClassesPreset : NbJavaFoldManager.this.foldCodeBlocksPreset));
                this.fold = NbJavaFoldManager.this.getOperation().addToHierarchy(this.template.getType(), this.template.getDescription(), bl, n2, n, this.template.getStartGuardedLength(), this.template.getEndGuardedLength(), (Object)this, foldHierarchyTransaction);
            }
            if (this.javadoc != null && this.javadocStartPos != null && FoldOperation.isBoundsValid((int)(n2 = this.javadocStartPos.getOffset()), (int)(n = this.javadocEndPos.getOffset()), (int)this.javadocTemplate.getStartGuardedLength(), (int)this.javadocTemplate.getEndGuardedLength())) {
                bl = classMemberFoldInfo != null && (fold = classMemberFoldInfo.getJavadocFold()) != null ? fold.isCollapsed() : (NbJavaFoldManager.this.documentModified ? false : NbJavaFoldManager.this.foldJavadocsPreset);
                this.javadocFold = NbJavaFoldManager.this.getOperation().addToHierarchy(this.javadocTemplate.getType(), this.javadocTemplate.getDescription(), bl, n2, n, this.javadocTemplate.getStartGuardedLength(), this.javadocTemplate.getEndGuardedLength(), (Object)this, foldHierarchyTransaction);
            }
        }

        public void removeFromHierarchy(FoldHierarchyTransaction foldHierarchyTransaction) {
            if (debug) {
                System.err.println("JavaFoldManager.removeFromHierarchy(): " + this);
            }
            if (this.fold != null) {
                NbJavaFoldManager.this.getOperation().removeFromHierarchy(this.fold, foldHierarchyTransaction);
            }
            if (this.javadocFold != null) {
                NbJavaFoldManager.this.getOperation().removeFromHierarchy(this.javadocFold, foldHierarchyTransaction);
            }
        }

        public Fold getFold() {
            return this.fold;
        }

        public Fold getJavadocFold() {
            return this.javadocFold;
        }

        public void removeFoldNotify(Fold fold) {
            if (fold == this.fold) {
                this.fold = null;
            } else if (fold == this.javadocFold) {
                this.javadocFold = null;
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public ClassMember getClassMember() {
            return this.classMember;
        }

        public JavaDoc getJavadoc() {
            return this.javadoc;
        }

        public String toString() {
            return "fold=" + this.fold + ", javadocFold=" + this.javadocFold;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$java$NbJavaFoldManager == null ? (class$org$netbeans$modules$editor$java$NbJavaFoldManager = NbJavaFoldManager.class$("org.netbeans.modules.editor.java.NbJavaFoldManager")) : class$org$netbeans$modules$editor$java$NbJavaFoldManager).desiredAssertionStatus();
        }
    }

    private final class ImportsFoldInfo {
        private Position importsStartPos;
        private Position importsEndPos;

        ImportsFoldInfo(Position position, Position position2) {
            this.importsStartPos = position;
            this.importsEndPos = position2;
        }

        public boolean isUpdateNecessary(Fold fold) {
            return fold == null || fold.getStartOffset() != this.importsStartPos.getOffset() || fold.getEndOffset() != this.importsEndPos.getOffset();
        }

        public void updateHierarchy(FoldHierarchyTransaction foldHierarchyTransaction, boolean bl) throws BadLocationException {
            int n;
            int n2 = this.importsStartPos.getOffset();
            if (FoldOperation.isBoundsValid((int)n2, (int)(n = this.importsEndPos.getOffset()), (int)JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getStartGuardedLength(), (int)JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getEndGuardedLength())) {
                Fold fold = NbJavaFoldManager.this.getOperation().addToHierarchy(JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getType(), JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getDescription(), bl, n2, n, JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getStartGuardedLength(), JavaFoldManager.IMPORTS_FOLD_TEMPLATE.getEndGuardedLength(), (Object)this, foldHierarchyTransaction);
                NbJavaFoldManager.this.setImportsFold(fold);
            }
        }
    }

    private final class InitialCommentFoldInfo {
        private Position initialCommentStartPos;
        private Position initialCommentEndPos;

        InitialCommentFoldInfo(Position position, Position position2) {
            this.initialCommentStartPos = position;
            this.initialCommentEndPos = position2;
        }

        public boolean isUpdateNecessary(Fold fold) {
            return fold == null || fold.getStartOffset() != this.initialCommentStartPos.getOffset() || fold.getEndOffset() != this.initialCommentEndPos.getOffset();
        }

        public void updateHierarchy(FoldHierarchyTransaction foldHierarchyTransaction, boolean bl) throws BadLocationException {
            int n;
            int n2 = this.initialCommentStartPos.getOffset();
            if (FoldOperation.isBoundsValid((int)n2, (int)(n = this.initialCommentEndPos.getOffset()), (int)JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getStartGuardedLength(), (int)JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getEndGuardedLength())) {
                Fold fold = NbJavaFoldManager.this.getOperation().addToHierarchy(JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getType(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getDescription(), bl, n2, n, JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getStartGuardedLength(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE.getEndGuardedLength(), (Object)this, foldHierarchyTransaction);
                NbJavaFoldManager.this.setInitialCommentFold(fold);
            }
        }
    }

    private static final class OpeningBraceProcessor
    implements TokenProcessor {
        private int bufferStartOffset;
        private int limitOffset = -1;
        private int openingBraceOffset = -1;

        public int eot(int n) {
            return 0;
        }

        OpeningBraceProcessor(int n) {
            this.limitOffset = n;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartOffset = n3 - n;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            int n3 = this.bufferStartOffset + n;
            if (JavaTokenContext.LBRACE.equals(tokenID)) {
                this.openingBraceOffset = n3;
                return false;
            }
            return n3 < this.limitOffset;
        }

        public int getOpeningBraceOffset() {
            return this.openingBraceOffset;
        }
    }

    private final class InitialCommentProcessor
    implements TokenProcessor {
        private int bufferStartOffset;
        private int commentStartOffset = -1;
        private int commentEndOffset = -1;

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartOffset = n3 - n;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            Document document = NbJavaFoldManager.this.getOperation().getHierarchy().getComponent().getDocument();
            if (JavaTokenContext.BLOCK_COMMENT.equals(tokenID) && document != null) {
                int n3 = this.bufferStartOffset + n;
                try {
                    String string = document.getText(n3, 3);
                    if (!"/**".equals(string)) {
                        this.commentStartOffset = this.bufferStartOffset + n;
                        this.commentEndOffset = this.commentStartOffset + n2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                return false;
            }
            return JavaTokenContext.WHITESPACE.equals(tokenID);
        }

        public int getCommentStartOffset() {
            return this.commentStartOffset;
        }

        public int getCommentEndOffset() {
            return this.commentEndOffset;
        }
    }
}

