/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaFastImport;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.openide.util.NbBundle;

public class NbJavaJMIFastImport
extends JavaFastImport {
    private static final int OK = 0;
    private static final int AMBIGUOUS = 1;
    private static final int CLASHING = 2;
    private JMIUtils jmiUtils;
    private NbJavaJMISyntaxSupport support;

    public NbJavaJMIFastImport(JTextComponent jTextComponent) {
        super(jTextComponent);
        this.jmiUtils = JMIUtils.get(Utilities.getDocument((JTextComponent)jTextComponent));
        this.support = (NbJavaJMISyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(NbJavaJMISyntaxSupport.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List findClasses(String string, int n) {
        ArrayList<NbJMIResultItem> arrayList = new ArrayList<NbJMIResultItem>();
        this.jmiUtils.beginTrans(false);
        try {
            List list = this.jmiUtils.findClasses(null, string, true, true, true, this.support.getTopJavaClass(), false, false);
            if (n == 1) {
                JavaPackage javaPackage;
                TreeSet<JavaPackage> treeSet = new TreeSet<JavaPackage>(JMIUtils.getNaturalMemberNameComparator());
                for (int i = 0; i < list.size(); ++i) {
                    javaPackage = (JavaPackage)((JavaClass)list.get(i)).getResource().refImmediateComposite();
                    if (javaPackage == null) continue;
                    treeSet.add(javaPackage);
                }
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    javaPackage = (JavaPackage)iterator.next();
                    arrayList.add(new NbJMIResultItem.PackageResultItem(javaPackage, true));
                }
            } else {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(new NbJMIResultItem.ClassResultItem((JavaClass)iterator.next(), true, false, false));
                }
            }
        }
        finally {
            this.jmiUtils.endTrans(false);
        }
        return arrayList;
    }

    protected void setFastImportSettings(int n) {
        BaseOptions baseOptions;
        Class clazz = Utilities.getKitClass((JTextComponent)this.target);
        if (clazz != null && (baseOptions = BaseOptions.getOptions((Class)clazz)) instanceof JavaOptions) {
            ((JavaOptions)baseOptions).setFastImportSelection(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImport(Object object) {
        if (object instanceof NbJMIResultItem.PackageResultItem || object instanceof NbJMIResultItem.ClassResultItem) {
            String string = null;
            this.jmiUtils.beginTrans(true);
            try {
                Resource resource = this.support.getResource();
                if (resource != null) {
                    if (object instanceof NbJMIResultItem.ClassResultItem) {
                        int n;
                        JavaClass javaClass = (JavaClass)((NbJMIResultItem.ClassResultItem)object).getAssociatedObject();
                        if (this.isClassAlreadyImported(javaClass, resource, n = this.checkImport(javaClass, resource))) {
                            Utilities.setStatusText((JTextComponent)this.target, (String)MessageFormat.format(NbBundle.getMessage((Class)NbJavaJMIFastImport.class, (String)"NJFI_CLASS_ALREADY_IMPORTED"), javaClass.getName()));
                        } else {
                            this.addImport((NamedElement)javaClass, resource);
                        }
                    } else if (object instanceof NbJMIResultItem.PackageResultItem) {
                        JavaPackage javaPackage = (JavaPackage)((NbJMIResultItem.PackageResultItem)object).getAssociatedObject();
                        if (this.isPackageAlreadyImported(javaPackage, resource)) {
                            Utilities.setStatusText((JTextComponent)this.target, (String)MessageFormat.format(NbBundle.getMessage((Class)NbJavaJMIFastImport.class, (String)"NJFI_PACKAGE_ALREADY_IMPORTED"), javaPackage.getName()));
                        } else {
                            this.addImport((NamedElement)javaPackage, resource);
                        }
                    }
                }
            }
            finally {
                this.jmiUtils.endTrans(false);
            }
            if (string != null) {
                this.pasteFQN(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAutoImport(Object object) {
        if (object instanceof NbJMIResultItem.ClassResultItem) {
            this.jmiUtils.beginTrans(true);
            try {
                Resource resource = this.support.getResource();
                if (resource != null) {
                    JavaClass javaClass = (JavaClass)((NbJMIResultItem.ClassResultItem)object).getAssociatedObject();
                    if (!javaClass.isValid()) {
                        boolean bl = false;
                        return bl;
                    }
                    int n = this.checkImport(javaClass, resource);
                    if (n == 2) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = !this.isClassAlreadyImported(javaClass, resource, n);
                    return bl;
                }
            }
            finally {
                this.jmiUtils.endTrans(false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean autoImport(JavaClass javaClass, boolean bl) {
        this.jmiUtils.beginTrans(true);
        boolean bl2 = true;
        try {
            int n;
            if (!javaClass.isValid()) {
                boolean bl3 = true;
                return bl3;
            }
            Resource resource = this.support.getResource();
            if (resource != null) {
                n = this.checkImport(javaClass, resource);
                if (n == 2) {
                    if (bl) {
                        this.pasteFQN(javaClass.getName());
                    }
                    bl2 = false;
                    boolean bl4 = false;
                    return bl4;
                }
                if (!this.isClassAlreadyImported(javaClass, resource, n)) {
                    this.addImport((NamedElement)javaClass, resource);
                }
            }
            bl2 = false;
            n = 1;
            return n != 0;
        }
        finally {
            this.jmiUtils.endTrans(bl2);
        }
    }

    protected String getItemFQN(Object object) {
        if (object instanceof NbJMIResultItem.ClassResultItem) {
            JavaClass javaClass = (JavaClass)((NbJMIResultItem.ClassResultItem)object).getAssociatedObject();
            return javaClass.getName();
        }
        return super.getItemFQN(object);
    }

    protected boolean isInnerClass(Object object) {
        if (object instanceof NbJMIResultItem.ClassResultItem) {
            JavaClass javaClass = (JavaClass)((NbJMIResultItem.ClassResultItem)object).getAssociatedObject();
            return javaClass.isInner();
        }
        return super.isInnerClass(object);
    }

    private boolean isClassAlreadyImported(JavaClass javaClass, Resource resource, int n) {
        Import import_;
        Iterator iterator;
        String string = this.jmiUtils.getPackageName((ClassDefinition)javaClass);
        if (!javaClass.isInner()) {
            if (("java.lang".equals(string) || resource.getPackageName().equals(string)) && n == 0) {
                return true;
            }
            iterator = resource.getImports().iterator();
            while (iterator.hasNext()) {
                import_ = (Import)iterator.next();
                if (!import_.isOnDemand() || !import_.getImportedElements().contains(javaClass) || n != 0) continue;
                return true;
            }
        } else if (n == 0 && resource == javaClass.getResource()) {
            return true;
        }
        iterator = resource.getImports().iterator();
        while (iterator.hasNext()) {
            import_ = (Import)iterator.next();
            if (import_.isOnDemand() || !javaClass.equals(import_.getImportedNamespace())) continue;
            return true;
        }
        return false;
    }

    private int checkImport(JavaClass javaClass, Resource resource) {
        int n = 0;
        String string = javaClass.getSimpleName();
        Iterator iterator = resource.getImports().iterator();
        block0: while (iterator.hasNext()) {
            Object object;
            Import import_ = (Import)iterator.next();
            if (import_.isOnDemand()) {
                if (n != 0) continue;
                object = import_.getImportedElements().iterator();
                while (object.hasNext()) {
                    NamedElement namedElement = (NamedElement)object.next();
                    if (!(namedElement instanceof JavaClass) || !string.equals(((JavaClass)namedElement).getSimpleName()) || namedElement.equals(javaClass)) continue;
                    n = 1;
                    continue block0;
                }
                continue;
            }
            object = import_.getImportedNamespace();
            if (!(object instanceof JavaClass) || !string.equals(((JavaClass)object).getSimpleName()) || object.equals(javaClass)) continue;
            return 2;
        }
        return n;
    }

    private boolean isPackageAlreadyImported(JavaPackage javaPackage, Resource resource) {
        String string = javaPackage.getName();
        if ("java.lang".equals(string) || resource.getPackageName().equals(string)) {
            return true;
        }
        Iterator iterator = resource.getImports().iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (!import_.getImportedNamespace().equals(javaPackage)) continue;
            return true;
        }
        return false;
    }

    private void addImport(NamedElement namedElement, Resource resource) {
        Import import_;
        String string = namedElement.getName();
        ListIterator<Import> listIterator = resource.getImports().listIterator();
        while (listIterator.hasNext()) {
            import_ = (Import)listIterator.next();
            String string2 = import_.getName();
            if (string2 == null || string.compareTo(string2) >= 0) continue;
            listIterator.previous();
            break;
        }
        import_ = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        listIterator.add(import_.createImport(string, null, false, namedElement instanceof JavaPackage));
    }
}

