/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.PositionBounds;

public class NbJavaJMISyntaxSupport
extends NbJavaSyntaxSupport {
    private JMIUtils jmiUtils;
    private HashMap featuresAtPosMap = new HashMap();

    public synchronized JMIUtils getJMIUtils() {
        if (this.jmiUtils == null) {
            this.jmiUtils = JMIUtils.get(this.getDocument());
        }
        return this.jmiUtils;
    }

    public NbJavaJMISyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
        this.setJava15(true);
    }

    public JavaClass getJavaClass(int n) {
        Feature feature = this.getFeatureAtPos(n, false);
        return feature == null || !feature.isValid() ? null : (feature instanceof JavaClass ? (JavaClass)feature : (JavaClass)feature.getDeclaringClass());
    }

    public boolean isStaticBlock(int n) {
        Feature feature = this.getFeatureAtPos(n, false);
        return feature != null && feature.isValid() ? (feature.getModifiers() & 8) != 0 : false;
    }

    protected int getMethodStartPosition(int n) {
        Feature feature = this.getFeatureAtPos(n, false);
        return feature != null ? JavaMetamodel.getManager().getElementPosition((Element)feature).getBegin().getOffset() : 0;
    }

    public Feature getFeatureAtPos(int n, boolean bl) {
        Integer n2 = new Integer(n);
        if (this.featuresAtPosMap.containsKey(n2)) {
            Element element = (Element)this.featuresAtPosMap.get(n2);
            if (element instanceof JavaDoc) {
                return (Feature)element.refImmediateComposite();
            }
            return (Feature)element;
        }
        Resource resource = this.getResource();
        if (resource == null) {
            this.featuresAtPosMap.put(n2, null);
            return null;
        }
        JavaClass javaClass = null;
        List list = resource.getClassifiers();
        boolean bl2 = true;
        block0: while (bl2) {
            bl2 = false;
            Object[] objectArray = list.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                PositionBounds positionBounds;
                Feature feature = (Feature)objectArray[i];
                PositionBounds positionBounds2 = JavaMetamodel.getManager().getElementPosition((Element)feature);
                if (positionBounds2.getBegin().getOffset() <= n && positionBounds2.getEnd().getOffset() >= n) {
                    if (feature instanceof JavaClass) {
                        javaClass = (JavaClass)feature;
                        list = javaClass.getFeatures();
                        bl2 = true;
                        continue block0;
                    }
                    this.featuresAtPosMap.put(n2, feature);
                    return feature;
                }
                JavaDoc javaDoc = feature.getJavadoc();
                if (!bl || javaDoc == null || (positionBounds = JavaMetamodel.getManager().getElementPosition((Element)javaDoc)).getBegin().getOffset() > n || positionBounds.getEnd().getOffset() < n) continue;
                this.featuresAtPosMap.put(n2, javaDoc);
                return feature;
            }
        }
        this.featuresAtPosMap.put(n2, javaClass);
        return javaClass;
    }

    protected void documentModified(DocumentEvent documentEvent) {
        super.documentModified(documentEvent);
        this.featuresAtPosMap.clear();
    }

    public Object findType(String string, int n) {
        Object object = super.findType(string, n);
        if (!(object instanceof JavaSyntaxSupport.JavaVariable)) {
            return object;
        }
        JCExpression jCExpression = ((JavaSyntaxSupport.JavaVariable)object).getTypeExpression();
        JCExpression jCExpression2 = ((JavaSyntaxSupport.JavaVariable)object).getVariableExpression();
        Type type = this.getType(jCExpression);
        if (type != null) {
            type = this.processArrayDepth(type, this.getArrayDepth(jCExpression2));
        }
        return type;
    }

    public int findLocalDeclarationPosition(String string, int n) {
        Object object = super.findType(string, n);
        if (!(object instanceof JavaSyntaxSupport.JavaVariable)) {
            return super.findLocalDeclarationPosition(string, n);
        }
        return this.getExpressionPos(((JavaSyntaxSupport.JavaVariable)object).getTypeExpression());
    }

    public Collection getLocalVariableNames(String string, int n, boolean bl) {
        Map map = this.getLocalVariableMap(n);
        if (map != null) {
            if (string != null && string.length() > 0) {
                return this.getJMIUtils().filterNames(map.keySet(), string, bl);
            }
            if (!bl) {
                return map.keySet();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getLocalVariableNamesOfType(int n, Type type) {
        Map map = this.getLocalVariableMap(n);
        Collection collection = this.getLocalVariableNames("", n, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JavaSyntaxSupport.OffsetJavaVariable offsetJavaVariable = (JavaSyntaxSupport.OffsetJavaVariable)map.get(string);
            Type type2 = this.getType(offsetJavaVariable.getTypeExpression());
            if (!NbJavaJMISyntaxSupport.isSubType(type2, type)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection getGlobalVariableNamesOfType(int n, Type type) {
        Map map = this.getGlobalVariableMap(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Type type2 = (Type)map.get(string);
            if (!NbJavaJMISyntaxSupport.isSubType(type2, type)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection getLocalVariableNamesOfArrayType(int n) {
        Map map = this.getLocalVariableMap(n);
        Collection collection = this.getLocalVariableNames("", n, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JavaSyntaxSupport.OffsetJavaVariable offsetJavaVariable = (JavaSyntaxSupport.OffsetJavaVariable)map.get(string);
            Type type = this.getType(offsetJavaVariable.getTypeExpression());
            if (!(type instanceof Array)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Collection getGlobalVariableNamesOfArrayType(int n) {
        Map map = this.getGlobalVariableMap(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Type type = (Type)map.get(string);
            if (!(type instanceof Array)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean isSubType(Type type, Type type2) {
        boolean bl = type.equals(type2);
        if (!bl && type instanceof ClassDefinition && type2 instanceof ClassDefinition) {
            bl = ((ClassDefinition)type).isSubTypeOf((ClassDefinition)type2);
        }
        return bl;
    }

    private int getExpressionPos(JCExpression jCExpression) {
        return Math.min(jCExpression.getTokenCount() > 0 ? jCExpression.getTokenOffset(0) : Integer.MAX_VALUE, jCExpression.getParameterCount() > 0 ? this.getExpressionPos(jCExpression.getParameter(0)) : Integer.MAX_VALUE);
    }

    private int getArrayDepth(JCExpression jCExpression) {
        return jCExpression.getExpID() == 7 ? jCExpression.getTokenCount() / 2 : 0;
    }

    private String getTypeName(JCExpression jCExpression) {
        switch (jCExpression.getExpID()) {
            case 1: 
            case 14: {
                return jCExpression.getTokenText(0);
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < jCExpression.getParameterCount(); ++i) {
                    stringBuffer.append(this.getTypeName(jCExpression.getParameter(i)));
                    if (i >= jCExpression.getParameterCount() - 1) continue;
                    stringBuffer.append('.');
                }
                return stringBuffer.toString();
            }
            case 17: {
                return this.getTypeName(jCExpression.getParameter(0));
            }
        }
        throw new IllegalStateException();
    }

    private Type getType(JCExpression jCExpression) {
        Type type = null;
        switch (jCExpression.getExpID()) {
            case 19: {
                type = this.getJMIUtils().resolveType("java.lang.Object");
                break;
            }
            case 7: {
                type = this.processArrayDepth(this.getType(jCExpression.getParameter(0)), this.getArrayDepth(jCExpression));
                break;
            }
            case 17: {
                type = this.getType(jCExpression.getParameter(0));
                if (!(type instanceof JavaClass) || ((JavaClass)type).getTypeParameters().isEmpty()) break;
                ArrayList<Type> arrayList = new ArrayList<Type>(jCExpression.getParameterCount() - 1);
                for (int i = 1; i < jCExpression.getParameterCount(); ++i) {
                    arrayList.add(this.getType(jCExpression.getParameter(i)));
                }
                type = this.getJMIUtils().resolveParameterizedType((JavaClass)type, arrayList);
                break;
            }
            case 4: {
                type = this.getType(jCExpression.getParameter(0));
                if (type != null && !(type instanceof UnresolvedClass)) {
                    int n = 1;
                    while (type instanceof ClassDefinition && n < jCExpression.getParameterCount()) {
                        if (!((type = ((ClassDefinition)type).getInnerClass(this.getTypeName(jCExpression.getParameter(n++)), true)) instanceof JavaClass) || ((JavaClass)type).getTypeParameters().isEmpty()) continue;
                        type = this.getJMIUtils().resolveParameterizedType((JavaClass)type, null);
                    }
                    break;
                }
                type = this.getJMIUtils().resolveType(this.getTypeName(jCExpression));
            }
            default: {
                TypeParameter typeParameter;
                Iterator iterator;
                JavaClass javaClass;
                String string = this.getTypeName(jCExpression);
                JavaClass javaClass2 = this.getJavaClass(jCExpression.getTokenOffset(0));
                if (javaClass2 != null) {
                    javaClass = javaClass2.getInnerClass(string, true);
                    if (javaClass != null) {
                        type = javaClass;
                    } else {
                        iterator = javaClass2.getTypeParameters().iterator();
                        while (iterator.hasNext()) {
                            typeParameter = (TypeParameter)iterator.next();
                            if (!typeParameter.getName().equals(string)) continue;
                            type = typeParameter;
                            break;
                        }
                    }
                }
                if (type == null && (javaClass = this.getFeatureAtPos(jCExpression.getTokenOffset(0), false)) instanceof CallableFeature) {
                    iterator = ((CallableFeature)javaClass).getTypeParameters().iterator();
                    while (iterator.hasNext()) {
                        typeParameter = (TypeParameter)iterator.next();
                        if (!typeParameter.getName().equals(string)) continue;
                        type = typeParameter;
                        break;
                    }
                }
                if (type == null) {
                    type = this.getTypeFromName(string, true, javaClass2, true);
                }
                if (type instanceof JavaClass && !((JavaClass)type).getTypeParameters().isEmpty()) {
                    type = this.getJMIUtils().resolveParameterizedType((JavaClass)type, null);
                }
                if (type != null) break;
                type = this.getJMIUtils().resolveType(string);
            }
        }
        return type;
    }

    private Type processArrayDepth(Type type, int n) {
        while (n > 0) {
            type = this.getJMIUtils().resolveArray(type);
            --n;
        }
        return type;
    }

    public Type getTypeFromName(String string, boolean bl, JavaClass javaClass, boolean bl2) {
        Object object = this.getJMIUtils().resolveType(string);
        if (object != null && !(object instanceof UnresolvedClass)) {
            return object;
        }
        JavaClass javaClass2 = this.getTopJavaClass();
        object = javaClass != null ? javaClass.getInnerClass(string, true) : (javaClass2 != null ? javaClass2.getInnerClass(string, true) : null);
        if (object != null) {
            return object;
        }
        JavaClass javaClass3 = this.getJMIUtils().getImportedClass(string, javaClass2, (JavaClass)(bl2 ? javaClass : null), this.getResource());
        if (javaClass3 != null) {
            return javaClass3;
        }
        if (bl) {
            List list = this.getJMIUtils().findClasses(null, string, true, false, true, (JavaClass)(bl2 ? javaClass : null), false, false);
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass4 = (JavaClass)iterator.next();
                this.getJMIUtils();
                int n2 = JMIUtils.getDefaultSelectionWeight(javaClass4);
                if (n2 <= n) continue;
                n = n2;
                object = javaClass4;
            }
            return object;
        }
        return null;
    }

    public Resource getResource() {
        return this.getJMIUtils().getResource();
    }

    public JavaClass getTopJavaClass(Resource resource) {
        Iterator iterator;
        if (resource != null && (iterator = resource.getClassifiers().iterator()).hasNext()) {
            return (JavaClass)iterator.next();
        }
        return null;
    }

    public JavaClass getTopJavaClass() {
        return this.getTopJavaClass(this.getResource());
    }

    protected Map buildGlobalVariableMap(int n) {
        this.refreshClassInfo();
        JavaClass javaClass = this.getJavaClass(n);
        if (javaClass == null) {
            javaClass = this.getTopJavaClass();
        }
        if (javaClass != null) {
            HashMap<String, Type> hashMap = new HashMap<String, Type>();
            List list = this.getJMIUtils().findFields((Type)javaClass, "", false, true, null, false, false, false, false);
            for (int i = list.size() - 1; i >= 0; --i) {
                Field field = (Field)list.get(i);
                hashMap.put(field.getName(), field.getType());
            }
            return hashMap;
        }
        return null;
    }

    public Type getCommonType(Type type, Type type2) {
        if (this.getJMIUtils().isAssignable(type, type2)) {
            return type;
        }
        if (this.getJMIUtils().isAssignable(type2, type)) {
            return type2;
        }
        return null;
    }

    public List filterMethods(List list, List list2, boolean bl) {
        if (list2 == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CallableFeature> arrayList = new ArrayList<CallableFeature>();
        int n = list2.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            CallableFeature callableFeature = (CallableFeature)iterator.next();
            List list3 = callableFeature.getParameters();
            int n2 = list3.size();
            boolean bl3 = bl2 = n2 > 0 ? ((Parameter)list3.get(n2 - 1)).isVarArg() : false;
            if ((n2 != n || bl && n2 != 0) && (!bl || n2 <= n) && (!bl2 || n2 > n)) continue;
            boolean bl4 = true;
            boolean bl5 = !bl;
            for (int i = 0; bl4 && i < n; ++i) {
                Type type = ((Parameter)list3.get(i < n2 ? i : n2 - 1)).getType();
                Type type2 = (Type)list2.get(i);
                if (type2 != null && !type2.isValid() || !type.isValid()) {
                    bl4 = false;
                    break;
                }
                if (type2 != null) {
                    if (this.getJMIUtils().isEqualType(type2, type)) continue;
                    bl5 = false;
                    if (this.getJMIUtils().isAssignable(type2, type) || !bl && bl2 && i == n2 - 1 && n2 == n && type2 instanceof Array && this.getJMIUtils().isAssignable(((Array)type2).getType(), type)) continue;
                    bl4 = false;
                    break;
                }
                if (type instanceof PrimitiveType) {
                    bl4 = false;
                    break;
                }
                bl5 = false;
            }
            if (!bl4) continue;
            if (bl5) {
                arrayList.clear();
            }
            arrayList.add(callableFeature);
            if (!bl5) continue;
            break;
        }
        return arrayList;
    }

    public boolean isImported(JavaClass javaClass) {
        JavaClass javaClass2 = this.getJMIUtils().getImportedClass(javaClass.getSimpleName(), this.getTopJavaClass(), null, this.getResource());
        return javaClass2 != null && javaClass2.equals(javaClass);
    }

    public int[] getImportSectionBounds() {
        Resource resource = this.getResource();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        if (resource != null) {
            Iterator iterator = resource.getImports().iterator();
            while (iterator.hasNext()) {
                Import import_ = (Import)iterator.next();
                PositionBounds positionBounds = JavaMetamodel.getManager().getElementPosition((Element)import_);
                n = Math.min(n, positionBounds.getBegin().getOffset());
                n2 = Math.max(n2, positionBounds.getEnd().getOffset());
            }
        }
        return new int[]{n, n2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getJavaDocURLs(Object object) {
        JavaPackage javaPackage;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (object instanceof NbJMIResultItem) {
            object = ((NbJMIResultItem)object).getAssociatedObject();
        }
        if (object instanceof Element) {
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                if (((Element)object).isValid()) {
                    URL uRL;
                    ClassDefinition classDefinition;
                    if (object instanceof JavaPackage) {
                        javaPackage = (JavaPackage)object;
                        URL uRL2 = this.getDocFileObjects(javaPackage.getName(), "package-summary");
                        if (uRL2 != null) {
                            arrayList.add(uRL2);
                        }
                    } else if (object instanceof JavaClass) {
                        javaPackage = (JavaClass)object;
                        URL uRL3 = this.getDocFileObjects(javaPackage.getName(), null);
                        if (uRL3 != null) {
                            arrayList.add(uRL3);
                        }
                    } else if (object instanceof CallableFeature) {
                        javaPackage = (CallableFeature)object;
                        ClassDefinition classDefinition2 = javaPackage.getDeclaringClass();
                        URL uRL4 = this.getDocFileObjects(classDefinition2.getName(), null);
                        if (uRL4 != null) {
                            StringBuffer stringBuffer = new StringBuffer("#");
                            stringBuffer.append(javaPackage instanceof Constructor ? JMIUtils.getTypeName(javaPackage.getType(), false, false) : javaPackage.getName());
                            stringBuffer.append('(');
                            List list = javaPackage.getParameters();
                            int n = list.size() - 1;
                            for (int i = 0; i <= n; ++i) {
                                String string = ((Parameter)list.get(i)).getType().getName();
                                int n2 = string.indexOf(60);
                                if (n2 > -1) {
                                    string = string.substring(0, n2);
                                }
                                stringBuffer.append(string);
                                if (i >= n) continue;
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(')');
                            try {
                                arrayList.add(new URL(uRL4.toExternalForm() + stringBuffer));
                            }
                            catch (MalformedURLException malformedURLException) {
                                ErrorManager.getDefault().log(65536, malformedURLException.toString());
                            }
                        }
                    } else if (object instanceof Field && (classDefinition = (javaPackage = (Field)object).getDeclaringClass()) != null && (uRL = this.getDocFileObjects(classDefinition.getName(), null)) != null) {
                        try {
                            arrayList.add(new URL(uRL.toExternalForm() + '#' + javaPackage.getName()));
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().log(65536, malformedURLException.toString());
                        }
                    }
                }
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
        javaPackage = new URL[arrayList.size()];
        arrayList.toArray((T[])javaPackage);
        return javaPackage;
    }

    public String openSource(Object object, boolean bl) {
        JavaClass javaClass = null;
        JavaClass javaClass2 = null;
        if (object instanceof JavaPackage) {
            if (!bl) {
                Node node;
                DataObject dataObject;
                String string = ((JavaPackage)object).getName();
                if (string == null || string.length() <= 0) {
                    return null;
                }
                FileObject fileObject = this.findResource(string.replace('.', '/'));
                if (fileObject != null && (dataObject = this.getDataObject(fileObject)) != null && (node = dataObject.getNodeDelegate()) != null) {
                    NodeOperation.getDefault().explore(node);
                    return null;
                }
                return string;
            }
        } else if (object instanceof JavaClass) {
            javaClass = javaClass2 = (JavaClass)object;
        } else if (object instanceof Field) {
            if (bl) {
                javaClass = (Field)object;
                javaClass2 = ((Field)javaClass).getDeclaringClass();
            } else {
                javaClass2 = ((Field)object).getType();
                if (javaClass2 instanceof JavaClass) {
                    javaClass = JMIUtils.getSourceElementIfExists((ClassDefinition)javaClass2);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        } else if (object instanceof CallableFeature) {
            javaClass = (CallableFeature)object;
            javaClass2 = ((CallableFeature)object).getDeclaringClass();
        }
        if (javaClass != null && JMIUtils.openElement(javaClass)) {
            return null;
        }
        return javaClass2 instanceof JavaClass ? javaClass2.getName() : null;
    }
}

