/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.Stack;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.editor.BaseAction;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

class SelectCodeElementAction
extends BaseAction {
    private boolean selectNext;

    public SelectCodeElementAction(String string, boolean bl) {
        super(string);
        this.selectNext = bl;
        String string2 = this.getShortDescription();
        if (string2 != null) {
            this.putValue("ShortDescription", string2);
        }
    }

    public String getShortDescription() {
        String string;
        String string2 = (String)this.getValue("Name");
        if (string2 == null) {
            return null;
        }
        try {
            string = NbBundle.getBundle((Class)JavaKit.class).getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            int n = jTextComponent.getSelectionStart();
            int n2 = jTextComponent.getSelectionEnd();
            if (n2 > n || this.selectNext) {
                SelectionHandler selectionHandler = (SelectionHandler)jTextComponent.getClientProperty(SelectionHandler.class);
                if (selectionHandler == null) {
                    selectionHandler = new SelectionHandler(jTextComponent);
                    jTextComponent.addCaretListener(selectionHandler);
                    jTextComponent.putClientProperty(SelectionHandler.class, selectionHandler);
                }
                if (!this.selectNext) {
                    if (!selectionHandler.isEmpty()) {
                        selectionHandler.popSelectionInfo();
                        selectionHandler.selectTop();
                    }
                } else {
                    DataObject dataObject = NbEditorUtilities.getDataObject((Document)jTextComponent.getDocument());
                    if (dataObject != null) {
                        JMManager jMManager = (JMManager)JMManager.getManager();
                        MDRepository mDRepository = JavaModel.getJavaRepository();
                        mDRepository.beginTrans(true);
                        try {
                            Element element;
                            if (selectionHandler.isEmpty()) {
                                selectionHandler.pushSelectionInfo(new SelectionInfo(n, n2, null));
                            }
                            if (!((element = selectionHandler.peekSelectionInfo().getElement()) instanceof Resource) && (element = element != null ? (Element)element.refImmediateComposite() : jMManager.getElementByOffset(dataObject.getPrimaryFile(), n)) != null) {
                                PositionBounds positionBounds = jMManager.getElementPosition(element);
                                n = positionBounds.getBegin().getOffset();
                                n2 = positionBounds.getEnd().getOffset();
                                if (element instanceof Resource) {
                                    n = 0;
                                    n2 = jTextComponent.getDocument().getLength();
                                }
                                selectionHandler.pushSelectionInfo(new SelectionInfo(n, n2, element));
                                selectionHandler.selectTop();
                            }
                        }
                        finally {
                            mDRepository.endTrans();
                        }
                    }
                }
            }
        }
    }

    private static final class SelectionInfo {
        private int startOffset;
        private int endOffset;
        private Element element;

        SelectionInfo(int n, int n2, Element element) {
            this.startOffset = n;
            this.endOffset = n2;
            this.element = element;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public Element getElement() {
            return this.element;
        }
    }

    private static final class SelectionHandler
    implements CaretListener {
        private JTextComponent target;
        private Stack selectionInfoStack;
        private boolean ignoreNextCaretUpdate;

        SelectionHandler(JTextComponent jTextComponent) {
            this.target = jTextComponent;
            this.selectionInfoStack = new Stack();
        }

        public void pushSelectionInfo(SelectionInfo selectionInfo) {
            this.selectionInfoStack.push(selectionInfo);
        }

        public SelectionInfo popSelectionInfo() {
            return (SelectionInfo)this.selectionInfoStack.pop();
        }

        public SelectionInfo peekSelectionInfo() {
            return (SelectionInfo)this.selectionInfoStack.peek();
        }

        public boolean isEmpty() {
            return this.selectionInfoStack.empty();
        }

        public void selectTop() {
            if (!this.selectionInfoStack.empty()) {
                SelectionInfo selectionInfo = this.peekSelectionInfo();
                Caret caret = this.target.getCaret();
                this.markIgnoreNextCaretUpdate();
                caret.setDot(selectionInfo.getStartOffset());
                this.markIgnoreNextCaretUpdate();
                caret.moveDot(selectionInfo.getEndOffset());
            }
        }

        private void markIgnoreNextCaretUpdate() {
            this.ignoreNextCaretUpdate = true;
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (!this.ignoreNextCaretUpdate) {
                this.selectionInfoStack.clear();
            }
            this.ignoreNextCaretUpdate = false;
        }
    }
}

