/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.ext.java.JavaSettingsInitializer;
import org.netbeans.editor.ext.java.JavaSettingsNames;
import org.netbeans.modules.editor.NbLocalizer;
import org.netbeans.modules.editor.java.JavaIndentEngine;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.NbJavaSettingsInitializer;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.netbeans.modules.java.editor.options.JavaPrintOptions;
import org.netbeans.modules.javacore.IndentationSettingsProvider;
import org.netbeans.modules.javacore.JMManager;
import org.openide.modules.ModuleInstall;
import org.openide.options.SystemOption;
import org.openide.text.IndentEngine;
import org.openide.text.PrintSettings;
import org.openide.util.SharedClassObject;

public class JavaEditorModule
extends ModuleInstall {
    private NbLocalizer settingsNamesLocalizer;
    private NbLocalizer optionsLocalizer;
    private JavaIndentationSettingsProvider jisProvider = null;
    static boolean inited = false;

    public static void init() {
        if (inited) {
            return;
        }
        inited = true;
        Settings.addInitializer((Settings.Initializer)new JavaSettingsInitializer(JavaKit.class));
        Settings.addInitializer((Settings.Initializer)new NbJavaSettingsInitializer());
        Settings.reset();
    }

    public void restored() {
        JavaEditorModule.init();
        PrintSettings printSettings = (PrintSettings)SharedClassObject.findObject((Class)PrintSettings.class, (boolean)true);
        printSettings.addOption((SystemOption)SharedClassObject.findObject((Class)JavaPrintOptions.class, (boolean)true));
        JMManager.setDocumentLocksCounter((ThreadLocal)BaseDocument.THREAD_LOCAL_LOCK_DEPTH);
        this.settingsNamesLocalizer = new NbLocalizer(JavaSettingsNames.class);
        this.optionsLocalizer = new NbLocalizer(JavaOptions.class);
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)this.settingsNamesLocalizer);
        LocaleSupport.addLocalizer((LocaleSupport.Localizer)this.optionsLocalizer);
        if (this.jisProvider == null) {
            this.jisProvider = new JavaIndentationSettingsProvider();
            JMManager.setIndentationSettingsProvider((IndentationSettingsProvider)this.jisProvider);
        }
    }

    public void uninstalled() {
        if (this.jisProvider != null) {
            this.jisProvider.release();
            JMManager.setIndentationSettingsProvider(null);
            this.jisProvider = null;
        }
        PrintSettings printSettings = (PrintSettings)SharedClassObject.findObject((Class)PrintSettings.class, (boolean)true);
        printSettings.removeOption((SystemOption)SharedClassObject.findObject((Class)JavaPrintOptions.class, (boolean)true));
        JMManager.setDocumentLocksCounter(null);
        Settings.removeInitializer((String)"java-settings-initializer");
        Settings.removeInitializer((String)"nb-java-settings-initializer");
        Settings.reset();
        LocaleSupport.removeLocalizer((LocaleSupport.Localizer)this.settingsNamesLocalizer);
        this.settingsNamesLocalizer = null;
        LocaleSupport.removeLocalizer((LocaleSupport.Localizer)this.optionsLocalizer);
        this.optionsLocalizer = null;
    }

    private static class JavaIndentationSettingsProvider
    implements IndentationSettingsProvider,
    PropertyChangeListener {
        private static final Map indentSettings2propertyName = new HashMap();
        private JavaIndentEngine indentEngine = null;
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private synchronized JavaIndentEngine getIndentEngine() {
            IndentEngine indentEngine;
            BaseOptions baseOptions;
            if (this.indentEngine == null && (baseOptions = BaseOptions.getOptions((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaEditorModule.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit))) instanceof JavaOptions && (indentEngine = baseOptions.getIndentEngine()) instanceof JavaIndentEngine) {
                this.indentEngine = (JavaIndentEngine)indentEngine;
                this.indentEngine.addPropertyChangeListener(this);
            }
            return this.indentEngine;
        }

        public Object getPropertyValue(String string) {
            String string2;
            JavaIndentEngine javaIndentEngine = this.getIndentEngine();
            if (javaIndentEngine != null && (string2 = (String)indentSettings2propertyName.get(string)) != null) {
                return javaIndentEngine.getValue(string2);
            }
            return null;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.getIndentEngine();
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.getIndentEngine();
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        public synchronized void release() {
            if (this.indentEngine != null) {
                this.indentEngine.removePropertyChangeListener(this);
            }
        }

        static {
            indentSettings2propertyName.put("javaFormatLeadingStarInComment", "java-format-leading-star-in-comment");
            indentSettings2propertyName.put("javaFormatNewlineBeforeBrace", "java-format-newline-before-brace");
            indentSettings2propertyName.put("javaFormatSpaceBeforeParenthesis", "java-format-space-before-parenthesis");
            indentSettings2propertyName.put("javaFormatStatementContinuationIndent", "java-format-statement-continuation-indent");
            indentSettings2propertyName.put("expandTabs", "expand-tabs");
            indentSettings2propertyName.put("spacesPerTab", "spaces-per-tab");
        }
    }
}

