/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.hyperlink;

import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public final class JavaHyperlinkProvider
implements HyperlinkProvider {
    private static final int TOKEN_LIMIT = 100;
    private static MessageFormat mf = null;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

    private String findName(BaseDocument baseDocument, int n) {
        String string = "";
        SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
        NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)syntaxSupport.get(NbJavaJMISyntaxSupport.class);
        boolean bl = false;
        try {
            for (int i = 0; i < 100; ++i) {
                TokenID tokenID = nbJavaJMISyntaxSupport.getTokenID(n);
                if (tokenID == JavaTokenContext.IDENTIFIER && !bl) {
                    int[] nArray = Utilities.getIdentifierBlock((BaseDocument)baseDocument, (int)n);
                    string = baseDocument.getText(nArray) + string;
                    n = nArray[0] - 1;
                    bl = true;
                    continue;
                }
                if (tokenID == JavaTokenContext.DOT) {
                    --n;
                    string = "." + string;
                    bl = false;
                    continue;
                }
                if (tokenID == JavaTokenContext.WHITESPACE || tokenID == JavaTokenContext.BLOCK_COMMENT || tokenID == JavaTokenContext.LINE_COMMENT) {
                    --n;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            return "<unknown>";
        }
        return string;
    }

    public void performClickAction(Document document, final int n) {
        if (!(document instanceof BaseDocument)) {
            return;
        }
        final BaseDocument baseDocument = (BaseDocument)document;
        final JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
                NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport = JavaHyperlinkProvider.class$("org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaJMISyntaxSupport);
                JMIUtils jMIUtils = JMIUtils.get(baseDocument);
                Object object = null;
                String string = null;
                jMIUtils.beginTrans(false);
                try {
                    object = JMIUtils.findItemAtCaretPos(jTextComponent);
                    if (object instanceof NbJMIResultItem.VarResultItem) {
                        int n2 = nbJavaJMISyntaxSupport.findLocalDeclarationPosition(((NbJMIResultItem.VarResultItem)object).getItemText(), jTextComponent.getCaretPosition());
                        jTextComponent.setCaretPosition(n2);
                    } else {
                        if (object instanceof ClassDefinition) {
                            object = JMIUtils.getSourceElementIfExists((ClassDefinition)object);
                        }
                        if (object == null || object instanceof JavaPackage || (string = nbJavaJMISyntaxSupport.openSource(object, true)) != null) {
                            String string2;
                            String string3;
                            Toolkit.getDefaultToolkit().beep();
                            if (string != null) {
                                string3 = "goto_source_source_not_found";
                                string2 = string;
                            } else {
                                string3 = "cannot-open-element";
                                string2 = JavaHyperlinkProvider.this.findName(baseDocument, n);
                            }
                            String string4 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaHyperlinkProvider.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(string3);
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string4, string2));
                        }
                    }
                }
                finally {
                    jMIUtils.endTrans(false);
                }
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(runnable, NbBundle.getMessage((Class)BaseDocument.class, (String)"goto-source"));
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        try {
            BaseDocument baseDocument = (BaseDocument)document;
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                return false;
            }
            SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
            NbJavaJMISyntaxSupport nbJavaJMISyntaxSupport = (NbJavaJMISyntaxSupport)syntaxSupport.get(NbJavaJMISyntaxSupport.class);
            TokenID tokenID = nbJavaJMISyntaxSupport.getTokenID(n);
            return tokenID == JavaTokenContext.IDENTIFIER || tokenID == JavaTokenContext.THIS || tokenID == JavaTokenContext.SUPER;
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return false;
        }
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        try {
            if (this.isHyperlinkPoint(document, n)) {
                return Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)document), (int)n);
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return null;
        }
    }
}

