/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaIndentEngine;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JavaOptions
extends BaseOptions {
    public static final String JAVA = "java";
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_CASE_SENSITIVE_PROP = "completionCaseSensitive";
    public static final String COMPLETION_NATURAL_SORT_PROP = "completionNaturalSort";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String FORMAT_SPACE_BEFORE_PARENTHESIS_PROP = "formatSpaceBeforeParenthesis";
    public static final String FORMAT_COMPOUND_BRACKET_ADD_NL_PROP = "formatCompoundBracketAddNL";
    public static final String FAST_IMPORT_SELECTION_PROP = "fastImportSelection";
    private static final String HELP_ID = "editing.editor.java";
    public static final String JAVADOC_BGCOLOR = "javaDocBGColor";
    public static final String JAVADOC_AUTO_POPUP_DELAY_PROP = "javaDocAutoPopupDelay";
    public static final String JAVADOC_PREFERRED_SIZE_PROP = "javaDocPreferredSize";
    public static final String JAVADOC_AUTO_POPUP_PROP = "javaDocAutoPopup";
    public static final String SHOW_DEPRECATED_MEMBERS_PROP = "showDeprecatedMembers";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    public static final String FAST_IMPORT_PACKAGE_PROP = "fastImportPackage";
    public static final String PAIR_CHARACTERS_COMPLETION = "pairCharactersCompletion";
    public static final String GOTO_CLASS_CASE_SENSITIVE_PROP = "gotoClassCaseSensitive";
    public static final String GOTO_CLASS_SHOW_INNER_CLASSES_PROP = "gotoClassShowInnerClasses";
    public static final String GOTO_CLASS_SHOW_LIBRARY_CLASSES_PROP = "gotoClassShowLibraryClasses";
    static final String[] JAVA_PROP_NAMES = OptionSupport.mergeStringArrays((String[])BaseOptions.BASE_PROP_NAMES, (String[])new String[]{"completionAutoPopup", "completionCaseSensitive", "completionAutoPopupDelay", "formatSpaceBeforeParenthesis", "formatCompoundBracketAddNL", "javaDocBGColor", "javaDocPreferredSize", "javaDocAutoPopup", "showDeprecatedMembers", "completionInstantSubstitution", "completionNaturalSort", "fastImportPackage", "gotoClassCaseSensitive", "gotoClassShowInnerClasses", "gotoClassShowLibraryClasses", "codeFoldingProps", "pairCharactersCompletion"});
    static final long serialVersionUID = -7951549840240159575L;

    public JavaOptions() {
        this(JavaKit.class, JAVA);
    }

    public JavaOptions(Class clazz, String string) {
        super(clazz, string);
    }

    public void setFormatSpaceBeforeParenthesis(boolean bl) {
        this.setSettingBoolean("java-format-space-before-parenthesis", bl, FORMAT_SPACE_BEFORE_PARENTHESIS_PROP);
    }

    public void setFormatCompoundBracketAddNL(boolean bl) {
        this.setSettingBoolean("java-format-newline-before-brace", bl, FORMAT_COMPOUND_BRACKET_ADD_NL_PROP);
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean bl) {
        this.setSettingBoolean("completion-auto-popup", bl, COMPLETION_AUTO_POPUP_PROP);
    }

    public boolean getCompletionCaseSensitive() {
        return this.getSettingBoolean("completion-case-sensitive");
    }

    public void setCompletionCaseSensitive(boolean bl) {
        this.setSettingBoolean("completion-case-sensitive", bl, COMPLETION_CASE_SENSITIVE_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean bl) {
        this.setSettingBoolean("completion-instant-substitution", bl, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", n, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public boolean getJavaDocAutoPopup() {
        return this.getSettingBoolean("javadoc-auto-popup");
    }

    public void setJavaDocAutoPopup(boolean bl) {
        this.setSettingBoolean("javadoc-auto-popup", bl, JAVADOC_AUTO_POPUP_PROP);
    }

    public Color getJavaDocBGColor() {
        return (Color)this.getSettingValue("javadoc-bg-color");
    }

    public void setJavaDocBGColor(Color color) {
        this.setSettingValue("javadoc-bg-color", color, JAVADOC_BGCOLOR);
    }

    public Dimension getJavaDocPreferredSize() {
        return (Dimension)this.getSettingValue("javadoc-preferred-size");
    }

    public void setJavaDocPreferredSize(Dimension dimension) {
        this.setSettingValue("javadoc-preferred-size", dimension, JAVADOC_PREFERRED_SIZE_PROP);
    }

    public boolean getShowDeprecatedMembers() {
        return this.getSettingBoolean("show-deprecated-members");
    }

    public void setShowDeprecatedMembers(boolean bl) {
        this.setSettingBoolean("show-deprecated-members", bl, SHOW_DEPRECATED_MEMBERS_PROP);
    }

    public boolean getCompletionNaturalSort() {
        return this.getSettingBoolean("completion-natural-sort");
    }

    public void setCompletionNaturalSort(boolean bl) {
        this.setSettingBoolean("completion-natural-sort", bl, COMPLETION_NATURAL_SORT_PROP);
    }

    public int getFastImportSelection() {
        return this.getSettingInteger("fast-import-selection");
    }

    public void setFastImportSelection(int n) {
        this.setSettingInteger("fast-import-selection", n, FAST_IMPORT_SELECTION_PROP);
    }

    public boolean getFastImportPackage() {
        return this.getFastImportSelection() == 1;
    }

    public void setFastImportPackage(boolean bl) {
        if (bl) {
            this.setFastImportSelection(1);
        }
    }

    public boolean getGotoClassCaseSensitive() {
        return this.getSettingBoolean("goto-class-case-sensitive");
    }

    public void setGotoClassCaseSensitive(boolean bl) {
        this.setSettingBoolean("goto-class-case-sensitive", bl, GOTO_CLASS_CASE_SENSITIVE_PROP);
    }

    public boolean getGotoClassShowInnerClasses() {
        return this.getSettingBoolean("goto-class-show-inner-classes");
    }

    public void setGotoClassShowInnerClasses(boolean bl) {
        this.setSettingBoolean("goto-class-show-inner-classes", bl, GOTO_CLASS_SHOW_INNER_CLASSES_PROP);
    }

    public boolean getGotoClassShowLibraryClasses() {
        return this.getSettingBoolean("goto-class-show-library-classes");
    }

    public void setGotoClassShowLibraryClasses(boolean bl) {
        this.setSettingBoolean("goto-class-show-library-classes", bl, GOTO_CLASS_SHOW_LIBRARY_CLASSES_PROP);
    }

    protected Class getDefaultIndentEngineClass() {
        return JavaIndentEngine.class;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public boolean getPairCharactersCompletion() {
        return this.getSettingBoolean("pair-characters-completion");
    }

    public void setPairCharactersCompletion(boolean bl) {
        this.setSettingBoolean("pair-characters-completion", bl, PAIR_CHARACTERS_COMPLETION);
    }

    public Map getCodeFoldingProps() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(super.getCodeFoldingProps());
        Boolean bl = (Boolean)this.getSettingValue("code-folding-collapse-method");
        hashMap.put("code-folding-collapse-method", bl);
        bl = (Boolean)this.getSettingValue("code-folding-collapse-innerclass");
        hashMap.put("code-folding-collapse-innerclass", bl);
        bl = (Boolean)this.getSettingValue("code-folding-collapse-import");
        hashMap.put("code-folding-collapse-import", bl);
        bl = (Boolean)this.getSettingValue("code-folding-collapse-javadoc");
        hashMap.put("code-folding-collapse-javadoc", bl);
        bl = (Boolean)this.getSettingValue("code-folding-collapse-initial-comment");
        hashMap.put("code-folding-collapse-initial-comment", bl);
        return hashMap;
    }

    public void setCodeFoldingProps(Map map) {
        String string = "code-folding-enable";
        this.setSettingValue(string, map.get(string));
        string = "code-folding-collapse-method";
        this.setSettingValue(string, map.get(string));
        string = "code-folding-collapse-innerclass";
        this.setSettingValue(string, map.get(string));
        string = "code-folding-collapse-import";
        this.setSettingValue(string, map.get(string));
        string = "code-folding-collapse-javadoc";
        this.setSettingValue(string, map.get(string));
        string = "code-folding-collapse-initial-comment";
        this.setSettingValue(string, map.get(string));
    }

    protected String getString(String string) {
        try {
            return NbBundle.getMessage((Class)JavaOptions.class, (String)string);
        }
        catch (MissingResourceException missingResourceException) {
            return super.getString(string);
        }
    }
}

