/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

final class DummyWindowManager
extends WindowManager {
    private static final long serialVersionUID = 1L;
    private static Action[] DEFAULT_ACTIONS_CLONEABLE;
    private static Action[] DEFAULT_ACTIONS_NOT_CLONEABLE;
    private final Map workspaces = new TreeMap();
    private transient Frame mw;
    private transient PropertyChangeSupport pcs;
    private transient R r;

    public DummyWindowManager() {
        this.createWorkspace("default", null);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected TopComponent.Registry componentRegistry() {
        TopComponent.Registry registry = super.componentRegistry();
        if (registry != null) {
            return registry;
        }
        return this.registry();
    }

    synchronized R registry() {
        if (this.r == null) {
            this.r = new R();
        }
        return this.r;
    }

    protected WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        return null;
    }

    public synchronized Workspace createWorkspace(String string, String string2) {
        W w = new W(string);
        this.workspaces.put(string, w);
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
        return w;
    }

    synchronized void delete(Workspace workspace) {
        this.workspaces.remove(workspace.getName());
        if (this.workspaces.isEmpty()) {
            this.createWorkspace("default", null);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Workspace findWorkspace(String string) {
        return (Workspace)this.workspaces.get(string);
    }

    public synchronized Workspace getCurrentWorkspace() {
        return (Workspace)this.workspaces.values().iterator().next();
    }

    public synchronized Workspace[] getWorkspaces() {
        return this.workspaces.values().toArray(new Workspace[0]);
    }

    public synchronized void setWorkspaces(Workspace[] workspaceArray) {
        if (workspaceArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.workspaces.clear();
        for (int i = 0; i < workspaceArray.length; ++i) {
            this.workspaces.put(workspaceArray[i].getName(), workspaceArray[i]);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Frame getMainWindow() {
        if (this.mw == null) {
            this.mw = new JFrame("dummy");
        }
        return this.mw;
    }

    public void updateUI() {
    }

    public Set getModes() {
        HashSet hashSet = new HashSet();
        Iterator iterator = new HashSet(this.workspaces.values()).iterator();
        while (iterator.hasNext()) {
            Workspace workspace = (Workspace)iterator.next();
            hashSet.addAll(workspace.getModes());
        }
        return hashSet;
    }

    public Mode findMode(TopComponent topComponent) {
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            Mode mode = (Mode)iterator.next();
            if (!Arrays.asList(mode.getTopComponents()).contains(topComponent)) continue;
            return mode;
        }
        return null;
    }

    public Mode findMode(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            Mode mode = (Mode)iterator.next();
            if (!string.equals(mode.getName())) continue;
            return mode;
        }
        return null;
    }

    public TopComponentGroup findTopComponentGroup(String string) {
        return null;
    }

    public TopComponent findTopComponent(String string) {
        return null;
    }

    protected String topComponentID(TopComponent topComponent, String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Action[] topComponentDefaultActions(TopComponent topComponent) {
        Class clazz = DummyWindowManager.class;
        synchronized (clazz) {
            if (topComponent instanceof TopComponent.Cloneable) {
                if (DEFAULT_ACTIONS_CLONEABLE == null) {
                    DEFAULT_ACTIONS_CLONEABLE = DummyWindowManager.loadActions(new String[]{"Save", "CloneView", null, "CloseView"});
                }
                return DEFAULT_ACTIONS_CLONEABLE;
            }
            if (DEFAULT_ACTIONS_NOT_CLONEABLE == null) {
                DEFAULT_ACTIONS_NOT_CLONEABLE = DummyWindowManager.loadActions(new String[]{"Save", null, "CloseView"});
            }
            return DEFAULT_ACTIONS_NOT_CLONEABLE;
        }
    }

    private static Action[] loadActions(String[] stringArray) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = DummyWindowManager.class.getClassLoader();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                arrayList.add(null);
                continue;
            }
            try {
                arrayList.add(SystemAction.get(Class.forName("org.openide.actions." + stringArray[i] + "Action")));
                continue;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return arrayList.toArray(new Action[0]);
    }

    protected boolean topComponentIsOpened(TopComponent topComponent) {
        return topComponent.isShowing();
    }

    protected void topComponentActivatedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        this.registry().setActivatedNodes(topComponent, nodeArray);
    }

    protected void topComponentIconChanged(TopComponent topComponent, Image image) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.setIconImage(image);
        }
    }

    protected void topComponentToolTipChanged(TopComponent topComponent, String string) {
    }

    protected void topComponentDisplayNameChanged(TopComponent topComponent, String string) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.setTitle(string);
        }
    }

    protected void topComponentHtmlDisplayNameChanged(TopComponent topComponent, String string) {
    }

    protected void topComponentOpen(TopComponent topComponent) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame == null) {
            jFrame = new JFrame(topComponent.getName());
            Image image = topComponent.getIcon();
            if (image != null) {
                jFrame.setIconImage(image);
            }
            jFrame.getContentPane().add(topComponent);
            jFrame.pack();
            final WeakReference<TopComponent> weakReference = new WeakReference<TopComponent>(topComponent);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TopComponent topComponent = (TopComponent)weakReference.get();
                    if (topComponent == null) {
                        return;
                    }
                    topComponent.close();
                }

                public void windowActivated(WindowEvent windowEvent) {
                    TopComponent topComponent = (TopComponent)weakReference.get();
                    if (topComponent == null) {
                        return;
                    }
                    topComponent.requestActive();
                }
            });
        }
        if (!topComponent.isShowing()) {
            this.componentOpenNotify(topComponent);
            this.componentShowing(topComponent);
            jFrame.setVisible(true);
            this.registry().open(topComponent);
        }
    }

    protected void topComponentClose(TopComponent topComponent) {
        this.componentHidden(topComponent);
        this.componentCloseNotify(topComponent);
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.setVisible(false);
            topComponent.getParent().remove(topComponent);
        }
        this.registry().close(topComponent);
        Iterator iterator = this.workspaces.values().iterator();
        while (iterator.hasNext()) {
            W w = (W)iterator.next();
            w.close(topComponent);
        }
    }

    protected void topComponentRequestVisible(TopComponent topComponent) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.setVisible(true);
        }
    }

    protected void topComponentRequestActive(TopComponent topComponent) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.toFront();
        }
        this.registry().setActive(topComponent);
        this.activateComponent(topComponent);
    }

    protected void topComponentRequestAttention(TopComponent topComponent) {
    }

    protected void topComponentCancelRequestAttention(TopComponent topComponent) {
    }

    private static final class R
    implements TopComponent.Registry {
        private TopComponent active;
        private final Set opened = new HashSet();
        private Node[] nodes = new Node[0];
        private PropertyChangeSupport pcs;

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        }

        synchronized void open(TopComponent topComponent) {
            this.opened.add(topComponent);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        synchronized void close(TopComponent topComponent) {
            this.opened.remove(topComponent);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
            if (this.active == topComponent) {
                this.setActive(null);
            }
        }

        public synchronized Set getOpened() {
            return new HashSet(this.opened);
        }

        synchronized void setActive(TopComponent topComponent) {
            Node[] nodeArray;
            this.active = topComponent;
            Node[] nodeArray2 = nodeArray = topComponent == null ? new Node[]{} : topComponent.getActivatedNodes();
            if (nodeArray != null) {
                this.nodes = nodeArray;
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("activatedNodes", null, null);
                }
            }
            if (this.pcs != null) {
                this.pcs.firePropertyChange("activated", null, null);
                this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        synchronized void setActivatedNodes(TopComponent topComponent, Node[] nodeArray) {
            if (topComponent == this.active) {
                if (nodeArray != null) {
                    this.nodes = nodeArray;
                    if (this.pcs != null) {
                        this.pcs.firePropertyChange("activatedNodes", null, null);
                    }
                }
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("currentNodes", null, null);
                }
            }
        }

        public TopComponent getActivated() {
            return this.active;
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public synchronized Node[] getCurrentNodes() {
            if (this.active != null) {
                return this.active.getActivatedNodes();
            }
            return null;
        }
    }

    private final class W
    implements Workspace {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map modes = new HashMap();
        private final Map modesByComponent = new WeakHashMap();
        private transient PropertyChangeSupport pcs;

        public W(String string) {
            this.name = string;
        }

        public void activate() {
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        }

        public void remove() {
            DummyWindowManager.this.delete(this);
        }

        public synchronized Mode createMode(String string, String string2, URL uRL) {
            M m = new M(string);
            this.modes.put(string, m);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("modes", null, null);
            }
            return m;
        }

        public synchronized Set getModes() {
            return new HashSet(this.modes.values());
        }

        public synchronized Mode findMode(String string) {
            return (Mode)this.modes.get(string);
        }

        public synchronized Mode findMode(TopComponent topComponent) {
            return (Mode)this.modesByComponent.get(topComponent);
        }

        synchronized void dock(Mode mode, TopComponent topComponent) {
            this.modesByComponent.put(topComponent, mode);
        }

        public Rectangle getBounds() {
            return Utilities.getUsableScreenBounds();
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void close(TopComponent topComponent) {
            Iterator iterator = this.modes.values().iterator();
            while (iterator.hasNext()) {
                M m = (M)iterator.next();
                m.close(topComponent);
            }
        }

        private final class M
        implements Mode {
            private static final long serialVersionUID = 1L;
            private final String name;
            private final Set components = new HashSet();

            public M(String string) {
                this.name = string;
            }

            public void close(TopComponent topComponent) {
                this.components.remove(topComponent);
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            public boolean canDock(TopComponent topComponent) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean dockInto(TopComponent topComponent) {
                if (this.components.add(topComponent)) {
                    Mode mode = W.this.findMode(topComponent);
                    if (mode != null && mode != this && mode instanceof M) {
                        Mode mode2 = mode;
                        synchronized (mode2) {
                            ((M)mode).components.remove(topComponent);
                        }
                    }
                    W.this.dock(this, topComponent);
                }
                return true;
            }

            public String getName() {
                return this.name;
            }

            public String getDisplayName() {
                return this.getName();
            }

            public Image getIcon() {
                return null;
            }

            public synchronized TopComponent[] getTopComponents() {
                return this.components.toArray(new TopComponent[0]);
            }

            public Workspace getWorkspace() {
                return W.this;
            }

            public synchronized Rectangle getBounds() {
                return W.this.getBounds();
            }

            public void setBounds(Rectangle rectangle) {
            }

            public TopComponent getSelectedTopComponent() {
                TopComponent[] topComponentArray = this.components.toArray(new TopComponent[0]);
                return topComponentArray.length > 0 ? topComponentArray[0] : null;
            }
        }
    }
}

