/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.bookmarks.api;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.lib.editor.bookmarks.BookmarksApiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.BookmarksSpiPackageAccessor;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkImplementation;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManager;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManagerFactory;
import org.netbeans.lib.editor.bookmarks.spi.BookmarkManagerSupport;
import org.openide.util.Lookup;

public final class BookmarkList {
    private static BookmarkManagerFactory bookmarkManagerFactory;
    private Document doc;
    private BookmarkManager manager;
    private BookmarkManagerSupport managerSupport;
    private List bookmarks;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized BookmarkList get(Document document) {
        BookmarkList bookmarkList = (BookmarkList)document.getProperty(BookmarkList.class);
        if (bookmarkList == null) {
            BookmarkManager bookmarkManager = BookmarkList.getBookmarkManagerFactory().createBookmarkManager(document);
            bookmarkList = new BookmarkList(document, bookmarkManager);
            document.putProperty(BookmarkList.class, bookmarkList);
        }
        return bookmarkList;
    }

    private static BookmarkManagerFactory getBookmarkManagerFactory() {
        if (bookmarkManagerFactory == null) {
            bookmarkManagerFactory = (BookmarkManagerFactory)Lookup.getDefault().lookup(BookmarkManagerFactory.class);
            if (!$assertionsDisabled && bookmarkManagerFactory == null) {
                throw new AssertionError((Object)"No BookmarkManagerFactory available");
            }
        }
        return bookmarkManagerFactory;
    }

    private BookmarkList(Document document, BookmarkManager bookmarkManager) {
        if (document == null) {
            throw new NullPointerException("Document cannot be null");
        }
        this.doc = document;
        this.bookmarks = new ArrayList();
        this.manager = bookmarkManager;
        this.managerSupport = BookmarksSpiPackageAccessor.get().createBookmarkManagerSupport(this);
        this.manager.init(this.managerSupport);
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getBookmarkCount() {
        return this.bookmarks.size();
    }

    public Bookmark getBookmark(int n) {
        return (Bookmark)this.bookmarks.get(n);
    }

    public Bookmark getNextBookmark(int n, boolean bl) {
        this.checkOffsetNonNegative(++n);
        int n2 = this.getBookmarkIndex(n);
        return n2 < this.getBookmarkCount() ? this.getBookmark(n2) : (bl ? this.getNextBookmark(-1, false) : null);
    }

    public Bookmark getPreviousBookmark(int n, boolean bl) {
        Bookmark bookmark;
        this.checkOffsetNonNegative(n);
        int n2 = this.getBookmarkCount();
        if (n2 > 0) {
            int n3;
            if ((n3 = this.getBookmarkIndex(--n)) == n2 || (bookmark = this.getBookmark(n3)).getOffset() != n) {
                bookmark = --n3 >= 0 ? this.getBookmark(n3) : (bl ? this.getPreviousBookmark(Integer.MAX_VALUE, false) : null);
            }
        } else {
            bookmark = null;
        }
        return bookmark;
    }

    public int getBookmarkIndex(int n) {
        int n2 = 0;
        int n3 = this.getBookmarkCount() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.getBookmark(n4).getOffset();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            --n4;
            while (n4 >= 0 && this.getBookmark(n4).getOffset() == n) {
                --n4;
            }
            return ++n4;
        }
        return n2;
    }

    public Bookmark toggleLineBookmark(int n) {
        this.checkOffsetInDocument(n);
        Element element = this.doc.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Bookmark bookmark = null;
        if (n2 < element.getElementCount()) {
            Element element2 = element.getElement(n2);
            int n3 = element2.getStartOffset();
            int n4 = this.getBookmarkIndex(n3);
            bookmark = n4 < this.getBookmarkCount() && this.getBookmark(n4).getOffset() < element2.getEndOffset() ? this.removeBookmarkAtIndex(n4) : this.addBookmark(this.manager.createBookmarkImplementation(n3));
            this.manager.saveBookmarks();
        }
        return bookmark;
    }

    public Bookmark removeBookmarkAtIndex(int n) {
        Bookmark bookmark = (Bookmark)this.bookmarks.remove(n);
        bookmark.release();
        return bookmark;
    }

    public void removeAllBookmarks() {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(i);
            bookmark.release();
        }
        this.bookmarks.clear();
    }

    BookmarkManager getManager() {
        return this.manager;
    }

    Bookmark addBookmark(BookmarkImplementation bookmarkImplementation) {
        Bookmark bookmark = new Bookmark(this, bookmarkImplementation);
        int n = this.getBookmarkIndex(bookmarkImplementation.getOffset() + 1);
        this.bookmarks.add(n, bookmark);
        return bookmark;
    }

    private void checkOffsetNonNegative(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("offset=" + n + " < 0");
        }
    }

    private void checkOffsetInDocument(int n) {
        this.checkOffsetNonNegative(n);
        int n2 = this.doc.getLength();
        if (n > n2) {
            throw new IndexOutOfBoundsException("offset=" + n + " > doc.getLength()=" + n2);
        }
    }

    public String toString() {
        return "Bookmarks: " + this.bookmarks;
    }

    static {
        $assertionsDisabled = !BookmarkList.class.desiredAssertionStatus();
        BookmarksApiPackageAccessor.register(new ApiAccessor());
        BookmarkManagerSupport.initPackageAccess();
    }

    private static final class ApiAccessor
    extends BookmarksApiPackageAccessor {
        private ApiAccessor() {
        }

        public BookmarkManager getBookmarkManager(BookmarkList bookmarkList) {
            return bookmarkList.getManager();
        }

        public BookmarkImplementation getBookmarkImplementation(Bookmark bookmark) {
            return bookmark.getImplementation();
        }

        public Bookmark addBookmark(BookmarkList bookmarkList, BookmarkImplementation bookmarkImplementation) {
            return bookmarkList.addBookmark(bookmarkImplementation);
        }
    }
}

