/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.editor.bookmarks.api.Bookmark;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarksXMLHandler;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.FileBookmarksMap;
import org.netbeans.modules.editor.bookmarks.NbBookmarkManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.w3c.dom.Element;

class PersistentBookmarks {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Map project2bookmarksMap = new WeakHashMap();

    PersistentBookmarks() {
    }

    static synchronized void loadBookmarks(NbBookmarkManager nbBookmarkManager) {
        FileBookmarksMap fileBookmarksMap;
        Document document = nbBookmarkManager.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null && (fileBookmarksMap = PersistentBookmarks.findOwningBookmarksMap(fileObject)) != null) {
            FileBookmarks fileBookmarks;
            URL uRL;
            try {
                uRL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                uRL = null;
            }
            if (uRL != null && (fileBookmarks = fileBookmarksMap.get(uRL)) != null) {
                int n = fileBookmarks.getBookmarkCount();
                for (int i = 0; i < n; ++i) {
                    int n2 = fileBookmarks.getBookmarkLineIndex(i);
                    nbBookmarkManager.addLoadedBookmark(n2);
                }
            }
        }
    }

    static synchronized void saveBookmarks(NbBookmarkManager nbBookmarkManager) {
        Document document = nbBookmarkManager.getDocument();
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null) {
            URL uRL;
            int[] nArray = PersistentBookmarks.getLineIndexes(document);
            try {
                uRL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                uRL = null;
            }
            if (uRL != null) {
                FileBookmarks fileBookmarks = new FileBookmarks(uRL, nArray);
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                FileBookmarksMap fileBookmarksMap = PersistentBookmarks.findBookmarksMap(project);
                if (fileBookmarksMap != null) {
                    fileBookmarksMap.put(fileBookmarks);
                }
            }
        }
    }

    static synchronized void saveAllProjectBookmarks() {
        ArrayList arrayList = new ArrayList(project2bookmarksMap.keySet());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PersistentBookmarks.saveProjectBookmarks((Project)iterator.next());
        }
    }

    static void saveProjectBookmarks(Project project) {
        if (!ProjectManager.getDefault().isValid(project)) {
            return;
        }
        FileBookmarksMap fileBookmarksMap = PersistentBookmarks.findBookmarksMap(project);
        if (fileBookmarksMap != null && fileBookmarksMap.isModified()) {
            PersistentBookmarks.saveBookmarksMap(project, fileBookmarksMap);
        }
    }

    private static int[] getLineIndexes(Document document) {
        BookmarkList bookmarkList = BookmarkList.get(document);
        int n = bookmarkList.getBookmarkCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Bookmark bookmark = bookmarkList.getBookmark(i);
            nArray[i] = bookmark.getLineIndex();
        }
        return nArray;
    }

    private static FileBookmarksMap findOwningBookmarksMap(FileObject fileObject) {
        return PersistentBookmarks.findBookmarksMap(FileOwnerQuery.getOwner((FileObject)fileObject));
    }

    private static FileBookmarksMap findBookmarksMap(Project project) {
        FileBookmarksMap fileBookmarksMap = null;
        if (project != null && (fileBookmarksMap = (FileBookmarksMap)project2bookmarksMap.get(project)) == null && (fileBookmarksMap = PersistentBookmarks.loadBookmarksMap(project)) != null) {
            project2bookmarksMap.put(project, fileBookmarksMap);
        }
        return fileBookmarksMap;
    }

    private static FileBookmarksMap loadBookmarksMap(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        FileBookmarksMap fileBookmarksMap = new FileBookmarksMap();
        if (auxiliaryConfiguration != null) {
            URL uRL;
            Element element = auxiliaryConfiguration.getConfigurationFragment("editor-bookmarks", "http://www.netbeans.org/ns/editor-bookmarks/1", false);
            try {
                uRL = project.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                uRL = null;
            }
            if (element != null) {
                BookmarksXMLHandler.loadFileBookmarksMap(fileBookmarksMap, element, uRL);
            }
        }
        return fileBookmarksMap;
    }

    private static void saveBookmarksMap(Project project, FileBookmarksMap fileBookmarksMap) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (auxiliaryConfiguration != null) {
            URI uRI;
            try {
                uRI = new URI(project.getProjectDirectory().getURL().toExternalForm());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                uRI = null;
            }
            catch (URISyntaxException uRISyntaxException) {
                uRI = null;
            }
            Element element = BookmarksXMLHandler.saveFileBookmarksMap(fileBookmarksMap, uRI);
            auxiliaryConfiguration.putConfigurationFragment(element, false);
        }
    }
}

