/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class AbstractUtil {
    private String packageName;
    private boolean loggable;
    private boolean loggableInit = false;
    private ResourceBundle bundle;

    public static boolean equals(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        return object == object2;
    }

    public final void debug(String string, Throwable throwable) {
        if (this.isLoggable()) {
            System.err.println("[" + this.getPackageName() + "] " + string);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }
    }

    public final void debug(String string) {
        this.debug(string, null);
    }

    public final void debug(Throwable throwable) {
        this.debug(throwable.getMessage(), throwable);
    }

    public final synchronized boolean isLoggable() {
        if (!this.loggableInit) {
            this.loggable = Boolean.getBoolean(this.getPackageName());
            this.loggableInit = true;
        }
        return this.loggable;
    }

    private final synchronized String getPackageName() {
        if (this.packageName == null) {
            this.packageName = this.getClass().getPackage().getName().intern();
        }
        return this.packageName;
    }

    protected final synchronized ResourceBundle getBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        String string = this.getPackageName() + ".Bundle";
        this.bundle = ResourceBundle.getBundle(string);
        return this.bundle;
    }

    public final String getString(String string) {
        return this.getBundle().getString(string);
    }

    public final String getString(String string, Object object) {
        return MessageFormat.format(this.getBundle().getString(string), object);
    }

    public final char getChar(String string) {
        return this.getString(string).charAt(0);
    }
}

