/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeCharacterReference;
import org.netbeans.tax.TreeData;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeGeneralEntityReference;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNamespace;
import org.netbeans.tax.TreeNamespaceContext;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.Element;

public class TreeAttribute
extends TreeNode
implements Element.Attribute,
TreeNamedObjectMap.NamedObject {
    public static final String PROP_NAME = "name";
    public static final String PROP_VALUE = "value";
    public static final String PROP_OWNER_ELEMENT = "ownerElement";
    public static final String PROP_SPECIFIED = "specified";
    private TreeElement ownerElement;
    private TreeName name;
    private TreeObjectList valueList;
    private boolean specified;
    private TreeNamedObjectMap.KeyListener mapKeyListener;
    static /* synthetic */ Class class$org$netbeans$tax$spec$Attribute$Value;

    public TreeAttribute(String string, String string2, boolean bl) throws InvalidArgumentException {
        TreeName treeName = new TreeName(string);
        this.checkName(treeName);
        this.checkValue(string2);
        this.name = treeName;
        this.specified = bl;
        this.valueList = new TreeObjectList(this.createValueListContentManager());
        this.setValueImpl(string2);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttribute::INIT : name = " + string + " : specified = " + bl);
        }
    }

    public TreeAttribute(String string, String string2) throws InvalidArgumentException {
        this(string, string2, true);
    }

    protected TreeAttribute(TreeAttribute treeAttribute) {
        super(treeAttribute);
        this.name = treeAttribute.name;
        this.specified = true;
        this.valueList = new TreeObjectList(this.createValueListContentManager());
        this.valueList.addAll((Collection)((TreeObjectList)treeAttribute.valueList.clone()));
    }

    public Object clone() {
        return new TreeAttribute(this);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeAttribute treeAttribute = (TreeAttribute)object;
        if (!Util.equals(this.getTreeName(), treeAttribute.getTreeName())) {
            return false;
        }
        if (this.specified != treeAttribute.isSpecified()) {
            return false;
        }
        return Util.equals(this.valueList, treeAttribute.valueList);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeAttribute treeAttribute = (TreeAttribute)treeObject;
        try {
            this.setTreeNameImpl(treeAttribute.getTreeName());
            this.setSpecifiedImpl(treeAttribute.isSpecified());
            this.valueList.merge(treeAttribute.valueList);
        }
        catch (Exception exception) {
            throw new CannotMergeException(treeObject, exception);
        }
    }

    protected void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        this.valueList.setReadOnly(bl);
    }

    public final boolean isInContext() {
        return this.getOwnerElement() != null;
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.getOwnerElement().removeAttribute(this);
        }
    }

    public final String getQName() {
        return this.name.getQualifiedName();
    }

    public final void setQName(String string) throws ReadOnlyException, InvalidArgumentException {
        this.setTreeName(new TreeName(string));
    }

    public final TreeName getTreeName() {
        return this.name;
    }

    private final void setTreeNameImpl(TreeName treeName) {
        TreeName treeName2 = this.name;
        this.name = treeName;
        this.fireMapKeyChanged(treeName2);
        this.firePropertyChange(PROP_NAME, treeName2, treeName);
    }

    public final void setTreeName(TreeName treeName) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.name, treeName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(treeName);
        this.setTreeNameImpl(treeName);
    }

    protected final void checkName(TreeName treeName) throws InvalidArgumentException {
        TreeUtilities.checkAttributeName(treeName);
    }

    public boolean isSpecified() {
        return this.specified;
    }

    private void setSpecifiedImpl(boolean bl) {
        if (this.specified == bl) {
            return;
        }
        Boolean bl2 = this.specified ? Boolean.TRUE : Boolean.FALSE;
        this.specified = bl;
        this.firePropertyChange(PROP_SPECIFIED, bl2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public final TreeObjectList getValueList() {
        return this.valueList;
    }

    public final String getValue() {
        StringBuffer stringBuffer = new StringBuffer(23);
        Iterator iterator = this.valueList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TreeData) {
                stringBuffer.append(((TreeData)e).getData());
                continue;
            }
            if (e instanceof TreeGeneralEntityReference) {
                stringBuffer.append("&" + ((TreeGeneralEntityReference)e).getName() + ";");
                continue;
            }
            if (!(e instanceof TreeCharacterReference)) continue;
            stringBuffer.append(((TreeCharacterReference)e).getData());
        }
        return stringBuffer.toString();
    }

    public final String getNonNormalizedValue() {
        StringBuffer stringBuffer = new StringBuffer(23);
        Iterator iterator = this.valueList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TreeData) {
                stringBuffer.append(((TreeData)e).getData());
                continue;
            }
            if (e instanceof TreeGeneralEntityReference) {
                stringBuffer.append("&" + ((TreeGeneralEntityReference)e).getName() + ";");
                continue;
            }
            if (!(e instanceof TreeCharacterReference)) continue;
            stringBuffer.append("&" + ((TreeCharacterReference)e).getName() + ";");
        }
        return stringBuffer.toString();
    }

    private final void setValueImpl(String string) {
        String string2 = this.getValue();
        this.valueList.clear();
        if (string.length() != 0) {
            try {
                TreeText treeText = new TreeText(string);
                this.valueList.add(treeText);
            }
            catch (TreeException treeException) {
                // empty catch block
            }
        }
        this.firePropertyChange(PROP_VALUE, string2, string);
    }

    public final void setValue(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.getValue(), string)) {
            return;
        }
        this.checkReadOnly();
        this.checkValue(string);
        this.setValueImpl(string);
    }

    protected final void checkValue(String string) throws InvalidArgumentException {
        TreeUtilities.checkAttributeValue(string);
    }

    public final TreeNamespace getNamespace() {
        if (this.getOwnerElement() != null) {
            String string;
            TreeElement treeElement = this.getOwnerElement();
            TreeNamespaceContext treeNamespaceContext = treeElement.getNamespaceContext();
            String string2 = treeNamespaceContext.getURI(string = this.getNamespacePrefix());
            if (string2 == null) {
                return TreeNamespace.NO_NAMESPACE;
            }
            return new TreeNamespace(string, string2);
        }
        return TreeNamespace.NO_NAMESPACE;
    }

    public final String getNamespacePrefix() {
        return this.name.getPrefix();
    }

    public final String getNamespaceURI() {
        return this.getNamespace().getURI();
    }

    public final String getLocalName() {
        return this.name.getName();
    }

    public Object mapKey() {
        return this.getTreeName();
    }

    public void setKeyListener(TreeNamedObjectMap.KeyListener keyListener) {
        this.mapKeyListener = keyListener;
    }

    private void fireMapKeyChanged(Object object) {
        if (this.mapKeyListener == null) {
            return;
        }
        this.mapKeyListener.mapKeyChanged(object);
    }

    public final TreeDocumentRoot getOwnerDocument() {
        if (this.getOwnerElement() == null) {
            return null;
        }
        return this.getOwnerElement().getOwnerDocument();
    }

    public final TreeElement getOwnerElement() {
        return this.ownerElement;
    }

    protected final void setOwnerElement(TreeElement treeElement) {
        if (Util.equals(this.ownerElement, treeElement)) {
            return;
        }
        TreeElement treeElement2 = this.ownerElement;
        this.ownerElement = treeElement;
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_OWNER_ELEMENT, treeElement2, treeElement));
    }

    protected TreeObjectList.ContentManager createValueListContentManager() {
        return new ValueListContentManager();
    }

    protected class ValueListContentManager
    extends TreeObjectList.ContentManager {
        protected ValueListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeAttribute.this;
        }

        public void checkAssignableObject(Object object) {
            super.checkAssignableObject(object);
            this.checkAssignableClass(class$org$netbeans$tax$spec$Attribute$Value == null ? (class$org$netbeans$tax$spec$Attribute$Value = TreeAttribute.class$("org.netbeans.tax.spec.Attribute$Value")) : class$org$netbeans$tax$spec$Attribute$Value, object);
        }

        public void objectInserted(TreeObject treeObject) {
            TreeAttribute.this.firePropertyChange(TreeAttribute.PROP_VALUE, TreeAttribute.this.valueList, treeObject);
        }

        public void objectRemoved(TreeObject treeObject) {
            TreeAttribute.this.firePropertyChange(TreeAttribute.PROP_VALUE, TreeAttribute.this.valueList, treeObject);
        }

        public void orderChanged(int[] nArray) {
            TreeAttribute.this.firePropertyChange(TreeAttribute.PROP_VALUE, TreeAttribute.this.valueList, nArray);
        }
    }
}

