/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.Util;

public abstract class TreeData
extends TreeChild {
    public static final String PROP_DATA = "data";
    private String data;

    protected TreeData(String string) throws InvalidArgumentException {
        this.checkData(string);
        this.data = string;
    }

    protected TreeData(TreeData treeData) {
        super(treeData);
        this.data = treeData.data;
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeData treeData = (TreeData)object;
        return Util.equals(this.getData(), treeData.getData());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeData treeData = (TreeData)treeObject;
        try {
            this.setDataImpl(treeData.getData());
        }
        catch (Exception exception) {
            throw new CannotMergeException(treeObject, exception);
        }
    }

    public final String getData() {
        return this.data;
    }

    private final void setDataImpl(String string) {
        String string2 = this.data;
        this.data = string;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeData::setDataImpl: firing data change " + string2 + " => " + string);
        }
        this.firePropertyChange(PROP_DATA, string2, string);
    }

    public final void setData(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.data, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkData(string);
        this.setDataImpl(string);
    }

    protected abstract void checkData(String var1) throws InvalidArgumentException;

    public final int getLength() {
        return this.data.length();
    }

    public final String substringData(int n, int n2) throws InvalidArgumentException {
        try {
            return this.data.substring(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidArgumentException(indexOutOfBoundsException);
        }
    }

    public final void appendData(String string) throws ReadOnlyException, InvalidArgumentException {
        this.setData(this.data + string);
    }

    public final void insertData(int n, String string) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        try {
            String string2 = this.data.substring(0, n);
            String string3 = this.data.substring(n, this.data.length());
            this.setData(string2 + string + string3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidArgumentException(indexOutOfBoundsException);
        }
    }

    public final void deleteData(int n, int n2) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        try {
            String string = this.data.substring(0, n);
            String string2 = this.data.substring(n + n2, this.data.length());
            this.setData(string + string2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidArgumentException(indexOutOfBoundsException);
        }
    }

    public final void replaceData(int n, int n2, String string) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        try {
            String string2 = this.data.substring(0, n);
            String string3 = this.data.substring(n + n2, this.data.length());
            this.setData(string2 + string + string3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidArgumentException(indexOutOfBoundsException);
        }
    }

    public final TreeData splitData(int n) throws ReadOnlyException, InvalidArgumentException {
        TreeData treeData;
        this.checkReadOnly();
        try {
            String string = this.data.substring(0, n);
            String string2 = this.data.substring(n, this.data.length());
            treeData = this.createData(string);
            this.setData(string2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidArgumentException(indexOutOfBoundsException);
        }
        return treeData;
    }

    protected abstract TreeData createData(String var1) throws InvalidArgumentException;

    public final boolean onlyWhiteSpaces() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeData::onlyWhiteSpaces: data = '" + this.data + "'");
        }
        String string = this.data.trim();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("        ::onlyWhiteSpaces: trimed = '" + string + "'");
        }
        return string.length() == 0;
    }
}

