/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayOutputStream;
import org.openide.ErrorManager;

public class FileLock {
    public static final FileLock NONE;
    private boolean locked = true;
    private Throwable lockedBy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileLock() {
        if (!$assertionsDisabled && (this.lockedBy = new Throwable()) == null) {
            throw new AssertionError();
        }
    }

    public void releaseLock() {
        this.locked = false;
    }

    public boolean isValid() {
        return this.locked;
    }

    public void finalize() {
        if (!$assertionsDisabled && this.isValid()) {
            throw new AssertionError((Object)this.assertMessageForInvalidLocks());
        }
        this.releaseLock();
    }

    private String assertMessageForInvalidLocks() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.lockedBy != null) {
            ErrorManager.getDefault().notify(1, new Exception("Not released lock for file: " + this.toString() + " (traped in finalizer)").initCause(this.lockedBy));
        }
        this.releaseLock();
        return byteArrayOutputStream.toString();
    }

    static {
        $assertionsDisabled = !FileLock.class.desiredAssertionStatus();
        NONE = new FileLock(){

            public boolean isValid() {
                return false;
            }
        };
    }
}

