/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

public abstract class FileObject
implements Serializable {
    static final long serialVersionUID = 85305031923497718L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract String getName();

    public abstract String getExt();

    public abstract void rename(FileLock var1, String var2, String var3) throws IOException;

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        if (this.isFolder()) {
            throw new IOException(NbBundle.getBundle((Class)FileObject.class).getString("EXC_FolderCopy"));
        }
        FileObject fileObject2 = FileUtil.copyFileImpl(this, fileObject, string, string2);
        return fileObject2;
    }

    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        if (this.getParent().equals(fileObject)) {
            this.rename(fileLock, string, string2);
            return this;
        }
        FileObject fileObject2 = this.copy(fileObject, string, string2);
        this.delete(fileLock);
        return fileObject2;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return string2 + '@' + Integer.toHexString(System.identityHashCode(this)) + '[' + this.getPath() + ']';
    }

    public String getPath() {
        StringBuffer stringBuffer = new StringBuffer();
        this.constructName(stringBuffer, '/');
        return stringBuffer.toString();
    }

    public String getPackageNameExt(char c, char c2) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.getNameExt();
        }
        this.getParent().constructName(stringBuffer, c);
        String string = this.getExt();
        if (string == null || string.equals("")) {
            stringBuffer.append(c).append(this.getNameExt());
        } else {
            stringBuffer.append(c).append(this.getName()).append(c2).append(this.getExt());
        }
        return stringBuffer.toString();
    }

    public String getPackageName(char c) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isRoot() || this.getParent().isRoot()) {
            return this.isFolder() ? this.getNameExt() : this.getName();
        }
        this.getParent().constructName(stringBuffer, c);
        stringBuffer.append(c).append(this.getName());
        return stringBuffer.toString();
    }

    public String getNameExt() {
        String string = this.getName();
        String string2 = this.getExt();
        return string2 == null || string2.length() == 0 ? string : string + '.' + string2;
    }

    private void constructName(StringBuffer stringBuffer, char c) {
        FileObject fileObject = this.getParent();
        if (fileObject != null && !fileObject.isRoot()) {
            fileObject.constructName(stringBuffer, c);
            stringBuffer.append(c);
        }
        stringBuffer.append(this.getNameExt());
    }

    public abstract FileSystem getFileSystem() throws FileStateInvalidException;

    public abstract FileObject getParent();

    public abstract boolean isFolder();

    public abstract Date lastModified();

    public abstract boolean isRoot();

    public abstract boolean isData();

    public abstract boolean isValid();

    public boolean existsExt(String string) {
        FileObject fileObject = this.getParent();
        return fileObject != null && fileObject.getFileObject(this.getName(), string) != null;
    }

    public abstract void delete(FileLock var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        FileLock fileLock = this.lock();
        try {
            this.delete(fileLock);
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IOException;

    public abstract Enumeration getAttributes();

    public final boolean hasExt(String string) {
        if (this.isHasExtOverride()) {
            return this.hasExtOverride(string);
        }
        return this.getExt().equals(string);
    }

    boolean isHasExtOverride() {
        return false;
    }

    boolean hasExtOverride(String string) {
        return false;
    }

    public abstract void addFileChangeListener(FileChangeListener var1);

    public abstract void removeFileChangeListener(FileChangeListener var1);

    protected void fireFileDataCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(0, enumeration, fileEvent);
    }

    protected void fireFileFolderCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(1, enumeration, fileEvent);
    }

    protected void fireFileChangedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(2, enumeration, fileEvent);
    }

    protected void fireFileDeletedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(3, enumeration, fileEvent);
    }

    protected void fireFileAttributeChangedEvent(Enumeration enumeration, FileAttributeEvent fileAttributeEvent) {
        this.dispatchEvent(5, enumeration, fileAttributeEvent);
    }

    protected void fireFileRenamedEvent(Enumeration enumeration, FileRenameEvent fileRenameEvent) {
        this.dispatchEvent(4, enumeration, fileRenameEvent);
    }

    private final void dispatchEvent(int n, Enumeration enumeration, FileEvent fileEvent) {
        try {
            FileSystem fileSystem = this.getFileSystem();
            fileSystem.dispatchEvent(new ED(n, enumeration, fileEvent));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    final void dispatchEvent(Enumeration enumeration, FileEvent fileEvent) {
        try {
            this.getFileSystem().dispatchEvent(new ED(enumeration, fileEvent));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getMIMEType() {
        return FileUtil.getMIMETypeOrDefault(this);
    }

    public abstract long getSize();

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public abstract OutputStream getOutputStream(FileLock var1) throws IOException;

    public abstract FileLock lock() throws IOException;

    public abstract void setImportant(boolean var1);

    public abstract FileObject[] getChildren();

    public Enumeration getChildren(boolean bl) {
        class WithChildren
        implements Enumerations.Processor {
            private final /* synthetic */ boolean val$rec;

            WithChildren(boolean bl) {
                this.val$rec = bl;
            }

            public Object process(Object object, Collection collection) {
                FileObject fileObject = (FileObject)object;
                if (this.val$rec && fileObject.isFolder()) {
                    collection.addAll(Arrays.asList(fileObject.getChildren()));
                }
                return fileObject;
            }
        }
        return Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new WithChildren(bl));
    }

    public Enumeration getFolders(boolean bl) {
        return Enumerations.filter((Enumeration)this.getChildren(bl), (Enumerations.Processor)new OnlyFolders(true));
    }

    public Enumeration getData(boolean bl) {
        return Enumerations.filter((Enumeration)this.getChildren(bl), (Enumerations.Processor)new OnlyFolders(false));
    }

    public abstract FileObject getFileObject(String var1, String var2);

    public FileObject getFileObject(String string) {
        String string2;
        FileObject fileObject;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (fileObject = this; fileObject != null && stringTokenizer.hasMoreTokens(); fileObject = fileObject.getFileObject(string2, null)) {
            string2 = stringTokenizer.nextToken();
        }
        return fileObject;
    }

    public abstract FileObject createFolder(String var1) throws IOException;

    public abstract FileObject createData(String var1, String var2) throws IOException;

    public FileObject createData(String string) throws IOException {
        return this.createData(string, "");
    }

    public abstract boolean isReadOnly();

    public boolean canWrite() {
        File file = FileUtil.toFile(this);
        if (file != null) {
            return file.canWrite();
        }
        return !this.isReadOnly();
    }

    public boolean canRead() {
        File file = FileUtil.toFile(this);
        if (file != null) {
            return file.canRead();
        }
        return true;
    }

    public void refresh(boolean bl) {
    }

    public void refresh() {
        this.refresh(false);
    }

    public final URL getURL() throws FileStateInvalidException {
        return URLMapper.findURL(this, 0);
    }

    public boolean isVirtual() {
        return false;
    }

    static boolean isPriorityListener(FileChangeListener fileChangeListener) {
        return fileChangeListener instanceof MultiFileObject.MfoWeakListener;
    }

    static {
        $assertionsDisabled = !FileObject.class.desiredAssertionStatus();
    }

    private static final class OnlyFolders
    implements Enumerations.Processor {
        private boolean folders;

        public OnlyFolders(boolean bl) {
            this.folders = bl;
        }

        public Object process(Object object, Collection collection) {
            FileObject fileObject = (FileObject)object;
            if (this.folders) {
                return fileObject.isFolder() ? fileObject : null;
            }
            return fileObject.isData() ? fileObject : null;
        }
    }

    private class ED
    extends FileSystem.EventDispatcher {
        private int op;
        private Enumeration en;
        private FileEvent fe;

        public ED(int n, Enumeration enumeration, FileEvent fileEvent) {
            this.op = n;
            this.en = enumeration;
            this.fe = fileEvent;
        }

        public ED(Enumeration enumeration, FileEvent fileEvent) {
            this.op = -1;
            this.en = enumeration;
            this.fe = fileEvent;
        }

        protected void dispatch(boolean bl) {
            Object object;
            if (this.op == -1) {
                this.op = this.fe.getFile().isFolder() ? 1 : 0;
            }
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (this.en.hasMoreElements()) {
                object = (FileChangeListener)this.en.nextElement();
                if (bl && !FileObject.isPriorityListener((FileChangeListener)object)) {
                    linkedList.add(object);
                    continue;
                }
                FCLSupport.dispatchEvent((FileChangeListener)object, this.fe, this.op);
            }
            if (bl) {
                this.en = Collections.enumeration(linkedList);
            }
            object = this.fe.getFile();
            boolean bl2 = false;
            if (object != null) {
                switch (this.op) {
                    case 2: {
                        bl2 = object.equals(this.fe.getSource());
                        break;
                    }
                    default: {
                        boolean bl3 = bl2 = !object.equals(this.fe.getSource());
                    }
                }
            }
            if (!this.en.hasMoreElements() && bl2 && !bl) {
                FileSystem fileSystem = null;
                Repository repository = null;
                try {
                    fileSystem = this.fe.getFile().getFileSystem();
                    repository = fileSystem.getRepository();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return;
                }
                fileSystem.getFCLSupport().dispatchEvent(this.fe, this.op);
                if (repository != null) {
                    repository.getFCLSupport().dispatchEvent(this.fe, this.op);
                }
            }
        }

        protected void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
            this.fe.setAtomicActionLink(atomicActionLink);
        }
    }
}

