/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

public class GlobalVisibilityQueryImpl
implements VisibilityQueryImplementation {
    static GlobalVisibilityQueryImpl INSTANCE;
    private SystemOption ideSettings;
    private final List listeners = new ArrayList();
    private static final String PROP_IGNORED_FILES = "IgnoredFiles";
    private static Method mIgnoredFiles;
    private Pattern ignoreFilesPattern = null;

    public GlobalVisibilityQueryImpl() {
        INSTANCE = this;
    }

    public boolean isVisible(FileObject fileObject) {
        return this.isVisible(fileObject.getNameExt());
    }

    boolean isVisible(String string) {
        Pattern pattern = this.getIgnoreFilesPattern();
        return pattern != null ? !pattern.matcher(string).find() : true;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    private Pattern getIgnoreFilesPattern() {
        if (this.ignoreFilesPattern == null) {
            String string = this.getIgnoredFiles();
            this.ignoreFilesPattern = string != null && string.length() > 0 ? Pattern.compile(string) : null;
        }
        return this.ignoreFilesPattern;
    }

    protected String getIgnoredFiles() {
        String string = "";
        try {
            if (this.ideSettings == null) {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> clazz = classLoader.loadClass("org.netbeans.core.IDESettings");
                this.ideSettings = (SystemOption)SharedClassObject.findObject(clazz, (boolean)true);
                if (this.ideSettings != null) {
                    mIgnoredFiles = clazz.getMethod("getIgnoredFiles", null);
                    this.ideSettings.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (GlobalVisibilityQueryImpl.PROP_IGNORED_FILES.equals(propertyChangeEvent.getPropertyName())) {
                                GlobalVisibilityQueryImpl.this.ignoreFilesPattern = null;
                                GlobalVisibilityQueryImpl.this.fireChange();
                            }
                        }
                    });
                }
            }
            string = this.ideSettings != null && mIgnoredFiles != null ? (String)mIgnoredFiles.invoke((Object)this.ideSettings, new Object[0]) : "";
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.ideSettings = null;
        }
        catch (Exception exception) {
            this.ideSettings = null;
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return string;
    }
}

