/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.swing.Action;
import org.netbeans.modules.masterfs.Cache;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ProviderCall;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.SyncSection;
import org.netbeans.modules.masterfs.Utils;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class MasterFileSystem
extends FileSystem
implements FileStatusListener {
    private static final long serialVersionUID = -97134851800761145L;
    private static transient MasterFileSystem instance;
    private final transient StatusImpl status = new StatusImpl();
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$providers$AnnotationProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MasterFileSystem getDefault() {
        boolean bl = false;
        Class clazz = MasterFileSystem.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new MasterFileSystem();
                bl = true;
            }
        }
        if (bl) {
            ProviderCall.init();
        }
        return instance;
    }

    public static MasterFileSystem settingsFactory(FileObject fileObject) {
        return MasterFileSystem.getDefault();
    }

    private MasterFileSystem() {
        this.init();
    }

    private Object writeReplace() {
        return new Replace();
    }

    private void init() {
        try {
            this.setSystemName(((Object)((Object)this)).getClass().getName());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.registerFileStatusListener();
    }

    private void registerFileStatusListener() {
        Enumeration enumeration = MountTable.getDefault().geAllFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            fileSystem.addNotify();
            fileSystem.addFileStatusListener((FileStatusListener)this);
        }
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)MasterFileSystem.class, (String)"LBL_this_computer");
    }

    public boolean isReadOnly() {
        return false;
    }

    public FileObject getRoot() {
        return Cache.getDefault().getOrCreate(ResourcePath.getRoot());
    }

    public FileObject findResource(String string) {
        ResourcePath resourcePath = new ResourcePath(string);
        MasterFileObject masterFileObject = Cache.getDefault().get(resourcePath);
        if (Utilities.getOperatingSystem() == 16384) {
            if (masterFileObject == null) {
                masterFileObject = MasterFileSystem.getStepByStepVMS(resourcePath);
            }
        } else if (masterFileObject == null) {
            masterFileObject = this.getStepByStep(resourcePath);
        }
        return masterFileObject;
    }

    private FileObject getStepByStep(ResourcePath resourcePath) {
        FileObject fileObject = this.getRoot();
        Enumeration enumeration = resourcePath.getElements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ((fileObject = fileObject.getFileObject(string)) != null) continue;
            return null;
        }
        return fileObject;
    }

    private static String findVMSRoot(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                if (!new File(string2 = string2 + "/" + stringTokenizer.nextToken()).exists()) continue;
                return string2;
            }
        }
        return null;
    }

    private static FileObject getRootForVMS(String string) {
        return Cache.getDefault().getOrCreate(new ResourcePath(string));
    }

    private static FileObject getStepByStepVMS(ResourcePath resourcePath) {
        String string = MasterFileSystem.findVMSRoot(resourcePath.getNormalizedPath());
        if (string == null) {
            return null;
        }
        FileObject fileObject = MasterFileSystem.getRootForVMS(string);
        ResourcePath resourcePath2 = new ResourcePath(resourcePath.getNormalizedPath().substring(string.length()));
        Enumeration enumeration = resourcePath2.getElements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("000000") || (fileObject = fileObject.getFileObject(string2)) != null) continue;
            return null;
        }
        return fileObject;
    }

    public void addNotify() {
    }

    public void removeNotify() {
        Cache.getDefault().clear();
    }

    public void refresh(boolean bl) {
        Enumeration enumeration = MountTable.getDefault().geAllFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            fileSystem.refresh(bl);
        }
    }

    public SystemAction[] getActions() {
        return this.getEmptyActions();
    }

    private SystemAction[] getEmptyActions() {
        return new SystemAction[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAction[] getActions(Set set) {
        SystemAction[] systemActionArray = this.status.getActions(set);
        if (systemActionArray != null) {
            return systemActionArray;
        }
        SyncSection.getDefault().enterSection();
        try {
            MasterFileObject masterFileObject = MasterFileSystem.getUniqueMasterFileObject(set);
            if (masterFileObject == null) {
                SystemAction[] systemActionArray2 = this.getEmptyActions();
                return systemActionArray2;
            }
            FileSystem fileSystem = MasterFileSystem.getDelegateFileSystem(masterFileObject.getDelegate().get());
            FileSystem fileSystem2 = MasterFileSystem.getDelegateFileSystem(masterFileObject.getDelegate().getPrefered());
            if (fileSystem == null) {
                SystemAction[] systemActionArray3 = this.getEmptyActions();
                return systemActionArray3;
            }
            if (fileSystem2 != fileSystem) {
                SystemAction[] systemActionArray4 = this.mergeActionsFromBothDelegates(set, fileSystem, fileSystem2);
                return systemActionArray4;
            }
            SystemAction[] systemActionArray5 = fileSystem.getActions(Utils.transformToDelegates(set, false));
            return systemActionArray5;
        }
        finally {
            SyncSection.getDefault().finishSection();
        }
    }

    private static FileSystem getDelegateFileSystem(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        FileSystem fileSystem = null;
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
        return fileSystem;
    }

    private static MasterFileObject getUniqueMasterFileObject(Set set) {
        MasterFileObject masterFileObject = null;
        FileSystem fileSystem = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem2;
            Object e = iterator.next();
            if (!(e instanceof MasterFileObject)) {
                return null;
            }
            masterFileObject = (MasterFileObject)((Object)e);
            FileObject fileObject = masterFileObject.getDelegate().get();
            if (fileObject == null || (fileSystem2 = MasterFileSystem.getDelegateFileSystem(fileObject)) == null) continue;
            if (fileSystem != null && fileSystem != fileSystem2) {
                return null;
            }
            fileSystem = fileSystem2;
        }
        return masterFileObject;
    }

    private SystemAction[] mergeActionsFromBothDelegates(Set set, FileSystem fileSystem, FileSystem fileSystem2) {
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(set.size());
        Set set2 = Utils.transformToDelegates(set, false);
        SystemAction[] systemActionArray = fileSystem.getActions(set2);
        hashSet.addAll(Arrays.asList(systemActionArray));
        Set set3 = Utils.transformToDelegates(set, true);
        SystemAction[] systemActionArray2 = fileSystem2.getActions(set3);
        hashSet.addAll(Arrays.asList(systemActionArray2));
        return hashSet.toArray(new SystemAction[hashSet.size()]);
    }

    public void annotationChanged(final FileStatusEvent fileStatusEvent) {
        HashSet hashSet = new HashSet(1){

            public boolean contains(Object object) {
                if (object instanceof MasterFileObject) {
                    MasterFileObject masterFileObject = (MasterFileObject)((Object)object);
                    FileObject fileObject = masterFileObject.getDelegate().get();
                    return fileObject != null && fileStatusEvent.hasChanged(fileObject);
                }
                return false;
            }
        };
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, (Set)hashSet, fileStatusEvent.isIconChange(), fileStatusEvent.isNameChange()));
    }

    public FileSystem.Status getStatus() {
        return this.status;
    }

    final void fireFileStatus(FileStatusEvent fileStatusEvent) {
        this.fireFileStatusChanged(fileStatusEvent);
    }

    static final class LazySet
    implements Set {
        private Set obj_files;
        private boolean initialized = false;
        private Iterator it = null;

        LazySet(Set set) {
            this.obj_files = set;
        }

        private synchronized void lazyInitialization() {
            if (!this.initialized) {
                Set set;
                this.obj_files = set = Utils.transformSet(this.obj_files);
                this.initialized = true;
            }
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            this.lazyInitialization();
            return this.obj_files.contains(object);
        }

        public boolean containsAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.containsAll(collection);
        }

        public boolean isEmpty() {
            this.lazyInitialization();
            return this.obj_files.isEmpty();
        }

        public Iterator iterator() {
            this.it = this.initialized ? this.obj_files.iterator() : new Iterator(this){
                private final Iterator originalIterator;
                private final /* synthetic */ LazySet this$0;
                {
                    this.this$0 = lazySet;
                    this.originalIterator = LazySet.access$200(this.this$0).iterator();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object next() {
                    MasterFileObject masterFileObject = (MasterFileObject)((Object)this.originalIterator.next());
                    return masterFileObject.getDelegate().get(true);
                }

                public boolean hasNext() {
                    return this.originalIterator.hasNext();
                }
            };
            return this.it;
        }

        public boolean remove(Object object) {
            this.lazyInitialization();
            return this.obj_files.remove(object);
        }

        public boolean removeAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.retainAll(collection);
        }

        public int size() {
            this.lazyInitialization();
            return this.obj_files.size();
        }

        public Object[] toArray() {
            this.lazyInitialization();
            return this.obj_files.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            this.lazyInitialization();
            return this.obj_files.toArray(objectArray);
        }

        static /* synthetic */ Set access$200(LazySet lazySet) {
            return lazySet.obj_files;
        }
    }

    private static final class Replace
    implements Serializable {
        static final long serialVersionUID = 50485340814380L;

        private Replace() {
        }

        public Object readResolve() {
            return MasterFileSystem.getDefault();
        }
    }

    static final class StatusImpl
    implements FileSystem.HtmlStatus,
    LookupListener,
    FileStatusListener {
        private Lookup.Result annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(class$org$netbeans$modules$masterfs$providers$AnnotationProvider == null ? (class$org$netbeans$modules$masterfs$providers$AnnotationProvider = MasterFileSystem.class$("org.netbeans.modules.masterfs.providers.AnnotationProvider")) : class$org$netbeans$modules$masterfs$providers$AnnotationProvider));
        private Collection previousProviders;

        StatusImpl() {
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public InterceptionListener getInterceptionListener() {
            InterceptionListener interceptionListener = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (interceptionListener == null && iterator.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
                interceptionListener = annotationProvider.getInterceptionListener();
            }
            return interceptionListener;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Object object;
            Object object2;
            HashSet hashSet;
            HashSet hashSet2 = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                hashSet = new HashSet(hashSet2);
                hashSet.removeAll(this.previousProviders);
                object2 = new HashSet(this.previousProviders);
                ((AbstractSet)object2).removeAll(hashSet2);
                object = ((HashSet)object2).iterator();
                while (object.hasNext()) {
                    AnnotationProvider annotationProvider = (AnnotationProvider)object.next();
                    annotationProvider.removeFileStatusListener(this);
                }
            } else {
                hashSet = hashSet2;
            }
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                object = (AnnotationProvider)object2.next();
                try {
                    ((AnnotationProvider)object).addFileStatusListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    ErrorManager.getDefault().notify((Throwable)tooManyListenersException);
                }
            }
            this.previousProviders = hashSet2;
        }

        public SystemAction[] getActions(Set set) {
            Object object;
            Action[] actionArray = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (actionArray == null && iterator.hasNext()) {
                object = (AnnotationProvider)iterator.next();
                actionArray = ((AnnotationProvider)object).actions(set);
            }
            if (actionArray != null) {
                object = new SystemAction[actionArray.length];
                for (int i = 0; i < actionArray.length; ++i) {
                    if (!(actionArray[i] instanceof SystemAction)) continue;
                    object[i] = (SystemAction)actionArray[i];
                }
                return object;
            }
            return null;
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (fileStatusEvent.getSource() != MasterFileSystem.getDefault()) {
                throw new IllegalStateException("The source must be master fs and not : " + fileStatusEvent.getSource());
            }
            MasterFileSystem.getDefault().fireFileStatusChanged(fileStatusEvent);
        }

        private FileSystem getDelegateFileSystem(Set set) {
            FileSystem fileSystem = null;
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                MasterFileObject masterFileObject = (MasterFileObject)((Object)iterator.next());
                fileSystem = masterFileObject.getDelegateFileSystem();
            }
            return fileSystem;
        }

        public Image annotateIcon(Image image, int n, Set set) {
            AnnotationProvider annotationProvider;
            Image image2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (image2 == null && iterator.hasNext()) {
                annotationProvider = (AnnotationProvider)iterator.next();
                image2 = annotationProvider.annotateIcon(image, n, set);
            }
            if (image2 != null) {
                return image2;
            }
            image2 = image;
            annotationProvider = this.getDelegateFileSystem(set);
            if (annotationProvider != null) {
                LazySet lazySet = new LazySet(set);
                image2 = annotationProvider.getStatus().annotateIcon(image, n, (Set)lazySet);
            }
            return image2;
        }

        public String annotateName(String string, Set set) {
            Object object;
            String string2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (string2 == null && iterator.hasNext()) {
                object = (AnnotationProvider)iterator.next();
                string2 = ((AnnotationProvider)object).annotateName(string, set);
            }
            if (string2 != null) {
                return string2;
            }
            string2 = string;
            object = new LazySet(set);
            FileSystem fileSystem = this.getDelegateFileSystem(set);
            if (fileSystem != null) {
                string2 = fileSystem.getStatus().annotateName(string, (Set)object);
            }
            return string2;
        }

        public String annotateNameHtml(String string, Set set) {
            AnnotationProvider annotationProvider;
            String string2 = null;
            Iterator iterator = this.annotationProviders.allInstances().iterator();
            while (string2 == null && iterator.hasNext()) {
                annotationProvider = (AnnotationProvider)iterator.next();
                string2 = annotationProvider.annotateNameHtml(string, set);
            }
            if (string2 != null) {
                return string2;
            }
            string2 = string;
            annotationProvider = this.getDelegateFileSystem(set);
            if (annotationProvider != null && annotationProvider != null && annotationProvider.getStatus() instanceof FileSystem.HtmlStatus) {
                LazySet lazySet = new LazySet(set);
                string2 = ((FileSystem.HtmlStatus)annotationProvider.getStatus()).annotateNameHtml(string, (Set)lazySet);
            }
            return string2;
        }
    }
}

