/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.masterfs.InvalidDummy;
import org.netbeans.modules.masterfs.MountTable;
import org.netbeans.modules.masterfs.ResourcePath;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

final class SpecialDelegates {
    private static boolean isUnixRootResolved = false;
    private static FileSystem fs = new WinSpecialFs();
    private static final FileSystemView fsv = FileSystemView.getFileSystemView();
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
    static /* synthetic */ Class class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy;

    private SpecialDelegates() {
    }

    static FileObject get(ResourcePath resourcePath) {
        FileObject fileObject = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? SpecialDelegates.getForWindows(resourcePath) : (Utilities.getOperatingSystem() == 16384 ? SpecialDelegates.getForVMS(resourcePath) : SpecialDelegates.getForUnix(resourcePath));
        return fileObject;
    }

    private static FileObject getForUnix(ResourcePath resourcePath) {
        FileObject fileObject = null;
        if (!isUnixRootResolved) {
            SpecialDelegates.mountUnixRoot();
            fileObject = MountTable.getDefault().resolveBestDelegate(resourcePath.getNormalizedPath());
            isUnixRootResolved = true;
        }
        return fileObject;
    }

    private static FileObject getForVMS(ResourcePath resourcePath) {
        FileObject fileObject = null;
        SpecialDelegates.mountVMSRoot(resourcePath);
        fileObject = MountTable.getDefault().resolveBestDelegate(resourcePath.getNormalizedPath());
        return fileObject;
    }

    private static FileObject getForWindows(ResourcePath resourcePath) {
        WinRootVirtual winRootVirtual = null;
        if (resourcePath.isRoot()) {
            winRootVirtual = WinRootVirtual.getDefault();
        } else if (SpecialDelegates.isWinDrive(resourcePath)) {
            winRootVirtual = WindowsDriveProxy.getDefault(resourcePath);
        } else {
            WindowsDriveProxy windowsDriveProxy = WindowsDriveProxy.getDefault(resourcePath);
            if (windowsDriveProxy != null && !windowsDriveProxy.isMounted()) {
                windowsDriveProxy.lfs = SpecialDelegates.mountWinDrive(windowsDriveProxy.getResource());
                winRootVirtual = MountTable.getDefault().resolveBestDelegate(resourcePath.getNormalizedPath());
            }
        }
        return winRootVirtual;
    }

    private static boolean isWinDrive(ResourcePath resourcePath) {
        boolean bl = resourcePath.getParent().isRoot();
        if (bl) {
            bl = SpecialDelegates.checkValidWindowsDrive(resourcePath.getFile()) != null;
        }
        return bl;
    }

    private static FileSystem mountWinDrive(ResourcePath resourcePath) {
        FileSystem fileSystem = null;
        String string = resourcePath.getNormalizedPath().substring(1) + "/";
        File file = SpecialDelegates.checkValidWindowsDrive(new File(string));
        if (file != null) {
            fileSystem = SpecialDelegates.mountLocalFileSystem(file, string);
        }
        return fileSystem;
    }

    private static void mountUnixRoot() {
        String string = ResourcePath.getRoot().getNormalizedPath();
        File file = new File(string);
        if (file.exists()) {
            SpecialDelegates.mountLocalFileSystem(file, string);
        }
    }

    private static void mountVMSRoot(ResourcePath resourcePath) {
        String string = resourcePath.getNormalizedPath();
        File file = new File(string);
        if (file.exists()) {
            SpecialDelegates.mountLocalFileSystem(file, string);
        }
    }

    private static FileSystem mountLocalFileSystem(File file, String string) {
        FileBasedFileSystem fileBasedFileSystem;
        try {
            fileBasedFileSystem = FileBasedFileSystem.getInstance(file);
            MountTable.getDefault().mount(string, fileBasedFileSystem);
        }
        catch (IOException iOException) {
            fileBasedFileSystem = null;
        }
        return fileBasedFileSystem;
    }

    static File checkValidWindowsDrive(File file) {
        File file2 = null;
        if (fsv != null) {
            File file3 = file2 = (SpecialDelegates.isRoot(file) || fsv.isFileSystemRoot(file)) && !fsv.isFloppyDrive(file) ? file : null;
            if (file2 != null && !file2.exists()) {
                file2 = null;
            }
        } else {
            file2 = SpecialDelegates.isRoot(file) ? file : null;
        }
        return file2;
    }

    private static boolean isRoot(File file) {
        boolean bl = false;
        if (file.getParentFile() == null) {
            File[] fileArray = File.listRoots();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.equals(file)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static File[] listRoots() {
        File[] fileArray = File.listRoots();
        if ((Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && fsv != null) {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = SpecialDelegates.checkValidWindowsDrive(fileArray[i]);
                if (file == null) continue;
                linkedHashSet.add(file);
            }
            fileArray = new File[linkedHashSet.size()];
            linkedHashSet.toArray(fileArray);
        }
        return fileArray;
    }

    private static final class WinSpecialFs
    extends FileSystem {
        private WinSpecialFs() {
        }

        public boolean isReadOnly() {
            return false;
        }

        public FileObject getRoot() {
            return WinRootVirtual.getDefault();
        }

        public FileObject findResource(String string) {
            ResourcePath resourcePath = new ResourcePath(string);
            if (resourcePath.isRoot()) {
                return this.getRoot();
            }
            return WindowsDriveProxy.getDefault(resourcePath);
        }

        public SystemAction[] getActions() {
            return new SystemAction[0];
        }

        public SystemAction[] getActions(Set set) {
            return this.getActions();
        }

        public String getDisplayName() {
            return null;
        }
    }

    private static final class WindowsDriveProxy
    extends WinRootVirtual {
        static final long serialVersionUID = -1244651321879256718L;
        private transient FileObject delegate;
        private transient boolean isValid = true;
        private static final transient Map instances = new WeakHashMap();
        private transient FileSystem lfs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static WindowsDriveProxy getDefault(ResourcePath resourcePath) {
            WindowsDriveProxy windowsDriveProxy;
            String string = WindowsDriveProxy.getWindowsDriveSubstr(resourcePath.getNormalizedPath());
            if (string == null) {
                return null;
            }
            resourcePath = new ResourcePath(string);
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WindowsDriveProxy")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy;
            synchronized (clazz) {
                windowsDriveProxy = (WindowsDriveProxy)((Object)instances.get(resourcePath));
                if (windowsDriveProxy == null) {
                    windowsDriveProxy = new WindowsDriveProxy(resourcePath);
                    instances.put(windowsDriveProxy.getResource(), windowsDriveProxy);
                }
            }
            return windowsDriveProxy;
        }

        private static String getWindowsDriveSubstr(String string) {
            int n = string.indexOf(58);
            return n == -1 ? null : string.substring(0, n + 1);
        }

        private WindowsDriveProxy(ResourcePath resourcePath) {
            super(resourcePath);
        }

        public boolean isRoot() {
            return false;
        }

        public boolean isFolder() {
            return true;
        }

        public boolean isData() {
            return false;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public FileObject[] getChildren() {
            FileObject fileObject = this.getDelegate(true);
            return fileObject != null ? fileObject.getChildren() : new FileObject[]{};
        }

        public FileObject getFileObject(String string, String string2) {
            FileObject fileObject = this.getDelegate(true);
            return fileObject != null ? fileObject.getFileObject(string, string2) : null;
        }

        public FileObject getParent() {
            return WinRootVirtual.getDefault();
        }

        private FileObject getDelegate() {
            return this.getDelegate(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileObject getDelegate(boolean bl) {
            if (this.delegate == null && bl) {
                this.delegate = new InvalidDummy(this.getResource());
                this.lfs = SpecialDelegates.mountWinDrive(this.getResource());
                this.delegate = MountTable.getDefault().resolveBestDelegate(this.getResource().getNormalizedPath());
                if (this.delegate != null) {
                    Set set = this.getListenerList();
                    synchronized (set) {
                        Iterator iterator = this.getListenerList().iterator();
                        while (iterator.hasNext()) {
                            FileChangeListener fileChangeListener = (FileChangeListener)iterator.next();
                            this.delegate.addFileChangeListener(fileChangeListener);
                            iterator.remove();
                        }
                    }
                } else {
                    this.isValid = false;
                }
            }
            return this.delegate;
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.lfs != null ? this.lfs : fs;
        }

        public FileObject createFolder(String string) throws IOException {
            return this.getDelegate() != null ? this.getDelegate().createFolder(string) : super.createFolder(string);
        }

        public FileObject createData(String string, String string2) throws IOException {
            return this.getDelegate() != null ? this.getDelegate().createData(string) : super.createData(string);
        }

        public Object getAttribute(String string) {
            return this.getDelegate() != null ? this.getDelegate().getAttribute(string) : super.getAttribute(string);
        }

        public void setAttribute(String string, Object object) throws IOException {
            if (this.getDelegate() != null) {
                this.getDelegate().setAttribute(string, object);
            } else {
                super.setAttribute(string, object);
            }
        }

        public Enumeration getAttributes() {
            return this.getDelegate() != null ? this.getDelegate().getAttributes() : super.getAttributes();
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            if (this.getDelegate() != null) {
                this.getDelegate().addFileChangeListener(fileChangeListener);
            } else {
                super.addFileChangeListener(fileChangeListener);
            }
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            if (this.getDelegate() != null) {
                this.getDelegate().removeFileChangeListener(fileChangeListener);
            } else {
                super.removeFileChangeListener(fileChangeListener);
            }
        }

        private boolean isMounted() {
            return this.lfs != null;
        }
    }

    private static class WinRootVirtual
    extends InvalidDummy {
        static final long serialVersionUID = -1244651321879256809L;
        private static transient WinRootVirtual instance = null;
        private static transient ArrayList delegs = null;
        private transient Set listenerList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static WinRootVirtual getDefault() {
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WinRootVirtual")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new WinRootVirtual(new ResourcePath(""));
                }
            }
            return instance;
        }

        private WinRootVirtual(ResourcePath resourcePath) {
            super(resourcePath);
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            this.getListenerList().add(fileChangeListener);
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            this.getListenerList().remove(fileChangeListener);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return fs;
        }

        public boolean isRoot() {
            return true;
        }

        public boolean isFolder() {
            return true;
        }

        public boolean isData() {
            return false;
        }

        public void refresh(boolean bl) {
            FileEvent fileEvent;
            FileObject fileObject;
            List<FileObject> list = Arrays.asList(this.getChildren());
            delegs = null;
            List<FileObject> list2 = Arrays.asList(this.getChildren());
            HashSet<FileObject> hashSet = new HashSet<FileObject>(list);
            HashSet<FileObject> hashSet2 = new HashSet<FileObject>(list2);
            hashSet.removeAll(list2);
            hashSet2.removeAll(list);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                fileObject = (FileObject)iterator.next();
                fileEvent = new FileEvent((FileObject)this, fileObject);
                this.fireFileDeletedEvent(Collections.enumeration(this.getListenerList()), fileEvent);
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                fileObject = (FileObject)iterator.next();
                fileEvent = new FileEvent((FileObject)this, fileObject);
                if (fileObject.isFolder()) {
                    this.fireFileFolderCreatedEvent(Collections.enumeration(this.getListenerList()), fileEvent);
                    continue;
                }
                this.fireFileDataCreatedEvent(Collections.enumeration(this.getListenerList()), fileEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject[] getChildren() {
            Object object;
            if (class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual == null) {
                class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WinRootVirtual");
                object = class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
            } else {
                object = class$org$netbeans$modules$masterfs$SpecialDelegates$WinRootVirtual;
            }
            FileObject[] fileObjectArray = object;
            synchronized (object) {
                if (delegs == null) {
                    List<File> list = Arrays.asList(SpecialDelegates.listRoots());
                    delegs = new ArrayList();
                    for (int i = 0; i < list.size(); ++i) {
                        File file = list.get(i);
                        ResourcePath resourcePath = this.getResource().getChild(file.getAbsolutePath());
                        WindowsDriveProxy windowsDriveProxy = WindowsDriveProxy.getDefault(resourcePath);
                        if (windowsDriveProxy == null) continue;
                        delegs.add(windowsDriveProxy);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                fileObjectArray = new FileObject[delegs.size()];
                delegs.toArray(fileObjectArray);
                return fileObjectArray;
            }
        }

        public boolean isValid() {
            return true;
        }

        public FileObject getFileObject(String string, String string2) {
            FileObject fileObject = null;
            FileObject[] fileObjectArray = this.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!fileObject2.getName().equals(string) || !fileObject2.getExt().equals(string2)) continue;
                fileObject = fileObject2;
                break;
            }
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set getListenerList() {
            Class clazz = class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy == null ? (class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy = SpecialDelegates.class$("org.netbeans.modules.masterfs.SpecialDelegates$WindowsDriveProxy")) : class$org$netbeans$modules$masterfs$SpecialDelegates$WindowsDriveProxy;
            synchronized (clazz) {
                if (this.listenerList == null) {
                    this.listenerList = Collections.synchronizedSet(new HashSet());
                }
            }
            return this.listenerList;
        }
    }
}

