/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.MutualExclusionSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

final class FileObj
extends BaseFileObj {
    static final long serialVersionUID = -1133540210876356809L;
    private long lastModified = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileObj(File file, FileNaming fileNaming) {
        super(file, fileNaming);
        this.setLastModified(System.currentTimeMillis());
    }

    public final OutputStream getOutputStream(FileLock fileLock) throws IOException {
        final File file = this.getFileName().getFile();
        final MutualExclusionSupport.Closeable closeable = MutualExclusionSupport.getDefault().addResource((Object)this, false);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file){

                public void close() throws IOException {
                    if (!closeable.isClosed()) {
                        super.close();
                        closeable.close();
                        FileObj.this.setLastModified(file.lastModified());
                        FileObj.this.fireFileChangedEvent(false);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (closeable != null) {
                closeable.close();
            }
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!file.exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.getParentFile().exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            FSException.annotateException(fileNotFoundException2);
            throw fileNotFoundException2;
        }
        return fileOutputStream;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        FileInputStream fileInputStream;
        File file = this.getFileName().getFile();
        MutualExclusionSupport.Closeable closeable = null;
        try {
            MutualExclusionSupport.Closeable closeable2;
            closeable = closeable2 = MutualExclusionSupport.getDefault().addResource((Object)this, true);
            fileInputStream = new FileInputStream(file){

                public void close() throws IOException {
                    super.close();
                    closeable2.close();
                }
            };
        }
        catch (IOException iOException) {
            if (closeable != null) {
                closeable.close();
            }
            FileNotFoundException fileNotFoundException = null;
            fileNotFoundException = !file.exists() ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (!file.canRead() ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (file.getParentFile() == null ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (!file.getParentFile().exists() ? (FileNotFoundException)new FileNotFoundException(iOException.getLocalizedMessage()).initCause(iOException) : (new FileInfo(file).isUnixSpecialFile() ? (FileNotFoundException)new FileNotFoundException(iOException.toString()).initCause(iOException) : (FileNotFoundException)new FileNotFoundException(iOException.toString()).initCause(iOException)))));
            FSException.annotateException(fileNotFoundException);
            throw fileNotFoundException;
        }
        if (!$assertionsDisabled && fileInputStream == null) {
            throw new AssertionError();
        }
        return fileInputStream;
    }

    public final Date lastModified() {
        File file = this.getFileName().getFile();
        return new Date(file.lastModified());
    }

    private final void setLastModified(long l) {
        this.lastModified = l;
    }

    public final FileObject createFolder(String string) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject createData(String string, String string2) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileObject[] getChildren() {
        return new FileObject[0];
    }

    public final FileObject getFileObject(String string, String string2) {
        return null;
    }

    public boolean isValid() {
        return this.lastModified != 0L;
    }

    protected void setValid(boolean bl) {
        if (bl) {
            if (!$assertionsDisabled && !this.isValid()) {
                throw new AssertionError((Object)this.toString());
            }
        } else {
            this.lastModified = 0L;
        }
    }

    public final boolean isFolder() {
        return false;
    }

    public final void refresh(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FILE);
        stopWatch.start();
        if (this.isValid()) {
            boolean bl2;
            long l = this.lastModified;
            this.setLastModified(this.getFileName().getFile().lastModified());
            if (l != -1L && this.lastModified != -1L && this.lastModified != 0L && l < this.lastModified) {
                this.fireFileChangedEvent(bl);
            }
            if (!(bl2 = this.getFileName().getFile().exists())) {
                this.setValid(false);
                this.fireFileDeletedEvent(bl);
            }
        }
        stopWatch.stop();
    }

    public final Enumeration getChildren(boolean bl) {
        return Enumerations.empty();
    }

    public final Enumeration getFolders(boolean bl) {
        return Enumerations.empty();
    }

    public final Enumeration getData(boolean bl) {
        return Enumerations.empty();
    }

    public final FileLock lock() throws IOException {
        File file = this.getFileName().getFile();
        try {
            boolean bl = false;
            FolderObj folderObj = this.getExistingParent();
            if (folderObj instanceof FolderObj) {
                bl = folderObj.isLightWeightLockRequired();
            }
            return WriteLockFactory.tryLock(file, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!file.exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canRead()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.getParentFile().exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            FSException.annotateException(fileNotFoundException2);
            throw fileNotFoundException2;
        }
    }

    final boolean checkLock(FileLock fileLock) throws IOException {
        File file = this.getFileName().getFile();
        return fileLock instanceof WriteLock && ((WriteLock)fileLock).isValid(file);
    }

    static {
        $assertionsDisabled = !FileObj.class.desiredAssertionStatus();
    }
}

