/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public final class FolderObj
extends BaseFileObj {
    static final long serialVersionUID = -1022430210876356809L;
    private static final Mutex.Privileged mp;
    private static final Mutex mutex;
    private final FolderChildrenCache folderChildren = new FolderChildrenCache();
    boolean valid = true;
    private int bitmask = 0;
    static final String LIGHTWEIGHT_LOCK_SET = "LIGHTWEIGHT_LOCK_SET";
    private static int LIGHTWEIGHT_LOCK;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FolderObj(File file, FileNaming fileNaming) {
        super(file, fileNaming);
    }

    public final boolean isFolder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject getFileObject(String string, String string2) {
        FileNaming fileNaming;
        Object object;
        File file;
        FileObject fileObject = null;
        File file2 = this.getFileName().getFile();
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterReadAccess();
        try {
            file = BaseFileObj.getFile(file2, string, string2);
            object = BaseFileObj.getNameExt(file);
            fileNaming = childrenCache.getChild((String)object, false);
        }
        finally {
            privileged.exitReadAccess();
        }
        object = this.getLocalFileSystem();
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        if (fileNaming != null) {
            fileObject = ((FileBasedFileSystem)((Object)object)).findFileObject(file);
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject[] getChildren() {
        HashSet hashSet;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterWriteAccess();
        try {
            hashSet = new HashSet(childrenCache.getChildren(true));
        }
        finally {
            privileged.exitWriteAccess();
        }
        FileBasedFileSystem fileBasedFileSystem = this.getLocalFileSystem();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            FileNaming fileNaming = (FileNaming)iterator.next();
            FileInfo fileInfo = new FileInfo(fileNaming.getFile());
            fileInfo.setFileNaming(fileNaming);
            fileInfo.setValueForFlag(2, true);
            FileObject fileObject = fileBasedFileSystem.findFileObject(fileInfo);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createFolder(String string) throws IOException {
        Object object;
        File file;
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        BaseFileObj baseFileObj = null;
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterWriteAccess();
        try {
            file = BaseFileObj.getFile(this.getFileName().getFile(), string, null);
            this.createFolder(file, string);
            object = this.getChildrenCache().getChild(file.getName(), true);
            NamingFactory.checkCaseSensitivity((FileNaming)object, file);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
        }
        finally {
            privileged.exitWriteAccess();
        }
        object = this.getLocalFileSystem();
        if (object != null) {
            if (!($assertionsDisabled || file.exists() && file.isDirectory())) {
                throw new AssertionError((Object)file.getAbsolutePath());
            }
            baseFileObj = (FolderObj)((FileBasedFileSystem)((Object)object)).findFileObject(file);
        }
        if (!$assertionsDisabled && baseFileObj == null) {
            throw new AssertionError((Object)file.getAbsolutePath());
        }
        baseFileObj.fireFileFolderCreatedEvent(false);
        return baseFileObj;
    }

    private void createFolder(File file, String string) throws IOException {
        boolean bl = new FileInfo(file).isSupportedFile();
        if (!bl) {
            FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
        } else if (file.exists()) {
            FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
        } else if (!file.mkdirs()) {
            FSException.io("EXC_CannotCreateFolder", file.getName(), this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createData(String string, String string2) throws IOException {
        Object object;
        File file;
        if (string.indexOf(92) != -1 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException(string);
        }
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
        privileged.enterWriteAccess();
        try {
            file = BaseFileObj.getFile(this.getFileName().getFile(), string, string2);
            this.createData(file);
            object = this.getChildrenCache().getChild(file.getName(), true);
            NamingFactory.checkCaseSensitivity((FileNaming)object, file);
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
        }
        finally {
            privileged.exitWriteAccess();
        }
        object = this.getLocalFileSystem();
        BaseFileObj baseFileObj = null;
        if (object != null) {
            if (!($assertionsDisabled || file.exists() && !file.isDirectory())) {
                throw new AssertionError((Object)file.getAbsolutePath());
            }
            baseFileObj = (FileObj)((FileBasedFileSystem)((Object)object)).findFileObject(file);
        }
        if (!$assertionsDisabled && baseFileObj == null) {
            throw new AssertionError();
        }
        baseFileObj.fireFileDataCreatedEvent(false);
        return baseFileObj;
    }

    private void createData(File file) throws IOException {
        boolean bl = new FileInfo(file).isSupportedFile();
        if (!bl) {
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        } else if (file.exists()) {
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        } else if (!file.createNewFile()) {
            FSException.io("EXC_CannotCreateData", file.getName(), this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(FileLock fileLock) throws IOException {
        Object object;
        LinkedList linkedList = new LinkedList();
        File file = this.getFileName().getFile();
        if (!this.deleteFile(file, linkedList, this.getLocalFileSystem().getFactory())) {
            FolderObj folderObj = this.getExistingParent();
            object = folderObj != null ? folderObj.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotDelete", file.getName(), object);
        }
        BaseFileObj.attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
        for (int i = 0; i < linkedList.size(); ++i) {
            ChildrenCache childrenCache;
            object = (BaseFileObj)((Object)linkedList.get(i));
            FolderObj folderObj = ((BaseFileObj)((Object)object)).getExistingParent();
            ChildrenCache childrenCache2 = childrenCache = folderObj != null ? folderObj.getChildrenCache() : null;
            if (childrenCache != null) {
                Mutex.Privileged privileged;
                Mutex.Privileged privileged2 = privileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (privileged != null) {
                    privileged.enterWriteAccess();
                }
                try {
                    childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                }
                finally {
                    if (privileged != null) {
                        privileged.exitWriteAccess();
                    }
                }
            }
            ((BaseFileObj)((Object)object)).setValid(false);
            ((BaseFileObj)((Object)object)).fireFileDeletedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh(boolean bl) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FOLDER);
        stopWatch.start();
        if (this.isValid()) {
            Object object;
            Object object2;
            boolean bl2 = false;
            ChildrenCache childrenCache = this.getChildrenCache();
            Mutex.Privileged privileged = childrenCache.getMutexPrivileged();
            Set set = null;
            Map map = null;
            privileged.enterWriteAccess();
            try {
                set = childrenCache.getChildren(false);
                map = childrenCache.refresh();
            }
            finally {
                privileged.exitWriteAccess();
            }
            set.removeAll(map.keySet());
            Object object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (FileName)object3.next();
                object = this.getLocalFileSystem().getFactory().get(((FileName)object2).getFile());
                if (object == null || !((BaseFileObj)((Object)object)).isData()) continue;
                ((FileObj)((Object)object)).refresh(bl);
            }
            object3 = this.getLocalFileSystem();
            object2 = ((FileBasedFileSystem)((Object)object3)).getFactory();
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                FileName fileName = (FileName)entry.getKey();
                Integer n = (Integer)entry.getValue();
                BaseFileObj baseFileObj = n == ChildrenCache.ADDED_CHILD ? (BaseFileObj)((FileObjectFactory)object2).findFileObject(new FileInfo(fileName.getFile())) : ((FileObjectFactory)object2).get(fileName.getFile());
                BaseFileObj baseFileObj2 = baseFileObj = baseFileObj != null ? baseFileObj : this.getFileObject(fileName.getName());
                if (n == ChildrenCache.ADDED_CHILD && baseFileObj != null) {
                    if (baseFileObj.isFolder()) {
                        bl2 = true;
                        baseFileObj.fireFileFolderCreatedEvent(bl);
                        continue;
                    }
                    bl2 = true;
                    baseFileObj.fireFileDataCreatedEvent(bl);
                    continue;
                }
                if (n == ChildrenCache.REMOVED_CHILD) {
                    if (baseFileObj != null) {
                        if (!baseFileObj.isValid()) continue;
                        baseFileObj.setValid(false);
                        baseFileObj.fireFileDeletedEvent(bl);
                        continue;
                    }
                    File file = fileName.getFile();
                    if (new FileInfo(file).isConvertibleToFileObject()) continue;
                    BaseFileObj baseFileObj3 = fileName.isFile() ? new FileObj(file, fileName) : new FolderObj(file, fileName);
                    baseFileObj3.setValid(false);
                    baseFileObj3.fireFileDeletedEvent(bl);
                    continue;
                }
                if (!$assertionsDisabled && new FileInfo(fileName.getFile()).isConvertibleToFileObject()) {
                    throw new AssertionError();
                }
            }
            boolean bl3 = this.getFileName().getFile().exists();
            if (!bl3) {
                this.setValid(false);
                this.fireFileDeletedEvent(bl);
            }
        }
        stopWatch.stop();
    }

    private boolean deleteFile(File file, LinkedList linkedList, FileObjectFactory fileObjectFactory) throws IOException {
        BaseFileObj baseFileObj;
        boolean bl;
        boolean bl2 = file.delete();
        if (bl2) {
            BaseFileObj baseFileObj2 = fileObjectFactory.get(file);
            if (baseFileObj2 != null) {
                linkedList.addFirst(baseFileObj2);
            }
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (this.deleteFile(file2, linkedList, fileObjectFactory)) continue;
                return false;
            }
        }
        if ((bl = file.delete()) && (baseFileObj = fileObjectFactory.get(file)) != null) {
            linkedList.addFirst(baseFileObj);
        }
        return true;
    }

    protected void setValid(boolean bl) {
        if (bl) {
            if (!$assertionsDisabled && !this.isValid()) {
                throw new AssertionError((Object)this.toString());
            }
        } else {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock fileLock) throws IOException {
        throw new IOException(this.getPath());
    }

    public final Date lastModified() {
        File file = this.getFileName().getFile();
        return new Date(file.lastModified());
    }

    public final FileLock lock() throws IOException {
        return new FileLock();
    }

    final boolean checkLock(FileLock fileLock) throws IOException {
        return true;
    }

    public final ChildrenCache getChildrenCache() {
        return this.folderChildren;
    }

    public Object getAttribute(String string) {
        if (string.equals(LIGHTWEIGHT_LOCK_SET)) {
            this.bitmask |= LIGHTWEIGHT_LOCK;
            return new FileLock(){

                public void releaseLock() {
                    super.releaseLock();
                    FolderObj.this.bitmask &= ~LIGHTWEIGHT_LOCK;
                }
            };
        }
        return super.getAttribute(string);
    }

    boolean isLightWeightLockRequired() {
        return (this.bitmask & LIGHTWEIGHT_LOCK) == LIGHTWEIGHT_LOCK;
    }

    static {
        $assertionsDisabled = !FolderObj.class.desiredAssertionStatus();
        mp = new Mutex.Privileged();
        mutex = new Mutex(mp);
        LIGHTWEIGHT_LOCK = 1;
    }

    public final class FolderChildrenCache
    implements ChildrenCache {
        final ChildrenSupport ch = new ChildrenSupport();

        public final Set getChildren(boolean bl) {
            return this.ch.getChildren(FolderObj.this.getFileName(), bl);
        }

        public final FileNaming getChild(String string, boolean bl) {
            return this.ch.getChild(string, FolderObj.this.getFileName(), bl);
        }

        public final Map refresh() {
            return this.ch.refresh(FolderObj.this.getFileName());
        }

        public final Mutex.Privileged getMutexPrivileged() {
            return mp;
        }

        public final String toString() {
            return FolderObj.this.getFileName().toString();
        }

        public boolean existsInCache(String string) {
            return this.ch.existsldInCache(FolderObj.this.getFileName(), string);
        }
    }
}

