/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;

public class FileName
implements FileNaming {
    private String name;
    private final FileNaming parent;
    private Integer id;

    protected FileName(FileNaming fileNaming, File file) {
        this.parent = fileNaming;
        this.name = FileName.parseName(file);
        this.id = NamingFactory.createID(file);
    }

    private static String parseName(File file) {
        return file.getParentFile() == null ? file.getPath() : file.getName();
    }

    public final boolean rename(String string) {
        File file;
        boolean bl = false;
        File file2 = this.getFile();
        if (file2.exists() && (bl = file2.renameTo(file = new File(file2.getParentFile(), string)))) {
            this.name = string;
            this.id = NamingFactory.createID(file);
        }
        FolderName.freeCaches();
        return bl;
    }

    public final boolean isRoot() {
        return this.getParent() == null;
    }

    public File getFile() {
        FileNaming fileNaming = this.getParent();
        return fileNaming != null ? new File(fileNaming.getFile(), this.getName()) : new File(this.getName());
    }

    public final String getName() {
        return this.name;
    }

    public FileNaming getParent() {
        return this.parent;
    }

    public final Integer getId() {
        return this.getId(false);
    }

    public Integer getId(boolean bl) {
        if (bl) {
            this.id = NamingFactory.createID(this.getFile());
        }
        return this.id;
    }

    public final boolean equals(Object object) {
        return object instanceof FileNaming && object.hashCode() == this.hashCode();
    }

    public final String toString() {
        return this.getFile().getAbsolutePath();
    }

    public final int hashCode() {
        return this.id;
    }

    public boolean isFile() {
        return true;
    }
}

