/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.ErrorManager;
import org.openide.awt.AWTTask;
import org.openide.awt.MouseUtils;
import org.openide.awt.Toolbar;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class ToolbarPool
extends JComponent
implements Accessible {
    private static ToolbarPool defaultPool;
    private Folder instance;
    private DataFolder folder;
    private Map toolbars;
    private Map toolbarConfigs;
    private String name = "";
    private Component center;
    private PopupListener listener;
    private AccessibleContext accessibleContext = null;
    public static final String DEFAULT_CONFIGURATION = "Standard";
    private TPTaskListener taskListener;
    private int preferredIconSize = 24;
    static final long serialVersionUID = 3420915387298484008L;
    private static Color mid;
    private static final Border lowerBorder;
    private static final Border upperBorder;
    private static Boolean isXP;
    static /* synthetic */ Class class$org$openide$awt$ToolbarPool;
    static /* synthetic */ Class class$org$openide$awt$ToolbarPool$Configuration;
    static /* synthetic */ Class class$java$awt$Component;

    public static synchronized ToolbarPool getDefault() {
        if (defaultPool == null) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Toolbars");
            if (fileObject == null) {
                throw new IllegalStateException("No Toolbars/");
            }
            DataFolder dataFolder = DataFolder.findFolder(fileObject);
            defaultPool = new ToolbarPool(dataFolder);
            ToolbarPool.defaultPool.instance.recreate();
        }
        return defaultPool;
    }

    public ToolbarPool(DataFolder dataFolder) {
        this.folder = dataFolder;
        this.setLayout(new BorderLayout());
        this.listener = new PopupListener();
        this.toolbars = new TreeMap();
        this.toolbarConfigs = new TreeMap();
        this.instance = new Folder(dataFolder);
        this.getAccessibleContext().setAccessibleName(this.instance.instanceName());
        this.getAccessibleContext().setAccessibleDescription(this.instance.instanceName());
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            if (ToolbarPool.isXPTheme()) {
                this.setBorder(BorderFactory.createCompoundBorder(upperBorder, BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(0, 0, 1, 0, mid))));
            } else {
                this.setBorder(BorderFactory.createEtchedBorder());
            }
        } else if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 3, 0));
        }
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    public void setPreferredIconSize(int n) throws IllegalArgumentException {
        if (n != 16 && n != 24) {
            throw new IllegalArgumentException("Unsupported argument value:" + n);
        }
        this.preferredIconSize = n;
    }

    public Border getBorder() {
        if (this.center != null && this.center instanceof Container && ((Container)this.center).getComponentCount() > 0) {
            boolean bl = false;
            for (int i = 0; i < ((Container)this.center).getComponentCount(); ++i) {
                Component component = ((Container)this.center).getComponent(i);
                if (!component.isVisible()) continue;
                bl = true;
                break;
            }
            if (bl) {
                return super.getBorder();
            }
        }
        return lowerBorder;
    }

    private static Color fetchColor(String string, Color color) {
        Color color2 = (Color)UIManager.get(string);
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public final void waitFinished() {
        this.instance.instanceFinished();
    }

    void update(Map map, Map map2) {
        this.toolbars = map;
        this.toolbarConfigs = map2;
        if (!"".equals(this.name)) {
            this.setConfiguration(this.name);
        }
    }

    private synchronized void updateDefault() {
        Toolbar[] toolbarArray = this.getToolbars();
        this.name = "";
        if (toolbarArray.length == 1) {
            this.revalidate(toolbarArray[0]);
        } else {
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            for (int i = 0; i < toolbarArray.length; ++i) {
                jPanel.add(toolbarArray[i]);
            }
            this.revalidate(jPanel);
        }
    }

    private synchronized void activate(Configuration configuration) {
        Component component = configuration.activate();
        this.name = configuration.getName();
        this.revalidate(component);
    }

    public void setToolbarsListener(Toolbar.DnDListener dnDListener) {
        Iterator iterator = this.toolbars.values().iterator();
        while (iterator.hasNext()) {
            ((Toolbar)iterator.next()).setDnDListener(dnDListener);
        }
    }

    private void revalidate(Component component) {
        if (component != this.center) {
            if (this.center != null) {
                this.remove(this.center);
                this.center.removeMouseListener((MouseListener)((Object)this.listener));
            }
            this.center = component;
            this.add(this.center, "Center");
            this.center.addMouseListener((MouseListener)((Object)this.listener));
        }
    }

    public final Toolbar findToolbar(String string) {
        return (Toolbar)this.toolbars.get(string);
    }

    public final String getConfiguration() {
        return this.name;
    }

    public final void setConfiguration(String string) {
        String string2 = this.name;
        if (!this.instance.isFinished()) {
            if (this.taskListener == null) {
                this.taskListener = new TPTaskListener();
                this.instance.addTaskListener(this.taskListener);
            }
            this.taskListener.setConfiguration(string);
            return;
        }
        if (this.taskListener != null) {
            this.instance.removeTaskListener(this.taskListener);
            this.taskListener = null;
        }
        Configuration configuration = null;
        if (string != null) {
            configuration = (Configuration)this.toolbarConfigs.get(string);
        }
        if (configuration != null) {
            this.activate(configuration);
        } else if (this.toolbarConfigs.isEmpty()) {
            this.updateDefault();
        } else {
            configuration = (Configuration)this.toolbarConfigs.get(DEFAULT_CONFIGURATION);
            if (configuration == null) {
                configuration = (Configuration)this.toolbarConfigs.values().iterator().next();
            }
            this.activate(configuration);
        }
        this.firePropertyChange("configuration", string2, this.name);
    }

    public final DataFolder getFolder() {
        return this.folder;
    }

    public final synchronized Toolbar[] getToolbars() {
        Toolbar[] toolbarArray = new Toolbar[this.toolbars.size()];
        return this.toolbars.values().toArray(toolbarArray);
    }

    public final synchronized String[] getConfigurations() {
        ArrayList arrayList = new ArrayList(this.toolbarConfigs.keySet());
        Collections.sort(arrayList);
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.TOOL_BAR;
                }
            };
        }
        return this.accessibleContext;
    }

    private static boolean isXPTheme() {
        if (isXP == null) {
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            isXP = Boolean.TRUE.equals(bl) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isXP;
    }

    boolean isInEditMode() {
        return null != this.getClientProperty("editMode");
    }

    static {
        Color color = ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY);
        Color color2 = ToolbarPool.fetchColor("control", Color.GRAY);
        int n = (color.getRed() + color2.getRed()) / 2;
        int n2 = (color.getGreen() + color2.getGreen()) / 2;
        int n3 = (color.getBlue() + color2.getBlue()) / 2;
        mid = new Color(n, n2, n3);
        lowerBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(0, 0, 1, 0, mid));
        upperBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ToolbarPool.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(1, 0, 0, 0, ToolbarPool.fetchColor("controlLtHighlight", Color.WHITE)));
        isXP = null;
    }

    private static final class ComponentConfiguration
    extends JPopupMenu
    implements Configuration,
    ActionListener {
        private Component comp;
        static final long serialVersionUID = -409474484612485719L;

        ComponentConfiguration() {
        }

        public ComponentConfiguration(Component component) {
            this.comp = component;
        }

        public Component activate() {
            return this.comp;
        }

        public String getName() {
            return this.comp.getName();
        }

        public JPopupMenu getContextMenu() {
            this.removeAll();
            Iterator<String> iterator = Arrays.asList(ToolbarPool.getDefault().getConfigurations()).iterator();
            ButtonGroup buttonGroup = new ButtonGroup();
            String string = ToolbarPool.getDefault().getConfiguration();
            while (iterator.hasNext()) {
                String string2;
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2, (string2 = iterator.next()).compareTo(string) == 0);
                jRadioButtonMenuItem.addActionListener(this);
                buttonGroup.add(jRadioButtonMenuItem);
                this.add(jRadioButtonMenuItem);
            }
            return this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarPool.getDefault().setConfiguration(actionEvent.getActionCommand());
        }
    }

    public static interface Configuration {
        public Component activate();

        public String getName();

        public JPopupMenu getContextMenu();
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            Configuration configuration = (Configuration)ToolbarPool.this.toolbarConfigs.get(ToolbarPool.this.name);
            if (configuration != null) {
                JPopupMenu jPopupMenu = configuration.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class Folder
    extends FolderInstance {
        private WeakHashMap foldersCache;

        public Folder(DataFolder dataFolder) {
            super(dataFolder);
            this.foldersCache = new WeakHashMap(15);
        }

        public String instanceName() {
            return this.instanceClass().getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$ToolbarPool == null ? (class$org$openide$awt$ToolbarPool = ToolbarPool.class$("org.openide.awt.ToolbarPool")) : class$org$openide$awt$ToolbarPool;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz;
            if ((class$org$openide$awt$ToolbarPool$Configuration == null ? (class$org$openide$awt$ToolbarPool$Configuration = ToolbarPool.class$("org.openide.awt.ToolbarPool$Configuration")) : class$org$openide$awt$ToolbarPool$Configuration).isAssignableFrom(clazz = instanceCookie.instanceClass())) {
                return instanceCookie;
            }
            if ((class$java$awt$Component == null ? (class$java$awt$Component = ToolbarPool.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz)) {
                return instanceCookie;
            }
            return null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            InstanceCookie instanceCookie = (InstanceCookie)this.foldersCache.get(dataFolder);
            if (instanceCookie == null) {
                instanceCookie = new Toolbar(dataFolder, true).waitFinished();
                this.foldersCache.put(dataFolder, instanceCookie);
            }
            return instanceCookie;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            int n = instanceCookieArray.length;
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
            for (int i = 0; i < n; ++i) {
                try {
                    String string;
                    Object object;
                    Object object2 = instanceCookieArray[i].instanceCreate();
                    if (object2 instanceof Toolbar) {
                        object = (Toolbar)object2;
                        ((Component)object).removeMouseListener((MouseListener)((Object)ToolbarPool.this.listener));
                        ((Component)object).addMouseListener((MouseListener)((Object)ToolbarPool.this.listener));
                        treeMap.put(((Component)object).getName(), object);
                        continue;
                    }
                    if (object2 instanceof Configuration) {
                        object = (Configuration)object2;
                        string = object.getName();
                        if (string == null) {
                            string = instanceCookieArray[i].instanceName();
                        }
                        treeMap2.put(string, object);
                        continue;
                    }
                    if (!(object2 instanceof Component)) continue;
                    object = (Component)object2;
                    string = ((Component)object).getName();
                    if (string == null) {
                        string = instanceCookieArray[i].instanceName();
                    }
                    treeMap2.put(string, new ComponentConfiguration((Component)object));
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                }
            }
            ToolbarPool.this.update(treeMap, treeMap2);
            return ToolbarPool.this;
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }
    }

    private class TPTaskListener
    implements TaskListener {
        private String conf;

        TPTaskListener() {
        }

        public void taskFinished(Task task) {
            ToolbarPool.this.setConfiguration(this.conf);
            this.conf = null;
        }

        void setConfiguration(String string) {
            if (this.conf == null) {
                this.conf = string;
            }
        }
    }
}

