/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DataTransferSupport;
import org.openide.loaders.FolderChildren;
import org.openide.loaders.FolderComparator;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.loaders.FolderRenameHandler;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.SortModeEditor;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;

public class DataFolder
extends MultiDataObject
implements Serializable,
DataObject.Container {
    static final long serialVersionUID = -8244904281845488751L;
    public static final String PROP_CHILDREN = "children";
    public static final String PROP_SORT_MODE = "sortMode";
    static final String EA_SORT_MODE = "OpenIDE-Folder-SortMode";
    static final String EA_ORDER = "OpenIDE-Folder-Order";
    public static final String PROP_ORDER = "order";
    public static final String SET_SORTING = "sorting";
    static final String FOLDER_ICON_BASE = "org/openide/loaders/defaultFolder";
    private static final String ROOT_SHADOW_NAME = "Root";
    private FolderList list;
    private PropertyChangeListener pcl;
    private DataTransferSupport dataTransferSupport = new Paste();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder$SortMode;
    static /* synthetic */ Class class$org$openide$loaders$FolderRenameHandler;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder$Paste;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$java$io$Serializable;

    public DataFolder(FileObject fileObject) throws DataObjectExistsException, IllegalArgumentException {
        this(fileObject, DataLoaderPool.getFolderLoader());
    }

    protected DataFolder(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException, IllegalArgumentException {
        this(fileObject, multiFileLoader, true);
    }

    protected DataFolder(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException, IllegalArgumentException {
        super(fileObject, dataLoader);
        this.init(fileObject, true);
    }

    private DataFolder(FileObject fileObject, MultiFileLoader multiFileLoader, boolean bl) throws DataObjectExistsException, IllegalArgumentException {
        super(fileObject, multiFileLoader);
        this.init(fileObject, bl);
    }

    private void init(FileObject fileObject, boolean bl) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not folder: " + fileObject);
        }
        this.list = this.reassignList(fileObject, bl);
    }

    private FolderList reassignList(FileObject fileObject, boolean bl) {
        FolderList folderList = FolderList.find(fileObject, true);
        if (bl) {
            this.pcl = new ListPCL();
            folderList.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)folderList));
        }
        return folderList;
    }

    public static DataFolder create(DataFolder dataFolder, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (DataFolder.confirmName(string2)) continue;
            throw new IOException(NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_WrongName", (Object)string2));
        }
        return DataFolder.findFolder(FileUtil.createFolder((FileObject)dataFolder.getPrimaryFile(), (String)string));
    }

    public final synchronized void setSortMode(SortMode sortMode) throws IOException {
        SortMode sortMode2 = this.getOrder().getSortMode();
        this.getOrder().setSortMode(sortMode);
        this.firePropertyChange(PROP_SORT_MODE, sortMode2, this.getOrder().getSortMode());
    }

    public final SortMode getSortMode() {
        return this.getOrder().getSortMode();
    }

    public final synchronized void setOrder(DataObject[] dataObjectArray) throws IOException {
        this.getOrder().setOrder(dataObjectArray);
        this.firePropertyChange(PROP_ORDER, null, null);
    }

    private FolderOrder getOrder() {
        return FolderOrder.findFor(this.getPrimaryFile());
    }

    public String getName() {
        return this.getPrimaryFile().getNameExt();
    }

    public DataObject[] getChildren() {
        return this.list.getChildren();
    }

    final List getChildrenList() {
        return this.list.getChildrenList();
    }

    final RequestProcessor.Task computeChildrenList(FolderListListener folderListListener) {
        return this.list.computeChildrenList(folderListListener);
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildrenList());
    }

    public Enumeration children(boolean bl) {
        if (!bl) {
            return this.children();
        }
        class Processor
        implements Enumerations.Processor {
            private final /* synthetic */ boolean val$rec;

            Processor(boolean bl) {
                this.val$rec = bl;
            }

            public Object process(Object object, Collection collection) {
                DataObject dataObject = (DataObject)object;
                if (this.val$rec && dataObject instanceof DataFolder) {
                    collection.addAll(Arrays.asList(((DataFolder)dataObject).getChildren()));
                }
                return object;
            }
        }
        Enumeration enumeration = Enumerations.queue((Enumeration)Enumerations.array((Object[])this.getChildren()), (Enumerations.Processor)new Processor(bl));
        return enumeration;
    }

    protected synchronized Node createNodeDelegate() {
        return new FolderNode();
    }

    Node getClonedNodeDelegate(DataFilter dataFilter) {
        Node node = this.getNodeDelegate();
        Children children = node.getChildren();
        if (children.getClass() == FolderChildren.class) {
            DataFilter dataFilter2 = ((FolderChildren)children).getFilter();
            if (dataFilter2 == DataFilter.ALL) {
                return new ClonedFilter(node, dataFilter);
            }
            if (dataFilter != DataFilter.ALL && dataFilter != dataFilter2) {
                return new ClonedFilter(node, DataFolder.filterCompose(dataFilter2, dataFilter));
            }
            return node.cloneNode();
        }
        return node.cloneNode();
    }

    private static DataFilter filterCompose(final DataFilter dataFilter, final DataFilter dataFilter2) {
        if (dataFilter.equals(dataFilter2)) {
            return dataFilter;
        }
        return new DataFilter(){

            public boolean acceptDataObject(DataObject dataObject) {
                return dataFilter.acceptDataObject(dataObject) && dataFilter2.acceptDataObject(dataObject);
            }
        };
    }

    public Children createNodeChildren(DataFilter dataFilter) {
        return new FolderChildren(this, dataFilter);
    }

    public boolean isDeleteAllowed() {
        return this.isRenameAllowed();
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return this.isRenameAllowed();
    }

    public boolean isRenameAllowed() {
        FileObject fileObject = this.getPrimaryFile();
        return !fileObject.isRoot() && !fileObject.isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public static DataFolder findFolder(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find(fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw (IllegalArgumentException)new IllegalArgumentException(dataObjectNotFoundException.toString()).initCause(dataObjectNotFoundException);
        }
        if (!(dataObject instanceof DataFolder)) {
            throw new IllegalArgumentException("Not a DataFolder: " + fileObject + " (was a " + dataObject.getClass().getName() + ") (file is folder? " + fileObject.isFolder() + ")");
        }
        return (DataFolder)dataObject;
    }

    public static DataObject.Container findContainer(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return FolderList.find(fileObject, true);
        }
        throw new IllegalArgumentException("Not a folder: " + fileObject);
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataFolder.testNesting(this, dataFolder);
        Enumeration enumeration = this.children();
        DataFolder dataFolder2 = (DataFolder)super.handleCopy(dataFolder);
        while (enumeration.hasMoreElements()) {
            try {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                if (dataObject.isCopyAllowed()) {
                    dataObject.copy(dataFolder2);
                    continue;
                }
                ErrorManager.getDefault().log(256, NbBundle.getMessage((Class)(class$org$openide$loaders$DataFolder == null ? DataFolder.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder), (String)"FMT_CannotCopyDo", (Object)dataObject.getName()));
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return dataFolder2;
    }

    static void testNesting(DataFolder dataFolder, DataFolder dataFolder2) throws IOException {
        if (dataFolder2.equals(dataFolder)) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Error Copying File or Folder"), 16, null, NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_CannotCopyTheSame", (Object)dataFolder.getName()), null, null);
        }
        for (DataFolder dataFolder3 = dataFolder2.getFolder(); dataFolder3 != null; dataFolder3 = dataFolder3.getFolder()) {
            if (!dataFolder3.equals(dataFolder)) continue;
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Error copying file or folder: " + dataFolder.getPrimaryFile() + " cannot be copied to its subfolder " + dataFolder2.getPrimaryFile()), 16, null, NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_CannotCopySubfolder", (Object)dataFolder.getName()), null, null);
        }
    }

    protected void handleDelete() throws IOException {
        Enumeration enumeration = this.children();
        FileLock fileLock = null;
        try {
            fileLock = DataFolder.createLightWeightLock(this);
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                if (!dataObject.isValid()) continue;
                dataObject.delete();
            }
        }
        catch (IOException iOException) {
            FileObject fileObject = this.getPrimaryFile();
            String string = NbBundle.getMessage((Class)DataFolder.class, (String)"EXC_CannotDelete2", (Object)FileUtil.getFileDisplayName((FileObject)fileObject));
            ErrorManager.getDefault().annotate((Throwable)iOException, string);
            throw iOException;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        super.handleDelete();
    }

    private static FileLock createLightWeightLock(DataFolder dataFolder) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError();
        }
        Object object = fileObject.getAttribute("LIGHTWEIGHT_LOCK_SET");
        if (!$assertionsDisabled && object != null && !(object instanceof FileLock)) {
            throw new AssertionError((Object)fileObject.toString());
        }
        return (FileLock)object;
    }

    protected FileObject handleRename(final String string) throws IOException {
        if (!DataFolder.confirmName(string)) {
            throw new IOException("bad name: " + string){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage((Class)(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder), (String)"EXC_WrongName", (Object)string);
                }
            };
        }
        return super.handleRename(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        FileObject fileObject = this.getPrimaryFile();
        FileLock fileLock = fileObject.lock();
        List list = this.saveEntries();
        try {
            Object object;
            Object object2;
            FileObject fileObject2 = super.handleMove(dataFolder);
            DataFolder dataFolder2 = null;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 20; i >= 0; --i) {
                try {
                    object2 = this.getMultiFileLoader();
                    if (!$assertionsDisabled && !(object2 instanceof DataLoaderPool.FolderLoader)) {
                        throw new AssertionError((Object)("This has to be FolderLoader: " + object2 + " for " + this.getPrimaryFile()));
                    }
                    object = (DataLoaderPool.FolderLoader)((Object)object2);
                    dataFolder2 = (DataFolder)DataObjectPool.createMultiObject((DataLoaderPool.FolderLoader)((Object)object), fileObject2, this);
                    bl = false;
                    break;
                }
                catch (DataObjectExistsException dataObjectExistsException) {
                    dataFolder2 = (DataFolder)dataObjectExistsException.getDataObject();
                    dataFolder2.dispose();
                    bl = true;
                    continue;
                }
            }
            object2 = this.children();
            while (object2.hasMoreElements()) {
                try {
                    object = (DataObject)object2.nextElement();
                    if (((DataObject)object).isMoveAllowed()) {
                        ((DataObject)object).move(dataFolder2);
                        continue;
                    }
                    bl2 = true;
                    ErrorManager.getDefault().log(256, NbBundle.getMessage((Class)(class$org$openide$loaders$DataFolder == null ? DataFolder.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder), (String)"FMT_CannotMoveDo", (Object)((DataObject)object).getName()));
                }
                catch (IOException iOException) {
                    bl2 = true;
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            if (bl2) {
                this.restoreEntries(list);
                this.list.refresh();
                object = fileObject;
                return object;
            }
            try {
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)iOException, DataObject.getString("EXC_folder_delete_failed"));
                ErrorManager.getDefault().notify(throwable);
            }
            if (bl) {
                try {
                    this.setValid(false);
                    fileObject2 = fileObject;
                }
                catch (PropertyVetoException propertyVetoException) {
                    this.restoreEntries(list);
                    fileObject2 = this.getPrimaryEntry().getFile();
                }
            } else {
                this.item.changePrimaryFile(fileObject2);
                dataFolder2.dispose();
                this.list = this.reassignList(fileObject2, true);
            }
            object = fileObject2;
            return object;
        }
        finally {
            fileLock.releaseLock();
        }
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        DataFolder dataFolder2 = (DataFolder)super.handleCreateFromTemplate(dataFolder, string);
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            try {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                dataObject.createFromTemplate(dataFolder2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        return dataFolder2;
    }

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        DataFolder.testNesting(this, dataFolder);
        String string = this.getPrimaryFile().isRoot() ? FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)ROOT_SHADOW_NAME, (String)"shadow") : null;
        return DataShadow.create(dataFolder, string, this);
    }

    boolean isMergingFolders(FileObject fileObject, FileObject fileObject2) {
        return !fileObject2.equals(fileObject.getParent());
    }

    private static boolean confirmName(String string) {
        return string.indexOf(47) == -1 && string.indexOf(92) == -1;
    }

    static {
        $assertionsDisabled = !DataFolder.class.desiredAssertionStatus();
    }

    private final class ListPCL
    implements PropertyChangeListener {
        ListPCL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this == DataFolder.this.pcl) {
                DataFolder.this.firePropertyChange(DataFolder.PROP_CHILDREN, null, null);
            }
        }
    }

    private class Paste
    extends DataTransferSupport {
        Paste() {
        }

        protected DataTransferSupport.PasteTypeExt[] definePasteTypes(int n) {
            switch (n) {
                case 4: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_move");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".move");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isMoveAllowed() && !this.isParent(Paste.access$300(this.this$1).getPrimaryFile(), dataObject.getPrimaryFile());
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.move(Paste.access$300(this.this$1));
                        }

                        protected boolean cleanClipboard() {
                            return true;
                        }

                        private boolean isParent(FileObject fileObject, FileObject fileObject2) {
                            File file = FileUtil.toFile((FileObject)fileObject2);
                            File file2 = FileUtil.toFile((FileObject)fileObject);
                            if (file2 != null && file != null) {
                                return Paste.access$400(this.this$1, file2, file);
                            }
                            try {
                                if (fileObject.getFileSystem() != fileObject2.getFileSystem()) {
                                    return false;
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            while (fileObject != null) {
                                if (fileObject.equals(fileObject2)) {
                                    return true;
                                }
                                fileObject = fileObject.getParent();
                            }
                            return false;
                        }
                    }};
                }
                case 1: {
                    return new DataTransferSupport.PasteTypeExt[]{new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_copy");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".copy");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isCopyAllowed();
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            this.saveIfModified(dataObject);
                            dataObject.copy(Paste.access$300(this.this$1));
                        }

                        private void saveIfModified(DataObject dataObject) throws IOException {
                            SaveCookie saveCookie;
                            if (dataObject.isModified() && (saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = DataFolder.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie)) != null) {
                                saveCookie.save();
                            }
                        }
                    }, new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_instantiate");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".instantiate");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            return dataObject.isTemplate();
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.createFromTemplate(Paste.access$300(this.this$1));
                        }
                    }, new DataTransferSupport.PasteTypeExt(this){
                        private final /* synthetic */ Paste this$1;
                        {
                            this.this$1 = paste;
                        }

                        public String getName() {
                            return DataObject.getString("PT_shadow");
                        }

                        public HelpCtx getHelpCtx() {
                            return new HelpCtx((class$org$openide$loaders$DataFolder$Paste == null ? (class$org$openide$loaders$DataFolder$Paste = DataFolder.class$("org.openide.loaders.DataFolder$Paste")) : class$org$openide$loaders$DataFolder$Paste).getName() + ".shadow");
                        }

                        protected boolean handleCanPaste(DataObject dataObject) {
                            try {
                                if (!Paste.access$300(this.this$1).getPrimaryFile().getFileSystem().equals(Repository.getDefault().getDefaultFileSystem())) {
                                    return false;
                                }
                            }
                            catch (FileStateInvalidException fileStateInvalidException) {
                                return false;
                            }
                            return dataObject.isShadowAllowed();
                        }

                        protected void handlePaste(DataObject dataObject) throws IOException {
                            dataObject.createShadow(Paste.access$300(this.this$1));
                        }
                    }};
                }
            }
            return new DataTransferSupport.PasteTypeExt[0];
        }

        private boolean isParentFile(File file, File file2) {
            boolean bl = false;
            while (file != null) {
                if (file.equals(file2)) {
                    bl = true;
                    break;
                }
                file = file.getParentFile();
            }
            return bl;
        }

        protected int[] defineOperations() {
            return new int[]{4, 1};
        }

        protected void handleCreatePasteTypes(Transferable transferable, List list) {
            Node node = NodeTransfer.node((Transferable)transferable, (int)1);
            if (node != null) {
                try {
                    InstanceCookie instanceCookie = (InstanceCookie)node.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = DataFolder.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
                    if (instanceCookie != null && (class$java$io$Serializable == null ? (class$java$io$Serializable = DataFolder.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(instanceCookie.instanceClass())) {
                        list.add(new DataTransferSupport.SerializePaste(DataFolder.this, instanceCookie));
                        list.add(new DataTransferSupport.InstantiatePaste(DataFolder.this, instanceCookie));
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ DataFolder access$300(Paste paste) {
            return paste.DataFolder.this;
        }

        static /* synthetic */ boolean access$400(Paste paste, File file, File file2) {
            return paste.isParentFile(file, file2);
        }
    }

    private final class NewFolder
    extends NewType {
        NewFolder() {
        }

        public String getName() {
            return DataObject.getString("CTL_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void create() throws IOException {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(DataObject.getString("CTL_NewFolderName"), DataObject.getString("CTL_NewFolderTitle"));
            inputLine.setInputText(DataObject.getString("CTL_NewFolderValue"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) == NotifyDescriptor.OK_OPTION) {
                Object object;
                String string;
                String string2 = inputLine.getInputText();
                if ("".equals(string2)) {
                    return;
                }
                FileObject fileObject = DataFolder.this.getPrimaryFile();
                int n = -1;
                while ((n = string2.indexOf(".")) != -1) {
                    string = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                    object = fileObject.getFileObject(string);
                    if (object != null) {
                        if (!object.isFolder()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_FMT_FileExists", (Object)string, (Object)fileObject.getName()), 2));
                            return;
                        }
                        fileObject = object;
                        continue;
                    }
                    if (!DataFolder.confirmName(string)) {
                        throw new IOException(NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"EXC_WrongName", (Object)string));
                    }
                    fileObject = fileObject.createFolder(string);
                }
                if (!"".equals(string2)) {
                    string = fileObject.getFileObject(string2);
                    if (string != null) {
                        if (string.isFolder()) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_FMT_FolderExists", (Object)string2, (Object)fileObject.getName()), 1));
                        } else {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_FMT_FileExists", (Object)string2, (Object)fileObject.getName()), 2));
                        }
                        return;
                    }
                    if (!DataFolder.confirmName(string2)) {
                        throw new IOException(NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataFolder.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"EXC_WrongName", (Object)string2));
                    }
                    object = DataObject.find(fileObject.createFolder(string2));
                    if (object != null) {
                        DataLoaderPool.getDefault().fireOperationEvent(new OperationEvent.Copy((DataObject)object, DataFolder.this), 6);
                    }
                }
            }
        }
    }

    public class FolderNode
    extends DataNode {
        public FolderNode(Children children) {
            super(DataFolder.this, children);
            this.setIconBase(DataFolder.FOLDER_ICON_BASE);
        }

        protected FolderNode() {
            super(DataFolder.this, (Children)new FolderChildren(DataFolder.this));
            this.setIconBase(DataFolder.FOLDER_ICON_BASE);
        }

        public Image getIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (image == null) {
                image = super.getIcon(n);
            } else {
                try {
                    DataObject dataObject = this.getDataObject();
                    image = dataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, dataObject.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = null;
            if (n == 1) {
                image = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (image == null) {
                image = super.getOpenedIcon(n);
            } else {
                try {
                    DataObject dataObject = this.getDataObject();
                    image = dataObject.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, dataObject.files());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return image;
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz == (class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = DataFolder.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) || clazz == (class$org$openide$loaders$DataFolder$Index == null ? (class$org$openide$loaders$DataFolder$Index = DataFolder.class$("org.openide.loaders.DataFolder$Index")) : class$org$openide$loaders$DataFolder$Index)) {
                try {
                    if (DataFolder.this.getPrimaryFile().getFileSystem() == Repository.getDefault().getDefaultFileSystem() || Boolean.TRUE.equals(DataFolder.this.getPrimaryFile().getAttribute("DataFolder.Index.reorderable"))) {
                        return new Index(DataFolder.this, (Node)this);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
                }
            }
            return super.getCookie(clazz);
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = new Sheet.Set();
            set.setName(DataFolder.SET_SORTING);
            set.setDisplayName(DataObject.getString("PROP_sorting"));
            set.setShortDescription(DataObject.getString("HINT_sorting"));
            PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite(this, DataFolder.PROP_SORT_MODE, class$org$openide$loaders$DataFolder$SortMode == null ? (class$org$openide$loaders$DataFolder$SortMode = DataFolder.class$("org.openide.loaders.DataFolder$SortMode")) : class$org$openide$loaders$DataFolder$SortMode, DataObject.getString("PROP_sort"), DataObject.getString("HINT_sort")){
                private final /* synthetic */ FolderNode this$1;
                {
                    this.this$1 = folderNode;
                    super(string, clazz, string2, string3);
                }

                public Object getValue() {
                    return FolderNode.access$000(this.this$1).getSortMode();
                }

                public void setValue(Object object) throws InvocationTargetException {
                    try {
                        FolderNode.access$000(this.this$1).setSortMode((SortMode)object);
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }

                public PropertyEditor getPropertyEditor() {
                    return new SortModeEditor();
                }
            };
            set.put((Node.Property)readWrite);
            sheet.put(set);
            return sheet;
        }

        public Action getPreferredAction() {
            return null;
        }

        public NewType[] getNewTypes() {
            return new NewType[0];
        }

        private synchronized FolderRenameHandler getRenameHandler() {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$loaders$FolderRenameHandler == null ? (class$org$openide$loaders$FolderRenameHandler = DataFolder.class$("org.openide.loaders.FolderRenameHandler")) : class$org$openide$loaders$FolderRenameHandler));
            List list = (List)result.allInstances();
            if (list.size() == 0) {
                return null;
            }
            if (list.size() > 1) {
                ErrorManager.getDefault().log(16, "Multiple instances of FolderRenameHandler found in Lookup; only using first one: " + list);
            }
            return (FolderRenameHandler)list.get(0);
        }

        public void setName(String string) {
            FolderRenameHandler folderRenameHandler = this.getRenameHandler();
            if (folderRenameHandler == null) {
                super.setName(string);
            } else {
                folderRenameHandler.handleRename(DataFolder.this, string);
            }
        }

        protected void createPasteTypes(Transferable transferable, List list) {
            super.createPasteTypes(transferable, list);
            if (!DataFolder.this.getPrimaryFile().isReadOnly()) {
                DataFolder.this.dataTransferSupport.createPasteTypes(transferable, list);
            }
        }

        static /* synthetic */ DataFolder access$000(FolderNode folderNode) {
            return folderNode.DataFolder.this;
        }
    }

    public static abstract class SortMode
    implements Comparator {
        public static final SortMode NONE = new FolderComparator(0);
        public static final SortMode NAMES = new FolderComparator(1);
        public static final SortMode CLASS = new FolderComparator(2);
        public static final SortMode FOLDER_NAMES = new FolderComparator(3);
        public static final SortMode LAST_MODIFIED = new FolderComparator(4);
        public static final SortMode SIZE = new FolderComparator(5);

        void write(FileObject fileObject) throws IOException {
            String string = this == FOLDER_NAMES ? "F" : (this == NAMES ? "N" : (this == CLASS ? "C" : (this == LAST_MODIFIED ? "M" : (this == SIZE ? "S" : "O"))));
            fileObject.setAttribute(DataFolder.EA_SORT_MODE, (Object)string);
        }

        static SortMode read(FileObject fileObject) {
            String string = (String)fileObject.getAttribute(DataFolder.EA_SORT_MODE);
            if (string == null || string.length() != 1) {
                return FOLDER_NAMES;
            }
            char c = string.charAt(0);
            switch (c) {
                case 'N': {
                    return NAMES;
                }
                case 'C': {
                    return CLASS;
                }
                case 'O': {
                    return NONE;
                }
                case 'M': {
                    return LAST_MODIFIED;
                }
                case 'S': {
                    return SIZE;
                }
            }
            return FOLDER_NAMES;
        }
    }

    public static class Index
    extends Index.Support {
        private DataFolder df;
        private Node node;
        private Listener listener;

        public Index(DataFolder dataFolder) {
            this(dataFolder, dataFolder.getNodeDelegate());
        }

        public Index(DataFolder dataFolder, Node node) {
            this.df = dataFolder;
            this.node = node;
            this.listener = new Listener();
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this.listener, (Object)node));
        }

        public int getNodesCount() {
            return this.node.getChildren().getNodes(FolderChildren.checkChildrenMutex()).length;
        }

        public Node[] getNodes() {
            return this.node.getChildren().getNodes(FolderChildren.checkChildrenMutex());
        }

        public void reorder(int[] nArray) {
            DataObject[] dataObjectArray = this.df.getChildren();
            DataObject[] dataObjectArray2 = new DataObject[dataObjectArray.length];
            Node[] nodeArray = this.getNodes();
            if (nodeArray.length != nArray.length) {
                throw new IllegalArgumentException("permutation of incorrect length: " + nArray.length + " rather than " + nodeArray.length);
            }
            HashMap<String, DataObject> hashMap = new HashMap<String, DataObject>(2 * dataObjectArray.length);
            for (int i = 0; i < dataObjectArray.length; ++i) {
                Node node = dataObjectArray[i].getNodeDelegate();
                if (node.getCookie(class$org$openide$loaders$DataObject == null ? DataFolder.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) != null) continue;
                hashMap.put(node.getName(), dataObjectArray[i]);
            }
            DataObject[] dataObjectArray3 = new DataObject[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                DataObject dataObject = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? DataFolder.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) {
                    dataObject = (DataObject)hashMap.get(nodeArray[i].getName());
                }
                if (dataObject == null) {
                    throw new IllegalArgumentException("cannot reorder node with no DataObject: " + nodeArray[i]);
                }
                if (dataObject.getFolder() != this.df) {
                    throw new IllegalArgumentException("wrong folder for: " + dataObject.getPrimaryFile() + " rather than " + this.df.getPrimaryFile());
                }
                dataObjectArray3[nArray[i]] = dataObject;
            }
            HashSet<DataObject> hashSet = new HashSet<DataObject>(Arrays.asList(dataObjectArray3));
            if (hashSet.size() != dataObjectArray3.length) {
                throw new IllegalArgumentException("duplicate DataObject's among reordered childen");
            }
            int n = 0;
            for (int i = 0; i < dataObjectArray.length; ++i) {
                dataObjectArray2[i] = hashSet.remove(dataObjectArray[i]) ? dataObjectArray3[n++] : dataObjectArray[i];
            }
            try {
                this.df.setOrder(dataObjectArray2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, DataObject.getString("EXC_ReorderFailed"));
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public void reorder() {
            Index.Support.showIndexedCustomizer((org.openide.nodes.Index)this);
        }

        void fireChangeEventAccess() {
            this.fireChangeEvent(new ChangeEvent((Object)this));
        }

        private final class Listener
        implements NodeListener {
            Listener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                Index.this.fireChangeEventAccess();
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                Index.this.fireChangeEventAccess();
            }
        }
    }

    private static final class ClonedFilterHandle
    implements Node.Handle {
        private static final long serialVersionUID = 24234097765186L;
        private DataObject folder;
        private DataFilter filter;

        public ClonedFilterHandle(DataFolder dataFolder, DataFilter dataFilter) {
            this.folder = dataFolder;
            this.filter = dataFilter;
        }

        public Node getNode() throws IOException {
            if (this.folder instanceof DataFolder) {
                DataFolder dataFolder = (DataFolder)this.folder;
                dataFolder.getClass();
                return dataFolder.new ClonedFilter(this.filter);
            }
            throw new InvalidObjectException(this.folder == null ? "" : this.folder.toString());
        }
    }

    private final class ClonedFilter
    extends FilterNode {
        private DataFilter filter;
        private int hashCode;

        public ClonedFilter(Node node, DataFilter dataFilter) {
            super(node, DataFolder.this.createNodeChildren(dataFilter));
            this.hashCode = -1;
            this.filter = dataFilter;
        }

        public ClonedFilter(DataFilter dataFilter) {
            this(dataFolder.getNodeDelegate(), dataFilter);
        }

        public Node cloneNode() {
            if (DataFolder.this.isValid()) {
                return new ClonedFilter(this.filter);
            }
            return super.cloneNode();
        }

        public Node.Handle getHandle() {
            return new ClonedFilterHandle(DataFolder.this, this.filter);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)((Object)object);
                if (folderNode.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) != DataFolder.this) {
                    return false;
                }
                Children children = folderNode.getChildren();
                return children instanceof FolderChildren && ((FolderChildren)children).getFilter().equals(this.filter);
            }
            if (object instanceof ClonedFilter) {
                ClonedFilter clonedFilter = (ClonedFilter)((Object)object);
                return clonedFilter.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == DataFolder.this && clonedFilter.filter.equals(this.filter);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = DataFolder.this.isValid() ? DataFolder.this.getNodeDelegate().hashCode() : super.hashCode();
                if (this.hashCode == -1) {
                    this.hashCode = -2;
                }
            }
            return this.hashCode;
        }
    }
}

